/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import org.hsqldb.HsqlException;
import org.hsqldb.Node;
import org.hsqldb.Record;
import org.hsqldb.Row;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class CachedRow
extends Row {
    static final int NO_POS = -1;
    protected Table tTable;
    int iLastAccess;
    CachedRow rLast;
    CachedRow rNext;
    int iPos = -1;
    int storageSize;
    protected boolean hasChanged;
    protected boolean hasDataChanged;

    CachedRow() {
    }

    public CachedRow(Table table, Object[] objectArray) throws HsqlException {
        this.tTable = table;
        int n = table.getIndexCount();
        Node node = this.nPrimaryNode = Node.newNode(this, 0, table);
        for (int i = 1; i < n; ++i) {
            node = node.nNext = Node.newNode(this, i, table);
        }
        this.oData = objectArray;
        this.hasDataChanged = true;
        this.hasChanged = true;
        table.addRowToStore(this);
    }

    public CachedRow(Table table, RowInputInterface rowInputInterface) throws IOException, HsqlException {
        this.tTable = table;
        this.iPos = rowInputInterface.getPos();
        this.storageSize = rowInputInterface.getSize();
        int n = table.getIndexCount();
        Node node = this.nPrimaryNode = Node.newNode(this, rowInputInterface, 0, table);
        for (int i = 1; i < n; ++i) {
            node = node.nNext = Node.newNode(this, rowInputInterface, i, table);
        }
        this.oData = rowInputInterface.readData(this.tTable.getColumnTypes());
        this.setPos(this.iPos);
    }

    void delete() throws HsqlException {
        ++Record.memoryRecords;
        this.hasChanged = false;
        this.tTable.removeRow(this);
        this.rNext = null;
        this.rLast = null;
        this.tTable = null;
        this.oData = null;
        this.nPrimaryNode = null;
    }

    void setPos(int n) {
        this.iPos = n;
        this.tTable.registerRow(this);
    }

    void setChanged() {
        this.hasChanged = true;
    }

    boolean hasChanged() {
        return this.hasChanged;
    }

    void setDataChanged() {
        this.hasDataChanged = true;
    }

    boolean hasDataChanged() {
        return this.hasDataChanged;
    }

    public Table getTable() {
        return this.tTable;
    }

    boolean isRoot() throws HsqlException {
        Node node = this.nPrimaryNode;
        while (node != null) {
            Trace.doAssert(node.getBalance() != -2);
            if (node.isRoot()) {
                return true;
            }
            node = node.nNext;
        }
        return false;
    }

    Row getUpdatedRow() throws HsqlException {
        return this.tTable == null ? null : this.tTable.getRow(this.iPos, null);
    }

    void write(RowOutputInterface rowOutputInterface) throws IOException, HsqlException {
        this.writeNodes(rowOutputInterface);
        if (this.hasDataChanged) {
            rowOutputInterface.writeData(this.oData, this.tTable);
            rowOutputInterface.writePos(this.iPos);
        }
        this.hasDataChanged = false;
    }

    private void writeNodes(RowOutputInterface rowOutputInterface) throws IOException, HsqlException {
        rowOutputInterface.writeSize(this.storageSize);
        Node node = this.nPrimaryNode;
        while (node != null) {
            node.write(rowOutputInterface);
            node = node.nNext;
        }
        this.hasChanged = false;
    }

    void insert(CachedRow cachedRow) {
        ++Record.memoryRecords;
        if (cachedRow == null) {
            this.rNext = this;
            this.rLast = this;
        } else {
            this.rNext = cachedRow;
            this.rLast = cachedRow.rLast;
            cachedRow.rLast = this;
            this.rLast.rNext = this;
        }
    }

    CachedRow free() throws HsqlException {
        CachedRow cachedRow = this.rNext;
        this.rLast.rNext = this.rNext;
        this.rNext.rLast = this.rLast;
        this.rLast = null;
        this.rNext = null;
        if (cachedRow == this) {
            return null;
        }
        return cachedRow;
    }
}

