/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.test;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Assert;
import junit.textui.TestRunner;
import net.sourceforge.jtds.test.TestBase;

public class SanityTest
extends TestBase {
    static /* synthetic */ Class class$net$sourceforge$jtds$test$SanityTest;

    public SanityTest(String name) {
        super(name);
    }

    public void testSanity() throws Exception {
        Statement stmt = this.con.createStatement();
        this.makeTestTables(stmt);
        this.makeObjects(stmt, 5);
        stmt.close();
    }

    public void testCursorStatements() throws Exception {
        Statement stmt = this.con.createStatement();
        this.makeTestTables(stmt);
        this.makeObjects(stmt, 5);
        Assert.assertEquals((String)"Expected an update count", (boolean)false, (boolean)stmt.execute("DECLARE cursor1 SCROLL CURSOR FOR\nSELECT * FROM #test"));
        this.showWarnings(stmt.getWarnings());
        Assert.assertEquals((String)"Expected an update count", (boolean)false, (boolean)stmt.execute("OPEN cursor1"));
        ResultSet rs = stmt.executeQuery("FETCH LAST FROM cursor1");
        this.dump(rs);
        rs.close();
        rs = stmt.executeQuery("FETCH FIRST FROM cursor1");
        this.dump(rs);
        rs.close();
        stmt.execute("CLOSE cursor1");
        stmt.execute("DEALLOCATE cursor1");
        stmt.close();
    }

    public void testCursorRSCreate() throws Exception {
        Statement stmt = this.con.createStatement(1004, 1007);
        this.makeTestTables(stmt);
        this.makeObjects(stmt, 5);
        ResultSet rs = stmt.executeQuery("Select * from #test order by 1");
        rs.last();
        Assert.assertEquals((int)5, (int)rs.getRow());
        Assert.assertEquals((int)4, (int)rs.getInt(1));
        Assert.assertEquals((boolean)false, (boolean)rs.isBeforeFirst());
        Assert.assertEquals((boolean)false, (boolean)rs.isFirst());
        Assert.assertEquals((boolean)true, (boolean)rs.isLast());
        Assert.assertEquals((boolean)false, (boolean)rs.isAfterLast());
        rs.beforeFirst();
        Assert.assertEquals((int)0, (int)rs.getRow());
        try {
            rs.getInt(1);
            Assert.fail((String)"There should be no current row.");
        }
        catch (SQLException ex) {
            // empty catch block
        }
        Assert.assertEquals((boolean)true, (boolean)rs.isBeforeFirst());
        Assert.assertEquals((boolean)false, (boolean)rs.isFirst());
        Assert.assertEquals((boolean)false, (boolean)rs.isLast());
        Assert.assertEquals((boolean)false, (boolean)rs.isAfterLast());
        rs.relative(3);
        Assert.assertEquals((int)3, (int)rs.getRow());
        Assert.assertEquals((int)2, (int)rs.getInt(1));
        Assert.assertEquals((boolean)false, (boolean)rs.isBeforeFirst());
        Assert.assertEquals((boolean)false, (boolean)rs.isFirst());
        Assert.assertEquals((boolean)false, (boolean)rs.isLast());
        Assert.assertEquals((boolean)false, (boolean)rs.isAfterLast());
        rs.afterLast();
        Assert.assertEquals((int)0, (int)rs.getRow());
        try {
            rs.getInt(1);
            Assert.fail((String)"There should be no current row.");
        }
        catch (SQLException ex) {
            // empty catch block
        }
        Assert.assertEquals((boolean)false, (boolean)rs.isBeforeFirst());
        Assert.assertEquals((boolean)false, (boolean)rs.isFirst());
        Assert.assertEquals((boolean)false, (boolean)rs.isLast());
        Assert.assertEquals((boolean)true, (boolean)rs.isAfterLast());
        rs.first();
        Assert.assertEquals((int)1, (int)rs.getRow());
        Assert.assertEquals((int)0, (int)rs.getInt(1));
        Assert.assertEquals((boolean)false, (boolean)rs.isBeforeFirst());
        Assert.assertEquals((boolean)true, (boolean)rs.isFirst());
        Assert.assertEquals((boolean)false, (boolean)rs.isLast());
        Assert.assertEquals((boolean)false, (boolean)rs.isAfterLast());
        rs.absolute(4);
        Assert.assertEquals((int)4, (int)rs.getRow());
        Assert.assertEquals((int)3, (int)rs.getInt(1));
        Assert.assertEquals((boolean)false, (boolean)rs.isBeforeFirst());
        Assert.assertEquals((boolean)false, (boolean)rs.isFirst());
        Assert.assertEquals((boolean)false, (boolean)rs.isLast());
        Assert.assertEquals((boolean)false, (boolean)rs.isAfterLast());
        rs.relative(-2);
        Assert.assertEquals((int)2, (int)rs.getRow());
        Assert.assertEquals((int)1, (int)rs.getInt(1));
        Assert.assertEquals((boolean)false, (boolean)rs.isBeforeFirst());
        Assert.assertEquals((boolean)false, (boolean)rs.isFirst());
        Assert.assertEquals((boolean)false, (boolean)rs.isLast());
        Assert.assertEquals((boolean)false, (boolean)rs.isAfterLast());
        rs.close();
        stmt.close();
    }

    public void testCursorRSScroll() throws Exception {
        Statement stmt = this.con.createStatement(1004, 1007);
        this.makeTestTables(stmt);
        this.makeObjects(stmt, 5);
        ResultSet rs = stmt.executeQuery("Select * from #test");
        while (rs.next()) {
        }
        rs.close();
        stmt.close();
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$net$sourceforge$jtds$test$SanityTest == null ? (class$net$sourceforge$jtds$test$SanityTest = SanityTest.class$("net.sourceforge.jtds.test.SanityTest")) : class$net$sourceforge$jtds$test$SanityTest));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

