/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.test;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import net.sourceforge.jtds.test.DatabaseTestCase;
import net.sourceforge.jtds.util.Logger;

public class SAfeTest
extends DatabaseTestCase {
    volatile int started;
    volatile int done;
    volatile boolean failed;
    static /* synthetic */ Class class$net$sourceforge$jtds$test$SAfeTest;

    public SAfeTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        Logger.setActive(true);
        if (args.length > 0) {
            TestSuite s = new TestSuite();
            int i = 0;
            while (i < args.length) {
                s.addTest((Test)new SAfeTest(args[i]));
                ++i;
            }
            TestRunner.run((Test)s);
        } else {
            TestRunner.run((Class)(class$net$sourceforge$jtds$test$SAfeTest == null ? (class$net$sourceforge$jtds$test$SAfeTest = SAfeTest.class$("net.sourceforge.jtds.test.SAfeTest")) : class$net$sourceforge$jtds$test$SAfeTest));
        }
    }

    public void testNullLengthStrings0001() throws Exception {
        String[] types = new String[]{"VARCHAR(50)", "TEXT", "VARCHAR(350)", "NVARCHAR(50)", "NTEXT"};
        String[] values = new String[]{null, "", " ", "x"};
        Statement stmt = this.con.createStatement();
        boolean tds70orLater = this.props.getProperty("TDS") == null || this.props.getProperty("TDS").charAt(0) >= '7';
        int typeCnt = tds70orLater ? types.length : 2;
        int i = 0;
        while (i < typeCnt) {
            Assert.assertTrue((stmt.executeUpdate("CREATE TABLE #SAfe0001 (val " + types[i] + " NULL)") == 0 ? 1 : 0) != 0);
            int j = 0;
            while (j < values.length) {
                String insQuery = values[j] == null ? "INSERT INTO #SAfe0001 VALUES (NULL)" : "INSERT INTO #SAfe0001 VALUES ('" + values[j] + "')";
                Assert.assertTrue((stmt.executeUpdate(insQuery) == 1 ? 1 : 0) != 0);
                ResultSet rs = stmt.executeQuery("SELECT val FROM #SAfe0001");
                Assert.assertTrue((boolean)rs.next());
                if (tds70orLater || !" ".equals(values[j])) {
                    Assert.assertEquals((Object)values[j], (Object)rs.getString(1));
                } else {
                    Assert.assertEquals((Object)"", (Object)rs.getObject(1));
                }
                Assert.assertTrue((!rs.next() ? 1 : 0) != 0);
                Assert.assertTrue((stmt.executeUpdate("TRUNCATE TABLE #SAfe0001") == 0 ? 1 : 0) != 0);
                ++j;
            }
            Assert.assertTrue((stmt.executeUpdate("DROP TABLE #SAfe0001") == 0 ? 1 : 0) != 0);
            ++i;
        }
    }

    public void testCancel0002() throws Exception {
        Connection con2 = this.getConnection();
        Statement stmt = this.con.createStatement();
        Assert.assertTrue((!stmt.execute("create table ##SAfe0002 (id int primary key, val varchar(20) null) insert into ##SAfe0002 values (1, 'Line 1') insert into ##SAfe0002 values (2, 'Line 2')") ? 1 : 0) != 0);
        Assert.assertEquals((int)0, (int)stmt.getUpdateCount());
        Assert.assertTrue((!stmt.getMoreResults() ? 1 : 0) != 0);
        Assert.assertEquals((int)1, (int)stmt.getUpdateCount());
        Assert.assertTrue((!stmt.getMoreResults() ? 1 : 0) != 0);
        Assert.assertEquals((int)1, (int)stmt.getUpdateCount());
        Assert.assertTrue((!stmt.getMoreResults() ? 1 : 0) != 0);
        Assert.assertEquals((int)-1, (int)stmt.getUpdateCount());
        this.con.setAutoCommit(false);
        stmt.executeUpdate("update ##SAfe0002 set val='Updated Line' where id=1");
        Statement stmt2 = con2.createStatement();
        stmt2.setQueryTimeout(1);
        try {
            stmt2.executeQuery("select * from ##SAfe0002");
            Assert.fail();
        }
        catch (SQLException ex) {
            // empty catch block
        }
        this.con.commit();
        this.con.setAutoCommit(true);
        stmt.execute("drop table ##SAfe0002");
        stmt.close();
        ResultSet rs = stmt2.executeQuery("select 1");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((int)1, (int)rs.getInt(1));
        Assert.assertTrue((!rs.next() ? 1 : 0) != 0);
        con2.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCursorResultSetConcurrency0003() throws Exception {
        Object rs;
        Object object;
        Statement stmt0 = this.con.createStatement();
        stmt0.execute("create table #SAfe0003(id int primary key, val varchar(20) null) insert into #SAfe0003 values (1, 'Line 1') insert into #SAfe0003 values (2, 'Line 2')");
        while (stmt0.getMoreResults() || stmt0.getUpdateCount() != -1) {
        }
        final Object o1 = new Object();
        final Object o2 = new Object();
        final Statement stmt = this.con.createStatement(1004, 1007);
        int threadCount = 25;
        Thread[] threads = new Thread[threadCount];
        this.done = 0;
        this.started = 0;
        this.failed = false;
        int i = 0;
        while (i < threadCount) {
            threads[i] = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object;
                    ResultSet rs = null;
                    try {
                        rs = stmt.executeQuery("SELECT * FROM #SAfe0003");
                        Assert.assertEquals(null, (Object)rs.getWarnings());
                        Assert.assertEquals(null, (Object)stmt.getWarnings());
                        Object object2 = o2;
                        synchronized (object2) {
                            Object object3 = o1;
                            synchronized (object3) {
                                ++SAfeTest.this.started;
                                o1.notify();
                            }
                            try {
                                o2.wait();
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                        }
                        Assert.assertNotNull((String)"executeQuery should not return null", (Object)rs);
                        Assert.assertTrue((boolean)rs.next());
                        Assert.assertTrue((boolean)rs.next());
                        Assert.assertTrue((!rs.next() ? 1 : 0) != 0);
                        Assert.assertTrue((boolean)rs.previous());
                        Assert.assertTrue((boolean)rs.previous());
                        Assert.assertTrue((!rs.previous() ? 1 : 0) != 0);
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        object = o1;
                        synchronized (object) {
                            SAfeTest.this.failed = true;
                        }
                        Assert.fail((String)("An SQL Exception occured: " + e));
                    }
                    finally {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (SQLException e) {}
                        }
                        object = o1;
                        synchronized (object) {
                            ++SAfeTest.this.done;
                            o1.notify();
                        }
                    }
                }
            };
            threads[i].start();
            ++i;
        }
        while (true) {
            object = o1;
            synchronized (object) {
                if (this.started == threadCount) {
                    break;
                }
                o1.wait();
            }
        }
        object = o2;
        synchronized (object) {
            o2.notifyAll();
        }
        boolean passed = true;
        int i2 = 0;
        while (i2 < threadCount) {
            stmt0 = this.con.createStatement();
            rs = stmt0.executeQuery("SELECT 1234");
            passed &= rs.next();
            passed &= !rs.next();
            stmt0.close();
            ++i2;
        }
        while (true) {
            rs = o1;
            synchronized (rs) {
                if (this.done == threadCount) {
                    break;
                }
                o1.wait();
            }
        }
        int i3 = 0;
        while (i3 < threadCount) {
            threads[i3].join();
            ++i3;
        }
        stmt0.close();
        stmt.close();
        Assert.assertTrue((boolean)passed);
        Assert.assertTrue((!this.failed ? 1 : 0) != 0);
    }

    public void testCursorResultSetEmpty0004() throws Exception {
        Statement stmt = this.con.createStatement(1004, 1007);
        ResultSet rs = stmt.executeQuery("SELECT 5 Value WHERE 1=0");
        Assert.assertEquals(null, (Object)stmt.getWarnings());
        Assert.assertEquals(null, (Object)rs.getWarnings());
        Assert.assertEquals((Object)"Value", (Object)rs.getMetaData().getColumnName(1));
        Assert.assertTrue((!rs.isBeforeFirst() ? 1 : 0) != 0);
        Assert.assertTrue((!rs.isAfterLast() ? 1 : 0) != 0);
        Assert.assertTrue((!rs.isFirst() ? 1 : 0) != 0);
        Assert.assertTrue((!rs.isLast() ? 1 : 0) != 0);
        rs.next();
        Assert.assertTrue((!rs.isBeforeFirst() ? 1 : 0) != 0);
        Assert.assertTrue((!rs.isAfterLast() ? 1 : 0) != 0);
        Assert.assertTrue((!rs.isFirst() ? 1 : 0) != 0);
        Assert.assertTrue((!rs.isLast() ? 1 : 0) != 0);
        rs.close();
        stmt.close();
    }

    public void testBitFields0005() throws Exception {
        Statement stmt = this.con.createStatement();
        stmt.execute("create table #SAfe0005(id int primary key, bit1 bit not null, bit2 bit null) insert into #SAfe0005 values (0, 0, 0) insert into #SAfe0005 values (1, 1, 1) insert into #SAfe0005 values (2, 0, NULL)");
        while (stmt.getMoreResults() || stmt.getUpdateCount() != -1) {
        }
        ResultSet rs = stmt.executeQuery("SELECT * FROM #SAfe0005");
        while (rs.next()) {
            int id = rs.getInt(1);
            int bit1 = rs.getInt(2);
            int bit2 = rs.getInt(3);
            Assert.assertTrue((String)("id: " + id + "; bit1: " + bit1 + "; bit2: " + bit2), (bit1 == id % 2 && (bit2 == id || id == 2 && rs.wasNull()) ? 1 : 0) != 0);
        }
        rs.close();
        stmt.close();
    }

    public void testCallableStatement0006() throws Exception {
        int myVal = 13;
        Statement stmt = this.con.createStatement();
        stmt.execute("CREATE PROCEDURE #SAfe0006 @p1 INT, @p2 VARCHAR(20) OUT AS SELECT @p2=CAST(@p1-1 AS VARCHAR(20)) SELECT @p1 AS value RETURN @p1+1");
        stmt.close();
        String[] sql = new String[]{"{?=call #SAfe0006(?,?)}", "exec ?=#SAfe0006 ?,?", "?=#SAfe0006 ?,?"};
        int i = 0;
        while (i < sql.length) {
            CallableStatement cs = this.con.prepareCall(sql[i]);
            cs.registerOutParameter(1, 4);
            cs.setInt(2, 13);
            cs.registerOutParameter(3, 12);
            cs.executeQuery().close();
            Assert.assertEquals((int)14, (int)cs.getInt(1));
            Assert.assertEquals((Object)String.valueOf(12), (Object)cs.getString(3));
            cs.close();
            cs = this.con.prepareCall(sql[i]);
            cs.registerOutParameter(1, 4);
            cs.setInt(2, 13);
            cs.registerOutParameter(3, 12);
            Assert.assertTrue((boolean)cs.execute());
            cs.getResultSet().close();
            Assert.assertEquals((int)14, (int)cs.getInt(1));
            Assert.assertEquals((Object)String.valueOf(12), (Object)cs.getString(3));
            cs.close();
            ++i;
        }
    }

    private static void insertBigDecimal(PreparedStatement stmt, double val, boolean scaleFlag) throws Exception {
        BigDecimal bd = new BigDecimal(val);
        if (scaleFlag) {
            bd = bd.setScale(4, 6);
        }
        stmt.setBigDecimal(1, bd);
        int rowCount = stmt.executeUpdate();
        Assert.assertEquals((int)1, (int)rowCount);
        Assert.assertTrue((boolean)stmt.getMoreResults());
        ResultSet rs = stmt.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((String)"Values don't match.", (double)val, (double)rs.getDouble(1), (double)0.0);
    }

    public void testBigDecimal0007() throws Exception {
        Statement createStmt = this.con.createStatement();
        createStmt.execute("CREATE TABLE #SAfe0007(value MONEY)");
        createStmt.close();
        PreparedStatement stmt = this.con.prepareStatement("INSERT INTO #SAfe0007(value) VALUES (?) SELECT * FROM #SAfe0007 DELETE #SAfe0007");
        SAfeTest.insertBigDecimal(stmt, 1.1, false);
        SAfeTest.insertBigDecimal(stmt, 0.1, false);
        SAfeTest.insertBigDecimal(stmt, 0.1, true);
        SAfeTest.insertBigDecimal(stmt, 0.01, false);
        SAfeTest.insertBigDecimal(stmt, 0.01, true);
        SAfeTest.insertBigDecimal(stmt, 0.02, false);
        SAfeTest.insertBigDecimal(stmt, 0.02, true);
        SAfeTest.insertBigDecimal(stmt, 0.25, false);
        stmt.close();
    }

    public void testLongToVarchar0008() throws Exception {
        long myVal = 13L;
        Statement createStmt = this.con.createStatement();
        createStmt.execute("CREATE TABLE #SAfe0008(value VARCHAR(255))");
        createStmt.close();
        PreparedStatement stmt = this.con.prepareStatement("INSERT INTO #SAfe0008(value) values (?) SELECT * FROM #SAfe0008 DELETE #SAfe0008");
        stmt.setLong(1, myVal);
        int rowCount = stmt.executeUpdate();
        Assert.assertEquals((int)1, (int)rowCount);
        Assert.assertTrue((boolean)stmt.getMoreResults());
        ResultSet rs = stmt.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((String)"Values don't match.", (Object)String.valueOf(myVal), (Object)rs.getString(1));
        stmt.close();
    }

    public void testDeleteRow0009() throws Exception {
        Statement stmt = this.con.createStatement();
        stmt.execute("CREATE TABLE #SAfe0009(value VARCHAR(255) PRIMARY KEY)");
        stmt.close();
        PreparedStatement insStmt = this.con.prepareStatement("INSERT INTO #SAfe0009(value) values (?)");
        insStmt.setString(1, "Row 1");
        Assert.assertEquals((int)1, (int)insStmt.executeUpdate());
        insStmt.setString(1, "Row 2");
        Assert.assertEquals((int)1, (int)insStmt.executeUpdate());
        insStmt.close();
        stmt = this.con.createStatement(1005, 1008);
        ResultSet rs = stmt.executeQuery("SELECT * FROM #SAfe0009 ORDER BY 1");
        Assert.assertEquals(null, (Object)stmt.getWarnings());
        Assert.assertEquals(null, (Object)rs.getWarnings());
        Assert.assertTrue((boolean)rs.last());
        Assert.assertTrue((!rs.rowDeleted() ? 1 : 0) != 0);
        rs.deleteRow();
        Assert.assertTrue((boolean)rs.rowDeleted());
        rs.close();
        rs = stmt.executeQuery("SELECT * FROM #SAfe0009");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"Row 1", (Object)rs.getString(1));
        Assert.assertTrue((!rs.next() ? 1 : 0) != 0);
        rs.close();
        stmt.close();
    }

    public void testCallableStatementVarchar0010() throws Exception {
        Statement stmt = this.con.createStatement();
        stmt.execute("CREATE PROCEDURE #SAfe0010 @p1 VARCHAR(2049) OUT AS SELECT @p1 = @p1 + @p1 SELECT @p1 = @p1 + @p1 SELECT @p1 = @p1 + @p1 SELECT @p1 AS value RETURN LEN(@p1)");
        stmt.close();
        String myVal = "0123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345";
        CallableStatement cs = this.con.prepareCall("{?=call #SAfe0010(?)}");
        cs.registerOutParameter(1, 4);
        cs.setString(2, myVal);
        cs.registerOutParameter(2, 12);
        ResultSet rs = cs.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        String rsVal = rs.getString(1);
        rs.close();
        Assert.assertEquals((int)(myVal.length() * 8), (int)cs.getInt(1));
        Assert.assertEquals((Object)rsVal, (Object)cs.getString(2));
        cs.close();
    }

    public void testUpdateRow0011() throws Exception {
        Statement stmt = this.con.createStatement();
        stmt.execute("CREATE TABLE #SAfe0011(value VARCHAR(255) PRIMARY KEY)");
        stmt.close();
        PreparedStatement insStmt = this.con.prepareStatement("INSERT INTO #SAfe0011(value) values (?)");
        insStmt.setString(1, "Row 1");
        Assert.assertEquals((int)1, (int)insStmt.executeUpdate());
        insStmt.setString(1, "Row 2");
        Assert.assertEquals((int)1, (int)insStmt.executeUpdate());
        insStmt.close();
        stmt = this.con.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("SELECT * FROM #SAfe0011 ORDER BY 1");
        Assert.assertEquals(null, (Object)stmt.getWarnings());
        Assert.assertEquals(null, (Object)rs.getWarnings());
        Assert.assertTrue((boolean)rs.next());
        Assert.assertTrue((boolean)rs.next());
        rs.updateString(1, "Row X");
        rs.updateRow();
        rs.next();
        Assert.assertEquals((Object)"Row X", (Object)rs.getString(1));
        rs.close();
    }

    public void testInsertRow0012() throws Exception {
        Statement stmt = this.con.createStatement();
        stmt.execute("CREATE TABLE #SAfe0012(value VARCHAR(255) PRIMARY KEY)");
        stmt.close();
        PreparedStatement insStmt = this.con.prepareStatement("INSERT INTO #SAfe0012(value) values (?)");
        insStmt.setString(1, "Row 1");
        Assert.assertEquals((int)1, (int)insStmt.executeUpdate());
        insStmt.setString(1, "Row 2");
        Assert.assertEquals((int)1, (int)insStmt.executeUpdate());
        insStmt.close();
        stmt = this.con.createStatement(1005, 1008);
        ResultSet rs = stmt.executeQuery("SELECT * FROM #SAfe0012 ORDER BY 1");
        Assert.assertEquals(null, (Object)stmt.getWarnings());
        Assert.assertEquals(null, (Object)rs.getWarnings());
        rs.moveToInsertRow();
        rs.updateString(1, "Row X");
        rs.insertRow();
        rs.moveToCurrentRow();
        rs.next();
        Assert.assertEquals((Object)"Row 1", (Object)rs.getString(1));
        rs.next();
        Assert.assertEquals((Object)"Row 2", (Object)rs.getString(1));
        rs.next();
        Assert.assertEquals((Object)"Row X", (Object)rs.getString(1));
        rs.close();
    }

    public void testOutOfOrderClose0013() throws Exception {
        Logger.setActive(true);
        Connection localConn = this.getConnection();
        Statement stmt = localConn.createStatement();
        stmt.execute("CREATE TABLE #SAfe0013(value VARCHAR(255) PRIMARY KEY)");
        PreparedStatement insStmt = localConn.prepareStatement("INSERT INTO #SAfe0013(value) values (?)");
        insStmt.setString(1, "Row 1");
        Assert.assertEquals((int)1, (int)insStmt.executeUpdate());
        insStmt.setString(1, "Row 2");
        Assert.assertEquals((int)1, (int)insStmt.executeUpdate());
        ResultSet rs = stmt.executeQuery("SELECT * FROM #SAfe0013");
        localConn.close();
        stmt.close();
        insStmt.close();
        rs.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

