/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.test;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import junit.framework.Assert;
import junit.textui.TestRunner;
import net.sourceforge.jtds.test.TestBase;

public class PreparedStatementTest
extends TestBase {
    static /* synthetic */ Class class$net$sourceforge$jtds$test$PreparedStatementTest;

    public PreparedStatementTest(String name) {
        super(name);
    }

    public void testPreparedStatement() throws Exception {
        PreparedStatement pstmt = this.con.prepareStatement("SELECT * FROM #test");
        this.makeTestTables(pstmt);
        this.makeObjects(pstmt, 10);
        ResultSet rs = pstmt.executeQuery();
        this.dump(rs);
        rs.close();
    }

    public void testScrollablePreparedStatement() throws Exception {
        Statement stmt = this.con.createStatement();
        this.makeTestTables(stmt);
        this.makeObjects(stmt, 10);
        stmt.close();
        PreparedStatement pstmt = this.con.prepareStatement("SELECT * FROM #test", 1005, 1007);
        ResultSet rs = pstmt.executeQuery();
        Assert.assertTrue((boolean)rs.isBeforeFirst());
        while (rs.next()) {
        }
        Assert.assertTrue((boolean)rs.isAfterLast());
        while (rs.previous()) {
        }
        Assert.assertTrue((boolean)rs.isBeforeFirst());
        rs.close();
    }

    public void testPreparedStatementAddBatch1() throws Exception {
        int count = 50;
        Statement stmt = this.con.createStatement();
        stmt.execute("CREATE TABLE #psbatch1 (f_int INT)");
        stmt.close();
        int sum = 0;
        this.con.setAutoCommit(false);
        PreparedStatement pstmt = this.con.prepareStatement("INSERT INTO #psbatch1 (f_int) VALUES (?)");
        int i = 0;
        while (i < count) {
            pstmt.setInt(1, i);
            pstmt.addBatch();
            sum += i;
            ++i;
        }
        int[] results = pstmt.executeBatch();
        Assert.assertTrue((results.length == count ? 1 : 0) != 0);
        int i2 = 0;
        while (i2 < count) {
            Assert.assertTrue((results[i2] == 1 ? 1 : 0) != 0);
            ++i2;
        }
        pstmt.close();
        this.con.commit();
        this.con.setAutoCommit(true);
        Statement stmt2 = this.con.createStatement();
        ResultSet rs = stmt2.executeQuery("SELECT SUM(f_int) FROM #psbatch1");
        Assert.assertTrue((boolean)rs.next());
        System.out.println(rs.getInt(1));
        Assert.assertTrue((rs.getInt(1) == sum ? 1 : 0) != 0);
        stmt2.close();
        rs.close();
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$net$sourceforge$jtds$test$PreparedStatementTest == null ? (class$net$sourceforge$jtds$test$PreparedStatementTest = PreparedStatementTest.class$("net.sourceforge.jtds.test.PreparedStatementTest")) : class$net$sourceforge$jtds$test$PreparedStatementTest));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

