/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.test;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import net.sourceforge.jtds.test.DatabaseTestCase;
import net.sourceforge.jtds.util.Logger;

public class CSUnitTest
extends DatabaseTestCase {
    static PrintStream output = null;
    static /* synthetic */ Class class$net$sourceforge$jtds$test$CSUnitTest;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$sql$ResultSet;

    public CSUnitTest(String name) {
        super(name);
        if (output == null) {
            try {
                output = new PrintStream(new FileOutputStream("nul"));
            }
            catch (FileNotFoundException ex) {
                throw new RuntimeException("could not create device nul");
            }
        }
    }

    public static void main(String[] args) {
        Logger.setActive(true);
        if (args.length > 0) {
            output = System.out;
            TestSuite s = new TestSuite();
            int i = 0;
            while (i < args.length) {
                s.addTest((Test)new CSUnitTest(args[i]));
                ++i;
            }
            TestRunner.run((Test)s);
        } else {
            TestRunner.run((Class)(class$net$sourceforge$jtds$test$CSUnitTest == null ? (class$net$sourceforge$jtds$test$CSUnitTest = CSUnitTest.class$("net.sourceforge.jtds.test.CSUnitTest")) : class$net$sourceforge$jtds$test$CSUnitTest));
        }
    }

    public void testMaxRows0003() throws Exception {
        this.dropTable("#t0003");
        Statement stmt = this.con.createStatement();
        int count = stmt.executeUpdate("create table #t0003                (i  integer not null)       ");
        PreparedStatement pStmt = this.con.prepareStatement("insert into #t0003 values (?)");
        int rowsToAdd = 100;
        count = 0;
        int i = 1;
        while (i <= 100) {
            pStmt.setInt(1, i);
            count += pStmt.executeUpdate();
            ++i;
        }
        Assert.assertTrue((String)("count: " + count + " rowsToAdd: " + 100), (count == 100 ? 1 : 0) != 0);
        pStmt.close();
        pStmt = this.con.prepareStatement("select i from #t0003 order by i");
        int rowLimit = 32;
        pStmt.setMaxRows(rowLimit);
        Assert.assertTrue((pStmt.getMaxRows() == rowLimit ? 1 : 0) != 0);
        ResultSet rs = pStmt.executeQuery();
        count = 0;
        while (rs.next()) {
            int n = rs.getInt("i");
            ++count;
        }
        Assert.assertTrue((count == rowLimit ? 1 : 0) != 0);
    }

    public void testGetAsciiStream0018() throws Exception {
        int count = 0;
        Statement stmt = this.con.createStatement();
        String bigtext1 = "abcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnopabcdefghijklmnop";
        String bigimage1 = "0x0123456789abcdeffedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210";
        this.dropTable("#t0018");
        String sql = "create table #t0018 (                                   mybinary                   binary(5) not null,        myvarbinary                varbinary(4) not null,     mychar                     char(10) not null,         myvarchar                  varchar(8) not null,       mytext                     text not null,             myimage                    image not null,            mynullbinary               binary(3) null,            mynullvarbinary            varbinary(6) null,         mynullchar                 char(10) null,             mynullvarchar              varchar(40) null,          mynulltext                 text null,                 mynullimage                image null)               ";
        count = stmt.executeUpdate(sql);
        sql = "insert into #t0018(        mybinary,                myvarbinary,             mychar,                  myvarchar,               mytext,                  myimage,                 mynullbinary,            mynullvarbinary,         mynullchar,              mynullvarchar,           mynulltext,              mynullimage             )                        values(                   0xffeeddccbb,            0x78,                    'Z',                     '',                      '" + bigtext1 + "',     " + " " + bigimage1 + ",      " + " null,                   " + " null,                   " + " null,                   " + " null,                   " + " null,                   " + " null                    " + ")";
        count = stmt.executeUpdate(sql);
        sql = "select * from #t0018";
        ResultSet rs = stmt.executeQuery(sql);
        if (!rs.next()) {
            Assert.assertTrue((String)"should get Result", (boolean)false);
        } else {
            output.println("Getting the results");
            output.println("mybinary is " + rs.getObject("mybinary"));
            output.println("myvarbinary is " + rs.getObject("myvarbinary"));
            output.println("mychar is " + rs.getObject("mychar"));
            output.println("myvarchar is " + rs.getObject("myvarchar"));
            output.println("mytext is " + rs.getObject("mytext"));
            output.println("myimage is " + rs.getObject("myimage"));
            output.println("mynullbinary is " + rs.getObject("mynullbinary"));
            output.println("mynullvarbinary is " + rs.getObject("mynullvarbinary"));
            output.println("mynullchar is " + rs.getObject("mynullchar"));
            output.println("mynullvarchar is " + rs.getObject("mynullvarchar"));
            output.println("mynulltext is " + rs.getObject("mynulltext"));
            output.println("mynullimage is " + rs.getObject("mynullimage"));
        }
    }

    public void testMoneyHandling0019() throws Exception {
        Statement stmt = null;
        Object tmp1 = null;
        Object tmp2 = null;
        BigDecimal[] money = new BigDecimal[]{new BigDecimal("922337203685477.5807"), new BigDecimal("-922337203685477.5807"), new BigDecimal("1.0000"), new BigDecimal("0.0000"), new BigDecimal("-1.0000")};
        BigDecimal[] smallmoney = new BigDecimal[]{new BigDecimal("214748.3647"), new BigDecimal("-214748.3648"), new BigDecimal("1.0000"), new BigDecimal("0.0000"), new BigDecimal("-1.0000")};
        if (smallmoney.length != money.length) {
            throw new SQLException("Must have same number of elements in money and smallmoney");
        }
        stmt = this.con.createStatement();
        this.dropTable("#t0019");
        stmt.executeUpdate("create table #t0019 (                       i               integer primary key,     mymoney         money not null,          mysmallmoney    smallmoney not null)   ");
        int i = 0;
        while (i < money.length) {
            stmt.executeUpdate("insert into #t0019 values (" + i + ", " + money[i] + ",   " + smallmoney[i] + ")         ");
            ++i;
        }
        ResultSet rs = stmt.executeQuery("select * from #t0019 order by i");
        i = 0;
        while (rs.next()) {
            BigDecimal m = (BigDecimal)rs.getObject("mymoney");
            BigDecimal sm = (BigDecimal)rs.getObject("mysmallmoney");
            Assert.assertEquals((Object)m, (Object)money[i]);
            Assert.assertEquals((Object)sm, (Object)smallmoney[i]);
            output.println(m + ", " + sm);
            ++i;
        }
    }

    public void testDataTypes0027() throws Exception {
        output.println("Test all the SQLServer datatypes in Statement\nand PreparedStatement using the preferred getXXX()\ninstead of getObject like #t0017.java does.");
        output.println("!!!Note- This test is not fully implemented yet!!!");
        Statement stmt = this.con.createStatement();
        stmt.execute("set dateformat ymd");
        this.dropTable("#t0027");
        String sql = "create table #t0027 (                                   mybinary                   binary(5) not null,        myvarbinary                varbinary(4) not null,     mychar                     char(10) not null,         myvarchar                  varchar(8) not null,       mydatetime                 datetime not null,         mysmalldatetime            smalldatetime not null,    mydecimal10_3              decimal(10,3) not null,    mynumeric5_4               numeric (5,4) not null,    myfloat6                   float(6) not null,         myfloat14                  float(6) not null,         myreal                     real not null,             myint                      int not null,              mysmallint                 smallint not null,         mytinyint                  tinyint not null,          mymoney                    money not null,            mysmallmoney               smallmoney not null,       mybit                      bit not null,              mytimestamp                timestamp not null,        mytext                     text not null,             myimage                    image not null,            mynullbinary               binary(3) null,           mynullvarbinary            varbinary(6) null,        mynullchar                 char(10) null,             mynullvarchar              varchar(40) null,          mynulldatetime             datetime null,             mynullsmalldatetime        smalldatetime null,        mynulldecimal10_3          decimal(10,3) null,        mynullnumeric15_10         numeric(15,10) null,       mynullfloat6               float(6) null,             mynullfloat14              float(14) null,            mynullreal                 real null,                 mynullint                  int null,                  mynullsmallint             smallint null,             mynulltinyint              tinyint null,              mynullmoney                money null,                mynullsmallmoney           smallmoney null,           mynulltext                 text null,                 mynullimage                image null)               ";
        int count = stmt.executeUpdate(sql);
        sql = "insert into #t0027                 (mybinary,                       myvarbinary,                    mychar,                         myvarchar,                      mydatetime,                     mysmalldatetime,                mydecimal10_3,                  mynumeric5_4,                 myfloat6,                       myfloat14,                      myreal,                         myint,                          mysmallint,                     mytinyint,                      mymoney,                        mysmallmoney,                   mybit,                          mytimestamp,                    mytext,                         myimage,                        mynullbinary,                   mynullvarbinary,                mynullchar,                     mynullvarchar,                  mynulldatetime,                 mynullsmalldatetime,            mynulldecimal10_3,              mynullnumeric15_10,             mynullfloat6,                   mynullfloat14,                  mynullreal,                     mynullint,                      mynullsmallint,                 mynulltinyint,                  mynullmoney,                    mynullsmallmoney,               mynulltext,                     mynullimage)                  values                            (0x1213141516,                   0x1718191A,                     '1234567890',                   '12345678',                     '19991015 21:29:59.01',         '19991015 20:45',               1234567.089,                    1.2345,                         65.4321,                        1.123456789,                    987654321.0,                    4097,                           4094,                           200,                            19.95,                          9.97,                           1,                              null,                           'abcdefg',                      0x0AAABB,                       0x123456,                       0xAB,                           'z',                            'zyx',                          '1976-07-04 12:00:00.04',       '2000-02-29 13:46',              1.23,                           7.1234567891,                   987654,                         0,                              -1.1,                           -10,                            126,                            7,                              -19999.00,                      -9.97,                          '1234',                         0x1200340056)              ";
        count = stmt.executeUpdate(sql);
        sql = "select * from #t0027";
        ResultSet rs = stmt.executeQuery(sql);
        Assert.assertTrue((boolean)rs.next());
        output.println("mybinary is " + rs.getObject("mybinary"));
        output.println("myvarbinary is " + rs.getObject("myvarbinary"));
        output.println("mychar is " + rs.getString("mychar"));
        output.println("myvarchar is " + rs.getString("myvarchar"));
        output.println("mydatetime is " + rs.getTimestamp("mydatetime"));
        output.println("mysmalldatetime is " + rs.getTimestamp("mysmalldatetime"));
        output.println("mydecimal10_3 is " + rs.getObject("mydecimal10_3"));
        output.println("mynumeric5_4 is " + rs.getObject("mynumeric5_4"));
        output.println("myfloat6 is " + rs.getDouble("myfloat6"));
        output.println("myfloat14 is " + rs.getDouble("myfloat14"));
        output.println("myreal is " + rs.getDouble("myreal"));
        output.println("myint is " + rs.getInt("myint"));
        output.println("mysmallint is " + rs.getShort("mysmallint"));
        output.println("mytinyint is " + rs.getByte("mytinyint"));
        output.println("mymoney is " + rs.getObject("mymoney"));
        output.println("mysmallmoney is " + rs.getObject("mysmallmoney"));
        output.println("mybit is " + rs.getObject("mybit"));
        output.println("mytimestamp is " + rs.getObject("mytimestamp"));
        output.println("mytext is " + rs.getObject("mytext"));
        output.println("myimage is " + rs.getObject("myimage"));
        output.println("mynullbinary is " + rs.getObject("mynullbinary"));
        output.println("mynullvarbinary is " + rs.getObject("mynullvarbinary"));
        output.println("mynullchar is " + rs.getString("mynullchar"));
        output.println("mynullvarchar is " + rs.getString("mynullvarchar"));
        output.println("mynulldatetime is " + rs.getTimestamp("mynulldatetime"));
        output.println("mynullsmalldatetime is " + rs.getTimestamp("mynullsmalldatetime"));
        output.println("mynulldecimal10_3 is " + rs.getObject("mynulldecimal10_3"));
        output.println("mynullnumeric15_10 is " + rs.getObject("mynullnumeric15_10"));
        output.println("mynullfloat6 is " + rs.getDouble("mynullfloat6"));
        output.println("mynullfloat14 is " + rs.getDouble("mynullfloat14"));
        output.println("mynullreal is " + rs.getDouble("mynullreal"));
        output.println("mynullint is " + rs.getInt("mynullint"));
        output.println("mynullsmallint is " + rs.getShort("mynullsmallint"));
        output.println("mynulltinyint is " + rs.getByte("mynulltinyint"));
        output.println("mynullmoney is " + rs.getObject("mynullmoney"));
        output.println("mynullsmallmoney is " + rs.getObject("mynullsmallmoney"));
        output.println("mynulltext is " + rs.getObject("mynulltext"));
        output.println("mynullimage is " + rs.getObject("mynullimage"));
    }

    public void testCallStoredProcedures0028() throws Exception {
        Statement stmt = this.con.createStatement();
        ResultSet rs = null;
        int resultSetCount = 0;
        int rowCount = 0;
        int numberOfUpdates = 0;
        boolean isResultSet = stmt.execute("EXEC sp_who");
        output.println("execute(EXEC sp_who) returned: " + isResultSet);
        int updateCount = stmt.getUpdateCount();
        while (isResultSet || updateCount != -1) {
            if (isResultSet) {
                ++resultSetCount;
                rs = stmt.getResultSet();
                ResultSetMetaData rsMeta = rs.getMetaData();
                int columnCount = rsMeta.getColumnCount();
                output.println("columnCount: " + Integer.toString(columnCount));
                int n = 1;
                while (n <= columnCount) {
                    output.println(Integer.toString(n) + ": " + rsMeta.getColumnName(n));
                    ++n;
                }
                while (rs.next()) {
                    ++rowCount;
                    int n2 = 1;
                    while (n2 <= columnCount) {
                        output.println(Integer.toString(n2) + ": " + rs.getString(n2));
                        ++n2;
                    }
                }
            } else {
                numberOfUpdates += updateCount;
                output.println("UpdateCount: " + Integer.toString(updateCount));
            }
            isResultSet = stmt.getMoreResults();
            updateCount = stmt.getUpdateCount();
        }
        output.println("resultSetCount: " + resultSetCount);
        output.println("Total rowCount: " + rowCount);
        output.println("Number of updates: " + numberOfUpdates);
        Assert.assertTrue((rowCount >= 1 && numberOfUpdates == 0 && resultSetCount == 1 ? 1 : 0) != 0);
    }

    public void testxx0029() throws Exception {
        int updateCount;
        boolean isResultSet;
        Statement stmt = this.con.createStatement();
        boolean count = false;
        ResultSet rs = null;
        int resultSetCount = 0;
        int rowCount = 0;
        int numberOfUpdates = 0;
        output.println("before execute DROP PROCEDURE");
        try {
            isResultSet = stmt.execute("DROP PROCEDURE #t0029_p1");
            updateCount = stmt.getUpdateCount();
            do {
                output.println("DROP PROCEDURE isResultSet: " + isResultSet);
                output.println("DROP PROCEDURE updateCount: " + updateCount);
                isResultSet = stmt.getMoreResults();
            } while ((updateCount = stmt.getUpdateCount()) != -1 && !isResultSet || isResultSet);
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            isResultSet = stmt.execute("DROP PROCEDURE #t0029_p2");
            updateCount = stmt.getUpdateCount();
            do {
                output.println("DROP PROCEDURE isResultSet: " + isResultSet);
                output.println("DROP PROCEDURE updateCount: " + updateCount);
                isResultSet = stmt.getMoreResults();
            } while ((updateCount = stmt.getUpdateCount()) != -1 && !isResultSet || isResultSet);
        }
        catch (SQLException e) {
            // empty catch block
        }
        this.dropTable("#t0029_t1");
        isResultSet = stmt.execute(" create table #t0029_t1                         (t1 datetime not null,                        t2 datetime null,                            t3 smalldatetime not null,                   t4 smalldatetime null,                       t5 text null)                             ");
        updateCount = stmt.getUpdateCount();
        do {
            output.println("CREATE TABLE isResultSet: " + isResultSet);
            output.println("CREATE TABLE updateCount: " + updateCount);
            isResultSet = stmt.getMoreResults();
        } while ((updateCount = stmt.getUpdateCount()) != -1 && !isResultSet || isResultSet);
        isResultSet = stmt.execute("CREATE PROCEDURE #t0029_p1 AS                 insert into #t0029_t1 values                 ('1999-01-07', '1998-09-09 15:35:05',        getdate(), '1998-09-09 15:35:00', null)      update #t0029_t1 set t1='1999-01-01'          insert into #t0029_t1 values                 ('1999-01-08', '1998-09-09 15:35:05',        getdate(), '1998-09-09 15:35:00','456')      update #t0029_t1 set t2='1999-01-02'         declare @ptr varbinary(16)                   select @ptr=textptr(t5) from #t0029_t1         where t1='1999-01-08'                      writetext #t0029_t1.t5 @ptr with log '123'  ");
        updateCount = stmt.getUpdateCount();
        do {
            output.println("CREATE PROCEDURE isResultSet: " + isResultSet);
            output.println("CREATE PROCEDURE updateCount: " + updateCount);
            isResultSet = stmt.getMoreResults();
        } while ((updateCount = stmt.getUpdateCount()) != -1 && !isResultSet || isResultSet);
        isResultSet = stmt.execute("CREATE PROCEDURE #t0029_p2 AS                 set nocount on  EXEC #t0029_p1                               SELECT * FROM #t0029_t1                     ");
        updateCount = stmt.getUpdateCount();
        do {
            output.println("CREATE PROCEDURE isResultSet: " + isResultSet);
            output.println("CREATE PROCEDURE updateCount: " + updateCount);
            isResultSet = stmt.getMoreResults();
        } while ((updateCount = stmt.getUpdateCount()) != -1 && !isResultSet || isResultSet);
        isResultSet = stmt.execute("EXEC  #t0029_p2  ");
        output.println("execute(EXEC #t0029_p2) returned: " + isResultSet);
        updateCount = stmt.getUpdateCount();
        while (isResultSet || updateCount != -1) {
            if (isResultSet) {
                ++resultSetCount;
                rs = stmt.getResultSet();
                ResultSetMetaData rsMeta = rs.getMetaData();
                int columnCount = rsMeta.getColumnCount();
                output.println("columnCount: " + Integer.toString(columnCount));
                int n = 1;
                while (n <= columnCount) {
                    output.println(Integer.toString(n) + ": " + rsMeta.getColumnName(n));
                    ++n;
                }
                while (rs.next()) {
                    ++rowCount;
                    int n2 = 1;
                    while (n2 <= columnCount) {
                        output.println(Integer.toString(n2) + ": " + rs.getString(n2));
                        ++n2;
                    }
                }
            } else {
                numberOfUpdates += updateCount;
                output.println("UpdateCount: " + Integer.toString(updateCount));
            }
            isResultSet = stmt.getMoreResults();
            updateCount = stmt.getUpdateCount();
        }
        output.println("resultSetCount: " + resultSetCount);
        output.println("Total rowCount: " + rowCount);
        output.println("Number of updates: " + numberOfUpdates);
        Assert.assertTrue((resultSetCount == 1 && rowCount == 2 && numberOfUpdates == 0 ? 1 : 0) != 0);
    }

    public void testDataTypesByResultSetMetaData0030() throws Exception {
        boolean passed = true;
        Statement stmt = this.con.createStatement();
        boolean count = false;
        String sql = "select  convert(tinyint, 2),   convert(smallint, 5)  ";
        ResultSet rs = stmt.executeQuery(sql);
        if (!rs.next()) {
            passed = false;
        } else {
            ResultSetMetaData meta = rs.getMetaData();
            if (meta.getColumnType(1) != -6) {
                output.println("tinyint column was read as " + meta.getColumnType(1));
                passed = false;
            }
            if (meta.getColumnType(2) != 5) {
                output.println("smallint column was read as " + meta.getColumnType(2));
                passed = false;
            }
            if (rs.getInt(1) != 2) {
                output.println("Bogus value read for tinyint");
                passed = false;
            }
            if (rs.getInt(2) != 5) {
                output.println("Bogus value read for smallint");
                passed = false;
            }
        }
        Assert.assertTrue((boolean)passed);
    }

    public void testTextColumns0031() throws Exception {
        Statement stmt = this.con.createStatement();
        boolean passed = true;
        output.println("Starting test #t0031-  test text columns");
        int count = 0;
        this.dropTable("#t0031");
        count = stmt.executeUpdate("create table #t0031                  (t_nullable      text null,        t_notnull       text not null,    i               int not null)  ");
        output.println("Creating table affected " + count + " rows");
        stmt.executeUpdate("insert into #t0031 values(null, '',   1)");
        stmt.executeUpdate("insert into #t0031 values(null, 'b1', 2)");
        stmt.executeUpdate("insert into #t0031 values('',   '',   3)");
        stmt.executeUpdate("insert into #t0031 values('',   'b2', 4)");
        stmt.executeUpdate("insert into #t0031 values('a1', '',   5)");
        stmt.executeUpdate("insert into #t0031 values('a2', 'b3', 6)");
        ResultSet rs = stmt.executeQuery("select * from #t0031  order by i ");
        if (!rs.next()) {
            throw new SQLException("Failed");
        }
        passed = passed && rs.getString(1) == null;
        passed = passed && rs.getString(2).equals("");
        boolean bl = passed = passed && rs.getInt(3) == 1;
        if (!rs.next()) {
            throw new SQLException("Failed");
        }
        passed = passed && rs.getString(1) == null;
        passed = passed && rs.getString(2).equals("b1");
        boolean bl2 = passed = passed && rs.getInt(3) == 2;
        if (!rs.next()) {
            throw new SQLException("Failed");
        }
        passed = passed && rs.getString(1).equals("");
        passed = passed && rs.getString(2).equals("");
        boolean bl3 = passed = passed && rs.getInt(3) == 3;
        if (!rs.next()) {
            throw new SQLException("Failed");
        }
        passed = passed && rs.getString(1).equals("");
        passed = passed && rs.getString(2).equals("b2");
        boolean bl4 = passed = passed && rs.getInt(3) == 4;
        if (!rs.next()) {
            throw new SQLException("Failed");
        }
        passed = passed && rs.getString(1).equals("a1");
        passed = passed && rs.getString(2).equals("");
        boolean bl5 = passed = passed && rs.getInt(3) == 5;
        if (!rs.next()) {
            throw new SQLException("Failed");
        }
        passed = passed && rs.getString(1).equals("a2");
        passed = passed && rs.getString(2).equals("b3");
        passed = passed && rs.getInt(3) == 6;
        Assert.assertTrue((boolean)passed);
    }

    public void testSpHelpSysUsers0032() throws Exception {
        Statement stmt = this.con.createStatement();
        boolean passed = true;
        boolean done = false;
        int updateCount = 0;
        output.println("Starting test #t0032-  test sp_help sysusers");
        boolean count = false;
        boolean isResultSet = stmt.execute("sp_help sysusers");
        output.println("Executed the statement.  rc is " + isResultSet);
        do {
            if (isResultSet) {
                output.println("About to call getResultSet");
                ResultSet rs = stmt.getResultSet();
                ResultSetMetaData meta = rs.getMetaData();
                updateCount = 0;
                while (rs.next()) {
                    int i = 1;
                    while (i <= meta.getColumnCount()) {
                        output.print(rs.getString(i) + "\t");
                        ++i;
                    }
                    output.println("");
                }
                output.println("Done processing the result set");
            } else {
                output.println("About to call getUpdateCount()");
                updateCount = stmt.getUpdateCount();
                output.println("Updated " + updateCount + " rows");
            }
            output.println("About to call getMoreResults()");
        } while (!(done = !(isResultSet = stmt.getMoreResults()) && updateCount == -1));
        Assert.assertTrue((boolean)passed);
    }

    static String longString(char ch) {
        String str255 = "";
        int i = 0;
        while (i < 255) {
            str255 = str255 + ch;
            ++i;
        }
        return str255;
    }

    public void testExceptionByUpdate0033() throws Exception {
        boolean passed;
        Statement stmt = this.con.createStatement();
        output.println("Starting test #t0033-  make sure Statement.executeUpdate() throws exception");
        try {
            passed = false;
            stmt.executeUpdate("I am sure this is an error");
        }
        catch (SQLException e) {
            output.println("The exception is " + e.getMessage());
            passed = true;
        }
        Assert.assertTrue((boolean)passed);
    }

    public void testInsertConflict0049() throws Exception {
        PreparedStatement pstmt;
        String query;
        int count;
        Statement stmt;
        block2: {
            stmt = this.con.createStatement();
            count = 0;
            this.dropTable("#t0049b");
            this.dropTable("#t0049a");
            query = "create table #t0049a(                      a integer identity(1,1) primary key,    b char    not null)";
            count = stmt.executeUpdate(query);
            output.println("Creating table affected " + count + " rows");
            query = "create table #t0049b(                      a integer not null,                     c char    not null,                     foreign key (a) references #t0049a(a)) ";
            count = stmt.executeUpdate(query);
            output.println("Creating table affected " + count + " rows");
            query = "insert into #t0049b (a, c) values (?, ?)";
            pstmt = this.con.prepareStatement(query);
            try {
                pstmt.setInt(1, 1);
                pstmt.setString(2, "a");
                count = pstmt.executeUpdate();
            }
            catch (SQLException e) {
                if (e.getMessage().startsWith("INSERT statement conflicted")) break block2;
                throw e;
            }
        }
        pstmt.close();
        count = stmt.executeUpdate("insert into #t0049a (b) values ('a')");
        output.println("insert affected " + count + " rows");
        pstmt = this.con.prepareStatement(query);
        pstmt.setInt(1, 1);
        pstmt.setString(2, "a");
        int n = pstmt.executeUpdate();
    }

    public void testxx0050() throws Exception {
        PreparedStatement pstmt;
        String query;
        int count;
        boolean passed;
        Statement stmt;
        block5: {
            block4: {
                stmt = this.con.createStatement();
                passed = true;
                count = 0;
                try {
                    stmt.executeUpdate("drop procedure p0050");
                }
                catch (SQLException e) {
                    if (e.getMessage().startsWith("Cannot drop the procedure 'p0050', because it does")) break block4;
                    throw e;
                }
            }
            this.dropTable("#t0050b");
            this.dropTable("#t0050a");
            query = "create table #t0050a(                      a integer identity(1,1) primary key,    b char    not null)";
            count = stmt.executeUpdate(query);
            output.println("Creating table affected " + count + " rows");
            query = "create table #t0050b(                      a integer not null,                     c char    not null,                     foreign key (a) references #t0050a(a)) ";
            count = stmt.executeUpdate(query);
            output.println("Creating table affected " + count + " rows");
            query = "create procedure #p0050 (@a integer, @c char) as    insert into #t0050b (a, c) values (@a, @c)    ";
            count = stmt.executeUpdate(query);
            output.println("Creating procedure affected " + count + " rows");
            query = "exec #p0050 ?, ?";
            pstmt = this.con.prepareStatement(query);
            try {
                pstmt.setInt(1, 1);
                pstmt.setString(2, "a");
                count = pstmt.executeUpdate();
            }
            catch (SQLException e) {
                if (e.getMessage().startsWith("INSERT statement conflicted")) break block5;
                throw e;
            }
        }
        pstmt.close();
        count = stmt.executeUpdate("insert into #t0050a (b) values ('a')");
        output.println("insert affected " + count + " rows");
        pstmt = this.con.prepareStatement(query);
        pstmt.setInt(1, 1);
        pstmt.setString(2, "a");
        count = pstmt.executeUpdate();
        Assert.assertTrue((boolean)passed);
    }

    public void testxx0051() throws Exception {
        boolean passed = true;
        boolean count = false;
        Statement stmt = this.con.createStatement();
        try {
            String[] types = new String[]{"TABLE"};
            DatabaseMetaData dbMetaData = this.con.getMetaData();
            ResultSet rs = dbMetaData.getTables(null, "%", "t%", types);
            while (rs.next()) {
                output.println("Table " + rs.getString(3));
                output.println("  catalog " + rs.getString(1));
                output.println("  schema  " + rs.getString(2));
                output.println("  name    " + rs.getString(3));
                output.println("  type    " + rs.getString(4));
                output.println("  remarks " + rs.getString(5));
            }
        }
        catch (SQLException e) {
            passed = false;
            output.println("Exception caught.  " + e.getMessage());
            e.printStackTrace();
        }
        Assert.assertTrue((boolean)passed);
    }

    public void testxx0055() throws Exception {
        boolean passed = true;
        boolean count = false;
        Statement stmt = this.con.createStatement();
        try {
            String[] expectedNames = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE", "REMARKS"};
            String[] types = new String[]{"TABLE"};
            DatabaseMetaData dbMetaData = this.con.getMetaData();
            ResultSet rs = dbMetaData.getTables(null, "%", "t%", types);
            ResultSetMetaData rsMetaData = rs.getMetaData();
            if (rsMetaData.getColumnCount() != 5 && passed) {
                passed = false;
                output.println("Bad column count.  Should be 5, was " + rsMetaData.getColumnCount());
            }
            int i = 0;
            while (passed && i < expectedNames.length) {
                if (!rsMetaData.getColumnName(i + 1).equals(expectedNames[i])) {
                    passed = false;
                    output.println("Bad name for column " + (i + 1) + ".  " + "Was " + rsMetaData.getColumnName(i + 1) + ", expected " + expectedNames[i]);
                }
                ++i;
            }
        }
        catch (SQLException e) {
            passed = false;
            output.println("Exception caught.  " + e.getMessage());
            e.printStackTrace();
        }
        Assert.assertTrue((boolean)passed);
    }

    public void testxx0052() throws Exception {
        boolean passed = true;
        byte[] image = new byte[]{71, 73, 70, 56, 57, 97, 10, 0, 10, 0, -128, -1, 0, -41, 61, 27, 0, 0, 0, 44, 0, 0, 0, 0, 10, 0, 10, 0, 0, 2, 8, -124, -113, -87, -53, -19, 15, 99, 43, 0, 59};
        int count = 0;
        Statement stmt = this.con.createStatement();
        this.dropTable("#t0052");
        try {
            String sql = "create table #t0052 (                                   myvarchar                varchar(2000) not null,      myvarbinary              varbinary(2000) not null)   ";
            stmt.executeUpdate(sql);
            sql = "insert into #t0052                 (myvarchar,                      myvarbinary)                  values                           ('This is a test with german umlauts \u00e4\u00f6\u00fc',    0x4749463839610A000A0080FF00D73D1B0000002C000000000A000A00000208848FA9CBED0F632B003B  )";
            stmt.executeUpdate(sql);
            sql = "select * from #t0052";
            ResultSet rs = stmt.executeQuery(sql);
            if (!rs.next()) {
                passed = false;
            } else {
                int actuallyRead;
                int i;
                output.println("Testing getAsciiStream()");
                InputStream in = rs.getAsciiStream("myvarchar");
                String expect = "This is a test with german umlauts ???";
                byte[] toRead = new byte[expect.length()];
                count = in.read(toRead);
                if (count == expect.length()) {
                    i = 0;
                    while (i < expect.length()) {
                        if (expect.charAt(i) != toRead[i]) {
                            passed = false;
                            output.println("Expected " + expect.charAt(i) + " but was " + toRead[i]);
                        }
                        ++i;
                    }
                } else {
                    passed = false;
                    output.println("Premature end in getAsciiStream(\"myvarchar\") " + count + " instead of " + expect.length());
                }
                in.close();
                in = rs.getAsciiStream(2);
                toRead = new byte[41];
                count = in.read(toRead);
                if (count == 41) {
                    i = 0;
                    while (i < 41) {
                        if (toRead[i] != (toRead[i] & 0x7F)) {
                            passed = false;
                            output.println("Non ASCII characters in getAsciiStream");
                            break;
                        }
                        ++i;
                    }
                } else {
                    passed = false;
                    output.println("Premature end in getAsciiStream(1) " + count + " instead of 41");
                }
                in.close();
                output.println("Testing getUnicodeStream()");
                Reader reader = rs.getCharacterStream("myvarchar");
                expect = "This is a test with german umlauts \u00e4\u00f6\u00fc";
                char[] charsToRead = new char[expect.length()];
                count = reader.read(charsToRead, 0, expect.length());
                if (count == expect.length()) {
                    String result = new String(charsToRead);
                    if (!expect.equals(result)) {
                        passed = false;
                        output.println("Expected " + expect + " but was " + result);
                    }
                } else {
                    passed = false;
                    output.println("Premature end in getUnicodeStream(\"myvarchar\") " + count + " instead of " + expect.length());
                }
                reader.close();
                reader = rs.getCharacterStream(2);
                reader.close();
                output.println("Testing getBinaryStream()");
                in = rs.getBinaryStream("myvarchar");
                in.close();
                in = rs.getBinaryStream(2);
                count = 0;
                toRead = new byte[image.length];
                do {
                    if ((actuallyRead = in.read(toRead, count, image.length - count)) != -1) continue;
                    passed = false;
                    output.println("Premature end in  getBinaryStream(2) " + count + " instead of " + image.length);
                    break;
                } while ((count += actuallyRead) < image.length);
                i = 0;
                while (i < count) {
                    if (toRead[i] != image[i]) {
                        passed = false;
                        output.println("Expected " + toRead[i] + "but was " + image[i]);
                        break;
                    }
                    ++i;
                }
                in.close();
                output.println("Testing getCharacterStream()");
                try {
                    Method getCharacterStreamString = (class$java$sql$ResultSet == null ? (class$java$sql$ResultSet = CSUnitTest.class$("java.sql.ResultSet")) : class$java$sql$ResultSet).getMethod("getCharacterStream", class$java$lang$String == null ? (class$java$lang$String = CSUnitTest.class$("java.lang.String")) : class$java$lang$String);
                    Method getCharacterStreamInt = (class$java$sql$ResultSet == null ? (class$java$sql$ResultSet = CSUnitTest.class$("java.sql.ResultSet")) : class$java$sql$ResultSet).getMethod("getCharacterStream", Integer.TYPE);
                    reader = (Reader)getCharacterStreamString.invoke((Object)rs, "myvarchar");
                    expect = "This is a test with german umlauts \u00e4\u00f6\u00fc";
                    charsToRead = new char[expect.length()];
                    count = reader.read(charsToRead, 0, expect.length());
                    if (count == expect.length()) {
                        String result = new String(charsToRead);
                        if (!expect.equals(result)) {
                            passed = false;
                            output.println("Expected " + expect + " but was " + result);
                        }
                    } else {
                        passed = false;
                        output.println("Premature end in getCharacterStream(\"myvarchar\") " + count + " instead of " + expect.length());
                    }
                    reader.close();
                    reader = (Reader)getCharacterStreamInt.invoke((Object)rs, new Integer(2));
                    reader.close();
                }
                catch (NoSuchMethodException e) {
                    output.println("JDBC 2 only");
                }
                catch (Throwable t) {
                    passed = false;
                    output.println("Exception: " + t.getMessage());
                }
            }
            rs.close();
        }
        catch (SQLException e) {
            passed = false;
            output.println("Exception caught.  " + e.getMessage());
            e.printStackTrace();
        }
        Assert.assertTrue((boolean)passed);
    }

    public void testxx0053() throws Exception {
        boolean passed = true;
        boolean count = false;
        Statement stmt = this.con.createStatement();
        this.dropTable("#t0053");
        try {
            String sql = "create table #t0053 (                                   myvarchar                varchar(2000)  not null,     mynchar                  nchar(2000)    not null,     mynvarchar               nvarchar(2000) not null,     myntext                  ntext          not null      )   ";
            stmt.executeUpdate(sql);
            sql = "insert into #t0053                 (myvarchar,                      mynchar,                        mynvarchar,                     myntext)                      values                           ('AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA',        '\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc',                     '\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc',                     '\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc'                     )";
            stmt.executeUpdate(sql);
            sql = "select * from #t0053";
            ResultSet rs = stmt.executeQuery(sql);
            if (!rs.next()) {
                passed = false;
            } else {
                System.err.print("Testing varchars > 255 chars: ");
                String test = rs.getString(1);
                if (test.length() == 270) {
                    System.err.println("passed");
                } else {
                    System.err.println("failed");
                    passed = false;
                }
                System.err.print("Testing nchar: ");
                test = rs.getString(2);
                if (test.length() == 2000 && "\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc".equals(test.trim())) {
                    System.err.println("passed");
                } else {
                    System.err.print("failed, got '");
                    System.err.print(test.trim());
                    System.err.println("' instead of '\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc'");
                    passed = false;
                }
                System.err.print("Testing nvarchar: ");
                test = rs.getString(3);
                if (test.length() == 6 && "\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc".equals(test)) {
                    System.err.println("passed");
                } else {
                    System.err.print("failed, got '");
                    System.err.print(test);
                    System.err.println("' instead of '\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc'");
                    passed = false;
                }
                System.err.print("Testing ntext: ");
                test = rs.getString(4);
                if (test.length() == 6 && "\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc".equals(test)) {
                    System.err.println("passed");
                } else {
                    System.err.print("failed, got '");
                    System.err.print(test);
                    System.err.println("' instead of '\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc'");
                    passed = false;
                }
            }
        }
        catch (SQLException e) {
            passed = false;
            output.println("Exception caught.  " + e.getMessage());
            e.printStackTrace();
        }
        Assert.assertTrue((boolean)passed);
    }

    public void testxx005x() throws Exception {
        long l;
        boolean passed = true;
        output.println("test getting a DECIMAL as a long from the database.");
        boolean count = false;
        Statement stmt = this.con.createStatement();
        ResultSet rs = stmt.executeQuery("select convert(DECIMAL(4,0), 0)");
        if (!rs.next()) {
            passed = false;
        } else {
            l = rs.getLong(1);
            if (l != 0L) {
                passed = false;
            }
        }
        rs = stmt.executeQuery("select convert(DECIMAL(4,0), 1)");
        if (!rs.next()) {
            passed = false;
        } else {
            l = rs.getLong(1);
            if (l != 1L) {
                passed = false;
            }
        }
        rs = stmt.executeQuery("select convert(DECIMAL(4,0), -1)");
        if (!rs.next()) {
            passed = false;
        } else {
            l = rs.getLong(1);
            if (l != -1L) {
                passed = false;
            }
        }
        Assert.assertTrue((boolean)passed);
    }

    public void testxx0057() throws Exception {
        output.println("test putting a zero length string into a parameter");
        int count = 0;
        Statement stmt = this.con.createStatement();
        this.dropTable("#t0057");
        count = stmt.executeUpdate("create table #t0057           (a varchar(10) not null,   b char(10)    not null) ");
        output.println("Creating table affected " + count + " rows");
        PreparedStatement pStmt = this.con.prepareStatement("insert into #t0057 values (?, ?)");
        pStmt.setString(1, "");
        pStmt.setString(2, "");
        count = pStmt.executeUpdate();
        output.println("Added " + count + " rows");
        if (count != 1) {
            output.println("Failed to add rows");
            Assert.fail();
        } else {
            pStmt.close();
            pStmt = this.con.prepareStatement("select a, b from #t0057");
            ResultSet rs = pStmt.executeQuery();
            if (!rs.next()) {
                output.println("Couldn't read rows from table.");
                Assert.fail();
            } else {
                output.println("a is |" + rs.getString("a") + "|");
                output.println("b is |" + rs.getString("b") + "|");
                Assert.assertEquals((Object)"", (Object)rs.getString("a"));
                Assert.assertEquals((Object)"          ", (Object)rs.getString("b"));
            }
        }
    }

    public void testxx0059() throws Exception {
        boolean passed = true;
        boolean count = false;
        Statement stmt = this.con.createStatement();
        try {
            DatabaseMetaData dbMetaData = this.con.getMetaData();
            ResultSet rs = dbMetaData.getSchemas();
            ResultSetMetaData rsm = rs.getMetaData();
            Assert.assertTrue((rsm.getColumnCount() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)rsm.getColumnName(1).equals("TABLE_SCHEM"));
            while (rs.next()) {
                output.println("schema " + rs.getString(1));
            }
        }
        catch (SQLException e) {
            output.println("Exception caught.  " + e.getMessage());
            e.printStackTrace();
            Assert.fail();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

