/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.test;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import net.sourceforge.jtds.test.DatabaseTestCase;
import net.sourceforge.jtds.util.Logger;

public class AsTest
extends DatabaseTestCase {
    static /* synthetic */ Class class$net$sourceforge$jtds$test$AsTest;

    public AsTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        Logger.setActive(true);
        if (args.length > 0) {
            TestSuite s = new TestSuite();
            int i = 0;
            while (i < args.length) {
                s.addTest((Test)new AsTest(args[i]));
                ++i;
            }
            TestRunner.run((Test)s);
        } else {
            TestRunner.run((Class)(class$net$sourceforge$jtds$test$AsTest == null ? (class$net$sourceforge$jtds$test$AsTest = AsTest.class$("net.sourceforge.jtds.test.AsTest")) : class$net$sourceforge$jtds$test$AsTest));
        }
    }

    public void testProc1() throws Exception {
        boolean passed = false;
        Statement stmt = this.con.createStatement();
        stmt.executeUpdate("  if (exists (select * from sysobjects where name = '#spTestExec')) drop procedure spTestExec");
        stmt.executeUpdate("  if (exists (select * from sysobjects where name = '#spTestExec2')) drop procedure spTestExec2");
        stmt.executeUpdate(" create procedure #spTestExec2 as select 'Did it work?' as Result");
        stmt.executeUpdate("create procedure #spTestExec as set nocount off create table #tmp ( Result varchar(50) ) insert #tmp execute #spTestExec2 select * from #tmp");
        CallableStatement cstmt = this.con.prepareCall("#spTestExec");
        Assert.assertTrue((boolean)cstmt.execute());
        ResultSet rs = cstmt.getResultSet();
        while (rs.next()) {
            passed = true;
        }
        Assert.assertTrue((!cstmt.getMoreResults() && cstmt.getUpdateCount() == -1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)passed);
    }

    public void testProc2() throws Exception {
        Statement stmt = this.con.createStatement();
        String sqlwithcount1 = "if (exists(select * from sysobjects where name = '#multi1withcount' and xtype = 'P'))  drop procedure #multi1withcount ";
        String sqlwithcount2 = "create procedure #multi1withcount as   set nocount off   select 'a'   select 'b'   create table #multi1withcountt (A VARCHAR(20))   insert into #multi1withcountt VALUES ('a')   insert into #multi1withcountt VALUES ('a')   insert into #multi1withcountt VALUES ('a')   select 'a'   select 'b' ";
        String sqlnocount1 = "if (exists(select * from sysobjects where name = '#multi1nocount' and xtype = 'P'))  drop procedure #multi1nocount ";
        String sqlnocount2 = "create procedure #multi1nocount as   set nocount on   select 'a'   select 'b'   create table #multi1nocountt (A VARCHAR(20))   insert into #multi1nocountt VALUES ('a')   insert into #multi1nocountt VALUES ('a')   insert into #multi1nocountt VALUES ('a')   select 'a'   select 'b' ";
        stmt.executeUpdate(sqlwithcount1);
        stmt.executeUpdate(sqlnocount1);
        stmt.executeUpdate(sqlwithcount2);
        stmt.executeUpdate(sqlnocount2);
        CallableStatement cstmt = this.con.prepareCall("#multi1nocount");
        Assert.assertTrue((boolean)cstmt.execute());
        ResultSet rs = cstmt.getResultSet();
        CallableStatement s2 = cstmt;
        Assert.assertTrue((boolean)rs.next());
        Assert.assertTrue((boolean)rs.getString(1).equals("a"));
        Assert.assertTrue((!rs.next() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)s2.getMoreResults());
        rs = s2.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertTrue((boolean)rs.getString(1).equals("b"));
        Assert.assertTrue((!rs.next() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)s2.getMoreResults());
        rs = s2.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertTrue((!rs.next() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)s2.getMoreResults());
        rs = s2.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertTrue((!rs.next() ? 1 : 0) != 0);
        Assert.assertTrue((!s2.getMoreResults() && s2.getUpdateCount() == -1 ? 1 : 0) != 0);
        cstmt = this.con.prepareCall("#multi1withcount");
        Assert.assertTrue((boolean)cstmt.execute());
        s2 = cstmt;
        rs = s2.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertTrue((boolean)rs.getString(1).equals("a"));
        Assert.assertTrue((!rs.next() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)s2.getMoreResults());
        rs = s2.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertTrue((boolean)rs.getString(1).equals("b"));
        Assert.assertTrue((!rs.next() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)s2.getMoreResults());
        rs = s2.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertTrue((!rs.next() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)s2.getMoreResults());
        rs = s2.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertTrue((!rs.next() ? 1 : 0) != 0);
        Assert.assertTrue((!s2.getMoreResults() && s2.getUpdateCount() == -1 ? 1 : 0) != 0);
    }

    public void testBatch1() throws Exception {
        Statement stmt = this.con.createStatement();
        String sqlwithcount1 = "  set nocount off   select 'a'   select 'b'   create table #multi2withcountt (A VARCHAR(20))   insert into #multi2withcountt VALUES ('a')   insert into #multi2withcountt VALUES ('a')   insert into #multi2withcountt VALUES ('a')   select 'a'   select 'b'   drop table #multi2withcountt";
        String sqlnocount1 = "  set nocount on   select 'a'   select 'b'   create table #multi2nocountt (A VARCHAR(20))   insert into #multi2nocountt VALUES ('a')   insert into #multi2nocountt VALUES ('a')   insert into #multi2nocountt VALUES ('a')   select 'a'   select 'b'   drop table #multi2nocountt";
        Assert.assertTrue((!stmt.execute(sqlwithcount1) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)stmt.getMoreResults());
        ResultSet rs = stmt.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertTrue((boolean)rs.getString(1).equals("a"));
        Assert.assertTrue((!rs.next() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)stmt.getMoreResults());
        rs = stmt.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertTrue((boolean)rs.getString(1).equals("b"));
        Assert.assertTrue((!rs.next() ? 1 : 0) != 0);
        Assert.assertTrue((!stmt.getMoreResults() && stmt.getUpdateCount() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((!stmt.getMoreResults() && stmt.getUpdateCount() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((!stmt.getMoreResults() && stmt.getUpdateCount() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((!stmt.getMoreResults() && stmt.getUpdateCount() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)stmt.getMoreResults());
        rs = stmt.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertTrue((!rs.next() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)stmt.getMoreResults());
        rs = stmt.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertTrue((!rs.next() ? 1 : 0) != 0);
        Assert.assertTrue((!stmt.getMoreResults() && stmt.getUpdateCount() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((!stmt.getMoreResults() && stmt.getUpdateCount() == -1 ? 1 : 0) != 0);
        Assert.assertTrue((!stmt.execute(sqlnocount1) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)stmt.getMoreResults());
        rs = stmt.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertTrue((boolean)rs.getString(1).equals("a"));
        Assert.assertTrue((!rs.next() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)stmt.getMoreResults());
        rs = stmt.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertTrue((boolean)rs.getString(1).equals("b"));
        Assert.assertTrue((!rs.next() ? 1 : 0) != 0);
        Assert.assertTrue((!stmt.getMoreResults() ? 1 : 0) != 0);
        Assert.assertEquals((int)0, (int)stmt.getUpdateCount());
        Assert.assertTrue((!stmt.getMoreResults() ? 1 : 0) != 0);
        Assert.assertEquals((int)1, (int)stmt.getUpdateCount());
        Assert.assertTrue((!stmt.getMoreResults() ? 1 : 0) != 0);
        Assert.assertEquals((int)1, (int)stmt.getUpdateCount());
        Assert.assertTrue((!stmt.getMoreResults() ? 1 : 0) != 0);
        Assert.assertEquals((int)1, (int)stmt.getUpdateCount());
        Assert.assertTrue((boolean)stmt.getMoreResults());
        rs = stmt.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertTrue((!rs.next() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)stmt.getMoreResults());
        rs = stmt.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertTrue((!rs.next() ? 1 : 0) != 0);
        Assert.assertTrue((!stmt.getMoreResults() ? 1 : 0) != 0);
        Assert.assertEquals((int)0, (int)stmt.getUpdateCount());
        Assert.assertTrue((!stmt.getMoreResults() && stmt.getUpdateCount() == -1 ? 1 : 0) != 0);
    }

    public void testBug457955() throws Exception {
        Statement stmt = this.con.createStatement();
        this.dropProcedure("#Bug457955");
        stmt.executeUpdate("  create procedure #Bug457955 (@par1 VARCHAR(10)) as select @par1");
        String param = "123456789";
        CallableStatement s = this.con.prepareCall("exec #Bug457955 ?");
        s.setString(1, param);
        s.executeQuery();
    }

    public void testBugAttTest2() throws Exception {
        String tabdef = "CREATE TABLE #ICEributeTest_AttributeTest2(   ICEobjectId NUMERIC(19)      /*CONSTRAINT ICEributeTest_AttributeTest2_PKICEobjectId PRIMARY KEY */     ,    ICEtestShort INTEGER       NULL,    ICEtestFloat NUMERIC(28,10)      NULL,   ICEtestDecimal NUMERIC(28,10)      NULL,   ICEtestCharacter INTEGER      NULL,   ICEtestInteger INTEGER      NULL,   ICEtestString VARCHAR(20)      NULL,   ICEtestBoolean BIT      NULL,   ICEtestByte INTEGER      NULL,   ICEtestDouble NUMERIC(28,10)      NULL,   ICEtestLong NUMERIC(19)      NULL,   ICEtestCombined1 VARBINARY(8000)      NULL,   ICEtestDate DATETIME      NULL,   testCombined_testFloat NUMERIC(28,10)      NULL,   testCombined_testShort INTEGER      NULL,   testCombined_testDecimal NUMERIC(28,10)      NULL,   testCombined_testCharacter INTEGER      NULL,   testCombined_testInteger INTEGER      NULL,   testCombined_testString VARCHAR(50)      NULL,   testCombined_testBoolean BIT      NULL,   testCombined_testByte INTEGER      NULL,   testCombined_testDouble NUMERIC(28,10)      NULL,   testCombined_testLong NUMERIC(19)      NULL,   testCombined_testDate DATETIME      NULL,   ICEtestContainedArrays VARBINARY(8000)      NULL,   BSF_FILTER_ATTRIBUTE_NAME INTEGER      NOT NULL,   updateCount INTEGER     NOT NULL   ) ";
        Statement stmt = this.con.createStatement();
        this.dropTable("#ICEributeTest_AttributeTest2");
        stmt.executeUpdate(tabdef);
        PreparedStatement istmt = this.con.prepareStatement("INSERT INTO #ICEributeTest_AttributeTest2 (ICEobjectId,BSF_FILTER_ATTRIBUTE_NAME,ICEtestShort,ICEtestFloat,ICEtestDecimal,ICEtestCharacter,ICEtestInteger,ICEtestString,ICEtestBoolean,ICEtestByte,ICEtestDouble,ICEtestLong,ICEtestCombined1,ICEtestDate,testCombined_testFloat,testCombined_testShort,testCombined_testDecimal,testCombined_testCharacter,testCombined_testInteger,testCombined_testString,testCombined_testBoolean,testCombined_testByte,testCombined_testDouble,testCombined_testLong,testCombined_testDate,ICEtestContainedArrays,updateCount ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        istmt.setLong(1, 650002L);
        istmt.setInt(2, -1461101755);
        istmt.setNull(3, 4);
        istmt.setNull(4, 7);
        try {
            istmt.setNull(5, 2);
        }
        catch (SQLException e) {
            istmt.setNull(5, 3);
        }
        istmt.setNull(6, 4);
        istmt.setNull(7, 4);
        istmt.setNull(8, 12);
        istmt.setNull(9, -7);
        istmt.setNull(10, 4);
        istmt.setNull(11, 8);
        istmt.setNull(12, -5);
        istmt.setNull(13, -4);
        istmt.setNull(14, 93);
        istmt.setNull(15, 7);
        istmt.setNull(16, 4);
        try {
            istmt.setNull(17, 2);
        }
        catch (SQLException e) {
            istmt.setNull(17, 3);
        }
        istmt.setNull(18, 4);
        istmt.setNull(19, 4);
        istmt.setNull(20, 12);
        istmt.setNull(21, -7);
        istmt.setNull(22, 4);
        istmt.setNull(23, 8);
        istmt.setNull(24, -5);
        istmt.setNull(25, 93);
        istmt.setNull(26, -4);
        istmt.setInt(27, 1);
        Assert.assertEquals((int)1, (int)istmt.executeUpdate());
    }

    public void testBigInt() throws Throwable {
        String crtab = "create table #testBigInt (a NUMERIC(19) NULL)";
        this.dropTable("#testBigInt");
        Statement stmt = this.con.createStatement();
        stmt.executeUpdate(crtab);
        PreparedStatement pstmt = this.con.prepareStatement("insert into #testBigInt values (?)");
        pstmt.setNull(1, -5);
        Assert.assertTrue((!pstmt.execute() ? 1 : 0) != 0);
        Assert.assertTrue((pstmt.getUpdateCount() == 1 ? 1 : 0) != 0);
        pstmt.setLong(1, 99999999999L);
        Assert.assertTrue((!pstmt.execute() ? 1 : 0) != 0);
        Assert.assertTrue((pstmt.getUpdateCount() == 1 ? 1 : 0) != 0);
        pstmt.setLong(1, -99999999999L);
        Assert.assertTrue((!pstmt.execute() ? 1 : 0) != 0);
        Assert.assertTrue((pstmt.getUpdateCount() == 1 ? 1 : 0) != 0);
        pstmt.setLong(1, 9999999999999L);
        Assert.assertTrue((!pstmt.execute() ? 1 : 0) != 0);
        Assert.assertTrue((pstmt.getUpdateCount() == 1 ? 1 : 0) != 0);
        pstmt.setLong(1, -9999999999999L);
        Assert.assertTrue((!pstmt.execute() ? 1 : 0) != 0);
        Assert.assertTrue((pstmt.getUpdateCount() == 1 ? 1 : 0) != 0);
        pstmt.setLong(1, 99999999999L);
        Assert.assertTrue((!pstmt.execute() ? 1 : 0) != 0);
        Assert.assertTrue((pstmt.getUpdateCount() == 1 ? 1 : 0) != 0);
    }

    public void testBoolean() throws Throwable {
        String crtab = "create table #testBit (a BIT NULL)";
        this.dropTable("#testBit");
        Statement stmt = this.con.createStatement();
        stmt.executeUpdate(crtab);
        stmt.executeUpdate("insert into #testBit values (NULL)");
        stmt.executeUpdate("insert into #testBit values (0)");
        stmt.executeUpdate("insert into #testBit values (1)");
        ResultSet rs = stmt.executeQuery("select * from #testBit where a is NULL");
        rs.next();
        rs.getBoolean(1);
        rs = stmt.executeQuery("select * from #testBit where a  = 0");
        rs.next();
        rs.getBoolean(1);
        rs = stmt.executeQuery("select * from #testBit where a = 1");
        rs.next();
        rs.getBoolean(1);
        PreparedStatement pstmt = this.con.prepareStatement("insert into #testBit values (?)");
        pstmt.setBoolean(1, true);
        Assert.assertTrue((!pstmt.execute() ? 1 : 0) != 0);
        Assert.assertTrue((pstmt.getUpdateCount() == 1 ? 1 : 0) != 0);
        pstmt.setBoolean(1, false);
        Assert.assertTrue((!pstmt.execute() ? 1 : 0) != 0);
        Assert.assertTrue((pstmt.getUpdateCount() == 1 ? 1 : 0) != 0);
        pstmt.setNull(1, -7);
        Assert.assertTrue((!pstmt.execute() ? 1 : 0) != 0);
        Assert.assertTrue((pstmt.getUpdateCount() == 1 ? 1 : 0) != 0);
    }

    public void testBinary() throws Throwable {
        String crtab = "create table #testBinary (a varbinary(8000))";
        this.dropTable("#testBinary");
        byte[] ba = new byte[8000];
        int i = 0;
        while (i < ba.length) {
            ba[i] = (byte)(i % 256);
            ++i;
        }
        Statement stmt = this.con.createStatement();
        stmt.executeUpdate(crtab);
        PreparedStatement pstmt = this.con.prepareStatement("insert into #testBinary values (?)");
        pstmt.setObject(1, ba);
        pstmt.execute();
    }

    private void checkTime(long time) throws Throwable {
        PreparedStatement pstmt = this.con.prepareStatement("insert into #testTimestamp values (?)");
        Timestamp ts = new Timestamp(time);
        pstmt.setTimestamp(1, ts);
        pstmt.executeUpdate();
        pstmt.close();
        Statement stmt = this.con.createStatement();
        ResultSet rs = stmt.executeQuery("select * from #testTimestamp");
        rs.next();
        Timestamp tsres = rs.getTimestamp(1);
        Assert.assertTrue((boolean)ts.equals(tsres));
        stmt.executeUpdate("truncate table #testTimestamp");
    }

    public void testSpecTime() throws Throwable {
        String crtab = "create table #testTimestamp (a datetime)";
        this.dropTable("#testTimestamp");
        Statement stmt = this.con.createStatement();
        stmt.executeUpdate(crtab);
        this.checkTime(92001000L);
        this.checkTime(4200000L);
        this.checkTime(4201000L);
        this.checkTime(1234567000L);
        this.checkTime(420000000000L);
        this.checkTime(840000000000L);
    }

    public void testBigDecimal() throws Throwable {
        String crtab = "create table #testBigDecimal (a decimal(28,10) NULL)";
        this.dropTable("#testBigDecimal");
        Statement stmt = this.con.createStatement();
        stmt.executeUpdate(crtab);
        PreparedStatement pstmt = this.con.prepareStatement("insert into #testBigDecimal values (?)");
        pstmt.setObject(1, new BigDecimal("10.200"));
        pstmt.execute();
        pstmt.setObject(1, new BigDecimal(10.2));
        pstmt.execute();
        pstmt.setObject(1, null);
        pstmt.execute();
        pstmt.setObject(1, new Integer(20));
        pstmt.execute();
        pstmt.setObject(1, new Double(2.1));
        pstmt.execute();
        pstmt.setObject(1, new BigDecimal(-10.2));
        pstmt.execute();
        pstmt.setObject(1, new Long(200L));
        pstmt.execute();
        pstmt.setByte(1, (byte)1);
        pstmt.execute();
        pstmt.setInt(1, 200);
        pstmt.execute();
        pstmt.setLong(1, 200L);
        pstmt.execute();
        pstmt.setFloat(1, 1.1f);
        pstmt.execute();
        pstmt.setDouble(1, 1.1);
        pstmt.execute();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

