/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbcx;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import net.sourceforge.jtds.jdbcx.ConnectionProxy;

public class PooledConnection
implements javax.sql.PooledConnection {
    private Connection _connection;
    private ConnectionProxy _connectionProxy = null;
    private ArrayList _listeners = null;

    public PooledConnection(Connection connection) {
        this._connection = connection;
    }

    public synchronized void addConnectionEventListener(ConnectionEventListener listener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList();
        }
        this._listeners.add(listener);
    }

    public synchronized void close() throws SQLException {
        this._connection.close();
        this._connection = null;
        this.fireConnectionEvent(false, null);
    }

    synchronized void fireConnectionEvent(boolean closed, SQLException sqlException) {
        if (this._listeners != null && this._listeners.size() > 0) {
            ConnectionEvent connectionEvent = new ConnectionEvent(this, sqlException);
            Iterator iterator = this._listeners.iterator();
            while (iterator.hasNext()) {
                ConnectionEventListener listener = (ConnectionEventListener)iterator.next();
                if (closed) {
                    listener.connectionClosed(connectionEvent);
                    continue;
                }
                listener.connectionErrorOccurred(connectionEvent);
            }
        }
    }

    public synchronized Connection getConnection() throws SQLException {
        if (this._connection == null) {
            this.fireConnectionEvent(false, new SQLException("Connection closed."));
            return null;
        }
        if (this._connectionProxy != null) {
            this._connectionProxy.close();
        }
        this._connectionProxy = new ConnectionProxy(this, this._connection);
        return this._connectionProxy;
    }

    public synchronized void removeConnectionEventListener(ConnectionEventListener listener) {
        if (this._listeners != null) {
            this._listeners.remove(listener);
        }
    }
}

