/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.io.IOException;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Vector;
import net.sourceforge.jtds.jdbc.CursorResultSet;
import net.sourceforge.jtds.jdbc.EscapeProcessor;
import net.sourceforge.jtds.jdbc.GenKeyResultSet;
import net.sourceforge.jtds.jdbc.OutputParamHandler;
import net.sourceforge.jtds.jdbc.PacketEndTokenResult;
import net.sourceforge.jtds.jdbc.PacketOutputParamResult;
import net.sourceforge.jtds.jdbc.PacketRetStatResult;
import net.sourceforge.jtds.jdbc.ParameterListItem;
import net.sourceforge.jtds.jdbc.SQLWarningChain;
import net.sourceforge.jtds.jdbc.Tds;
import net.sourceforge.jtds.jdbc.TdsConnection;
import net.sourceforge.jtds.jdbc.TdsException;
import net.sourceforge.jtds.jdbc.TdsResultSet;

public class TdsStatement
implements Statement {
    public static final int RETURN_GENERATED_KEYS = 1;
    public static final int NO_GENERATED_KEYS = 2;
    public static final int SUCCESS_NO_INFO = -2;
    public static final int EXECUTE_FAILED = -3;
    public static final int CLOSE_CURRENT_RESULT = 1;
    public static final int KEEP_CURRENT_RESULT = 2;
    public static final int CLOSE_ALL_RESULTS = 3;
    public static final String cvsVersion = "$Id: TdsStatement.java,v 1.23 2004/02/25 01:24:48 alin_sinpalean Exp $";
    private TdsConnection connection;
    SQLWarningChain warningChain = new SQLWarningChain();
    TdsResultSet results = null;
    protected Vector cursorResults = new Vector();
    private Tds actTds = null;
    private boolean escapeProcessing = true;
    private int updateCount = -1;
    private int maxFieldSize = Integer.MAX_VALUE;
    private int maxRows = 0;
    private int timeout = 0;
    private int fetchSize = 100;
    private int fetchDir = 1000;
    private int type = 1003;
    private int concurrency = 1007;
    private boolean isClosed = false;
    private boolean returnKeys = false;
    private boolean statementReturnsKeys = false;
    private GenKeyResultSet lastGeneratedKey = null;
    public OutputParamHandler outParamHandler;
    protected ArrayList batchValues = null;

    public TdsStatement(TdsConnection con, int type, int concurrency) throws SQLException {
        this.connection = con;
        this.type = type;
        this.concurrency = concurrency;
    }

    public TdsStatement(TdsConnection con) throws SQLException {
        this(con, 1003, 1007);
    }

    public void statementReturnsKeys(boolean value) {
        this.statementReturnsKeys = value;
    }

    protected synchronized void releaseTds() throws SQLException {
        if (this.actTds == null) {
            return;
        }
        if (this.actTds.moreResults()) {
            return;
        }
        try {
            this.connection.freeTds(this.actTds);
            this.actTds = null;
        }
        catch (TdsException e) {
            throw new SQLException("Confusion in freeing Tds: " + e);
        }
    }

    protected void NotImplemented() throws SQLException {
        throw new SQLException("Not Implemented");
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        this.checkClosed();
        SQLWarning warn = null;
        this.returnKeys = false;
        if (this.type != 1003 || this.concurrency != 1007) {
            try {
                CursorResultSet rs = new CursorResultSet(this, sql, this.fetchDir, null);
                this.cursorResults.add(rs);
                return rs;
            }
            catch (SQLException ex) {
                warn = new SQLWarning(ex.getMessage(), ex.getSQLState(), ex.getErrorCode());
            }
        }
        boolean res = this.internalExecute(sql);
        if (warn != null) {
            this.warningChain.addWarning(warn);
        }
        if (res) {
            return this.results;
        }
        throw new SQLException("No ResultSet was produced.");
    }

    public final synchronized boolean internalExecute(String sql) throws SQLException {
        return this.internalExecute(sql, this.getTds(), this.warningChain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized boolean internalExecute(String sql, Tds tds, SQLWarningChain wChain) throws SQLException {
        boolean bl;
        try {
            this.checkClosed();
            boolean result = this.executeImpl(tds, sql, wChain);
            this.internalGetGeneratedKeys(tds, result, false);
            bl = result;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.releaseTds();
            throw throwable;
        }
        this.releaseTds();
        return bl;
    }

    private final boolean executeImpl(Tds tds, String sql, SQLWarningChain wChain) throws SQLException {
        wChain.clearWarnings();
        this.updateCount = -1;
        this.skipToEnd();
        if (this.escapeProcessing) {
            sql = EscapeProcessor.nativeSQL(sql);
        }
        tds.executeQuery(sql, this, wChain, this.timeout);
        wChain.checkForExceptions();
        return this.getMoreResults(tds, wChain, false);
    }

    public final synchronized boolean internalExecuteCall(String name, ParameterListItem[] formalParameterList, ParameterListItem[] actualParameterList, Tds tds, SQLWarningChain wChain) throws SQLException {
        this.checkClosed();
        return this.executeCallImpl(tds, name, formalParameterList, actualParameterList, wChain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeCallImpl(Tds tds, String name, ParameterListItem[] formalParameterList, ParameterListItem[] actualParameterList, SQLWarningChain wChain) throws SQLException {
        boolean bl;
        try {
            wChain.clearWarnings();
            this.skipToEnd();
            this.lastGeneratedKey = null;
            tds.executeProcedure(name, formalParameterList, actualParameterList, this, wChain, this.getQueryTimeout(), false);
            boolean result = this.getMoreResults(tds, this.warningChain, false);
            this.internalGetGeneratedKeys(tds, result, true);
            bl = result;
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.releaseTds();
            throw throwable;
        }
        this.releaseTds();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int executeUpdate(String sql) throws SQLException {
        int n;
        try {
            int res;
            this.checkClosed();
            this.returnKeys = false;
            if (this.internalExecute(sql)) {
                this.skipToEnd();
                throw new SQLException("executeUpdate can't return a result set");
            }
            do {
                if ((res = this.getUpdateCount()) != -1 && this.connection.returnLastUpdateCount()) continue;
            } while (!this.getMoreResults());
            this.skipToEnd();
            throw new SQLException("executeUpdate can't return a result set");
            n = res == -1 ? 0 : res;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.releaseTds();
            throw throwable;
        }
        this.releaseTds();
        return n;
    }

    protected synchronized void closeResults(boolean allowTdsRelease) throws SQLException {
        this.updateCount = -1;
        if (this.results != null) {
            this.results.close(allowTdsRelease);
            this.results = null;
        }
    }

    protected synchronized void skipToEnd() throws SQLException {
        this.closeResults(false);
        if (this.actTds != null) {
            this.actTds.skipToEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        if (this.actTds != null) {
            try {
                this.closeResults(false);
                if (!this.connection.isClosed()) {
                    this.actTds.skipToEnd();
                }
                this.connection.freeTds(this.actTds);
                this.actTds = null;
            }
            catch (TdsException e) {
                throw new SQLException(e.toString());
            }
        }
        if (!this.connection.isClosed()) {
            Vector vector = this.cursorResults;
            synchronized (vector) {
                int i = this.cursorResults.size() - 1;
                while (i >= 0) {
                    CursorResultSet rs = (CursorResultSet)this.cursorResults.get(i);
                    rs.close();
                    --i;
                }
            }
        }
        this.cursorResults.clear();
        this.isClosed = true;
    }

    public void finalize() throws SQLException {
        this.close();
    }

    public synchronized int getMaxFieldSize() throws SQLException {
        this.checkClosed();
        return this.maxFieldSize;
    }

    public synchronized void setMaxFieldSize(int max) throws SQLException {
        this.checkClosed();
        this.maxFieldSize = max;
    }

    public synchronized int getMaxRows() throws SQLException {
        this.checkClosed();
        return this.maxRows;
    }

    public synchronized void setMaxRows(int max) throws SQLException {
        this.checkClosed();
        if (this.maxRows < 0) {
            throw new SQLException("Negative row count");
        }
        this.maxRows = max;
    }

    public synchronized void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkClosed();
        this.escapeProcessing = enable;
    }

    public synchronized int getQueryTimeout() throws SQLException {
        this.checkClosed();
        return this.timeout;
    }

    public synchronized void setQueryTimeout(int seconds) throws SQLException {
        this.checkClosed();
        this.timeout = seconds;
    }

    public void cancel() throws SQLException {
        this.checkClosed();
        try {
            if (this.actTds != null) {
                this.actTds.cancel();
            }
        }
        catch (TdsException e) {
            throw new SQLException(e.getMessage());
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.warningChain.getWarnings();
    }

    public synchronized void clearWarnings() throws SQLException {
        this.checkClosed();
        this.warningChain.clearWarnings();
    }

    public void setCursorName(String name) throws SQLException {
    }

    public synchronized boolean execute(String sql) throws SQLException {
        this.checkClosed();
        this.returnKeys = false;
        return this.internalExecute(sql);
    }

    synchronized Tds getTds() throws SQLException {
        if (this.actTds == null) {
            this.actTds = this.connection.allocateTds(false);
        }
        return this.actTds;
    }

    public synchronized ResultSet getResultSet() throws SQLException {
        this.checkClosed();
        return this.results;
    }

    public synchronized int getUpdateCount() throws SQLException {
        this.checkClosed();
        return this.updateCount;
    }

    public synchronized boolean getMoreResults() throws SQLException {
        this.checkClosed();
        return this.getMoreResults(this.actTds, this.warningChain, true);
    }

    public boolean getMoreResults(int current) throws SQLException {
        this.NotImplemented();
        return false;
    }

    boolean handleRetStat(PacketRetStatResult packet) {
        return this.outParamHandler != null && this.outParamHandler.handleRetStat(packet);
    }

    boolean handleParamResult(PacketOutputParamResult packet) throws SQLException {
        return this.outParamHandler != null && this.outParamHandler.handleParamResult(packet);
    }

    synchronized boolean getMoreResults(Tds tds, SQLWarningChain wChain, boolean allowTdsRelease) throws SQLException {
        this.updateCount = -1;
        if (tds == null) {
            return false;
        }
        this.closeResults(false);
        Tds tds2 = tds;
        synchronized (tds2) {
            try {
                do {
                    tds.goToNextResult(wChain, this);
                    if (!tds.moreResults()) {
                        if (allowTdsRelease) {
                            this.releaseTds();
                        }
                        wChain.checkForExceptions();
                        return false;
                    }
                    if (tds.isResultSet()) {
                        this.results = new TdsResultSet(tds, this, wChain, this.fetchSize);
                        wChain.checkForExceptions();
                        return true;
                    }
                    PacketEndTokenResult end = (PacketEndTokenResult)tds.processSubPacket();
                    this.updateCount = end.getRowCount();
                    tds.goToNextResult(wChain, this);
                } while (this.updateCount == -1 && tds.moreResults());
                if (allowTdsRelease) {
                    this.releaseTds();
                }
                wChain.checkForExceptions();
                return false;
            }
            catch (Exception ex) {
                this.releaseTds();
                if (ex instanceof SQLException) {
                    throw (SQLException)ex;
                }
                throw new SQLException("Network error: " + ex.toString());
            }
        }
    }

    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000 && direction != 1001 && direction != 1002) {
            throw new SQLException("Invalid fetch direction.");
        }
        this.fetchDir = direction;
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDir;
    }

    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0) {
            throw new SQLException("Invalid fetch size.");
        }
        this.fetchSize = rows;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public int getResultSetConcurrency() throws SQLException {
        this.checkClosed();
        return this.concurrency;
    }

    public int getResultSetType() throws SQLException {
        this.checkClosed();
        return this.type;
    }

    public synchronized void addBatch(String sql) throws SQLException {
        if (this.batchValues == null) {
            this.batchValues = new ArrayList();
        }
        this.batchValues.add(sql);
    }

    public synchronized void clearBatch() throws SQLException {
        this.batchValues.clear();
    }

    public synchronized int[] executeBatch() throws SQLException {
        if (this.batchValues == null || this.batchValues.size() == 0) {
            throw new SQLException("Nothing has been batched for execution.");
        }
        int size = this.batchValues.size();
        int[] updateCounts = new int[size];
        int i = 0;
        try {
            try {
                while (i < size) {
                    Object value = this.batchValues.get(i);
                    updateCounts[i] = value instanceof String ? this.executeUpdate((String)value) : this.executeBatchOther(value);
                    ++i;
                }
            }
            catch (SQLException e) {
                int[] tmpUpdateCounts = new int[i + 1];
                System.arraycopy(updateCounts, 0, tmpUpdateCounts, 0, i + 1);
                tmpUpdateCounts[i] = -3;
                throw new BatchUpdateException(e.getMessage(), tmpUpdateCounts);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.clearBatch();
            throw throwable;
        }
        this.clearBatch();
        return updateCounts;
    }

    protected int executeBatchOther(Object value) throws SQLException {
        throw new SQLException("Unable to execute batch value: " + value);
    }

    public Connection getConnection() throws SQLException {
        this.checkClosed();
        return this.connection;
    }

    private void checkClosed() throws SQLException {
        if (this.isClosed || this.connection.isClosed()) {
            throw new SQLException("Statement already closed.");
        }
    }

    public boolean execute(String str, int param) throws SQLException {
        this.checkClosed();
        this.returnKeys = param == 1 && str.trim().substring(0, 6).equalsIgnoreCase("INSERT");
        return this.internalExecute(str);
    }

    public boolean execute(String str, String[] str1) throws SQLException {
        if (str1 == null) {
            throw new SQLException("str1 cannot be null.");
        }
        if (str1.length != 1) {
            throw new SQLException("One valid column name must be supplied");
        }
        return this.execute(str, 1);
    }

    public boolean execute(String str, int[] values) throws SQLException {
        if (values == null) {
            throw new SQLException("values cannot be null.");
        }
        if (values.length != 1) {
            throw new SQLException("One valid column index must be supplied.");
        }
        return this.execute(str, 1);
    }

    public int executeUpdate(String str, String[] str1) throws SQLException {
        if (str1 == null) {
            throw new SQLException("str1 cannot be null.");
        }
        if (str1.length != 1) {
            throw new SQLException("One valid column name must be supplied.");
        }
        return this.executeUpdate(str, 1);
    }

    public int executeUpdate(String str, int[] values) throws SQLException {
        if (values == null) {
            throw new SQLException("values cannot be null.");
        }
        if (values.length != 1) {
            throw new SQLException("One valid column index must be supplied.");
        }
        return this.executeUpdate(str, 1);
    }

    public int executeUpdate(String str, int param) throws SQLException {
        this.checkClosed();
        this.returnKeys = param == 1 && str.trim().substring(0, 6).equalsIgnoreCase("INSERT");
        if (this.internalExecute(str)) {
            this.skipToEnd();
            throw new SQLException("executeUpdate can't return a result set.");
        }
        int res = this.getUpdateCount();
        return res == -1 ? 0 : res;
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        this.checkClosed();
        return this.lastGeneratedKey != null ? this.lastGeneratedKey : new GenKeyResultSet(this);
    }

    public int getResultSetHoldability() throws SQLException {
        this.NotImplemented();
        return Integer.MIN_VALUE;
    }

    private void internalGetGeneratedKeys(Tds tds, boolean result, boolean alreadySubmitted) throws SQLException {
        this.lastGeneratedKey = null;
        if ((this.returnKeys || this.statementReturnsKeys) && !result && tds.moreResults() == alreadySubmitted) {
            int saveCount = this.updateCount;
            try {
                try {
                    SQLWarningChain tmpWarnings = new SQLWarningChain();
                    if (!alreadySubmitted) {
                        String sql = tds.getServerType() == 1 && tds.getDatabaseMajorVersion() >= 8 ? "SELECT SCOPE_IDENTITY() AS ID" : "SELECT @@IDENTITY AS ID";
                        tds.executeQuery(sql, this, tmpWarnings, this.timeout);
                    }
                    if (!this.getMoreResults(tds, tmpWarnings, false)) {
                        throw new SQLException("Expected generated keys ResultSet.");
                    }
                    this.lastGeneratedKey = new GenKeyResultSet(this, this.results);
                    this.results.close();
                    this.results = null;
                    Object var8_9 = null;
                    this.results = null;
                    this.updateCount = saveCount;
                }
                catch (SQLException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new SQLException(ex.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                this.results = null;
                this.updateCount = saveCount;
                throw throwable;
            }
        }
    }
}

