/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import net.sourceforge.jtds.jdbc.AbstractResultSet;
import net.sourceforge.jtds.jdbc.Context;
import net.sourceforge.jtds.jdbc.PacketRowResult;
import net.sourceforge.jtds.jdbc.SQLWarningChain;
import net.sourceforge.jtds.jdbc.Tds;
import net.sourceforge.jtds.jdbc.TdsException;
import net.sourceforge.jtds.jdbc.TdsStatement;

public class TdsResultSet
extends AbstractResultSet
implements ResultSet {
    Tds tds = null;
    TdsStatement stmt = null;
    Context context = null;
    int row = 0;
    boolean hitEndOfData = false;
    boolean isClosed = false;
    int rowIndex = -1;
    int rowCount = 0;
    PacketRowResult[] rowCache = null;
    public static final String cvsVersion = "$Id: TdsResultSet.java,v 1.8 2004/02/25 01:24:48 alin_sinpalean Exp $";

    public TdsResultSet(Tds tds_, TdsStatement stmt_, SQLWarningChain stmtChain, int fetchSize) throws SQLException {
        this.tds = tds_;
        this.stmt = stmt_;
        this.warningChain = new SQLWarningChain();
        this.hitEndOfData = false;
        if (fetchSize > 0) {
            this.fetchSize = fetchSize;
        }
        this.rowCache = new PacketRowResult[this.fetchSize];
        this.startResultSet(this.tds, stmtChain);
    }

    private void startResultSet(Tds tds, SQLWarningChain stmtWarningChain) throws SQLException {
        tds.startResultSet(stmtWarningChain, this.stmt);
        this.context = tds.getContext();
        stmtWarningChain.checkForExceptions();
    }

    public Context getContext() {
        return this.context;
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.checkClosed();
        if (direction != 1000) {
            throw new SQLException("The result set type is TYPE_FORWARD_ONLY and the fetch direction is not FETCH_FORWARD.");
        }
    }

    public synchronized void setFetchSize(int rows) throws SQLException {
        this.checkClosed();
        int maxRows = this.stmt.getMaxRows();
        if (rows < 0 || maxRows > 0 && rows > maxRows) {
            throw new SQLException("Illegal fetch size: " + rows);
        }
        if (rows == 0) {
            this.fetchSize = this.rowCache.length;
            return;
        }
        if (rows > this.rowCache.length) {
            PacketRowResult[] newCache = new PacketRowResult[rows];
            System.arraycopy(this.rowCache, 0, newCache, 0, this.rowCache.length);
            this.rowCache = newCache;
        }
        this.fetchSize = rows;
    }

    public String getCursorName() throws SQLException {
        throw new SQLException("Not implemented (getCursorName)");
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.warningChain.getWarnings();
    }

    public synchronized boolean isBeforeFirst() throws SQLException {
        this.checkClosed();
        return this.row == 0 && this.haveMoreResults();
    }

    public boolean isAfterLast() throws SQLException {
        this.checkClosed();
        return this.rowIndex == this.rowCount && this.hitEndOfData;
    }

    public boolean isFirst() throws SQLException {
        this.checkClosed();
        return this.row == 1;
    }

    public synchronized boolean isLast() throws SQLException {
        this.checkClosed();
        return this.rowIndex >= 0 && this.rowIndex == this.rowCount - 1 && !this.haveMoreResults();
    }

    public int getRow() throws SQLException {
        this.checkClosed();
        return this.row;
    }

    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return this.fetchSize;
    }

    public int getType() throws SQLException {
        return 1003;
    }

    public int getConcurrency() throws SQLException {
        return 1007;
    }

    public Statement getStatement() throws SQLException {
        this.checkClosed();
        return this.stmt;
    }

    public void clearWarnings() throws SQLException {
        this.warningChain.clearWarnings();
    }

    public void close() throws SQLException {
        this.close(true);
    }

    synchronized void close(boolean allowTdsRelease) throws SQLException {
        Exception exception = null;
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        if (!this.hitEndOfData) {
            try {
                this.tds.goToNextResult(this.warningChain, this.stmt);
                this.hitEndOfData = true;
                if (allowTdsRelease) {
                    this.stmt.releaseTds();
                }
            }
            catch (TdsException e) {
                exception = e;
            }
            catch (IOException e) {
                exception = e;
            }
        }
        this.rowCache = null;
        this.metaData = null;
        this.context = null;
        this.stmt = null;
        this.tds = null;
        if (exception != null) {
            throw new SQLException(exception.toString());
        }
    }

    public synchronized boolean next() throws SQLException {
        this.checkClosed();
        if (this.haveMoreResults()) {
            ++this.rowIndex;
            ++this.row;
            return true;
        }
        if (this.rowCount != 0) {
            this.rowIndex = 0;
            this.rowCount = 0;
            this.row = 0;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PacketRowResult fetchNextRow() throws SQLException {
        PacketRowResult row = null;
        Tds tds = this.tds;
        synchronized (tds) {
            this.clearWarnings();
            if (!this.tds.moreResults()) {
                this.hitEndOfData = true;
                return null;
            }
            row = this.tds.fetchRow(this.stmt, this.warningChain, this.context);
            this.stmt.releaseTds();
            this.warningChain.checkForExceptions();
            if (row == null) {
                this.hitEndOfData = true;
            }
        }
        return row;
    }

    public void beforeFirst() throws SQLException {
        throw new SQLException("The result set type is TYPE_FORWARD_ONLY");
    }

    public void afterLast() throws SQLException {
        throw new SQLException("The result set type is TYPE_FORWARD_ONLY");
    }

    public boolean first() throws SQLException {
        throw new SQLException("The result set type is TYPE_FORWARD_ONLY");
    }

    public boolean last() throws SQLException {
        throw new SQLException("The result set type is TYPE_FORWARD_ONLY");
    }

    public boolean absolute(int row) throws SQLException {
        throw new SQLException("The result set type is TYPE_FORWARD_ONLY");
    }

    public boolean relative(int rows) throws SQLException {
        throw new SQLException("The result set type is TYPE_FORWARD_ONLY");
    }

    public boolean previous() throws SQLException {
        throw new SQLException("The result set type is TYPE_FORWARD_ONLY");
    }

    public boolean rowUpdated() throws SQLException {
        this.checkClosed();
        return false;
    }

    public boolean rowInserted() throws SQLException {
        this.checkClosed();
        return false;
    }

    public boolean rowDeleted() throws SQLException {
        this.checkClosed();
        return false;
    }

    public void insertRow() throws SQLException {
        throw new SQLException("ResultSet is not updateable");
    }

    public void updateRow() throws SQLException {
        throw new SQLException("ResultSet is not updateable");
    }

    public void deleteRow() throws SQLException {
        throw new SQLException("ResultSet is not updateable");
    }

    public void refreshRow() throws SQLException {
        this.checkClosed();
    }

    public void cancelRowUpdates() throws SQLException {
        this.checkClosed();
    }

    public void moveToInsertRow() throws SQLException {
        throw new SQLException("ResultSet is not updateable");
    }

    public void moveToCurrentRow() throws SQLException {
        throw new SQLException("ResultSet is not updateable");
    }

    public synchronized PacketRowResult currentRow() throws SQLException {
        this.checkClosed();
        if (this.rowIndex < 0) {
            throw new SQLException("No current row in the ResultSet");
        }
        if (this.rowIndex >= this.rowCount) {
            throw new SQLException("No more results in ResultSet");
        }
        return this.rowCache[this.rowIndex];
    }

    private boolean haveMoreResults() throws SQLException {
        if (this.rowCount > 0 && this.rowIndex < this.rowCount - 1) {
            return true;
        }
        if (this.hitEndOfData) {
            return false;
        }
        return this.internalFetchRows() > 0;
    }

    private int internalFetchRows() throws SQLException {
        this.rowCount = 0;
        this.rowIndex = -1;
        do {
            PacketRowResult row = this.fetchNextRow();
            if (this.hitEndOfData) break;
            this.rowCache[this.rowCount] = row;
            ++this.rowCount;
        } while (this.rowCount < this.fetchSize);
        return this.rowCount;
    }

    private void reallocCache() {
        if (this.rowCache.length == this.fetchSize) {
            PacketRowResult[] newCache = new PacketRowResult[this.fetchSize * 2];
            System.arraycopy(this.rowCache, 0, newCache, 0, this.rowCache.length);
            this.rowCache = newCache;
            this.fetchSize *= 2;
        } else {
            this.fetchSize = this.rowCache.length;
        }
    }

    synchronized void fetchIntoCache() throws SQLException {
        this.checkClosed();
        if (this.rowCount == 0 && !this.hitEndOfData) {
            this.internalFetchRows();
        }
        if (this.hitEndOfData) {
            return;
        }
        if (this.rowIndex > 0 && this.rowIndex < this.rowCount) {
            System.arraycopy(this.rowCache, this.rowIndex, this.rowCache, 0, this.rowCount - this.rowIndex);
            this.rowCount -= this.rowIndex;
            this.rowIndex = 0;
        } else if (this.rowIndex <= 0 && this.rowCount == this.fetchSize) {
            this.reallocCache();
        }
        while (!this.hitEndOfData) {
            do {
                PacketRowResult row = this.fetchNextRow();
                if (this.hitEndOfData) break;
                this.rowCache[this.rowCount] = row;
                ++this.rowCount;
            } while (this.rowCount < this.fetchSize);
            if (this.hitEndOfData) continue;
            this.reallocCache();
        }
    }

    private void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Invalid state: ResultSet closed.");
        }
    }
}

