/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.sql.CallableStatement;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import net.sourceforge.jtds.jdbc.Column;
import net.sourceforge.jtds.jdbc.Columns;
import net.sourceforge.jtds.jdbc.Context;
import net.sourceforge.jtds.jdbc.EncodingHelper;
import net.sourceforge.jtds.jdbc.MSSqlServerInfo;
import net.sourceforge.jtds.jdbc.NtlmAuth;
import net.sourceforge.jtds.jdbc.PacketAuthTokenResult;
import net.sourceforge.jtds.jdbc.PacketColInfoResult;
import net.sourceforge.jtds.jdbc.PacketColumnInfoResult;
import net.sourceforge.jtds.jdbc.PacketColumnNamesResult;
import net.sourceforge.jtds.jdbc.PacketColumnOrderResult;
import net.sourceforge.jtds.jdbc.PacketControlResult;
import net.sourceforge.jtds.jdbc.PacketEndTokenResult;
import net.sourceforge.jtds.jdbc.PacketErrorResult;
import net.sourceforge.jtds.jdbc.PacketMsgResult;
import net.sourceforge.jtds.jdbc.PacketOutputParamResult;
import net.sourceforge.jtds.jdbc.PacketResult;
import net.sourceforge.jtds.jdbc.PacketRetStatResult;
import net.sourceforge.jtds.jdbc.PacketRowResult;
import net.sourceforge.jtds.jdbc.PacketTabNameResult;
import net.sourceforge.jtds.jdbc.PacketUnknown;
import net.sourceforge.jtds.jdbc.ParameterListItem;
import net.sourceforge.jtds.jdbc.Procedure;
import net.sourceforge.jtds.jdbc.SQLWarningChain;
import net.sourceforge.jtds.jdbc.SqlMessage;
import net.sourceforge.jtds.jdbc.TdsComm;
import net.sourceforge.jtds.jdbc.TdsConfused;
import net.sourceforge.jtds.jdbc.TdsConnection;
import net.sourceforge.jtds.jdbc.TdsDefinitions;
import net.sourceforge.jtds.jdbc.TdsException;
import net.sourceforge.jtds.jdbc.TdsNotImplemented;
import net.sourceforge.jtds.jdbc.TdsStatement;
import net.sourceforge.jtds.jdbc.TdsUnknownPacketSubType;
import net.sourceforge.jtds.jdbc.TdsUtil;
import net.sourceforge.jtds.util.Logger;

public class Tds
implements TdsDefinitions {
    private Socket sock = null;
    private TdsComm comm = null;
    private String databaseProductName;
    private String databaseProductVersion;
    private int databaseMajorVersion;
    private int databaseMinorVersion;
    private final TdsConnection connection;
    private int tdsVer = 70;
    private final String host;
    private int serverType = -1;
    private int port;
    private String database;
    private final String user;
    private final String password;
    private final String appName;
    private final String serverName;
    private final String progName;
    private final String domain;
    private final boolean useUnicode;
    private final boolean lastUpdateCount;
    private HashMap procedureCache = new HashMap();
    private ArrayList proceduresOfTra = new ArrayList();
    private Boolean cancelActive = Boolean.FALSE;
    private EncodingHelper encoder = null;
    private String charset = null;
    private boolean charsetSpecified = false;
    private boolean moreResults = true;
    private final int zoneOffset = Calendar.getInstance().get(15);
    private int maxRows = 0;
    public static final String cvsVersion = "$Id: Tds.java,v 1.34 2004/02/25 01:24:47 alin_sinpalean Exp $";
    private int transactionIsolationLevel = 2;
    private boolean autoCommit = true;
    private Context currentContext;

    public Tds(TdsConnection connection, Properties props) throws IOException, SQLException, TdsException {
        this.connection = connection;
        this.host = props.getProperty("HOST");
        this.serverType = Integer.parseInt(props.getProperty("SERVERTYPE"));
        this.port = Integer.parseInt(props.getProperty("PORT"));
        this.database = null;
        this.user = props.getProperty("USER");
        this.password = props.getProperty("PASSWORD");
        this.appName = props.getProperty("APPNAME", "jTDS");
        this.serverName = props.getProperty("SERVERNAME", this.host);
        this.progName = props.getProperty("PROGNAME", "jTDS");
        String verString = props.getProperty("TDS", "7.0");
        this.useUnicode = "true".equalsIgnoreCase(props.getProperty("SENDSTRINGPARAMETERSASUNICODE", "true"));
        this.lastUpdateCount = "true".equalsIgnoreCase(props.getProperty("LASTUPDATECOUNT", "false"));
        this.domain = props.getProperty("DOMAIN", "");
        String instanceName = props.getProperty("INSTANCE", "");
        if (instanceName.length() > 0) {
            MSSqlServerInfo info = new MSSqlServerInfo(this.host);
            this.port = info.getPortForInstance(instanceName);
            if (this.port == -1) {
                throw new SQLException("Server " + this.host + " has no instance named " + instanceName);
            }
        }
        if (verString.equals("5.0")) {
            this.tdsVer = 50;
        } else if (verString.equals("4.2")) {
            this.tdsVer = 42;
        }
        this.sock = new Socket(this.host, this.port);
        this.sock.setTcpNoDelay(true);
        this.comm = new TdsComm(this.sock, this.tdsVer);
        String cs = props.getProperty("CHARSET");
        this.charsetSpecified = this.setCharset(cs);
        this.autoCommit = this.connection.getAutoCommit();
        this.transactionIsolationLevel = this.connection.getTransactionIsolation();
        try {
            this.logon(props.getProperty("DBNAME"));
        }
        catch (SQLException ex) {
            throw new SQLException("Logon failed.  " + ex.getMessage(), ex.getSQLState(), ex.getErrorCode());
        }
    }

    public String getDatabase() {
        return this.database;
    }

    public int getServerType() {
        return this.serverType;
    }

    public synchronized boolean isResultSet() throws TdsException, IOException {
        byte type = this.comm.peek();
        return type == -96 || type == -127;
    }

    private synchronized boolean isResultRow() throws TdsException, IOException {
        byte type = this.comm.peek();
        return type == -47;
    }

    private synchronized boolean isEndOfResults() throws TdsException, IOException {
        byte type = this.comm.peek();
        return type == -3 || type == -2 || type == -1;
    }

    public void close() {
        this.comm.close();
        try {
            this.sock.close();
        }
        catch (IOException e) {}
    }

    public String toString() {
        return this.database + ", " + this.sock.getLocalAddress() + ":" + this.sock.getLocalPort() + " -> " + this.sock.getInetAddress() + ":" + this.sock.getPort();
    }

    private void initSettings(String database, SQLWarningChain wChain) {
        try {
            if (database.length() > 0) {
                this.changeDB(database, wChain);
            }
            this.changeSettings(this.sqlStatementToInitialize());
        }
        catch (SQLException ex) {
            wChain.addException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() throws IOException, TdsException {
        Boolean bl = this.cancelActive;
        synchronized (bl) {
            if (!this.cancelActive.booleanValue()) {
                this.comm.startPacket(6);
                this.comm.sendPacket();
                this.cancelActive = Boolean.TRUE;
            }
        }
    }

    public boolean moreResults() {
        return this.moreResults;
    }

    public synchronized void submitProcedure(String sql, SQLWarningChain wChain) throws SQLException {
        try {
            this.executeQuery(sql, null, wChain, 0);
            do {
                PacketResult res;
                if (!((res = this.processSubPacket()) instanceof PacketMsgResult)) continue;
                wChain.addOrReturn((PacketMsgResult)res);
            } while (this.moreResults);
        }
        catch (IOException e) {
            wChain.addException(new SQLException("Network problem. " + e.getMessage()));
        }
        catch (TdsUnknownPacketSubType e) {
            wChain.addException(new SQLException("Unknown response. " + e.getMessage()));
        }
        catch (TdsException e) {
            wChain.addException(new SQLException(e.toString()));
        }
    }

    public void executeProcedure(String procedureName, ParameterListItem[] formalParameterList, ParameterListItem[] actualParameterList, TdsStatement stmt, SQLWarningChain wChain, int timeout, boolean noMetaData) throws SQLException {
        try {
            this.executeProcedureInternal(procedureName, formalParameterList, actualParameterList, stmt, wChain, timeout, noMetaData);
        }
        catch (IOException e) {
            wChain.addException(new SQLException("Network problem. " + e.getMessage()));
        }
        catch (TdsUnknownPacketSubType e) {
            wChain.addException(new SQLException("Unknown response. " + e.getMessage()));
        }
        catch (TdsException e) {
            wChain.addException(new SQLException(e.toString()));
        }
        wChain.checkForExceptions();
    }

    private synchronized void executeProcedureInternal(String procedureName, ParameterListItem[] formalParameterList, ParameterListItem[] actualParameterList, TdsStatement stmt, SQLWarningChain wChain, int timeout, boolean noMetaData) throws SQLException, TdsException, IOException {
        while (this.cancelActive.booleanValue()) {
            this.waitForDataOrTimeout(wChain, timeout);
            this.processSubPacket();
        }
        this.checkMaxRows(stmt, wChain);
        try {
            try {
                this.comm.startPacket(3);
                if (this.tdsVer == 70) {
                    this.comm.appendTdsShort((short)procedureName.length());
                    this.comm.appendChars(procedureName);
                } else {
                    byte[] nameBytes = this.encoder.getBytes(procedureName);
                    this.comm.appendByte((byte)nameBytes.length);
                    this.comm.appendBytes(nameBytes);
                }
                this.comm.appendShort((short)(noMetaData ? 512 : 0));
                int i = 0;
                while (i < formalParameterList.length) {
                    byte nativeType = Tds.cvtJdbcTypeToNativeType(formalParameterList[i].type);
                    if (formalParameterList[i].formalName == null) {
                        this.comm.appendByte((byte)0);
                    } else {
                        String name = formalParameterList[i].formalName;
                        this.comm.appendByte((byte)name.length());
                        if (this.tdsVer == 70) {
                            this.comm.appendChars(name);
                        } else {
                            byte[] nameBytes = this.encoder.getBytes(name);
                            this.comm.appendBytes(nameBytes);
                        }
                    }
                    if (actualParameterList[i].isOutput) {
                        this.comm.appendByte((byte)1);
                        if (nativeType == 50 && actualParameterList[i].value == null) {
                            actualParameterList[i].value = Boolean.FALSE;
                        }
                    } else {
                        this.comm.appendByte((byte)0);
                    }
                    if (actualParameterList[i].value == null && (nativeType == 48 || nativeType == 52 || nativeType == 56)) {
                        nativeType = 38;
                    }
                    switch (nativeType) {
                        case 47: {
                            String val;
                            try {
                                val = (String)actualParameterList[i].value;
                            }
                            catch (ClassCastException e) {
                                val = actualParameterList[i].value instanceof Boolean ? ((Boolean)actualParameterList[i].value != false ? "1" : "0") : actualParameterList[i].value.toString();
                            }
                            if (this.tdsVer < 70 && val != null && val.length() == 0) {
                                val = " ";
                            }
                            int len = val != null ? val.length() : 0;
                            int max = formalParameterList[i].maxLength;
                            if (formalParameterList[i].formalType != null && formalParameterList[i].formalType.startsWith("n")) {
                                if (max > 4000) {
                                    this.comm.appendByte((byte)99);
                                    this.comm.appendTdsInt(max * 2);
                                    if (val == null) {
                                        this.comm.appendTdsInt(-1);
                                        break;
                                    }
                                    this.comm.appendTdsInt(len * 2);
                                    this.comm.appendChars(val);
                                    break;
                                }
                                this.comm.appendByte((byte)-25);
                                this.comm.appendTdsShort((short)(max * 2));
                                if (val == null) {
                                    this.comm.appendTdsShort((short)-1);
                                    break;
                                }
                                if (val.length() > 4000) {
                                    throw new IOException("Field too long");
                                }
                                this.comm.appendTdsShort((short)(len * 2));
                                this.comm.appendChars(val);
                                break;
                            }
                            if (this.tdsVer != 70 && max > 255) {
                                this.comm.appendByte((byte)35);
                                if (actualParameterList[i].value instanceof byte[]) {
                                    this.sendSybImage((byte[])actualParameterList[i].value);
                                    break;
                                }
                                this.sendSybImage(this.encoder.getBytes(val));
                                break;
                            }
                            this.sendSybChar(val, formalParameterList[i].maxLength);
                            break;
                        }
                        case 38: {
                            this.comm.appendByte((byte)38);
                            this.comm.appendByte((byte)4);
                            if (actualParameterList[i].value == null) {
                                this.comm.appendByte((byte)0);
                                break;
                            }
                            this.comm.appendByte((byte)4);
                            this.comm.appendTdsInt(((Number)actualParameterList[i].value).intValue());
                            break;
                        }
                        case 56: {
                            this.comm.appendByte((byte)56);
                            this.comm.appendTdsInt(((Number)actualParameterList[i].value).intValue());
                            break;
                        }
                        case 52: {
                            this.comm.appendByte((byte)52);
                            this.comm.appendTdsShort(((Number)actualParameterList[i].value).shortValue());
                            break;
                        }
                        case 48: {
                            this.comm.appendByte((byte)48);
                            this.comm.appendByte(((Number)actualParameterList[i].value).byteValue());
                            break;
                        }
                        case 62: 
                        case 109: {
                            if (actualParameterList[i].value == null) {
                                this.comm.appendByte((byte)109);
                                this.comm.appendByte((byte)8);
                                this.comm.appendByte((byte)0);
                                break;
                            }
                            Double d = null;
                            if (actualParameterList[i].value instanceof Double) {
                                d = (Double)actualParameterList[i].value;
                            } else {
                                Number n = (Number)actualParameterList[i].value;
                                d = new Double(n.doubleValue());
                            }
                            this.comm.appendByte((byte)62);
                            this.comm.appendFlt8(d);
                            break;
                        }
                        case 111: {
                            this.writeDatetimeValue(actualParameterList[i].value);
                            break;
                        }
                        case 34: {
                            this.comm.appendByte(nativeType);
                            this.sendSybImage((byte[])actualParameterList[i].value);
                            break;
                        }
                        case 35: {
                            this.comm.appendByte((byte)35);
                            this.sendSybImage(this.encoder.getBytes((String)actualParameterList[i].value));
                            break;
                        }
                        case 50: 
                        case 104: {
                            if (actualParameterList[i].value == null) {
                                this.comm.appendByte((byte)104);
                                this.comm.appendByte((byte)1);
                                this.comm.appendByte((byte)0);
                                break;
                            }
                            this.comm.appendByte((byte)50);
                            if (actualParameterList[i].value.equals(Boolean.TRUE)) {
                                this.comm.appendByte((byte)1);
                                break;
                            }
                            this.comm.appendByte((byte)0);
                            break;
                        }
                        case 106: 
                        case 108: {
                            this.writeDecimalValue(actualParameterList[i].value, actualParameterList[i].type, actualParameterList[i].scale);
                            break;
                        }
                        case 37: 
                        case 45: {
                            byte[] value = (byte[])actualParameterList[i].value;
                            int maxLength = formalParameterList[i].maxLength;
                            if (value == null) {
                                this.comm.appendByte((byte)37);
                                this.comm.appendByte((byte)maxLength);
                                this.comm.appendByte((byte)0);
                                break;
                            }
                            if (value.length > 255) {
                                if (this.tdsVer != 70) {
                                    throw new IOException("Field too long");
                                }
                                this.comm.appendByte((byte)-91);
                                if (maxLength < 0 || maxLength > 8000) {
                                    this.comm.appendTdsShort((short)8000);
                                } else {
                                    this.comm.appendTdsShort((short)maxLength);
                                }
                                this.comm.appendTdsShort((short)value.length);
                            } else {
                                this.comm.appendByte((byte)37);
                                this.comm.appendByte((byte)maxLength);
                                this.comm.appendByte((byte)value.length);
                            }
                            this.comm.appendBytes(value);
                            break;
                        }
                        default: {
                            throw new SQLException("Not implemented for nativeType 0x" + Integer.toHexString(nativeType));
                        }
                    }
                    ++i;
                }
                this.moreResults = true;
                this.comm.sendPacket();
                this.waitForDataOrTimeout(wChain, timeout);
            }
            catch (IOException e) {
                throw new SQLException("Network error-  " + e.getMessage());
            }
            Object var14_18 = null;
            this.comm.packetType = 0;
        }
        catch (Throwable throwable) {
            Object var14_19 = null;
            this.comm.packetType = 0;
            throw throwable;
        }
    }

    private void checkMaxRows(Statement stmt, SQLWarningChain wChain) throws SQLException {
        if (stmt == null) {
            return;
        }
        int maxRows = stmt.getMaxRows();
        if (maxRows != this.maxRows) {
            this.submitProcedure("set rowcount " + maxRows, wChain);
            this.maxRows = maxRows;
        }
    }

    public void executeQuery(String sql, TdsStatement stmt, SQLWarningChain wChain, int timeout) throws SQLException {
        try {
            this.executeQueryInternal(sql, stmt, wChain, timeout);
        }
        catch (IOException e) {
            wChain.addException(new SQLException("Network problem. " + e.getMessage()));
        }
        catch (TdsUnknownPacketSubType e) {
            wChain.addException(new SQLException("Unknown response. " + e.getMessage()));
        }
        catch (TdsException e) {
            wChain.addException(new SQLException(e.toString()));
        }
        wChain.checkForExceptions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void executeQueryInternal(String sql, TdsStatement stmt, SQLWarningChain wChain, int timeout) throws IOException, SQLException, TdsException {
        while (this.cancelActive.booleanValue()) {
            this.waitForDataOrTimeout(wChain, timeout);
            this.processSubPacket();
        }
        this.checkMaxRows(stmt, wChain);
        if (sql.length() > 0) {
            try {
                this.comm.startPacket(1);
                if (this.tdsVer == 70) {
                    this.comm.appendChars(sql);
                } else {
                    byte[] sqlBytes = this.encoder.getBytes(sql);
                    this.comm.appendBytes(sqlBytes, sqlBytes.length, (byte)0);
                }
                this.moreResults = true;
                this.comm.sendPacket();
                this.waitForDataOrTimeout(wChain, timeout);
                Object var7_6 = null;
                this.comm.packetType = 0;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.comm.packetType = 0;
                throw throwable;
            }
        }
    }

    protected synchronized void goToNextResult(SQLWarningChain warningChain, TdsStatement stmt) throws TdsException, IOException, SQLException {
        boolean isPreparedStmt = stmt instanceof PreparedStatement;
        boolean isCallableStmt = stmt instanceof CallableStatement;
        while (this.moreResults) {
            byte next = this.comm.peek();
            if (next == -3 || next == -127 || next == -96 || next == -1 && isPreparedStmt && !isCallableStmt) break;
            PacketResult res = this.processSubPacket();
            if (res instanceof PacketMsgResult) {
                warningChain.addOrReturn((PacketMsgResult)res);
                continue;
            }
            if (res instanceof PacketOutputParamResult) {
                stmt.handleParamResult((PacketOutputParamResult)res);
                continue;
            }
            if (res instanceof PacketRetStatResult) {
                stmt.handleRetStat((PacketRetStatResult)res);
                continue;
            }
            if (!(res instanceof PacketEndTokenResult) || !((PacketEndTokenResult)res).wasCanceled()) continue;
            warningChain.addException(new SQLException("Query was cancelled or timed out."));
        }
    }

    EncodingHelper getEncoder() {
        return this.encoder;
    }

    int getTdsVer() {
        return this.tdsVer;
    }

    String getDatabaseProductName() {
        return this.databaseProductName;
    }

    String getDatabaseProductVersion() {
        return this.databaseProductVersion;
    }

    int getDatabaseMajorVersion() {
        return this.databaseMajorVersion;
    }

    int getDatabaseMinorVersion() {
        return this.databaseMinorVersion;
    }

    TdsConnection getConnection() {
        return this.connection;
    }

    private PacketOutputParamResult processOutputParam() throws TdsException, IOException {
        Object element;
        this.getSubPacketLength();
        this.comm.getString(this.comm.getByte() & 0xFF, this.encoder);
        this.comm.skip(5);
        byte colType = this.comm.getByte();
        switch (colType) {
            case 38: {
                this.comm.getByte();
                element = this.getIntValue(colType);
                break;
            }
            case 48: 
            case 52: 
            case 56: {
                element = this.getIntValue(colType);
                break;
            }
            case 34: {
                this.comm.getByte();
                element = this.getImageValue();
                break;
            }
            case 35: {
                this.comm.getByte();
                element = this.getTextValue(false);
                break;
            }
            case 99: {
                this.comm.getByte();
                element = this.getTextValue(true);
                break;
            }
            case 39: 
            case 47: {
                this.comm.getByte();
                element = this.getCharValue(false, true);
                break;
            }
            case -91: {
                this.comm.getTdsShort();
                int len = this.comm.getTdsShort();
                element = this.comm.getBytes(len, true);
                break;
            }
            case -89: {
                this.comm.getTdsShort();
                element = this.getCharValue(false, false);
                break;
            }
            case -25: {
                this.comm.getTdsShort();
                element = this.getCharValue(true, false);
                break;
            }
            case -17: 
            case 103: {
                this.comm.getByte();
                element = this.getCharValue(true, true);
                break;
            }
            case 59: {
                element = this.readFloatN(4);
                break;
            }
            case 62: {
                element = this.readFloatN(8);
                break;
            }
            case 109: {
                this.comm.getByte();
                byte actual_size = this.comm.getByte();
                element = this.readFloatN(actual_size);
                break;
            }
            case 60: 
            case 110: 
            case 122: {
                this.comm.getByte();
                element = this.getMoneyValue(colType);
                break;
            }
            case 106: 
            case 108: {
                this.comm.getByte();
                this.comm.getByte();
                byte scale = this.comm.getByte();
                element = this.getDecimalValue(scale);
                break;
            }
            case 111: {
                this.comm.getByte();
                element = this.getDatetimeValue(colType);
                break;
            }
            case 58: 
            case 61: {
                element = this.getDatetimeValue(colType);
                break;
            }
            case 37: 
            case 45: {
                this.comm.getByte();
                int len = this.comm.getByte() & 0xFF;
                element = this.comm.getBytes(len, true);
                break;
            }
            case 104: {
                this.comm.getByte();
                if (this.comm.getByte() == 0) {
                    element = null;
                    break;
                }
                element = new Boolean(this.comm.getByte() != 0);
                break;
            }
            case 50: {
                element = new Boolean(this.comm.getByte() != 0);
                break;
            }
            case 36: {
                int len = this.comm.getByte() & 0xFF;
                element = len == 0 ? null : TdsUtil.uniqueIdToString(this.comm.getBytes(len, false));
                break;
            }
            default: {
                throw new TdsNotImplemented("Don't now how to handle column type 0x" + Integer.toHexString(colType));
            }
        }
        return new PacketOutputParamResult(element);
    }

    PacketResult processSubPacket() throws TdsUnknownPacketSubType, IOException, TdsException, SQLException {
        return this.processSubPacket(this.currentContext);
    }

    private synchronized PacketResult processSubPacket(Context context) throws TdsUnknownPacketSubType, SQLException, IOException, TdsException {
        byte packetSubType = this.comm.getByte();
        if (Logger.isActive()) {
            Logger.println("processSubPacket: " + Integer.toHexString(packetSubType & 0xFF) + " " + "moreResults: " + this.moreResults());
        }
        switch (packetSubType) {
            case -29: {
                return this.processEnvChange();
            }
            case -86: 
            case -85: 
            case -27: {
                return this.processMsg(packetSubType);
            }
            case -84: {
                return this.processOutputParam();
            }
            case -83: {
                return this.processLoginAck();
            }
            case 121: {
                return this.processRetStat();
            }
            case 124: {
                return this.processProcId();
            }
            case -3: 
            case -2: 
            case -1: {
                PacketEndTokenResult result = this.processEndToken(packetSubType);
                this.moreResults = result.moreResults();
                return result;
            }
            case -96: {
                return this.processColumnNames();
            }
            case -95: {
                return this.processColumnInfo();
            }
            case -89: 
            case -88: {
                this.comm.skip(this.comm.getTdsShort());
                return new PacketUnknown(packetSubType);
            }
            case -92: {
                return this.processTabName();
            }
            case -91: {
                return this.processColInfo();
            }
            case -87: {
                int len = this.comm.getTdsShort();
                this.comm.skip(len);
                return new PacketColumnOrderResult();
            }
            case -82: {
                int len = this.comm.getTdsShort();
                this.comm.skip(len);
                return new PacketControlResult();
            }
            case -47: {
                return this.getRow(context);
            }
            case -127: {
                return this.processTds7Result();
            }
            case -19: {
                return this.processNtlmChallenge();
            }
        }
        throw new TdsUnknownPacketSubType(packetSubType);
    }

    private boolean setCharset(String charset) {
        boolean used;
        boolean bl = used = charset != null;
        if (charset == null || charset.length() > 30) {
            charset = "iso_1";
        }
        if (charset.toLowerCase().startsWith("cp")) {
            charset = "Cp" + charset.substring(2);
        }
        if (!charset.equals(this.charset)) {
            this.encoder = EncodingHelper.getHelper(charset);
            if (this.encoder == null) {
                if (Logger.isActive()) {
                    Logger.println("Invalid charset: " + charset + ". Trying iso_1 instead.");
                }
                charset = "iso_1";
                this.encoder = EncodingHelper.getHelper(charset);
                used = false;
            }
            this.charset = charset;
        }
        if (Logger.isActive()) {
            Logger.println("Set charset to " + charset + '/' + this.encoder.getName());
        }
        return used;
    }

    private static String getClientName() {
        String tmp;
        try {
            tmp = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            tmp = "";
        }
        StringTokenizer st = new StringTokenizer(tmp, ".");
        if (!st.hasMoreTokens()) {
            return "JOHNDOE";
        }
        tmp = st.nextToken();
        if (tmp.length() == 0) {
            return "JANEDOE";
        }
        if (Character.isDigit(tmp.charAt(0))) {
            return "BABYDOE";
        }
        return tmp.toUpperCase();
    }

    private int getSubPacketLength() throws IOException, TdsException {
        return this.comm.getTdsShort();
    }

    private static boolean isFixedSizeColumn(byte nativeColumnType) throws TdsException {
        switch (nativeColumnType) {
            case 48: 
            case 50: 
            case 52: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 112: 
            case 122: {
                return true;
            }
            case -17: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 45: 
            case 47: 
            case 99: 
            case 103: 
            case 104: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                return false;
            }
        }
        throw new TdsException("Unrecognized column type 0x" + Integer.toHexString(nativeColumnType));
    }

    private Object getMoneyValue(int type) throws IOException, TdsException {
        BigInteger x;
        int len;
        switch (type) {
            case 112: 
            case 122: {
                len = 4;
                break;
            }
            case 60: {
                len = 8;
                break;
            }
            case 110: {
                len = this.comm.getByte();
                break;
            }
            default: {
                throw new TdsException("Not a money value.");
            }
        }
        if (len == 0) {
            return null;
        }
        if (len == 4) {
            x = BigInteger.valueOf(this.comm.getTdsInt());
        } else if (len == 8) {
            byte b4 = this.comm.getByte();
            byte b5 = this.comm.getByte();
            byte b6 = this.comm.getByte();
            byte b7 = this.comm.getByte();
            byte b0 = this.comm.getByte();
            byte b1 = this.comm.getByte();
            byte b2 = this.comm.getByte();
            byte b3 = this.comm.getByte();
            long l = (long)(b0 & 0xFF) + ((long)(b1 & 0xFF) << 8) + ((long)(b2 & 0xFF) << 16) + ((long)(b3 & 0xFF) << 24) + ((long)(b4 & 0xFF) << 32) + ((long)(b5 & 0xFF) << 40) + ((long)(b6 & 0xFF) << 48) + ((long)(b7 & 0xFF) << 56);
            x = BigInteger.valueOf(l);
        } else {
            throw new TdsConfused("Don't know what to do with len of " + len);
        }
        return new BigDecimal(x, 4);
    }

    private Object getDecimalValue(int scale) throws TdsException, IOException, NumberFormatException {
        int len = this.comm.getByte() & 0xFF;
        if (--len < 1) {
            return null;
        }
        byte[] bytes = new byte[len];
        int signum = this.comm.getByte() == 0 ? -1 : 1;
        while (len > 0) {
            bytes[--len] = this.comm.getByte();
        }
        BigInteger bigInt = new BigInteger(signum, bytes);
        return new BigDecimal(bigInt, scale);
    }

    private Object getDatetimeValue(int type) throws IOException, TdsException {
        long SECONDS_PER_DAY = 86400L;
        long DAYS_BETWEEN_1900_AND_1970 = 25567L;
        int len = type == 111 ? this.comm.getByte() : (type == 58 ? 4 : 8);
        switch (len) {
            case 0: {
                return null;
            }
            case 8: {
                long tdsDays = this.comm.getTdsInt();
                long tdsTime = this.comm.getTdsInt();
                long sqlDays = tdsDays - 25567L;
                long seconds = sqlDays * 86400L + tdsTime / 300L;
                long micros = tdsTime % 300L * 1000000L / 300L;
                long millis = seconds * 1000L + micros / 1000L - (long)this.zoneOffset;
                if (micros % 1000L >= 500L) {
                    ++millis;
                }
                return new Timestamp(millis - Tds.getDstOffset(millis));
            }
            case 4: {
                long tdsDays = this.comm.getTdsShort();
                long minutes = this.comm.getTdsShort();
                long sqlDays = tdsDays - 25567L;
                long seconds = sqlDays * 86400L + minutes * 60L;
                long millis = seconds * 1000L - (long)this.zoneOffset;
                return new Timestamp(millis - Tds.getDstOffset(millis));
            }
        }
        throw new TdsNotImplemented("Don't now how to handle date with size of " + len);
    }

    private static long getDstOffset(long time) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new java.util.Date(time));
        return cal.get(16);
    }

    private Object getIntValue(int type) throws IOException, TdsException {
        Integer result;
        int len;
        switch (type) {
            case 38: {
                len = this.comm.getByte();
                break;
            }
            case 56: {
                len = 4;
                break;
            }
            case 52: {
                len = 2;
                break;
            }
            case 48: {
                len = 1;
                break;
            }
            default: {
                throw new TdsNotImplemented("Can't handle integer of type " + Integer.toHexString(type));
            }
        }
        switch (len) {
            case 4: {
                result = new Integer(this.comm.getTdsInt());
                break;
            }
            case 2: {
                result = new Integer((short)this.comm.getTdsShort());
                break;
            }
            case 1: {
                result = new Integer(this.comm.getByte() & 0xFF);
                break;
            }
            case 0: {
                result = null;
                break;
            }
            default: {
                throw new TdsConfused("Bad SYBINTN length of " + len);
            }
        }
        return result;
    }

    private Object getCharValue(boolean wideChars, boolean outputParam) throws TdsException, IOException {
        String result;
        int len;
        boolean shortLen = this.tdsVer == 70 && (wideChars || !outputParam);
        int n = len = shortLen ? this.comm.getTdsShort() : this.comm.getByte() & 0xFF;
        if (this.tdsVer < 70 && len == 0 || this.tdsVer == 70 && len == 65535) {
            result = null;
        } else if (len >= 0) {
            result = wideChars ? this.comm.getString(len >> 1, this.encoder) : this.encoder.getString(this.comm.getBytes(len, false), 0, len);
            if (this.tdsVer < 70 && " ".equals(result)) {
                result = "";
            }
        } else {
            throw new TdsConfused("String with length<0");
        }
        return result;
    }

    private Object getTextValue(boolean wideChars) throws TdsException, IOException {
        String result;
        byte hasValue = this.comm.getByte();
        if (hasValue == 0) {
            result = null;
        } else {
            this.comm.skip(24);
            int len = this.comm.getTdsInt();
            if (len >= 0) {
                result = wideChars ? this.comm.getString(len / 2, this.encoder) : this.encoder.getString(this.comm.getBytes(len, false), 0, len);
                if (this.tdsVer < 70 && " ".equals(result)) {
                    result = "";
                }
            } else {
                throw new TdsConfused("String with length<0");
            }
        }
        return result;
    }

    private Object getImageValue() throws TdsException, IOException {
        byte[] result;
        byte hasValue = this.comm.getByte();
        if (hasValue == 0) {
            result = null;
        } else {
            this.comm.skip(24);
            int len = this.comm.getTdsInt();
            if (len >= 0) {
                result = this.comm.getBytes(len, true);
            } else {
                throw new TdsConfused("String with length<0");
            }
        }
        return result;
    }

    private PacketRowResult loadRow(PacketRowResult result) throws SQLException, TdsException, IOException {
        Columns columnsInfo = result.getContext().getColumnInfo();
        int i = 1;
        while (i <= columnsInfo.realColumnCount()) {
            Object element;
            int colType = columnsInfo.getNativeType(i);
            if (Logger.isActive()) {
                Logger.println("colno=" + i + " type=" + colType + " offset=" + Integer.toHexString(this.comm.inBufferIndex));
            }
            switch (colType) {
                case 38: 
                case 48: 
                case 52: 
                case 56: {
                    element = this.getIntValue(colType);
                    break;
                }
                case 34: {
                    element = this.getImageValue();
                    break;
                }
                case 35: {
                    element = this.getTextValue(false);
                    break;
                }
                case 99: {
                    element = this.getTextValue(true);
                    break;
                }
                case 39: 
                case 47: {
                    element = this.getCharValue(false, false);
                    break;
                }
                case -17: 
                case 103: {
                    element = this.getCharValue(true, false);
                    break;
                }
                case 59: {
                    element = this.readFloatN(4);
                    break;
                }
                case 62: {
                    element = this.readFloatN(8);
                    break;
                }
                case 109: {
                    element = this.readFloatN(this.comm.getByte());
                    break;
                }
                case 60: 
                case 110: 
                case 122: {
                    element = this.getMoneyValue(colType);
                    break;
                }
                case 106: 
                case 108: {
                    element = this.getDecimalValue(columnsInfo.getScale(i));
                    break;
                }
                case 58: 
                case 61: 
                case 111: {
                    element = this.getDatetimeValue(colType);
                    break;
                }
                case 37: 
                case 45: {
                    int len;
                    int n = len = this.tdsVer == 70 ? this.comm.getTdsShort() : this.comm.getByte() & 0xFF;
                    if (this.tdsVer == 70 && len == 65535) {
                        element = null;
                        break;
                    }
                    element = this.comm.getBytes(len, true);
                    break;
                }
                case 50: 
                case 104: {
                    if (colType == 104 && this.comm.getByte() == 0) {
                        element = null;
                        break;
                    }
                    element = new Boolean(this.comm.getByte() != 0);
                    break;
                }
                case 36: {
                    int len = this.comm.getByte() & 0xFF;
                    element = len == 0 ? null : TdsUtil.uniqueIdToString(this.comm.getBytes(len, false));
                    break;
                }
                default: {
                    throw new TdsNotImplemented("Don't now how to handle column type 0x" + Integer.toHexString(colType));
                }
            }
            result.setElementAt(i, element);
            ++i;
        }
        return result;
    }

    private PacketRowResult getRow(Context context) throws SQLException, TdsException, IOException {
        PacketRowResult result = new PacketRowResult(context);
        return this.loadRow(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logon(String database) throws SQLException, TdsUnknownPacketSubType, IOException, TdsException {
        boolean pad = false;
        byte[] empty = new byte[]{};
        try {
            if (this.tdsVer == 70) {
                this.send70Login(database);
                database = "";
            } else {
                this.comm.startPacket(2);
                byte[] tmp = this.encoder.getBytes(Tds.getClientName());
                this.comm.appendBytes(tmp, 30, (byte)0);
                this.comm.appendByte((byte)(tmp.length < 30 ? tmp.length : 30));
                tmp = this.encoder.getBytes(this.user);
                this.comm.appendBytes(tmp, 30, (byte)0);
                this.comm.appendByte((byte)(tmp.length < 30 ? tmp.length : 30));
                tmp = this.encoder.getBytes(this.password);
                this.comm.appendBytes(tmp, 30, (byte)0);
                this.comm.appendByte((byte)(tmp.length < 30 ? tmp.length : 30));
                tmp = this.encoder.getBytes("00000116");
                this.comm.appendBytes(tmp, 8, (byte)0);
                this.comm.appendBytes(empty, 16, (byte)0);
                this.comm.appendByte((byte)0);
                this.comm.appendByte((byte)-96);
                this.comm.appendByte((byte)36);
                this.comm.appendByte((byte)-52);
                this.comm.appendByte((byte)80);
                this.comm.appendByte((byte)18);
                this.comm.appendByte((byte)8);
                this.comm.appendByte((byte)3);
                this.comm.appendByte((byte)1);
                this.comm.appendByte((byte)6);
                this.comm.appendByte((byte)10);
                this.comm.appendByte((byte)9);
                this.comm.appendByte((byte)1);
                this.comm.appendByte((byte)1);
                this.comm.appendByte((byte)0);
                this.comm.appendByte((byte)0);
                this.comm.appendBytes(empty, 7, (byte)0);
                tmp = this.encoder.getBytes(this.appName);
                this.comm.appendBytes(tmp, 30, (byte)0);
                this.comm.appendByte((byte)(tmp.length < 30 ? tmp.length : 30));
                tmp = this.encoder.getBytes(this.serverName);
                this.comm.appendBytes(tmp, 30, (byte)0);
                this.comm.appendByte((byte)(tmp.length < 30 ? tmp.length : 30));
                this.comm.appendBytes(empty, 2, (byte)0);
                tmp = this.encoder.getBytes(this.password);
                this.comm.appendBytes(tmp, 253, (byte)0);
                this.comm.appendByte((byte)(tmp.length < 253 ? tmp.length + 2 : 255));
                this.comm.appendByte((byte)4);
                this.comm.appendByte((byte)2);
                this.comm.appendByte((byte)0);
                this.comm.appendByte((byte)0);
                tmp = this.encoder.getBytes(this.progName);
                this.comm.appendBytes(tmp, 10, (byte)0);
                this.comm.appendByte((byte)(tmp.length < 10 ? tmp.length : 10));
                this.comm.appendByte((byte)6);
                this.comm.appendByte((byte)0);
                this.comm.appendByte((byte)0);
                this.comm.appendByte((byte)0);
                this.comm.appendByte((byte)0);
                this.comm.appendByte((byte)13);
                this.comm.appendByte((byte)17);
                tmp = this.encoder.getBytes("us_english");
                this.comm.appendBytes(tmp, 30, (byte)0);
                this.comm.appendByte((byte)(tmp.length < 30 ? tmp.length : 30));
                this.comm.appendByte((byte)1);
                this.comm.appendShort((short)0);
                this.comm.appendBytes(empty, 8, (byte)0);
                this.comm.appendShort((short)0);
                this.comm.appendByte((byte)0);
                tmp = this.encoder.getBytes(this.charset);
                this.comm.appendBytes(tmp, 30, (byte)0);
                this.comm.appendByte((byte)(tmp.length < 30 ? tmp.length : 30));
                this.comm.appendByte((byte)1);
                tmp = this.encoder.getBytes("512");
                this.comm.appendBytes(tmp, 6, (byte)0);
                this.comm.appendByte((byte)3);
                this.comm.appendBytes(empty, 8, (byte)0);
            }
            this.moreResults = true;
            this.comm.sendPacket();
            Object var6_5 = null;
            this.comm.packetType = 0;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.comm.packetType = 0;
            throw throwable;
        }
        SQLWarningChain wChain = new SQLWarningChain();
        while (this.moreResults) {
            PacketResult res = this.processSubPacket();
            if (res instanceof PacketMsgResult) {
                wChain.addOrReturn((PacketMsgResult)res);
            }
            if (!(res instanceof PacketAuthTokenResult)) continue;
            this.sendNtlmChallengeResponse((PacketAuthTokenResult)res);
        }
        wChain.checkForExceptions();
        this.initSettings(database, wChain);
        wChain.checkForExceptions();
    }

    private void send70Login(String _database) throws IOException, TdsException {
        short authLen;
        String libName = this.progName;
        boolean pad = false;
        byte[] empty = new byte[]{};
        String appName = this.appName;
        String clientName = Tds.getClientName();
        boolean ntlmAuth = this.domain.length() > 0;
        short packSize = (short)(86 + 2 * (clientName.length() + appName.length() + this.serverName.length() + libName.length() + _database.length()));
        if (ntlmAuth) {
            authLen = (short)(32 + this.domain.length());
            packSize = (short)(packSize + authLen);
        } else {
            authLen = 0;
            packSize = (short)(packSize + 2 * (this.user.length() + this.password.length()));
        }
        this.comm.startPacket(16);
        this.comm.appendTdsInt(packSize);
        this.comm.appendTdsInt(0x70000000);
        this.comm.appendBytes(empty, 16, (byte)0);
        this.comm.appendByte((byte)-32);
        if (ntlmAuth) {
            this.comm.appendByte((byte)-125);
        } else {
            this.comm.appendByte((byte)3);
        }
        this.comm.appendBytes(empty, 10, (byte)0);
        short curPos = 86;
        this.comm.appendTdsShort(curPos);
        this.comm.appendTdsShort((short)clientName.length());
        curPos = (short)(curPos + clientName.length() * 2);
        if (!ntlmAuth) {
            this.comm.appendTdsShort(curPos);
            this.comm.appendTdsShort((short)this.user.length());
            curPos = (short)(curPos + this.user.length() * 2);
            this.comm.appendTdsShort(curPos);
            this.comm.appendTdsShort((short)this.password.length());
            curPos = (short)(curPos + this.password.length() * 2);
        } else {
            this.comm.appendTdsShort(curPos);
            this.comm.appendTdsShort((short)0);
            this.comm.appendTdsShort(curPos);
            this.comm.appendTdsShort((short)0);
        }
        this.comm.appendTdsShort(curPos);
        this.comm.appendTdsShort((short)appName.length());
        curPos = (short)(curPos + appName.length() * 2);
        this.comm.appendTdsShort(curPos);
        this.comm.appendTdsShort((short)this.serverName.length());
        curPos = (short)(curPos + this.serverName.length() * 2);
        this.comm.appendTdsShort((short)0);
        this.comm.appendTdsShort((short)0);
        this.comm.appendTdsShort(curPos);
        this.comm.appendTdsShort((short)libName.length());
        curPos = (short)(curPos + libName.length() * 2);
        this.comm.appendTdsShort(curPos);
        this.comm.appendTdsShort((short)0);
        this.comm.appendTdsShort(curPos);
        this.comm.appendTdsShort((short)_database.length());
        curPos = (short)(curPos + _database.length() * 2);
        this.comm.appendBytes(empty, 6, (byte)0);
        this.comm.appendTdsShort(curPos);
        this.comm.appendTdsShort(authLen);
        this.comm.appendTdsInt(packSize);
        this.comm.appendChars(clientName);
        if (!ntlmAuth) {
            String scrambledPw = Tds.tds7CryptPass(this.password);
            this.comm.appendChars(this.user);
            this.comm.appendChars(scrambledPw);
        }
        this.comm.appendChars(appName);
        this.comm.appendChars(this.serverName);
        this.comm.appendChars(libName);
        this.comm.appendChars(_database);
        if (ntlmAuth) {
            byte[] domainBytes = this.domain.getBytes("UTF8");
            byte[] header = new byte[]{78, 84, 76, 77, 83, 83, 80, 0};
            this.comm.appendBytes(header);
            this.comm.appendTdsInt(1);
            this.comm.appendTdsInt(45569);
            this.comm.appendTdsShort((short)domainBytes.length);
            this.comm.appendTdsShort((short)domainBytes.length);
            this.comm.appendTdsInt(32);
            this.comm.appendTdsShort((short)0);
            this.comm.appendTdsShort((short)0);
            this.comm.appendTdsInt(32);
            this.comm.appendBytes(domainBytes);
        }
    }

    protected synchronized void changeDB(String database, SQLWarningChain wChain) {
        if (database.length() > 32 || database.length() < 1) {
            wChain.addException(new SQLException("Name too long - " + database));
        }
        int i = 0;
        while (i < database.length()) {
            char ch = database.charAt(i);
            if (!(ch == '_' && i != 0 || ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9')) {
                wChain.addException(new SQLException("Bad database name- " + database));
            }
            ++i;
        }
        String query = this.tdsVer == 70 ? "use [" + database + ']' : "use " + database;
        try {
            this.submitProcedure(query, wChain);
        }
        catch (SQLException ex) {
            wChain.addException(ex);
        }
    }

    private PacketMsgResult processMsg(byte packetSubType) throws IOException, TdsException {
        SqlMessage msg = new SqlMessage();
        this.getSubPacketLength();
        msg.number = this.comm.getTdsInt();
        msg.state = this.comm.getByte() & 0xFF;
        msg.severity = this.comm.getByte() & 0xFF;
        int msgLen = this.comm.getTdsShort();
        msg.message = this.comm.getString(msgLen, this.encoder);
        int srvNameLen = this.comm.getByte() & 0xFF;
        msg.server = this.comm.getString(srvNameLen, this.encoder);
        if (packetSubType != -85 && packetSubType != -86) {
            throw new TdsConfused("Was expecting a msg or error token.  Found 0x" + Integer.toHexString(packetSubType & 0xFF));
        }
        int procNameLen = this.comm.getByte() & 0xFF;
        msg.procName = this.comm.getString(procNameLen, this.encoder);
        msg.line = this.comm.getTdsShort();
        if (packetSubType == -86) {
            return new PacketErrorResult(packetSubType, msg);
        }
        return new PacketMsgResult(packetSubType, msg);
    }

    private PacketResult processEnvChange() throws IOException, TdsException {
        int len = this.getSubPacketLength();
        byte type = this.comm.getByte();
        switch (type) {
            case 4: {
                int clen = this.comm.getByte() & 0xFF;
                String blocksize = this.comm.getString(clen, this.encoder);
                if (this.tdsVer == 70) {
                    this.comm.skip(len - 2 - clen * 2);
                } else {
                    this.comm.skip(len - 2 - clen);
                }
                this.comm.resizeOutbuf(Integer.parseInt(blocksize));
                if (!Logger.isActive()) break;
                Logger.println("Changed blocksize to " + blocksize);
                break;
            }
            case 3: {
                int clen = this.comm.getByte() & 0xFF;
                String charset = this.comm.getString(clen, this.encoder);
                if (this.tdsVer == 70) {
                    this.comm.skip(len - 2 - clen * 2);
                } else {
                    this.comm.skip(len - 2 - clen);
                }
                if (!this.charsetSpecified) {
                    this.setCharset(charset);
                    break;
                }
                if (!Logger.isActive()) break;
                Logger.println("Server charset " + charset + ". Ignoring.");
                break;
            }
            case 1: {
                int clen = this.comm.getByte() & 0xFF;
                String newDb = this.comm.getString(clen, this.encoder);
                clen = this.comm.getByte() & 0xFF;
                String oldDb = this.comm.getString(clen, this.encoder);
                if (this.database != null && !oldDb.equalsIgnoreCase(this.database)) {
                    throw new TdsException("Old database mismatch.");
                }
                this.database = newDb;
                if (!Logger.isActive()) break;
                Logger.println("Changed database to " + this.database);
                break;
            }
            default: {
                this.comm.skip(len - 1);
            }
        }
        return new PacketResult(-29);
    }

    private PacketColumnNamesResult processColumnNames() throws IOException, TdsException {
        Columns columns = new Columns();
        int totalLen = this.comm.getTdsShort();
        int bytesRead = 0;
        int i = 0;
        while (bytesRead < totalLen) {
            int colNameLen = this.comm.getByte() & 0xFF;
            String colName = this.comm.getString(colNameLen, this.encoder);
            bytesRead = bytesRead + 1 + colNameLen;
            columns.setName(++i, colName);
            columns.setLabel(i, colName);
        }
        this.currentContext = new Context(columns, this.encoder);
        return new PacketColumnNamesResult(columns);
    }

    private PacketColumnInfoResult processColumnInfo() throws IOException, TdsException {
        Columns columns = new Columns();
        int totalLen = this.comm.getTdsShort();
        int bytesRead = 0;
        int numColumns = 0;
        while (bytesRead < totalLen) {
            int bufLength;
            int scale = -1;
            int precision = -1;
            int dispSize = -1;
            byte[] flagData = new byte[4];
            int i = 0;
            while (i < 4) {
                flagData[i] = this.comm.getByte();
                ++bytesRead;
                ++i;
            }
            boolean nullable = (flagData[2] & 1) > 0;
            boolean caseSensitive = (flagData[2] & 2) > 0;
            boolean writable = (flagData[2] & 0xC) > 0;
            boolean autoIncrement = (flagData[2] & 0x10) > 0;
            String tableName = "";
            byte columnType = this.comm.getByte();
            ++bytesRead;
            if (columnType == 35 || columnType == 34) {
                this.comm.skip(4);
                bytesRead += 4;
                int tableNameLen = this.comm.getTdsShort();
                bytesRead += 2;
                tableName = this.comm.getString(tableNameLen, this.encoder);
                bytesRead += tableNameLen;
                bufLength = Integer.MIN_VALUE;
            } else if (columnType == 106 || columnType == 108) {
                bufLength = this.comm.getByte();
                ++bytesRead;
                precision = this.comm.getByte();
                ++bytesRead;
                scale = this.comm.getByte();
                ++bytesRead;
            } else if (Tds.isFixedSizeColumn(columnType)) {
                bufLength = Tds.lookupBufferSize(columnType);
            } else {
                bufLength = this.comm.getByte() & 0xFF;
                ++bytesRead;
            }
            Tds.populateColumn(columns.getColumn(++numColumns), columnType, null, -1, bufLength, nullable, autoIncrement, writable, caseSensitive, tableName, precision, scale);
        }
        int skipLen = totalLen - bytesRead;
        if (skipLen != 0) {
            throw new TdsException("skipping " + skipLen + " bytes");
        }
        this.currentContext.getColumnInfo().merge(columns);
        return new PacketColumnInfoResult(columns);
    }

    /*
     * Unable to fully structure code
     */
    private PacketTabNameResult processTabName() throws IOException, TdsException {
        block2: {
            totalLen = this.comm.getTdsShort();
            bytesRead = 0;
            tables = new ArrayList<String>();
            if (this.tdsVer != 70) ** GOTO lbl20
            while (bytesRead < totalLen) {
                nameLen = this.comm.getTdsShort();
                bytesRead += 2;
                tabName = this.comm.getString(nameLen, this.encoder);
                bytesRead += nameLen << 1;
                tables.add(tabName);
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                nameLen = this.comm.getByte() & 255;
                ++bytesRead;
                tabName = this.comm.getString(nameLen, this.encoder);
                bytesRead += nameLen;
                tables.add(tabName);
lbl20:
                // 2 sources

                ** while (bytesRead < totalLen)
            }
        }
        this.currentContext.setTables(tables);
        return new PacketTabNameResult(tables);
    }

    /*
     * Unable to fully structure code
     */
    private PacketColInfoResult processColInfo() throws IOException, TdsException {
        block2: {
            totalLen = this.comm.getTdsShort();
            bytesRead = 0;
            tables = this.currentContext.getTables();
            columns = this.currentContext.getColumnInfo();
            if (tables != null) ** GOTO lbl20
            this.comm.skip(totalLen);
            break block2;
lbl-1000:
            // 1 sources

            {
                columnIndex = this.comm.getByte() & 255;
                tableIndex = (this.comm.getByte() & 255) - 1;
                flags = this.comm.getByte();
                bytesRead += 3;
                if (tableIndex != -1) {
                    columns.getColumn(columnIndex).setTableName(tables.get(tableIndex).toString());
                }
                if ((flags & 32) == 0) continue;
                nameLen = this.comm.getByte() & 255;
                ++bytesRead;
                colName = this.comm.getString(nameLen, this.encoder);
                columns.getColumn(columnIndex).setName(colName);
                bytesRead += this.tdsVer == 70 ? 2 * colName.length() : colName.length();
lbl20:
                // 3 sources

                ** while (bytesRead < totalLen)
            }
        }
        return new PacketColInfoResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PacketEndTokenResult processEndToken(byte packetType) throws TdsException, IOException {
        PacketEndTokenResult result;
        byte status = this.comm.getByte();
        this.comm.getByte();
        byte op = this.comm.getByte();
        this.comm.getByte();
        int rowCount = this.comm.getTdsInt();
        if (op == -63 || op == -32) {
            rowCount = -1;
        }
        if (packetType == -2) {
            rowCount = -1;
        }
        if ((result = new PacketEndTokenResult(packetType, status, rowCount)).wasCanceled()) {
            Boolean bl = this.cancelActive;
            synchronized (bl) {
                this.cancelActive = Boolean.FALSE;
            }
        }
        return result;
    }

    private static int lookupBufferSize(byte nativeColumnType) throws TdsException {
        switch (nativeColumnType) {
            case 48: {
                return 1;
            }
            case 52: {
                return 2;
            }
            case 56: {
                return 4;
            }
            case 59: {
                return 4;
            }
            case 62: {
                return 8;
            }
            case 61: {
                return 8;
            }
            case 58: {
                return 4;
            }
            case 50: {
                return 1;
            }
            case 60: {
                return 8;
            }
            case 112: 
            case 122: {
                return 4;
            }
        }
        throw new TdsException("Not fixed size column " + nativeColumnType);
    }

    private static int lookupDisplaySize(byte nativeColumnType) throws TdsException {
        switch (nativeColumnType) {
            case 48: {
                return 3;
            }
            case 52: {
                return 6;
            }
            case 56: {
                return 11;
            }
            case 59: {
                return 14;
            }
            case 62: {
                return 24;
            }
            case 61: {
                return 23;
            }
            case 58: {
                return 16;
            }
            case 50: {
                return 1;
            }
            case 60: {
                return 21;
            }
            case 112: 
            case 122: {
                return 12;
            }
        }
        throw new TdsException("Not fixed size column " + nativeColumnType);
    }

    private void writeDatetimeValue(Object value_in) throws IOException {
        this.comm.appendByte((byte)111);
        if (value_in == null) {
            this.comm.appendByte((byte)8);
            this.comm.appendByte((byte)0);
        } else {
            long ms;
            int secondsPerDay = 86400;
            int msPerDay = 86400000;
            int nsPerMs = 1000000;
            int msPerMinute = 60000;
            int epochsDifference = 25567;
            if (value_in instanceof Timestamp) {
                Timestamp value = (Timestamp)value_in;
                ms = value.getTime();
                if (ms % 1000L == 0L) {
                    ms += (long)(value.getNanos() / 1000000);
                }
            } else {
                ms = ((java.util.Date)value_in).getTime();
            }
            ms += (long)this.zoneOffset;
            ms += Tds.getDstOffset(ms);
            long msIntoCurrentDay = ms % 86400000L;
            long daysIntoUnixEpoch = ms / 86400000L;
            if (msIntoCurrentDay < 0L) {
                msIntoCurrentDay += 86400000L;
                --daysIntoUnixEpoch;
            }
            if (value_in instanceof Date) {
                msIntoCurrentDay = 0L;
            } else if (value_in instanceof Time) {
                daysIntoUnixEpoch = 0L;
            }
            int daysIntoSybaseEpoch = (int)daysIntoUnixEpoch + 25567;
            if (msIntoCurrentDay % 60000L == 0L && daysIntoSybaseEpoch > Short.MIN_VALUE && daysIntoSybaseEpoch < Short.MAX_VALUE) {
                this.comm.appendByte((byte)4);
                this.comm.appendByte((byte)4);
                this.comm.appendTdsShort((short)daysIntoSybaseEpoch);
                this.comm.appendTdsShort((short)(msIntoCurrentDay / 60000L));
            } else {
                int jiffies = (int)((msIntoCurrentDay * 300L + 100L) / 1000L);
                this.comm.appendByte((byte)8);
                this.comm.appendByte((byte)8);
                this.comm.appendTdsInt(daysIntoSybaseEpoch);
                this.comm.appendTdsInt(jiffies);
            }
        }
    }

    private void writeDecimalValue(Object o, int jdbcType, int reqScale) throws TdsException, IOException {
        byte prec = this.connection.getMaxPrecision();
        byte maxLen = prec <= 28 ? (byte)13 : 17;
        this.comm.appendByte((byte)106);
        if (jdbcType == -5) {
            this.comm.appendByte(maxLen);
            this.comm.appendByte(prec);
            this.comm.appendByte((byte)0);
            if (o == null) {
                this.comm.appendByte((byte)0);
            } else {
                this.comm.appendByte((byte)9);
                long value = ((Number)o).longValue();
                if (value >= 0L) {
                    this.comm.appendByte((byte)1);
                } else {
                    this.comm.appendByte((byte)0);
                    value = -value;
                }
                int valueidx = 0;
                while (valueidx < 8) {
                    this.comm.appendByte((byte)(value & 0xFFL));
                    value >>>= 8;
                    ++valueidx;
                }
            }
        } else {
            this.comm.appendByte(maxLen);
            this.comm.appendByte(prec);
            if (o == null) {
                this.comm.appendByte((byte)(reqScale == -1 ? 0 : reqScale));
                this.comm.appendByte((byte)0);
            } else {
                byte len;
                byte[] mantisse;
                byte scale;
                BigDecimal bd = o instanceof BigDecimal ? (BigDecimal)o : (o instanceof Number ? new BigDecimal(((Number)o).doubleValue()) : (o instanceof Boolean ? new BigDecimal((Boolean)o != false ? 1.0 : 0.0) : new BigDecimal(o.toString())));
                if (reqScale != -1) {
                    bd = bd.setScale(reqScale, 4);
                }
                if (bd.scale() > prec) {
                    bd = bd.setScale((int)prec, 4);
                }
                byte signum = (byte)(bd.signum() >= 0 ? 1 : 0);
                while (true) {
                    scale = (byte)bd.scale();
                    BigInteger bi = bd.unscaledValue();
                    mantisse = bi.abs().toByteArray();
                    len = (byte)(mantisse.length + 1);
                    if (len <= maxLen) break;
                    int dif = len - maxLen;
                    if ((scale = (byte)(scale - dif * 2)) < 0) {
                        throw new TdsException("can't sent this BigDecimal");
                    }
                    bd = bd.setScale((int)scale, 4);
                }
                this.comm.appendByte(scale);
                this.comm.appendByte(len);
                this.comm.appendByte(signum);
                int i = mantisse.length - 1;
                while (i >= 0) {
                    this.comm.appendByte(mantisse[i]);
                    --i;
                }
            }
        }
    }

    private Object readFloatN(int len) throws TdsException, IOException {
        Number tmp;
        switch (len) {
            case 8: {
                long l = this.comm.getTdsInt64();
                tmp = new Double(Double.longBitsToDouble(l));
                break;
            }
            case 4: {
                int i = this.comm.getTdsInt();
                tmp = new Float(Float.intBitsToFloat(i));
                break;
            }
            case 0: {
                tmp = null;
                break;
            }
            default: {
                throw new TdsNotImplemented("Don't now how to handle float with size of " + len + "(0x" + Integer.toHexString(len & 0xFF) + ")");
            }
        }
        return tmp;
    }

    private void sendSybImage(byte[] value) throws IOException {
        int length = value == null ? 0 : value.length;
        this.comm.appendTdsInt(length);
        this.comm.appendTdsInt(length);
        if (value != null) {
            this.comm.appendBytes(value);
        }
    }

    private void sendSybChar(String value, int maxLength) throws IOException {
        if (value == null) {
            this.comm.appendByte((byte)39);
            this.comm.appendByte((byte)(maxLength > 255 ? 255 : maxLength));
            this.comm.appendByte((byte)0);
            return;
        }
        byte[] converted = this.encoder.getBytes(value);
        if (this.tdsVer == 70) {
            this.comm.appendByte((byte)-89);
            this.comm.appendTdsShort((short)maxLength);
            this.comm.appendTdsShort((short)converted.length);
        } else {
            if (maxLength > 255 || converted.length > 255) {
                throw new IOException("String too long");
            }
            this.comm.appendByte((byte)39);
            this.comm.appendByte((byte)maxLength);
            if (converted.length != 0) {
                this.comm.appendByte((byte)converted.length);
            } else {
                this.comm.appendByte((byte)1);
                this.comm.appendByte((byte)32);
            }
        }
        this.comm.appendBytes(converted);
    }

    private PacketResult processLoginAck() throws TdsException, IOException {
        int nameLen;
        this.getSubPacketLength();
        if (this.tdsVer == 70) {
            this.comm.skip(5);
            nameLen = this.comm.getByte() & 0xFF;
            this.databaseProductName = this.comm.getString(nameLen, this.encoder);
            this.databaseMajorVersion = this.comm.getByte() & 0xFF;
            this.databaseMinorVersion = this.comm.getByte() & 0xFF;
            this.databaseProductVersion = "0" + this.databaseMajorVersion + ".0" + this.databaseMinorVersion + ".0" + this.comm.getNetShort();
        } else {
            this.comm.skip(5);
            nameLen = this.comm.getByte() & 0xFF;
            this.databaseProductName = this.comm.getString(nameLen, this.encoder);
            this.comm.skip(1);
            this.databaseMajorVersion = this.comm.getByte() & 0xFF;
            this.databaseMinorVersion = this.comm.getByte() & 0xFF;
            this.databaseProductVersion = "" + this.databaseMajorVersion + "." + this.databaseMinorVersion;
            this.comm.skip(1);
        }
        if (this.databaseProductName.length() > 1 && -1 != this.databaseProductName.indexOf(0)) {
            int last = this.databaseProductName.indexOf(0);
            this.databaseProductName = this.databaseProductName.substring(0, last);
        }
        return new PacketResult(-83);
    }

    private PacketResult processProcId() throws IOException, TdsException {
        this.comm.skip(8);
        return new PacketResult(124);
    }

    private PacketRetStatResult processRetStat() throws IOException, TdsException {
        return new PacketRetStatResult(this.comm.getTdsInt());
    }

    private PacketResult processTds7Result() throws IOException, TdsException {
        int numColumns = this.comm.getTdsShort();
        Columns columns = new Columns(numColumns);
        int colNum = 1;
        while (colNum <= numColumns) {
            int bufLength;
            byte[] flagData = new byte[4];
            int i = 0;
            while (i < 4) {
                flagData[i] = this.comm.getByte();
                ++i;
            }
            boolean nullable = (flagData[2] & 1) > 0;
            boolean caseSensitive = (flagData[2] & 2) > 0;
            boolean writable = (flagData[2] & 0xC) > 0;
            boolean autoIncrement = (flagData[2] & 0x10) > 0;
            int columnType = this.comm.getByte() & 0xFF;
            if (columnType == 239) {
                columnType = -17;
            }
            int xColType = -1;
            if (Tds.isLargeType(columnType)) {
                xColType = columnType;
                if (columnType != -17) {
                    columnType -= 128;
                }
            }
            int dispSize = -1;
            String tableName = "";
            if (Tds.isBlobType(columnType)) {
                bufLength = this.comm.getTdsInt();
                tableName = this.comm.getString(this.comm.getTdsShort(), this.encoder);
            } else {
                bufLength = Tds.isFixedSizeColumn((byte)columnType) ? Tds.lookupBufferSize((byte)columnType) : (Tds.isLargeType(xColType) ? this.comm.getTdsShort() : this.comm.getByte() & 0xFF);
            }
            int precision = -1;
            int scale = -1;
            if (columnType == 106 || columnType == 108) {
                precision = this.comm.getByte();
                scale = this.comm.getByte();
            }
            int colNameLen = this.comm.getByte() & 0xFF;
            String columnName = this.comm.getString(colNameLen, this.encoder);
            Tds.populateColumn(columns.getColumn(colNum), columnType, columnName, -1, bufLength, nullable, autoIncrement, writable, caseSensitive, tableName, precision, scale);
            ++colNum;
        }
        this.currentContext = new Context(columns, this.encoder);
        return new PacketColumnNamesResult(columns);
    }

    private static void populateColumn(Column col, int columnType, String columnName, int dispSize, int bufLength, boolean nullable, boolean autoIncrement, boolean writable, boolean caseSensitive, String tableName, int precision, int scale) {
        if (columnName != null) {
            col.setName(columnName);
            col.setLabel(columnName);
        }
        col.setType(columnType);
        col.setBufferSize(bufLength);
        col.setNullable(nullable ? 1 : 0);
        col.setAutoIncrement(autoIncrement);
        col.setReadOnly(!writable);
        col.setCaseSensitive(caseSensitive);
        if (tableName != null) {
            int pos = tableName.lastIndexOf(46);
            col.setTableName(tableName.substring(pos + 1));
            pos = pos == -1 ? 0 : pos;
            tableName = tableName.substring(0, pos);
            if (pos > 0) {
                pos = tableName.lastIndexOf(46);
                col.setSchema(tableName.substring(pos + 1));
                pos = pos == -1 ? 0 : pos;
                tableName = tableName.substring(0, pos);
            }
            if (pos > 0) {
                col.setCatalog(tableName);
            }
        }
        switch (columnType) {
            case 60: 
            case 110: 
            case 112: 
            case 122: {
                col.setScale(4);
                break;
            }
            case 61: {
                col.setScale(3);
                break;
            }
            case 111: {
                if (bufLength == 8) {
                    col.setScale(3);
                    break;
                }
                col.setScale(0);
                break;
            }
            default: {
                col.setScale(scale < 0 ? 0 : scale);
            }
        }
        switch (columnType) {
            case 34: 
            case 37: 
            case 45: {
                precision = bufLength;
                dispSize = 2 * precision;
                break;
            }
            case 35: 
            case 39: 
            case 47: {
                dispSize = precision = bufLength;
                break;
            }
            case -17: 
            case 99: 
            case 103: {
                dispSize = precision = bufLength >> 1;
                break;
            }
            case 50: {
                precision = 1;
                dispSize = 1;
                break;
            }
            case 36: {
                precision = 36;
                dispSize = 36;
                break;
            }
            case 61: {
                precision = 23;
                dispSize = 23;
                break;
            }
            case 58: {
                precision = 16;
                dispSize = 3 + 16;
                break;
            }
            case 111: {
                if (bufLength == 8) {
                    precision = 23;
                    dispSize = 23;
                    break;
                }
                precision = 16;
                dispSize = 3 + 16;
                break;
            }
            case 106: 
            case 108: {
                dispSize = (bufLength == scale ? 3 : 2) + precision;
                break;
            }
            case 62: {
                precision = 15;
                dispSize = 9 + 15;
                break;
            }
            case 59: {
                precision = 7;
                dispSize = 7 + 7;
                break;
            }
            case 109: {
                if (bufLength == 8) {
                    precision = 15;
                    dispSize = 9 + 15;
                    break;
                }
                precision = 7;
                dispSize = 7 + 7;
                break;
            }
            case 56: {
                precision = 10;
                dispSize = 1 + 10;
                break;
            }
            case 52: {
                precision = 5;
                dispSize = 1 + 5;
                break;
            }
            case 48: {
                precision = 2;
                dispSize = 1 + 2;
                break;
            }
            case 38: {
                if (bufLength == 4) {
                    precision = 10;
                    dispSize = 1 + 10;
                    break;
                }
                if (bufLength == 2) {
                    precision = 5;
                    dispSize = 1 + 5;
                    break;
                }
                precision = 2;
                dispSize = 1 + 2;
                break;
            }
            case 60: {
                precision = 19;
                dispSize = 2 + 19;
                break;
            }
            case 112: 
            case 122: {
                precision = 10;
                dispSize = 2 + 10;
                break;
            }
            case 110: {
                if (bufLength == 8) {
                    precision = 19;
                    dispSize = 2 + 19;
                    break;
                }
                precision = 10;
                dispSize = 2 + 10;
            }
        }
        col.setDisplaySize(dispSize);
        col.setPrecision(precision);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitForDataOrTimeout(SQLWarningChain wChain, int timeout) throws IOException, TdsException {
        if (timeout == 0 || wChain == null) {
            this.comm.peek();
            return;
        }
        this.sock.setSoTimeout(timeout * 1000);
        try {
            try {
                this.comm.peek();
            }
            catch (InterruptedIOException e) {
                wChain.addException(new SQLException("Query has timed out."));
                this.cancel();
                Object var5_4 = null;
                this.sock.setSoTimeout(0);
                return;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.sock.setSoTimeout(0);
            throw throwable;
        }
        this.sock.setSoTimeout(0);
    }

    public static byte cvtJdbcTypeToNativeType(int jdbcType) throws TdsNotImplemented {
        switch (jdbcType) {
            case -1: 
            case 1: 
            case 12: {
                return 47;
            }
            case -6: {
                return 48;
            }
            case 5: {
                return 52;
            }
            case 4: {
                return 56;
            }
            case -7: {
                return 50;
            }
            case 6: 
            case 7: 
            case 8: {
                return 62;
            }
            case 91: 
            case 92: 
            case 93: {
                return 111;
            }
            case -2: {
                return 45;
            }
            case -3: {
                return 37;
            }
            case -4: {
                return 34;
            }
            case -5: {
                return 106;
            }
            case 2: {
                return 108;
            }
            case 3: {
                return 106;
            }
        }
        throw new TdsNotImplemented("cvtJdbcTypeToNativeType (" + TdsUtil.javaSqlTypeToString(jdbcType) + ")");
    }

    public static int cvtNativeTypeToJdbcType(int nativeType, int size) throws TdsException {
        switch (nativeType) {
            case 45: {
                return -2;
            }
            case 50: {
                return -7;
            }
            case 104: {
                return -7;
            }
            case 47: {
                return 1;
            }
            case -17: {
                return 1;
            }
            case 58: {
                return 93;
            }
            case 61: {
                return 93;
            }
            case 111: {
                return 93;
            }
            case 106: {
                return 3;
            }
            case 108: {
                return 2;
            }
            case 62: {
                return 6;
            }
            case 109: {
                switch (size) {
                    case 4: {
                        return 7;
                    }
                    case 8: {
                        return 6;
                    }
                }
                throw new TdsException("Bad size of SYBFLTN");
            }
            case 48: {
                return -6;
            }
            case 52: {
                return 5;
            }
            case 56: {
                return 4;
            }
            case 38: {
                switch (size) {
                    case 1: {
                        return -6;
                    }
                    case 2: {
                        return 5;
                    }
                    case 4: {
                        return 4;
                    }
                }
                throw new TdsException("Bad size of SYBINTN");
            }
            case 122: {
                return 3;
            }
            case 112: {
                return 3;
            }
            case 60: {
                return 3;
            }
            case 110: {
                return 3;
            }
            case 59: {
                return 7;
            }
            case 35: {
                return -1;
            }
            case 99: {
                return -1;
            }
            case 34: {
                return -3;
            }
            case 37: {
                return -3;
            }
            case 39: {
                return 12;
            }
            case 103: {
                return 12;
            }
            case 36: {
                return 12;
            }
        }
        throw new TdsException("Unknown native data type " + Integer.toHexString(nativeType & 0xFF));
    }

    private static boolean isBlobType(int type) {
        return type == 35 || type == 34 || type == 99;
    }

    private static boolean isLargeType(int type) {
        return type == -17 || type > 128;
    }

    private static String tds7CryptPass(String pw) {
        int xormask = 23130;
        int len = pw.length();
        char[] chars = new char[len];
        int i = 0;
        while (i < len) {
            int c = pw.charAt(i) ^ 0x5A5A;
            int m1 = c >> 4 & 0xF0F;
            int m2 = c << 4 & 0xF0F0;
            chars[i] = (char)(m1 | m2);
            ++i;
        }
        return new String(chars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void commit() throws SQLException {
        this.skipToEnd();
        this.submitProcedure("IF @@TRANCOUNT>0 COMMIT TRAN", new SQLWarningChain());
        HashMap hashMap = this.procedureCache;
        synchronized (hashMap) {
            this.proceduresOfTra.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void rollback() throws SQLException {
        this.skipToEnd();
        SQLException exception = null;
        try {
            this.submitProcedure("IF @@TRANCOUNT>0 ROLLBACK TRAN", new SQLWarningChain());
        }
        catch (SQLException e) {
            exception = e;
        }
        HashMap hashMap = this.procedureCache;
        synchronized (hashMap) {
            Iterator it = this.proceduresOfTra.iterator();
            while (it.hasNext()) {
                Procedure p = (Procedure)it.next();
                this.procedureCache.remove(p.getSignature());
            }
            this.proceduresOfTra.clear();
        }
        if (exception != null) {
            throw exception;
        }
    }

    synchronized void skipToEnd() throws SQLException {
        try {
            while (this.moreResults) {
                this.processSubPacket();
            }
        }
        catch (Exception ex) {
            if (ex instanceof SQLException) {
                throw (SQLException)ex;
            }
            throw new SQLException("Error occured while consuming output: " + ex);
        }
    }

    private String sqlStatementToInitialize() throws SQLException {
        StringBuffer statement = new StringBuffer(150);
        statement.append("SET QUOTED_IDENTIFIER ON ");
        if (this.serverType == 2) {
            statement.append("SET TEXTSIZE 50000 ");
        } else {
            statement.append("SET TEXTSIZE 2147483647 ");
        }
        this.sqlStatementToSetTransactionIsolationLevel(statement);
        statement.append(' ');
        this.sqlStatementToSetCommit(statement);
        return statement.toString();
    }

    private void sqlStatementToSetTransactionIsolationLevel(StringBuffer sql) throws SQLException {
        sql.append("SET TRANSACTION ISOLATION LEVEL ");
        switch (this.transactionIsolationLevel) {
            case 1: {
                sql.append("READ UNCOMMITTED");
                break;
            }
            case 2: {
                sql.append("READ COMMITTED");
                break;
            }
            case 4: {
                sql.append("REPEATABLE READ");
                break;
            }
            case 8: {
                sql.append("SERIALIZABLE");
                break;
            }
            default: {
                throw new SQLException("Bad transaction level");
            }
        }
    }

    private void sqlStatementToSetCommit(StringBuffer sql) {
        if (this.serverType == 2) {
            if (this.autoCommit) {
                sql.append("SET CHAINED OFF");
            } else {
                sql.append("SET CHAINED ON");
            }
        } else if (this.autoCommit) {
            sql.append("SET IMPLICIT_TRANSACTIONS OFF");
        } else {
            sql.append("SET IMPLICIT_TRANSACTIONS ON");
        }
    }

    private String sqlStatementForSettings(boolean autoCommit, int transactionIsolationLevel) throws SQLException {
        StringBuffer res = new StringBuffer(64);
        res.append("IF @@TRANCOUNT>0 COMMIT TRAN ");
        if (autoCommit != this.autoCommit) {
            this.autoCommit = autoCommit;
            this.sqlStatementToSetCommit(res);
            res.append(' ');
        }
        if (transactionIsolationLevel != this.transactionIsolationLevel) {
            this.transactionIsolationLevel = transactionIsolationLevel;
            this.sqlStatementToSetTransactionIsolationLevel(res);
            res.append(' ');
        }
        res.setLength(res.length() - 1);
        return res.toString();
    }

    protected synchronized void changeSettings(boolean autoCommit, int transactionIsolationLevel) throws SQLException {
        String query = this.sqlStatementForSettings(autoCommit, transactionIsolationLevel);
        if (query != null) {
            try {
                this.skipToEnd();
                this.changeSettings(query);
            }
            catch (SQLException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new SQLException(ex.toString());
            }
        }
    }

    private void changeSettings(String query) throws SQLException {
        if (query.length() == 0) {
            return;
        }
        SQLWarningChain wChain = new SQLWarningChain();
        this.submitProcedure(query, wChain);
        wChain.checkForExceptions();
    }

    private PacketResult processNtlmChallenge() throws TdsException, IOException {
        int packetLength = this.getSubPacketLength();
        int headerLength = 40;
        if (packetLength < 40) {
            throw new TdsException("NTLM challenge: packet is too small:" + packetLength);
        }
        this.comm.skip(8);
        int seq = this.comm.getTdsInt();
        if (seq != 2) {
            throw new TdsException("NTLM challenge: got unexpected sequence number:" + seq);
        }
        this.comm.skip(4);
        this.comm.skip(4);
        this.comm.skip(4);
        byte[] nonce = this.comm.getBytes(8, true);
        this.comm.skip(8);
        this.comm.skip(packetLength - 40);
        return new PacketAuthTokenResult(nonce);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendNtlmChallengeResponse(PacketAuthTokenResult authToken) throws TdsException, IOException {
        try {
            this.comm.startPacket(17);
            byte[] header = new byte[]{78, 84, 76, 77, 83, 83, 80, 0};
            this.comm.appendBytes(header);
            this.comm.appendTdsInt(3);
            int domainLenInBytes = this.domain.length() * 2;
            int userLenInBytes = this.user.length() * 2;
            boolean hostLenInBytes = false;
            int pos = 64 + domainLenInBytes + userLenInBytes + 0;
            this.comm.appendTdsShort((short)24);
            this.comm.appendTdsShort((short)24);
            this.comm.appendTdsInt(pos);
            this.comm.appendTdsShort((short)24);
            this.comm.appendTdsShort((short)24);
            this.comm.appendTdsInt(pos += 24);
            pos = 64;
            this.comm.appendTdsShort((short)domainLenInBytes);
            this.comm.appendTdsShort((short)domainLenInBytes);
            this.comm.appendTdsInt(pos);
            this.comm.appendTdsShort((short)userLenInBytes);
            this.comm.appendTdsShort((short)userLenInBytes);
            this.comm.appendTdsInt(pos += domainLenInBytes);
            this.comm.appendTdsShort((short)0);
            this.comm.appendTdsShort((short)0);
            this.comm.appendTdsInt(pos += userLenInBytes);
            this.comm.appendTdsShort((short)0);
            this.comm.appendTdsShort((short)0);
            this.comm.appendTdsInt(pos += 0);
            this.comm.appendTdsInt(33281);
            this.comm.appendChars(this.domain);
            this.comm.appendChars(this.user);
            byte[] lmAnswer = NtlmAuth.answerLmChallenge(this.password, authToken.getNonce());
            byte[] ntAnswer = NtlmAuth.answerNtChallenge(this.password, authToken.getNonce());
            this.comm.appendBytes(lmAnswer);
            this.comm.appendBytes(ntAnswer);
            this.comm.sendPacket();
            Object var10_9 = null;
            this.comm.packetType = 0;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.comm.packetType = 0;
            throw throwable;
        }
    }

    public Context getContext() {
        return this.currentContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Procedure findCompatibleStoredProcedure(String signature) {
        HashMap hashMap = this.procedureCache;
        synchronized (hashMap) {
            return (Procedure)this.procedureCache.get(signature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStoredProcedure(Procedure procedure) throws SQLException {
        HashMap hashMap = this.procedureCache;
        synchronized (hashMap) {
            this.procedureCache.put(procedure.getSignature(), procedure);
            if (!this.connection.getAutoCommit()) {
                this.proceduresOfTra.add(procedure);
            }
        }
    }

    public boolean useUnicode() {
        return this.useUnicode;
    }

    public boolean lastUpdateCount() {
        return this.lastUpdateCount;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void startResultSet(SQLWarningChain wChain, TdsStatement stmt) {
        try {
            while (!this.isResultRow()) {
                if (this.isEndOfResults()) {
                    return;
                }
                PacketResult res = this.processSubPacket();
                if (res instanceof PacketMsgResult) {
                    wChain.addOrReturn((PacketMsgResult)res);
                    continue;
                }
                if (res instanceof PacketOutputParamResult) {
                    stmt.handleParamResult((PacketOutputParamResult)res);
                    continue;
                }
                if (res instanceof PacketRetStatResult) {
                    stmt.handleRetStat((PacketRetStatResult)res);
                    continue;
                }
                if (!(res instanceof PacketEndTokenResult) || !((PacketEndTokenResult)res).wasCanceled()) continue;
                wChain.addException(new SQLException("Query was cancelled or timed out."));
            }
            return;
        }
        catch (IOException e) {
            wChain.addException(new SQLException("Network problem. " + e.getMessage()));
            return;
        }
        catch (TdsUnknownPacketSubType e) {
            wChain.addException(new SQLException("Unknown response. " + e.getMessage()));
            return;
        }
        catch (TdsException e) {
            wChain.addException(new SQLException(e.toString()));
            return;
        }
        catch (SQLException e) {
            wChain.addException(e);
            return;
        }
    }

    synchronized PacketRowResult fetchRow(TdsStatement stmt, SQLWarningChain wChain, Context context) {
        try {
            block14: while (true) {
                PacketResult res = this.processSubPacket(context);
                switch (res.getPacketType()) {
                    case -47: {
                        return (PacketRowResult)res;
                    }
                    case -127: 
                    case -96: {
                        wChain.addException(new SQLException("Unexpected packet type."));
                        continue block14;
                    }
                    case -3: 
                    case -2: 
                    case -1: {
                        if (((PacketEndTokenResult)res).wasCanceled()) {
                            wChain.addException(new SQLException("Query was cancelled or timed out."));
                        }
                        this.goToNextResult(wChain, stmt);
                        return null;
                    }
                    case 124: {
                        continue block14;
                    }
                    case 121: {
                        stmt.handleRetStat((PacketRetStatResult)res);
                        continue block14;
                    }
                    case -84: {
                        stmt.handleParamResult((PacketOutputParamResult)res);
                        continue block14;
                    }
                    case -86: 
                    case -85: {
                        wChain.addOrReturn((PacketMsgResult)res);
                        continue block14;
                    }
                }
                wChain.addException(new SQLException("Protocol confusion. Got a 0x" + Integer.toHexString(res.getPacketType() & 0xFF) + " packet"));
            }
        }
        catch (IOException e) {
            wChain.addException(new SQLException("Network problem. " + e.getMessage()));
        }
        catch (TdsUnknownPacketSubType e) {
            wChain.addException(new SQLException("Unknown response. " + e.getMessage()));
        }
        catch (TdsException e) {
            wChain.addException(new SQLException(e.toString()));
        }
        catch (SQLException e) {
            wChain.addException(e);
        }
        return null;
    }
}

