/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import net.sourceforge.jtds.jdbc.CallableStatement_base;
import net.sourceforge.jtds.jdbc.CursorResultSet;
import net.sourceforge.jtds.jdbc.EscapeProcessor;
import net.sourceforge.jtds.jdbc.ParameterListItem;
import net.sourceforge.jtds.jdbc.ParameterUtils;
import net.sourceforge.jtds.jdbc.PreparedStatementHelper;
import net.sourceforge.jtds.jdbc.Procedure;
import net.sourceforge.jtds.jdbc.Tds;
import net.sourceforge.jtds.jdbc.TdsConnection;
import net.sourceforge.jtds.jdbc.TdsException;
import net.sourceforge.jtds.jdbc.TdsResultSet;
import net.sourceforge.jtds.jdbc.TdsStatement;

public class PreparedStatement_base
extends TdsStatement
implements PreparedStatementHelper,
PreparedStatement {
    public static final String cvsVersion = "$Id: PreparedStatement_base.java,v 1.24 2004/02/25 01:24:47 alin_sinpalean Exp $";
    static Map typemap = null;
    String rawQueryString;
    ParameterListItem[] parameterList;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$sql$Timestamp;

    public PreparedStatement_base(TdsConnection conn_, String sql) throws SQLException {
        this(conn_, sql, 1003, 1007);
    }

    public PreparedStatement_base(TdsConnection conn_, String sql, int type, int concurrency) throws SQLException {
        this(conn_, type, concurrency);
        StringBuffer result = new StringBuffer(sql.length());
        int numberOfParameters = EscapeProcessor.parameterNativeSQL(sql, result);
        this.rawQueryString = result.toString();
        this.parameterList = new ParameterListItem[numberOfParameters];
        int i = 0;
        while (i < numberOfParameters) {
            this.parameterList[i] = new ParameterListItem();
            ++i;
        }
    }

    public PreparedStatement_base(TdsConnection conn_, int type, int concurrency) throws SQLException {
        super(conn_, type, concurrency);
    }

    public void clearParameters() throws SQLException {
        int i = 0;
        while (i < this.parameterList.length) {
            this.parameterList[i].clear();
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws SQLException {
        boolean bl;
        Tds tds = this.getTds();
        try {
            bl = this.execute(tds);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.releaseTds();
            throw throwable;
        }
        this.releaseTds();
        return bl;
    }

    public boolean execute(Tds tds) throws SQLException {
        this.closeResults(false);
        Procedure procedure = this.findOrCreateProcedure(tds);
        return this.internalExecuteCall(procedure.getProcedureName(), procedure.getParameterList(), this.parameterList, tds, this.warningChain);
    }

    private Procedure findOrCreateProcedure(Tds tds) throws SQLException {
        Procedure procedure = null;
        ParameterUtils.createParameterMapping(this.rawQueryString, this.parameterList, tds, true);
        StringBuffer signature = new StringBuffer();
        signature.append(this.rawQueryString);
        int i = 0;
        while (i < this.parameterList.length) {
            signature.append(this.parameterList[i].formalType);
            ++i;
        }
        procedure = this.findCompatibleStoredProcedure(tds, signature.toString());
        if (procedure == null) {
            procedure = new Procedure(this.rawQueryString, signature.toString(), this.parameterList, tds);
            this.submitProcedure(tds, procedure);
            tds.addStoredProcedure(procedure);
        }
        return procedure;
    }

    private Procedure findCompatibleStoredProcedure(Tds tds, String rawQueryString) {
        return tds.findCompatibleStoredProcedure(rawQueryString);
    }

    private void submitProcedure(Tds tds, Procedure proc) throws SQLException {
        tds.submitProcedure(proc.getPreparedSqlString(), this.warningChain);
        this.warningChain.checkForExceptions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeQuery() throws SQLException {
        TdsResultSet tdsResultSet;
        block20: {
            this.warningChain.clearWarnings();
            SQLWarning warn = null;
            if (this.getResultSetType() != 1003 || this.getResultSetConcurrency() != 1007) {
                TdsConnection conn = (TdsConnection)this.getConnection();
                String procedureName = null;
                Object object = conn.mainTdsMonitor;
                synchronized (object) {
                    Tds tds = conn.allocateTds(true);
                    try {
                        if (this instanceof CallableStatement) {
                            procedureName = ((CallableStatement_base)this).getProcedureName();
                            ParameterUtils.createParameterMapping(null, this.parameterList, tds, false);
                        } else {
                            procedureName = this.findOrCreateProcedure(tds).getProcedureName();
                        }
                    }
                    finally {
                        try {
                            conn.freeTds(tds);
                        }
                        catch (TdsException ex) {
                            this.warningChain.addException(new SQLException(ex.getMessage()));
                        }
                    }
                }
                this.warningChain.checkForExceptions();
                try {
                    CursorResultSet rs = new CursorResultSet(this, procedureName, this.getFetchDirection(), this.parameterList);
                    this.cursorResults.add(rs);
                    return rs;
                }
                catch (SQLException ex) {
                    warn = new SQLWarning(ex.getMessage(), ex.getSQLState(), ex.getErrorCode());
                }
            }
            Tds tds = this.getTds();
            try {
                if (!this.execute(tds)) {
                    tds.skipToEnd();
                    throw new SQLException("Was expecting a result set");
                }
                tdsResultSet = this.results;
                Object var11_11 = null;
                if (warn == null) break block20;
                this.warningChain.addWarning(warn);
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                if (warn != null) {
                    this.warningChain.addWarning(warn);
                }
                this.releaseTds();
                throw throwable;
            }
        }
        this.releaseTds();
        return tdsResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int executeUpdate() throws SQLException {
        int n;
        Tds tds = this.getTds();
        try {
            int res;
            if (this.execute(tds)) {
                tds.skipToEnd();
                throw new SQLException("executeUpdate can't return a result set");
            }
            do {
                if ((res = this.getUpdateCount()) != -1 && ((TdsConnection)this.getConnection()).returnLastUpdateCount()) continue;
            } while (!this.getMoreResults());
            this.skipToEnd();
            throw new SQLException("executeUpdate can't return a result set");
            n = res == -1 ? 0 : res;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.releaseTds();
            throw throwable;
        }
        this.releaseTds();
        return n;
    }

    public void setAsciiStream(int parameterIndex, InputStream inputStream, int length) throws SQLException {
        if (inputStream == null) {
            this.setCharacterStream(parameterIndex, (Reader)null, 0);
        } else {
            try {
                this.setCharacterStream(parameterIndex, (Reader)new InputStreamReader(inputStream, "ASCII"), length);
            }
            catch (UnsupportedEncodingException e) {
                throw new SQLException("Unexpected encoding exception: " + e.getMessage());
            }
        }
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.setParam(parameterIndex, x, 3, -1);
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        int actlen;
        if (length == 0) {
            this.setBytes(parameterIndex, null);
        }
        byte[] bs = new byte[length];
        try {
            actlen = x.read(bs);
        }
        catch (IOException e) {
            SQLException newE = new SQLException("setBinaryStream: IO-Exception occured reading Stream" + e.toString());
            throw newE;
        }
        if (actlen != length) {
            throw new SQLException("SetBinaryStream parameterized Length: " + Integer.toString(length) + " got length: " + Integer.toString(actlen));
        }
        try {
            actlen = x.read(bs);
        }
        catch (IOException e) {
            SQLException newE = new SQLException("setBinaryStream: IO-Exception occured reading Stream" + e.toString());
            throw newE;
        }
        if (actlen != -1) {
            throw new SQLException("SetBinaryStream parameterized Length: " + Integer.toString(length) + " got more than that ");
        }
        this.setBytes(parameterIndex, bs);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.setParam(parameterIndex, new Boolean(x), -7, -1);
    }

    public void setByte(int index, byte x) throws SQLException {
        this.setParam(index, new Integer(x), -6, -1);
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        if (x == null || x.length <= 255 || x.length <= 8000 && ((TdsConnection)this.getConnection()).getTdsVer() == 70) {
            this.setParam(parameterIndex, x, -3, -1);
        } else {
            this.setParam(parameterIndex, x, -4, -1);
        }
    }

    public void setDate(int parameterIndex, Date value) throws SQLException {
        this.setParam(parameterIndex, value, 91, -1);
    }

    public void setDouble(int parameterIndex, double value) throws SQLException {
        this.setParam(parameterIndex, new Double(value), 8, -1);
    }

    public void setFloat(int parameterIndex, float value) throws SQLException {
        this.setParam(parameterIndex, new Float(value), 7, -1);
    }

    public void setInt(int index, int value) throws SQLException {
        this.setParam(index, new Integer(value), 4, -1);
    }

    public void setLong(int parameterIndex, long value) throws SQLException {
        this.setParam(parameterIndex, new Long(value), -5, -1);
    }

    public void setNull(int index, int type) throws SQLException {
        this.setParam(index, null, type, -1);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 12);
        } else if (x instanceof String) {
            this.setString(parameterIndex, (String)x);
        } else if (x instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)x);
        } else if (x instanceof Integer) {
            this.setInt(parameterIndex, ((Number)x).intValue());
        } else if (x instanceof Long) {
            this.setLong(parameterIndex, ((Number)x).longValue());
        } else if (x instanceof Byte) {
            this.setByte(parameterIndex, ((Number)x).byteValue());
        } else if (x instanceof Short) {
            this.setShort(parameterIndex, ((Number)x).shortValue());
        } else if (x instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)x);
        } else if (x instanceof Double) {
            this.setDouble(parameterIndex, ((Number)x).doubleValue());
        } else if (x instanceof Float) {
            this.setFloat(parameterIndex, ((Number)x).floatValue());
        } else if (x instanceof Date) {
            this.setDate(parameterIndex, (Date)x);
        } else if (x instanceof Time) {
            this.setTime(parameterIndex, (Time)x);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
        } else {
            Class<?> c = x.getClass();
            if (c.isArray() && c.getComponentType().equals(Byte.TYPE)) {
                this.setBytes(parameterIndex, (byte[])x);
            } else {
                throw new SQLException("Not implemented");
            }
        }
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x, targetSqlType, 0);
    }

    protected void setParam(int index, Object value, int type, int scale) throws SQLException {
        if (index < 1) {
            throw new SQLException("Invalid Parameter index " + index + ".  JDBC indexes start at 1.");
        }
        if (index > this.parameterList.length) {
            throw new SQLException("Invalid Parameter index " + index + ".  This statement only has " + this.parameterList.length + " parameters");
        }
        this.parameterList[--index].type = type;
        this.parameterList[index].isSet = true;
        this.parameterList[index].value = value;
        this.parameterList[index].scale = scale;
    }

    protected static Map getTypemap() {
        if (typemap != null) {
            return typemap;
        }
        HashMap<Class, Integer> map = new HashMap<Class, Integer>(15);
        map.put(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = PreparedStatement_base.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new Integer(2));
        map.put(class$java$lang$Boolean == null ? (class$java$lang$Boolean = PreparedStatement_base.class$("java.lang.Boolean")) : class$java$lang$Boolean, new Integer(-7));
        map.put(class$java$lang$Byte == null ? (class$java$lang$Byte = PreparedStatement_base.class$("java.lang.Byte")) : class$java$lang$Byte, new Integer(-6));
        map.put(array$B == null ? (array$B = PreparedStatement_base.class$("[B")) : array$B, new Integer(-3));
        map.put(class$java$sql$Date == null ? (class$java$sql$Date = PreparedStatement_base.class$("java.sql.Date")) : class$java$sql$Date, new Integer(91));
        map.put(class$java$lang$Double == null ? (class$java$lang$Double = PreparedStatement_base.class$("java.lang.Double")) : class$java$lang$Double, new Integer(8));
        map.put(Float.TYPE, new Integer(7));
        map.put(class$java$lang$Integer == null ? (class$java$lang$Integer = PreparedStatement_base.class$("java.lang.Integer")) : class$java$lang$Integer, new Integer(4));
        map.put(class$java$lang$Long == null ? (class$java$lang$Long = PreparedStatement_base.class$("java.lang.Long")) : class$java$lang$Long, new Integer(-5));
        map.put(class$java$lang$Short == null ? (class$java$lang$Short = PreparedStatement_base.class$("java.lang.Short")) : class$java$lang$Short, new Integer(5));
        map.put(class$java$lang$String == null ? (class$java$lang$String = PreparedStatement_base.class$("java.lang.String")) : class$java$lang$String, new Integer(12));
        map.put(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = PreparedStatement_base.class$("java.sql.Timestamp")) : class$java$sql$Timestamp, new Integer(93));
        typemap = map;
        return typemap;
    }

    protected static int getType(Object o) throws SQLException {
        if (o == null) {
            throw new SQLException("You must specify a type for a null parameter");
        }
        Map map = PreparedStatement_base.getTypemap();
        Object ot = map.get(o.getClass());
        if (ot == null) {
            throw new SQLException("Support for this type is not implemented");
        }
        return (Integer)ot;
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        if (x == null) {
            this.setParam(parameterIndex, x, targetSqlType, scale);
            return;
        }
        switch (targetSqlType) {
            case 1: 
            case 12: {
                this.setString(parameterIndex, (String)x);
                break;
            }
            case 7: {
                this.setFloat(parameterIndex, ((Number)x).floatValue());
                break;
            }
            case 8: {
                this.setDouble(parameterIndex, ((Number)x).doubleValue());
                break;
            }
            case 4: {
                this.setInt(parameterIndex, ((Number)x).intValue());
                break;
            }
            case -5: {
                this.setLong(parameterIndex, ((Number)x).longValue());
                break;
            }
            default: {
                this.setParam(parameterIndex, x, targetSqlType, scale);
            }
        }
    }

    public void setShort(int index, short value) throws SQLException {
        this.setParam(index, new Integer(value), 5, -1);
    }

    public void setString(int index, String str) throws SQLException {
        this.setParam(index, str, 12, -1);
    }

    public void setTime(int parameterIndex, Time value) throws SQLException {
        this.setParam(parameterIndex, value, 92, -1);
    }

    public void setTimestamp(int index, Timestamp value) throws SQLException {
        this.setParam(index, value, 93, -1);
    }

    public void setUnicodeStream(int parameterIndex, InputStream inputStream, int length) throws SQLException {
        if (inputStream == null) {
            this.setCharacterStream(parameterIndex, (Reader)null, 0);
        } else {
            try {
                this.setCharacterStream(parameterIndex, (Reader)new InputStreamReader(inputStream, "UTF-8"), length);
            }
            catch (UnsupportedEncodingException e) {
                throw new SQLException("Unexpected encoding exception: " + e.getMessage());
            }
        }
    }

    public synchronized void addBatch() throws SQLException {
        if (this.batchValues == null) {
            this.batchValues = new ArrayList();
        }
        this.batchValues.add(this.parameterList);
        this.parameterList = new ParameterListItem[this.parameterList.length];
        int i = 0;
        while (i < this.parameterList.length) {
            this.parameterList[i] = new ParameterListItem();
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int executeBatchOther(Object value) throws SQLException {
        if (value instanceof ParameterListItem[]) {
            ParameterListItem[] tmpParameterListItem = this.parameterList;
            try {
                this.parameterList = (ParameterListItem[])value;
                int n = this.executeUpdate();
                Object var5_4 = null;
                this.parameterList = tmpParameterListItem;
                return n;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.parameterList = tmpParameterListItem;
                throw throwable;
            }
        }
        super.executeBatchOther(value);
        return Integer.MIN_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        if (reader == null || length < 0) {
            this.setString(parameterIndex, null);
        }
        StringBuffer value = new StringBuffer(length);
        char[] buffer = new char[1024];
        try {
            int bytes;
            while ((bytes = reader.read(buffer, 0, buffer.length)) != -1) {
                void var6_6;
                value.append(buffer, 0, (int)var6_6);
            }
        }
        catch (IOException e) {
            throw new SQLException("Error reading stream: " + e.getMessage());
        }
        this.setParam(parameterIndex, value, -1, -1);
    }

    public void setRef(int i, Ref x) throws SQLException {
        this.NotImplemented();
    }

    public void setBlob(int parameterIndex, Blob blob) throws SQLException {
        if (blob == null) {
            this.setBinaryStream(parameterIndex, (InputStream)null, 0);
        } else {
            long length = blob.length();
            if (length > Integer.MAX_VALUE) {
                throw new SQLException("Blob lengths greater than 2147483647 are not suported.");
            }
            this.setBinaryStream(parameterIndex, blob.getBinaryStream(), (int)length);
        }
    }

    public void setClob(int parameterIndex, Clob clob) throws SQLException {
        if (clob == null) {
            this.setCharacterStream(parameterIndex, (Reader)null, 0);
        } else {
            long length = clob.length();
            if (length > Integer.MAX_VALUE) {
                throw new SQLException("Clob lengths greater than 2147483647 are not suported.");
            }
            this.setCharacterStream(parameterIndex, clob.getCharacterStream(), (int)length);
        }
    }

    public void setArray(int i, Array x) throws SQLException {
        this.NotImplemented();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.NotImplemented();
        return null;
    }

    public void setDate(int parameterIndex, Date date, Calendar calendar) throws SQLException {
        if (date != null && calendar != null) {
            TimeZone timeZone = TimeZone.getDefault();
            long newTime = date.getTime();
            newTime -= (long)timeZone.getRawOffset();
            date = new Date(newTime += (long)calendar.getTimeZone().getRawOffset());
        }
        this.setDate(parameterIndex, date);
    }

    public void setTime(int parameterIndex, Time time, Calendar calendar) throws SQLException {
        if (time != null && calendar != null) {
            TimeZone timeZone = TimeZone.getDefault();
            long newTime = time.getTime();
            newTime -= (long)timeZone.getRawOffset();
            time = new Time(newTime += (long)calendar.getTimeZone().getRawOffset());
        }
        this.setTime(parameterIndex, time);
    }

    public void setTimestamp(int parameterIndex, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (timestamp != null && calendar != null) {
            TimeZone timeZone = TimeZone.getDefault();
            long newTime = timestamp.getTime();
            newTime -= (long)timeZone.getRawOffset();
            timestamp = new Timestamp(newTime += (long)calendar.getTimeZone().getRawOffset());
        }
        this.setTimestamp(parameterIndex, timestamp);
    }

    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.NotImplemented();
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.NotImplemented();
        return null;
    }

    public void setURL(int param, URL url) throws SQLException {
        this.NotImplemented();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

