/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.sql.SQLException;
import net.sourceforge.jtds.jdbc.TdsException;

public class MSSqlServerInfo {
    private int m_numRetries = 3;
    private int m_timeout = 2000;
    private String[] m_serverInfoStrings = null;

    public MSSqlServerInfo(String host) throws SQLException {
        try {
            InetAddress addr = InetAddress.getByName(host);
            DatagramSocket socket = new DatagramSocket();
            byte[] msg = new byte[]{2};
            DatagramPacket p = new DatagramPacket(msg, msg.length, addr, 1434);
            socket.send(p);
            byte[] buf = new byte[4096];
            p = new DatagramPacket(buf, buf.length);
            socket.setSoTimeout(this.m_timeout);
            int i = 0;
            while (i < this.m_numRetries) {
                try {
                    socket.receive(p);
                    String infoString = MSSqlServerInfo.extractString(buf, p.getLength());
                    this.m_serverInfoStrings = MSSqlServerInfo.split(infoString, 59);
                    return;
                }
                catch (InterruptedIOException toEx) {
                    ++i;
                }
            }
        }
        catch (Exception e) {
            SQLException sqlEx = new SQLException("Unable to get info from SQL Server:" + host);
            throw sqlEx;
        }
        throw new SQLException("Unable to get info from SQL Server:" + host);
    }

    public int getPortForInstance(String instanceName) throws TdsException {
        if (this.m_serverInfoStrings == null) {
            return -1;
        }
        if (instanceName == null || instanceName.length() == 0) {
            instanceName = "MSSQLSERVER";
        }
        String curInstance = null;
        String curPort = null;
        int index = 0;
        while (index < this.m_serverInfoStrings.length) {
            if (this.m_serverInfoStrings[index].length() == 0) {
                curInstance = null;
                curPort = null;
            } else {
                String key = this.m_serverInfoStrings[index];
                String value = "";
                if (++index < this.m_serverInfoStrings.length) {
                    value = this.m_serverInfoStrings[index];
                }
                if (key.equals("InstanceName")) {
                    curInstance = value;
                }
                if (key.equals("tcp")) {
                    curPort = value;
                }
                if (curInstance != null && curPort != null && curInstance.equalsIgnoreCase(instanceName)) {
                    try {
                        return Integer.parseInt(curPort);
                    }
                    catch (NumberFormatException ex) {
                        throw new TdsException("Could not parse instance port number [" + instanceName + "].");
                    }
                }
            }
            ++index;
        }
        return -1;
    }

    private static final String extractString(byte[] buf, int len) {
        int headerLength = 3;
        return new String(buf, 3, len - 3);
    }

    public static String[] split(String s, int ch) {
        int size = 0;
        int pos = 0;
        while (pos != -1) {
            pos = s.indexOf(ch, pos + 1);
            ++size;
        }
        String[] res = new String[size];
        int i = 0;
        int p1 = 0;
        int p2 = s.indexOf(ch);
        do {
            res[i++] = s.substring(p1, p2 == -1 ? s.length() : p2);
            p1 = p2 + 1;
            p2 = s.indexOf(ch, p1);
        } while (p1 != 0);
        return res;
    }
}

