/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.sql.SQLException;
import java.util.Vector;
import net.sourceforge.jtds.jdbc.Column;
import net.sourceforge.jtds.jdbc.Tds;
import net.sourceforge.jtds.jdbc.TdsException;

public class Columns {
    public static final String cvsVersion = "$Id: Columns.java,v 1.1 2002/10/14 10:48:59 alin_sinpalean Exp $";
    private Vector columns = null;
    private int columnCount = 0;
    private int fakeColCount = 0;

    public Columns() {
        this(10);
    }

    public Columns(int size) {
        this.columns = new Vector(size);
    }

    public void setCatalog(int columnNumber, String value) {
        this.resize(columnNumber);
        ((Column)this.columns.elementAt(columnNumber - 1)).setCatalog(value);
    }

    public void setSchema(int columnNumber, String value) {
        this.resize(columnNumber);
        ((Column)this.columns.elementAt(columnNumber - 1)).setSchema(value);
    }

    public void setName(int columnNumber, String value) {
        this.resize(columnNumber);
        ((Column)this.columns.elementAt(columnNumber - 1)).setName(value);
    }

    public void setDisplaySize(int columnNumber, int value) {
        this.resize(columnNumber);
        ((Column)this.columns.elementAt(columnNumber - 1)).setDisplaySize(value);
    }

    public void setBufferSize(int columnNumber, int value) {
        this.resize(columnNumber);
        ((Column)this.columns.elementAt(columnNumber - 1)).setBufferSize(value);
    }

    public void setLabel(int columnNumber, String value) {
        ((Column)this.columns.elementAt(columnNumber - 1)).setLabel(value);
    }

    public void setNativeType(int columnNumber, int value) {
        this.resize(columnNumber);
        ((Column)this.columns.elementAt(columnNumber - 1)).setType(value);
    }

    public void setPrecision(int columnNumber, int value) {
        this.resize(columnNumber);
        ((Column)this.columns.elementAt(columnNumber - 1)).setPrecision(value);
    }

    public void setScale(int columnNumber, int value) {
        this.resize(columnNumber);
        ((Column)this.columns.elementAt(columnNumber - 1)).setScale(value);
    }

    public void setAutoIncrement(int columnNumber, boolean value) {
        this.resize(columnNumber);
        ((Column)this.columns.elementAt(columnNumber - 1)).setAutoIncrement(value);
    }

    public void setNullable(int columnNumber, int value) {
        this.resize(columnNumber);
        ((Column)this.columns.elementAt(columnNumber - 1)).setNullable(value);
    }

    public void setReadOnly(int columnNumber, boolean value) {
        this.resize(columnNumber);
        ((Column)this.columns.elementAt(columnNumber - 1)).setReadOnly(value);
    }

    public void setCaseSensitive(int columnNumber, boolean value) {
        this.resize(columnNumber);
        ((Column)this.columns.elementAt(columnNumber - 1)).setCaseSensitive(value);
    }

    public void setJdbcType(int columnNumber, int jdbcType) throws SQLException {
        try {
            this.setNativeType(columnNumber, Tds.cvtJdbcTypeToNativeType(jdbcType));
        }
        catch (TdsException e) {
            throw new SQLException("TDS error- " + e.getMessage());
        }
    }

    public void setTableName(int columnNumber, String tableName) {
        this.resize(columnNumber);
        ((Column)this.columns.elementAt(columnNumber - 1)).setTableName(tableName);
    }

    public Column getColumn(int columnNumber) {
        this.resize(columnNumber);
        return (Column)this.columns.elementAt(columnNumber - 1);
    }

    public int realColumnCount() {
        return this.columnCount;
    }

    public int fakeColumnCount() {
        return this.fakeColCount;
    }

    public void setFakeColumnCount(int count) {
        this.fakeColCount = count;
    }

    public String getCatalog(int columnNumber) {
        return ((Column)this.columns.elementAt(columnNumber - 1)).getCatalog();
    }

    public String getSchema(int columnNumber) {
        return ((Column)this.columns.elementAt(columnNumber - 1)).getSchema();
    }

    public String getName(int columnNumber) {
        return ((Column)this.columns.elementAt(columnNumber - 1)).getName();
    }

    public int getDisplaySize(int columnNumber) {
        return ((Column)this.columns.elementAt(columnNumber - 1)).getDisplaySize();
    }

    public int getBufferSize(int columnNumber) {
        return ((Column)this.columns.elementAt(columnNumber - 1)).getBufferSize();
    }

    public String getLabel(int columnNumber) {
        return ((Column)this.columns.elementAt(columnNumber - 1)).getLabel();
    }

    public int getNativeType(int columnNumber) {
        return ((Column)this.columns.elementAt(columnNumber - 1)).getType();
    }

    public int getJdbcType(int index) throws SQLException {
        try {
            return Tds.cvtNativeTypeToJdbcType(this.getNativeType(index), this.getBufferSize(index));
        }
        catch (TdsException e) {
            throw new SQLException("TDS error- " + e.getMessage());
        }
    }

    public int getPrecision(int columnNumber) {
        return ((Column)this.columns.elementAt(columnNumber - 1)).getPrecision();
    }

    public int getScale(int columnNumber) {
        return ((Column)this.columns.elementAt(columnNumber - 1)).getScale();
    }

    public Boolean isAutoIncrement(int columnNumber) {
        return ((Column)this.columns.elementAt(columnNumber - 1)).isAutoIncrement();
    }

    public int isNullable(int columnNumber) {
        return ((Column)this.columns.elementAt(columnNumber - 1)).isNullable();
    }

    public Boolean isReadOnly(int columnNumber) {
        return ((Column)this.columns.elementAt(columnNumber - 1)).isReadOnly();
    }

    public Boolean isCaseSensitive(int columnNumber) {
        return ((Column)this.columns.elementAt(columnNumber - 1)).isCaseSensitive();
    }

    public String getTableName(int columnNumber) {
        return ((Column)this.columns.elementAt(columnNumber - 1)).getTableName();
    }

    public Columns merge(Columns other) throws TdsException {
        if (this.columnCount != other.columnCount) {
            throw new TdsException("Confused. Mismatch in number of columns");
        }
        int i = 1;
        while (i <= this.columnCount) {
            if (this.getName(i) == null) {
                this.setName(i, other.getName(i));
            } else if (other.getName(i) != null) {
                throw new TdsException("Trying to merge two non-null columns");
            }
            if (this.getLabel(i) == null) {
                this.setLabel(i, other.getLabel(i));
            } else if (other.getLabel(i) != null) {
                throw new TdsException("Trying to merge two non-null columns");
            }
            if (this.getTableName(i) == null) {
                this.setTableName(i, other.getTableName(i));
            } else if (other.getTableName(i) != null) {
                throw new TdsException("Trying to merge two non-null columns");
            }
            if (this.getDisplaySize(i) == -1) {
                this.setDisplaySize(i, other.getDisplaySize(i));
            } else if (other.getDisplaySize(i) != -1) {
                throw new TdsException("Trying to merge two non-null columns");
            }
            if (this.getBufferSize(i) == -1) {
                this.setBufferSize(i, other.getBufferSize(i));
            } else if (other.getBufferSize(i) != -1) {
                throw new TdsException("Trying to merge two non-null columns");
            }
            if (this.getNativeType(i) == -1) {
                this.setNativeType(i, other.getNativeType(i));
            } else if (other.getNativeType(i) != -1) {
                throw new TdsException("Trying to merge two non-null columns");
            }
            if (this.getPrecision(i) == -1) {
                this.setPrecision(i, other.getPrecision(i));
            } else if (other.getPrecision(i) != -1) {
                throw new TdsException("Trying to merge two non-null columns");
            }
            if (this.getScale(i) == -1) {
                this.setScale(i, other.getScale(i));
            } else if (other.getScale(i) != -1) {
                throw new TdsException("Trying to merge two non-null columns");
            }
            if (!this.readOnlyWasSet(i)) {
                this.setReadOnly(i, other.isReadOnly(i));
            } else if (other.readOnlyWasSet(i)) {
                throw new TdsException("Trying to merge two non-null columns");
            }
            if (!this.autoIncrementWasSet(i)) {
                this.setAutoIncrement(i, other.isAutoIncrement(i));
            } else if (other.autoIncrementWasSet(i)) {
                throw new TdsException("Trying to merge two non-null columns");
            }
            if (!this.caseSensitiveWasSet(i)) {
                this.setCaseSensitive(i, other.isCaseSensitive(i));
            } else if (other.caseSensitiveWasSet(i)) {
                throw new TdsException("Trying to merge two non-null columns");
            }
            if (!this.nullableWasSet(i)) {
                this.setNullable(i, other.isNullable(i));
            } else if (other.nullableWasSet(i)) {
                throw new TdsException("Trying to merge two non-null columns");
            }
            ++i;
        }
        return this;
    }

    public boolean autoIncrementWasSet(int columnNumber) {
        return ((Column)this.columns.elementAt(columnNumber - 1)).isAutoIncrement() != null;
    }

    public boolean nullableWasSet(int columnNumber) {
        return this.isNullable(columnNumber) != 2;
    }

    public boolean readOnlyWasSet(int columnNumber) {
        return ((Column)this.columns.elementAt(columnNumber - 1)).isReadOnly() != null;
    }

    public boolean caseSensitiveWasSet(int columnNumber) {
        return ((Column)this.columns.elementAt(columnNumber - 1)).isCaseSensitive() != null;
    }

    private void resize(int columnNumber) {
        if (columnNumber > this.columnCount) {
            this.columnCount = columnNumber;
            this.fakeColCount = columnNumber;
        }
        if (this.columns.size() <= columnNumber) {
            this.columns.setSize(columnNumber + 1);
        }
        if (this.columns.elementAt(columnNumber - 1) == null) {
            this.columns.setElementAt(new Column(), columnNumber - 1);
        }
    }
}

