/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public class ClobImpl
implements Clob {
    public static final String cvsVersion = "$Id: ClobImpl.java,v 1.5 2004/02/06 19:25:32 bheineman Exp $";
    private String _clob;

    ClobImpl(String clob) throws SQLException {
        if (clob == null) {
            throw new SQLException("clob cannot be null.");
        }
        this._clob = clob;
    }

    public synchronized InputStream getAsciiStream() throws SQLException {
        try {
            return new ByteArrayInputStream(this._clob.getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            throw new SQLException("Unexpected encoding exception: " + e.getMessage());
        }
    }

    public synchronized Reader getCharacterStream() throws SQLException {
        return new StringReader(this._clob);
    }

    public synchronized String getSubString(long pos, int length) throws SQLException {
        if (pos > Integer.MAX_VALUE) {
            throw new SQLException("pos must be <= 2147483647");
        }
        return this._clob.substring((int)pos, length);
    }

    public synchronized long length() throws SQLException {
        return this._clob.length();
    }

    public synchronized long position(Clob searchStr, long start) throws SQLException {
        if (searchStr == null) {
            throw new SQLException("searchStr cannot be null.");
        }
        if (start > Integer.MAX_VALUE) {
            throw new SQLException("start must be <= 2147483647");
        }
        long length = searchStr.length();
        if (length > Integer.MAX_VALUE) {
            throw new SQLException("searchStr.length() must be <= 2147483647");
        }
        return this._clob.indexOf(searchStr.getSubString(0L, (int)length), (int)start);
    }

    public synchronized long position(String searchStr, long start) throws SQLException {
        if (searchStr == null) {
            throw new SQLException("searchStr cannot be null.");
        }
        if (start < 0L) {
            throw new SQLException("start must be >= 0.");
        }
        if (start > Integer.MAX_VALUE) {
            throw new SQLException("start must be <= 2147483647");
        }
        return this._clob.indexOf(searchStr, (int)start);
    }

    public synchronized OutputStream setAsciiStream(final long pos) throws SQLException {
        byte[] clob;
        if (pos < 0L) {
            throw new SQLException("pos must be >= 0.");
        }
        if (pos > (long)this._clob.length()) {
            throw new SQLException("pos specified is past length of value.");
        }
        if (pos >= Integer.MAX_VALUE) {
            throw new SQLException("pos must be < 2147483647");
        }
        try {
            clob = this._clob.getBytes("ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new SQLException("Unexpected encoding exception: " + e.getMessage());
        }
        return new ByteArrayOutputStream(){
            {
                this.write(clob, 0, (int)pos);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void flush() throws IOException {
                ClobImpl clobImpl = ClobImpl.this;
                synchronized (clobImpl) {
                    String clob2 = new String(this.toByteArray(), "ASCII");
                    if (clob2.length() < ClobImpl.this._clob.length()) {
                        ClobImpl.this._clob = clob2 + ClobImpl.this._clob.substring(clob2.length());
                    } else {
                        ClobImpl.this._clob = clob2;
                    }
                }
            }

            public void close() throws IOException {
                this.flush();
            }
        };
    }

    public synchronized Writer setCharacterStream(final long pos) throws SQLException {
        if (pos < 0L) {
            throw new SQLException("pos must be >= 0.");
        }
        if (pos > (long)this._clob.length()) {
            throw new SQLException("pos specified is past length of value.");
        }
        if (pos >= Integer.MAX_VALUE) {
            throw new SQLException("pos must be < 2147483647");
        }
        return new StringWriter(){
            {
                this.write(ClobImpl.this._clob, 0, (int)pos);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void flush() {
                ClobImpl clobImpl = ClobImpl.this;
                synchronized (clobImpl) {
                    String clob = this.toString();
                    if (clob.length() < ClobImpl.this._clob.length()) {
                        ClobImpl.this._clob = clob + ClobImpl.this._clob.substring(clob.length());
                    } else {
                        ClobImpl.this._clob = clob;
                    }
                }
            }

            public void close() throws IOException {
                this.flush();
            }
        };
    }

    public synchronized int setString(long pos, String str) throws SQLException {
        if (str == null) {
            throw new SQLException("str cannot be null.");
        }
        return this.setString(pos, str, 0, str.length());
    }

    public synchronized int setString(long pos, String str, int offset, int len) throws SQLException {
        Writer writer = this.setCharacterStream(pos);
        try {
            writer.write(str, offset, len);
            writer.close();
        }
        catch (IOException e) {
            throw new SQLException("Unable to write value: " + e.getMessage());
        }
        return len;
    }

    public synchronized void truncate(long len) throws SQLException {
        if (len < 0L) {
            throw new SQLException("len must be >= 0.");
        }
        if (len > (long)this._clob.length()) {
            throw new SQLException("length specified is more than length of value.");
        }
        this._clob = this._clob.substring(0, (int)len);
    }

    public synchronized String toString() {
        return this._clob;
    }
}

