/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.io.IOException;
import net.sourceforge.jtds.jdbc.TdsComm;
import net.sourceforge.jtds.jdbc.TdsException;

public class CancelController {
    public static final String cvsVersion = "$Id: CancelController.java,v 1.2 2003/12/16 19:08:48 alin_sinpalean Exp $";
    private boolean awaitingData = false;
    private int cancelsRequested = 0;
    private int cancelsProcessed = 0;

    public synchronized void setQueryInProgressFlag() {
        this.awaitingData = true;
    }

    public synchronized void finishQuery(boolean wasCanceled, boolean moreResults) {
        if (!moreResults) {
            this.awaitingData = false;
        }
        if (wasCanceled) {
            ++this.cancelsProcessed;
        }
    }

    public synchronized void doCancel(TdsComm comm) throws IOException, TdsException {
        if (this.awaitingData && this.cancelsRequested == this.cancelsProcessed) {
            comm.startPacket(6);
            comm.sendPacket();
            ++this.cancelsRequested;
        }
    }

    public synchronized int outstandingCancels() {
        return this.cancelsRequested - this.cancelsProcessed;
    }
}

