/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import net.sourceforge.jtds.jdbc.EscapeProcessor;
import net.sourceforge.jtds.jdbc.PacketOutputParamResult;
import net.sourceforge.jtds.jdbc.PacketRetStatResult;
import net.sourceforge.jtds.jdbc.ParameterListItem;
import net.sourceforge.jtds.jdbc.ParameterUtils;
import net.sourceforge.jtds.jdbc.PreparedStatement_base;
import net.sourceforge.jtds.jdbc.Tds;
import net.sourceforge.jtds.jdbc.TdsConnection;

public class CallableStatement_base
extends PreparedStatement_base
implements CallableStatement {
    public static final String cvsVersion = "$Id: CallableStatement_base.java,v 1.16 2004/02/20 00:09:09 alin_sinpalean Exp $";
    private String procedureName = null;
    private boolean lastWasNull = false;
    private int lastOutParam = -1;
    private Integer retVal = null;
    private boolean haveRetVal = false;

    public CallableStatement_base(TdsConnection conn_, String sql) throws SQLException {
        this(conn_, sql, 1003, 1007);
    }

    /*
     * Unable to fully structure code
     */
    public CallableStatement_base(TdsConnection conn_, String sql, int type, int concurrency) throws SQLException {
        super(conn_, type, concurrency);
        sql = sql.trim();
        result = new StringBuffer(sql.length());
        numberOfParameters = EscapeProcessor.parameterNativeSQL(sql, result);
        this.rawQueryString = result.toString();
        length = this.rawQueryString.length();
        i = 0;
        while (i < length && !Character.isWhitespace(this.rawQueryString.charAt(i))) {
            ++i;
        }
        call = this.rawQueryString.substring(0, i);
        if (!call.equalsIgnoreCase("exec") && !call.equalsIgnoreCase("execute")) {
            this.rawQueryString = "exec " + this.rawQueryString;
            length = this.rawQueryString.length();
            i = 4;
        }
        inString = false;
        while (i < length) {
            ch = this.rawQueryString.charAt(i);
            if (Character.isLetterOrDigit(ch) || ch == '#' || ch == '?') break;
            if (ch == '[' || ch == '\"') {
                inString = true;
                break;
            }
            ++i;
        }
        pos = i;
        if (this.rawQueryString.charAt(i) == '?') {
            retPos = i;
            while (i < length && this.rawQueryString.charAt(i) != '=') {
                ++i;
            }
            if (this.rawQueryString.charAt(i) == '=') {
                this.rawQueryString = this.rawQueryString.substring(0, retPos) + this.rawQueryString.substring(i + 1);
                --numberOfParameters;
                this.haveRetVal = true;
            } else {
                throw new SQLException("Invalid return value syntax; expected to find '=': " + sql);
            }
        }
        ++i;
        while (i < length) {
            ch = this.rawQueryString.charAt(i);
            if (inString) {
                if (ch == ']' || ch == '\"') {
                    inString = false;
                }
            } else if (ch == '[' || ch == '\"') {
                inString = true;
            } else if (!Character.isLetterOrDigit(ch) && ch != '#' && ch != '_' && ch != '.') break;
            ++i;
        }
        if (!inString) ** GOTO lbl58
        throw new SQLException("Invalid procedure name detected; expected idendifer to be closed properly by \" or ]: " + sql);
lbl-1000:
        // 1 sources

        {
            ++i;
lbl58:
            // 2 sources

            ** while (i < length && !Character.isWhitespace((char)this.rawQueryString.charAt((int)i)))
        }
lbl59:
        // 1 sources

        this.procedureName = this.rawQueryString.substring(pos, i);
        if (this.procedureName.length() == 0) {
            throw new SQLException("Unable to locate procedure name in: " + sql);
        }
        this.parameterList = new ParameterListItem[numberOfParameters];
        x = 0;
        while (x < numberOfParameters) {
            this.parameterList[x] = new ParameterListItem();
            ++x;
        }
    }

    private Object getParam(int index) throws SQLException {
        if (this.haveRetVal) {
            if (index == 1) {
                return this.retVal;
            }
            --index;
        }
        if (index < 1) {
            throw new SQLException("Invalid parameter index " + index + ". JDBC indexes start at 1.");
        }
        if (index > this.parameterList.length) {
            throw new SQLException("Invalid parameter index " + index + ". This statement only has " + this.parameterList.length + " parameters.");
        }
        this.lastWasNull = this.parameterList[--index] == null;
        return this.parameterList[index].value;
    }

    protected void setParam(int index, Object value, int type, int scale) throws SQLException {
        super.setParam(this.haveRetVal ? index - 1 : index, value, type, scale);
    }

    protected void addOutputParam(Object value) throws SQLException {
        ++this.lastOutParam;
        while (this.lastOutParam < this.parameterList.length) {
            if (this.parameterList[this.lastOutParam].isOutput) {
                this.parameterList[this.lastOutParam].value = value;
                return;
            }
            ++this.lastOutParam;
        }
        throw new SQLException("More output params than expected.");
    }

    protected boolean handleRetStat(PacketRetStatResult packet) {
        if (!super.handleRetStat(packet)) {
            this.retVal = new Integer(packet.getRetStat());
        }
        return true;
    }

    protected boolean handleParamResult(PacketOutputParamResult packet) throws SQLException {
        if (!super.handleParamResult(packet)) {
            this.addOutputParam(packet.value);
        }
        return true;
    }

    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public boolean getBoolean(int parameterIndex) throws SQLException {
        Object value = this.getParam(parameterIndex);
        if (value == null) {
            return false;
        }
        try {
            return (Boolean)value;
        }
        catch (Exception e) {
            throw new SQLException("Unable to convert parameter");
        }
    }

    public byte getByte(int parameterIndex) throws SQLException {
        Object value = this.getParam(parameterIndex);
        if (value == null) {
            return 0;
        }
        try {
            return ((Number)value).byteValue();
        }
        catch (Exception e) {
            throw new SQLException("Unable to convert parameter");
        }
    }

    public byte[] getBytes(int parameterIndex) throws SQLException {
        Object value = this.getParam(parameterIndex);
        if (value == null) {
            return null;
        }
        try {
            return (byte[])value;
        }
        catch (Exception e) {
            throw new SQLException("Unable to convert parameter");
        }
    }

    public Date getDate(int parameterIndex) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public double getDouble(int parameterIndex) throws SQLException {
        Object value = this.getParam(parameterIndex);
        if (value == null) {
            return 0.0;
        }
        try {
            return ((Number)value).doubleValue();
        }
        catch (Exception e) {
            throw new SQLException("Unable to convert parameter");
        }
    }

    public float getFloat(int parameterIndex) throws SQLException {
        Object value = this.getParam(parameterIndex);
        if (value == null) {
            return 0.0f;
        }
        try {
            return ((Number)value).floatValue();
        }
        catch (Exception e) {
            throw new SQLException("Unable to convert parameter");
        }
    }

    public int getInt(int parameterIndex) throws SQLException {
        Object value = this.getParam(parameterIndex);
        if (value == null) {
            return 0;
        }
        try {
            return ((Number)value).intValue();
        }
        catch (Exception e) {
            throw new SQLException("Unable to convert parameter");
        }
    }

    public long getLong(int parameterIndex) throws SQLException {
        Object value = this.getParam(parameterIndex);
        if (value == null) {
            return 0L;
        }
        try {
            return ((Number)value).longValue();
        }
        catch (Exception e) {
            throw new SQLException("Unable to convert parameter");
        }
    }

    public Object getObject(int parameterIndex) throws SQLException {
        return this.getParam(parameterIndex);
    }

    public short getShort(int parameterIndex) throws SQLException {
        Object value = this.getParam(parameterIndex);
        if (value == null) {
            return 0;
        }
        try {
            return ((Number)value).shortValue();
        }
        catch (Exception e) {
            throw new SQLException("Unable to convert parameter");
        }
    }

    public String getString(int parameterIndex) throws SQLException {
        Object value = this.getParam(parameterIndex);
        try {
            return (String)value;
        }
        catch (Exception e) {
            throw new SQLException("Unable to convert parameter");
        }
    }

    public Time getTime(int parameterIndex) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType, -1);
    }

    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        if (this.haveRetVal) {
            if (parameterIndex == 1) {
                if (sqlType != 4 && sqlType != 2 && sqlType != 3 && sqlType != -5) {
                    throw new SQLException("Procedure return value is integer.");
                }
                return;
            }
            --parameterIndex;
        }
        Object value = this.parameterList[parameterIndex - 1].value;
        super.setParam(parameterIndex, null, sqlType, scale);
        this.parameterList[parameterIndex - 1].isOutput = true;
        this.parameterList[parameterIndex - 1].value = value;
    }

    public boolean wasNull() throws SQLException {
        return this.lastWasNull;
    }

    public boolean execute(Tds tds) throws SQLException {
        this.closeResults(false);
        this.lastOutParam = -1;
        ParameterUtils.createParameterMapping(null, this.parameterList, tds, false);
        return this.internalExecuteCall(this.procedureName, this.parameterList, this.parameterList, tds, this.warningChain);
    }

    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public void registerOutParameter(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.NotImplemented();
    }

    public Blob getBlob(int i) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public Clob getClob(int i) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public Object getObject(int i, Map map) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public Ref getRef(int i) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public Array getArray(int i) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public void registerOutParameter(String str, int param, String str2) throws SQLException {
        this.NotImplemented();
    }

    public void registerOutParameter(String str, int param, int param2) throws SQLException {
        this.NotImplemented();
    }

    public void registerOutParameter(String str, int param) throws SQLException {
        this.NotImplemented();
    }

    public Array getArray(String str) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public BigDecimal getBigDecimal(String str) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public Blob getBlob(String str) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public boolean getBoolean(String str) throws SQLException {
        this.NotImplemented();
        return false;
    }

    public byte getByte(String str) throws SQLException {
        this.NotImplemented();
        return 0;
    }

    public byte[] getBytes(String str) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public Clob getClob(String str) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public Date getDate(String str) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public Date getDate(String str, Calendar calendar) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public double getDouble(String str) throws SQLException {
        this.NotImplemented();
        return 0.0;
    }

    public float getFloat(String str) throws SQLException {
        this.NotImplemented();
        return 0.0f;
    }

    public int getInt(String str) throws SQLException {
        this.NotImplemented();
        return 0;
    }

    public long getLong(String str) throws SQLException {
        this.NotImplemented();
        return 0L;
    }

    public Object getObject(String str) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public Object getObject(String str, Map map) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public Ref getRef(String str) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public short getShort(String str) throws SQLException {
        this.NotImplemented();
        return 0;
    }

    public String getString(String str) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public Time getTime(String str) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public Time getTime(String str, Calendar calendar) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public Timestamp getTimestamp(String str) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public Timestamp getTimestamp(String str, Calendar calendar) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public URL getURL(int param) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public URL getURL(String str) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public void setAsciiStream(String str, InputStream inputStream, int param) throws SQLException {
        this.NotImplemented();
    }

    public void setBigDecimal(String str, BigDecimal bigDecimal) throws SQLException {
        this.NotImplemented();
    }

    public void setBinaryStream(String str, InputStream inputStream, int param) throws SQLException {
        this.NotImplemented();
    }

    public void setBoolean(String str, boolean param) throws SQLException {
        this.NotImplemented();
    }

    public void setByte(String str, byte param) throws SQLException {
        this.NotImplemented();
    }

    public void setBytes(String str, byte[] values) throws SQLException {
        this.NotImplemented();
    }

    public void setCharacterStream(String str, Reader reader, int param) throws SQLException {
        this.NotImplemented();
    }

    public void setDate(String str, Date date) throws SQLException {
        this.NotImplemented();
    }

    public void setDate(String str, Date date, Calendar calendar) throws SQLException {
        this.NotImplemented();
    }

    public void setDouble(String str, double param) throws SQLException {
        this.NotImplemented();
    }

    public void setFloat(String str, float param) throws SQLException {
        this.NotImplemented();
    }

    public void setInt(String str, int param) throws SQLException {
        this.NotImplemented();
    }

    public void setLong(String str, long param) throws SQLException {
        this.NotImplemented();
    }

    public void setNull(String str, int param) throws SQLException {
        this.NotImplemented();
    }

    public void setNull(String str, int param, String str2) throws SQLException {
        this.NotImplemented();
    }

    public void setObject(String str, Object obj) throws SQLException {
        this.NotImplemented();
    }

    public void setObject(String str, Object obj, int param) throws SQLException {
        this.NotImplemented();
    }

    public void setObject(String str, Object obj, int param, int param3) throws SQLException {
        this.NotImplemented();
    }

    public void setShort(String str, short param) throws SQLException {
        this.NotImplemented();
    }

    public void setString(String str, String str1) throws SQLException {
        this.NotImplemented();
    }

    public void setTime(String str, Time time) throws SQLException {
        this.NotImplemented();
    }

    public void setTime(String str, Time time, Calendar calendar) throws SQLException {
        this.NotImplemented();
    }

    public void setTimestamp(String str, Timestamp timestamp) throws SQLException {
        this.NotImplemented();
    }

    public void setTimestamp(String str, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.NotImplemented();
    }

    public void setURL(String str, URL url) throws SQLException {
        this.NotImplemented();
    }

    public String getProcedureName() {
        return this.procedureName;
    }
}

