/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.TimeZone;
import net.sourceforge.jtds.jdbc.BlobImpl;
import net.sourceforge.jtds.jdbc.ClobImpl;
import net.sourceforge.jtds.jdbc.Columns;
import net.sourceforge.jtds.jdbc.Context;
import net.sourceforge.jtds.jdbc.PacketRowResult;
import net.sourceforge.jtds.jdbc.SQLWarningChain;
import net.sourceforge.jtds.jdbc.TdsResultSetMetaData;

public abstract class AbstractResultSet
implements ResultSet {
    public static final String cvsVersion = "$Id: AbstractResultSet.java,v 1.11 2004/02/26 19:00:51 alin_sinpalean Exp $";
    public static final int DEFAULT_FETCH_SIZE = 100;
    public static final long HOUR_CONSTANT = 3600000L;
    protected int fetchSize = 100;
    protected SQLWarningChain warningChain = null;
    ResultSetMetaData metaData = null;
    private static NumberFormat f = NumberFormat.getInstance();
    private static Calendar staticCalendar = new GregorianCalendar();

    public abstract Context getContext();

    public abstract PacketRowResult currentRow() throws SQLException;

    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.metaData == null) {
            this.metaData = new TdsResultSetMetaData(this.getContext().getColumnInfo());
        }
        return this.metaData;
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName), scale);
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnName));
    }

    public Ref getRef(String colName) throws SQLException {
        return this.getRef(this.findColumn(colName));
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName), cal);
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnName), cal);
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnName), cal);
    }

    public short getShort(int index) throws SQLException {
        return (short)this.getLong(index);
    }

    public Object getObject(String colName, Map map) throws SQLException {
        return this.getObject(this.findColumn(colName), map);
    }

    public Blob getBlob(String colName) throws SQLException {
        return this.getBlob(this.findColumn(colName));
    }

    public Clob getClob(String colName) throws SQLException {
        return this.getClob(this.findColumn(colName));
    }

    public Array getArray(String colName) throws SQLException {
        return this.getArray(this.findColumn(colName));
    }

    public float getFloat(int index) throws SQLException {
        return (float)this.getDouble(index);
    }

    public int getInt(int index) throws SQLException {
        return (int)this.getLong(index);
    }

    public InputStream getAsciiStream(int index) throws SQLException {
        String val = this.getString(index);
        if (val == null) {
            return null;
        }
        try {
            return new ByteArrayInputStream(val.getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            throw new SQLException("Unexpected encoding exception: " + e.getMessage());
        }
    }

    public BigDecimal getBigDecimal(int index, int scale) throws SQLException {
        return this.currentRow().getBigDecimal(index, scale);
    }

    public InputStream getBinaryStream(int index) throws SQLException {
        byte[] bytes = this.getBytes(index);
        if (bytes != null) {
            return new ByteArrayInputStream(bytes);
        }
        return null;
    }

    public boolean getBoolean(int index) throws SQLException {
        return this.currentRow().getBoolean(index);
    }

    public byte getByte(int index) throws SQLException {
        return (byte)this.getLong(index);
    }

    public byte[] getBytes(int index) throws SQLException {
        return this.currentRow().getBytes(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate(int index) throws SQLException {
        Date result = null;
        Timestamp tmp = this.getTimestamp(index);
        if (tmp != null) {
            Calendar calendar = staticCalendar;
            synchronized (calendar) {
                staticCalendar.setTime(tmp);
                staticCalendar.set(11, 0);
                staticCalendar.set(12, 0);
                staticCalendar.set(13, 0);
                staticCalendar.set(14, 0);
                result = new Date(staticCalendar.getTime().getTime());
            }
        }
        return result;
    }

    public double getDouble(int index) throws SQLException {
        return this.currentRow().getDouble(index);
    }

    public long getLong(int index) throws SQLException {
        return this.currentRow().getLong(index);
    }

    public Object getObject(int index) throws SQLException {
        PacketRowResult row = this.currentRow();
        if (row == null) {
            throw new SQLException("No current row in the result set.");
        }
        return row.getObject(index);
    }

    public String getString(int index) throws SQLException {
        Object tmp = this.getObject(index);
        if (tmp == null) {
            return null;
        }
        if (tmp instanceof byte[]) {
            byte[] b = (byte[])tmp;
            StringBuffer buf = new StringBuffer(2 * b.length);
            int i = 0;
            while (i < b.length) {
                int n = b[i] & 0xFF;
                int v = n >> 4;
                buf.append((char)(v < 10 ? 48 + v : 65 + v - 10));
                v = n & 0xF;
                buf.append((char)(v < 10 ? 48 + v : 65 + v - 10));
                ++i;
            }
            return buf.toString();
        }
        if (tmp instanceof Boolean) {
            return (Boolean)tmp != false ? "1" : "0";
        }
        return tmp.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getTime(int index) throws SQLException {
        Time result = null;
        Timestamp tmp = this.getTimestamp(index);
        if (tmp != null) {
            Calendar calendar = staticCalendar;
            synchronized (calendar) {
                staticCalendar.setTime(tmp);
                staticCalendar.set(0, 1);
                staticCalendar.set(1, 1970);
                staticCalendar.set(2, 0);
                staticCalendar.set(5, 1);
                result = new Time(staticCalendar.getTime().getTime());
            }
        }
        return result;
    }

    public Reader getCharacterStream(int index) throws SQLException {
        String val = this.getString(index);
        if (val == null) {
            return null;
        }
        return new StringReader(val);
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(int index) throws SQLException {
        return this.currentRow().getBigDecimal(index);
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.currentRow().getBigDecimal(this.findColumn(columnName));
    }

    public Object getObject(int i, Map map) throws SQLException {
        throw new UnsupportedOperationException("Not Implemented");
    }

    public Ref getRef(int i) throws SQLException {
        throw new UnsupportedOperationException("Not Implemented");
    }

    public Blob getBlob(int i) throws SQLException {
        byte[] value = this.getBytes(i);
        if (value == null) {
            return null;
        }
        return new BlobImpl(value);
    }

    public Clob getClob(int i) throws SQLException {
        String value = this.getString(i);
        if (value == null) {
            return null;
        }
        return new ClobImpl(value);
    }

    public Array getArray(int i) throws SQLException {
        throw new UnsupportedOperationException("Not Implemented");
    }

    public Timestamp getTimestamp(int index, Calendar calendar) throws SQLException {
        Timestamp timestamp = this.getTimestamp(index);
        if (timestamp != null && calendar != null) {
            TimeZone timeZone = TimeZone.getDefault();
            long newTime = timestamp.getTime();
            newTime -= (long)timeZone.getRawOffset();
            timestamp = new Timestamp(newTime += (long)calendar.getTimeZone().getRawOffset());
        }
        return timestamp;
    }

    public Date getDate(int index, Calendar calendar) throws SQLException {
        Date date = this.getDate(index);
        if (date != null && calendar != null) {
            TimeZone timeZone = TimeZone.getDefault();
            long newTime = date.getTime();
            newTime -= (long)timeZone.getRawOffset();
            date = new Date(newTime += (long)calendar.getTimeZone().getRawOffset());
        }
        return date;
    }

    public Time getTime(int index, Calendar calendar) throws SQLException {
        Time time = this.getTime(index);
        if (time != null && calendar != null) {
            TimeZone timeZone = TimeZone.getDefault();
            long newTime = time.getTime();
            newTime -= (long)timeZone.getRawOffset();
            time = new Time(newTime += (long)calendar.getTimeZone().getRawOffset());
        }
        return time;
    }

    public Timestamp getTimestamp(int index) throws SQLException {
        return this.currentRow().getTimestamp(index);
    }

    public InputStream getUnicodeStream(int index) throws SQLException {
        String val = this.getString(index);
        if (val == null) {
            return null;
        }
        try {
            return new ByteArrayInputStream(val.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new SQLException("Unexpected encoding exception: " + e.getMessage());
        }
    }

    public int findColumn(String columnName) throws SQLException {
        Columns info = this.getContext().getColumnInfo();
        int i = 1;
        while (i <= info.fakeColumnCount()) {
            if (info.getName(i).equalsIgnoreCase(columnName) || info.getLabel(i).equalsIgnoreCase(columnName)) {
                return i;
            }
            ++i;
        }
        throw new SQLException("No such column " + columnName);
    }

    public void updateNull(int index) throws SQLException {
        this.updateObject(index, null);
    }

    public void updateNull(String columnName) throws SQLException {
        this.updateNull(this.findColumn(columnName));
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.updateBoolean(this.findColumn(columnName), x);
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        this.updateByte(this.findColumn(columnName), x);
    }

    public void updateShort(String columnName, short x) throws SQLException {
        this.updateShort(this.findColumn(columnName), x);
    }

    public void updateInt(String columnName, int x) throws SQLException {
        this.updateInt(this.findColumn(columnName), x);
    }

    public void updateLong(String columnName, long x) throws SQLException {
        this.updateLong(this.findColumn(columnName), x);
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        this.updateFloat(this.findColumn(columnName), x);
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        this.updateDouble(this.findColumn(columnName), x);
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnName), x);
    }

    public void updateString(String columnName, String x) throws SQLException {
        this.updateString(this.findColumn(columnName), x);
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.updateBytes(this.findColumn(columnName), x);
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        this.updateDate(this.findColumn(columnName), x);
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        this.updateTime(this.findColumn(columnName), x);
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.updateTimestamp(this.findColumn(columnName), x);
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnName), x, length);
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), x, length);
    }

    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), reader, length);
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.updateObject(this.findColumn(columnName), x, scale);
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        this.updateObject(this.findColumn(columnName), x);
    }

    public boolean wasNull() throws SQLException {
        return this.currentRow().wasNull();
    }

    public void updateBoolean(int index, boolean x) throws SQLException {
        this.updateObject(index, (Object)new Boolean(x));
    }

    public void updateByte(int index, byte x) throws SQLException {
        this.updateObject(index, (Object)new Byte(x));
    }

    public void updateShort(int index, short x) throws SQLException {
        this.updateObject(index, (Object)new Short(x));
    }

    public void updateInt(int index, int x) throws SQLException {
        this.updateObject(index, (Object)new Integer(x));
    }

    public void updateLong(int index, long x) throws SQLException {
        this.updateObject(index, (Object)new Long(x));
    }

    public void updateFloat(int index, float x) throws SQLException {
        this.updateObject(index, (Object)new Float(x));
    }

    public void updateDouble(int index, double x) throws SQLException {
        this.updateObject(index, (Object)new Double(x));
    }

    public void updateBigDecimal(int index, BigDecimal x) throws SQLException {
        this.updateObject(index, (Object)x);
    }

    public void updateString(int index, String x) throws SQLException {
        this.updateObject(index, (Object)x);
    }

    public void updateBytes(int index, byte[] x) throws SQLException {
        this.updateObject(index, (Object)x);
    }

    public void updateDate(int index, Date x) throws SQLException {
        this.updateObject(index, (Object)x);
    }

    public void updateTime(int index, Time x) throws SQLException {
        this.updateObject(index, (Object)x);
    }

    public void updateTimestamp(int index, Timestamp x) throws SQLException {
        this.updateObject(index, (Object)x);
    }

    public void updateAsciiStream(int index, InputStream inputStream, int length) throws SQLException {
        if (inputStream == null) {
            this.updateCharacterStream(index, (Reader)null, 0);
        } else {
            try {
                this.updateCharacterStream(index, (Reader)new InputStreamReader(inputStream, "ASCII"), length);
            }
            catch (UnsupportedEncodingException e) {
                throw new SQLException("Unexpected encoding exception: " + e.getMessage());
            }
        }
    }

    public void updateBinaryStream(int index, InputStream inputStream, int length) throws SQLException {
        int actlen;
        if (length == 0) {
            this.updateBytes(index, null);
        }
        byte[] bs = new byte[length];
        try {
            actlen = inputStream.read(bs);
        }
        catch (IOException e) {
            throw new SQLException("setBinaryStream: IO-Exception occured reading Stream" + e.toString());
        }
        if (actlen != length) {
            throw new SQLException("SetBinaryStream parameterized Length: " + Integer.toString(length) + " got length: " + Integer.toString(actlen));
        }
        try {
            actlen = inputStream.read(bs);
        }
        catch (IOException e) {
            throw new SQLException("setBinaryStream: IO-Exception occured reading Stream" + e.toString());
        }
        if (actlen != -1) {
            throw new SQLException("SetBinaryStream parameterized Length: " + Integer.toString(length) + " got more than that ");
        }
        this.updateBytes(index, bs);
    }

    /*
     * WARNING - void declaration
     */
    public void updateCharacterStream(int index, Reader reader, int length) throws SQLException {
        if (reader == null || length < 0) {
            this.updateString(index, null);
        }
        StringBuffer value = new StringBuffer(length);
        char[] buffer = new char[1024];
        try {
            int bytes;
            while ((bytes = reader.read(buffer, 0, buffer.length)) != -1) {
                void var6_6;
                value.append(buffer, 0, (int)var6_6);
            }
        }
        catch (IOException e) {
            throw new SQLException("Error reading stream: " + e.getMessage());
        }
        this.updateString(index, value.toString());
    }

    public void updateObject(int index, Object x, int scale) throws SQLException {
        if (x instanceof BigDecimal) {
            f.setMaximumFractionDigits(scale);
            this.updateObject(index, (Object)((BigDecimal)x).setScale(scale));
        } else if (x instanceof Number) {
            f.setMaximumFractionDigits(scale);
            this.updateObject(index, (Object)f.format(x));
        } else {
            this.updateObject(index, x);
        }
    }

    public void updateObject(int index, Object x) throws SQLException {
        this.currentRow().setElementAt(index, x);
    }

    public void updateRef(int param, Ref ref) throws SQLException {
        throw new SQLException("Not Implemented");
    }

    public void updateRef(String columnName, Ref ref) throws SQLException {
        this.updateRef(this.findColumn(columnName), ref);
    }

    public void updateClob(int param, Clob clob) throws SQLException {
        this.updateCharacterStream(param, clob.getCharacterStream(), (int)clob.length());
    }

    public void updateClob(String columnName, Clob clob) throws SQLException {
        this.updateClob(this.findColumn(columnName), clob);
    }

    public void updateBlob(String columnName, Blob blob) throws SQLException {
        this.updateBlob(this.findColumn(columnName), blob);
    }

    public void updateBlob(int param, Blob blob) throws SQLException {
        this.updateBinaryStream(param, blob.getBinaryStream(), (int)blob.length());
    }

    public void updateArray(String columnName, Array array) throws SQLException {
        this.updateArray(this.findColumn(columnName), array);
    }

    public void updateArray(int param, Array array) throws SQLException {
        throw new SQLException("Not Implemented");
    }

    public URL getURL(String columnName) throws SQLException {
        return this.getURL(this.findColumn(columnName));
    }

    public URL getURL(int param) throws SQLException {
        throw new SQLException("Not Implemented");
    }
}

