/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.util.Iterator;
import java.util.TreeMap;
import org.apache.poi.hssf.model.Sheet;
import org.apache.poi.hssf.model.Workbook;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.RowRecord;
import org.apache.poi.hssf.record.VCenterRecord;
import org.apache.poi.hssf.record.WSBoolRecord;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.util.Region;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public class HSSFSheet {
    private static final int DEBUG = 1;
    public static final int INITIAL_CAPACITY = 20;
    private Sheet sheet;
    private TreeMap rows;
    private Workbook book;
    private int firstrow;
    private int lastrow;
    private static POILogger log = POILogFactory.getLogger(class$org$apache$poi$hssf$usermodel$HSSFSheet == null ? (class$org$apache$poi$hssf$usermodel$HSSFSheet = HSSFSheet.class$("org.apache.poi.hssf.usermodel.HSSFSheet")) : class$org$apache$poi$hssf$usermodel$HSSFSheet);
    static /* synthetic */ Class class$org$apache$poi$hssf$usermodel$HSSFSheet;

    protected HSSFSheet(Workbook book) {
        this.sheet = Sheet.createSheet();
        this.rows = new TreeMap();
        this.book = book;
    }

    protected HSSFSheet(Workbook book, Sheet sheet) {
        this.sheet = sheet;
        this.rows = new TreeMap();
        this.book = book;
        this.setPropertiesFromSheet(sheet);
    }

    private void setPropertiesFromSheet(Sheet sheet) {
        int sloc = sheet.getLoc();
        RowRecord row = sheet.getNextRow();
        while (row != null) {
            this.createRowFromRecord(row);
            row = sheet.getNextRow();
        }
        sheet.setLoc(sloc);
        CellValueRecordInterface cval = sheet.getNextValueRecord();
        long timestart = System.currentTimeMillis();
        log.log(1, (Object)"Time at start of cell creating in HSSF sheet = ", new Long(timestart));
        HSSFRow lastrow = null;
        while (cval != null) {
            long cellstart = System.currentTimeMillis();
            HSSFRow hrow = lastrow;
            if (lastrow == null || lastrow.getRowNum() != cval.getRow()) {
                hrow = this.getRow(cval.getRow());
            }
            lastrow = hrow;
            hrow.createCellFromRecord(cval);
            cval = sheet.getNextValueRecord();
            log.log(1, (Object)"record took ", new Long(System.currentTimeMillis() - cellstart));
        }
        log.log(1, (Object)"total sheet cell creation took ", new Long(System.currentTimeMillis() - timestart));
    }

    public HSSFRow createRow(short rownum) {
        HSSFRow row = new HSSFRow(this.book, this.sheet, rownum);
        this.addRow(row, true);
        return row;
    }

    private HSSFRow createRowFromRecord(RowRecord row) {
        HSSFRow hrow = new HSSFRow(this.book, this.sheet, row);
        this.addRow(hrow, false);
        return hrow;
    }

    public void removeRow(HSSFRow row) {
        this.sheet.setLoc(this.sheet.getDimsLoc());
        if (this.rows.size() > 0) {
            this.rows.remove(row);
            if (row.getRowNum() == this.getLastRowNum()) {
                this.lastrow = this.findLastRow(this.lastrow);
            }
            if (row.getRowNum() == this.getFirstRowNum()) {
                this.firstrow = this.findFirstRow(this.firstrow);
            }
            Iterator iter = row.cellIterator();
            while (iter.hasNext()) {
                HSSFCell cell = (HSSFCell)iter.next();
                this.sheet.removeValueRecord(row.getRowNum(), cell.getCellValueRecord());
            }
            this.sheet.removeRow(row.getRowRecord());
        }
    }

    private int findLastRow(int lastrow) {
        int rownum = lastrow - 1;
        HSSFRow r = this.getRow(rownum);
        while (r == null && rownum >= 0) {
            r = this.getRow(--rownum);
        }
        return rownum;
    }

    private int findFirstRow(int firstrow) {
        int rownum = firstrow + 1;
        HSSFRow r = this.getRow(rownum);
        while (r == null && rownum <= this.getLastRowNum()) {
            r = this.getRow(++rownum);
        }
        if (rownum > this.getLastRowNum()) {
            return -1;
        }
        return rownum;
    }

    private void addRow(HSSFRow row, boolean addLow) {
        this.rows.put(row, row);
        if (addLow) {
            this.sheet.addRow(row.getRowRecord());
        }
        if (row.getRowNum() > this.getLastRowNum()) {
            this.lastrow = row.getRowNum();
        }
        if (row.getRowNum() < this.getFirstRowNum()) {
            this.firstrow = row.getRowNum();
        }
    }

    public HSSFRow getRow(int rownum) {
        HSSFRow row = new HSSFRow();
        row.setRowNum((short)rownum);
        return (HSSFRow)this.rows.get(row);
    }

    public int getPhysicalNumberOfRows() {
        return this.rows.size();
    }

    public int getFirstRowNum() {
        return this.firstrow;
    }

    public int getLastRowNum() {
        return this.lastrow;
    }

    public void setColumnWidth(short column, short width) {
        this.sheet.setColumnWidth(column, width);
    }

    public short getColumnWidth(short column) {
        return this.sheet.getColumnWidth(column);
    }

    public short getDefaultColumnWidth() {
        return this.sheet.getDefaultColumnWidth();
    }

    public short getDefaultRowHeight() {
        return this.sheet.getDefaultRowHeight();
    }

    public float getDefaultRowHeightInPoints() {
        return this.sheet.getDefaultRowHeight() / 20;
    }

    public void setDefaultColumnWidth(short width) {
        this.sheet.setDefaultColumnWidth(width);
    }

    public void setDefaultRowHeight(short height) {
        this.sheet.setDefaultRowHeight(height);
    }

    public void setDefaultRowHeightInPoints(float height) {
        this.sheet.setDefaultRowHeight((short)(height * 20.0f));
    }

    public boolean isGridsPrinted() {
        return this.sheet.isGridsPrinted();
    }

    public void setGridsPrinted(boolean value) {
        this.sheet.setGridsPrinted(value);
    }

    public int addMergedRegion(Region region) {
        return this.sheet.addMergedRegion((short)region.getRowFrom(), region.getColumnFrom(), (short)region.getRowTo(), region.getColumnTo());
    }

    public void setVerticallyCenter(boolean value) {
        VCenterRecord record = (VCenterRecord)this.sheet.findFirstRecordBySid((short)132);
        record.setVCenter(value);
    }

    public boolean getVerticallyCenter(boolean value) {
        VCenterRecord record = (VCenterRecord)this.sheet.findFirstRecordBySid((short)132);
        return record.getVCenter();
    }

    public void removeMergedRegion(int index) {
        this.sheet.removeMergedRegion(index);
    }

    public int getNumMergedRegions() {
        return this.sheet.getNumMergedRegions();
    }

    public Region getMergedRegionAt(int index) {
        return new Region(this.sheet.getMergedRegionAt(index));
    }

    public Iterator rowIterator() {
        return this.rows.values().iterator();
    }

    protected Sheet getSheet() {
        return this.sheet;
    }

    public void setAlternativeExpression(boolean b) {
        WSBoolRecord record = (WSBoolRecord)this.sheet.findFirstRecordBySid((short)129);
        record.setAlternateExpression(b);
    }

    public void setAlternativeFormula(boolean b) {
        WSBoolRecord record = (WSBoolRecord)this.sheet.findFirstRecordBySid((short)129);
        record.setAlternateFormula(b);
    }

    public void setAutobreaks(boolean b) {
        WSBoolRecord record = (WSBoolRecord)this.sheet.findFirstRecordBySid((short)129);
        record.setAutobreaks(b);
    }

    public void setDialog(boolean b) {
        WSBoolRecord record = (WSBoolRecord)this.sheet.findFirstRecordBySid((short)129);
        record.setDialog(b);
    }

    public void setDisplayGuts(boolean b) {
        WSBoolRecord record = (WSBoolRecord)this.sheet.findFirstRecordBySid((short)129);
        record.setDisplayGuts(b);
    }

    public void setFitToPage(boolean b) {
        WSBoolRecord record = (WSBoolRecord)this.sheet.findFirstRecordBySid((short)129);
        record.setFitToPage(b);
    }

    public void setRowSumsBelow(boolean b) {
        WSBoolRecord record = (WSBoolRecord)this.sheet.findFirstRecordBySid((short)129);
        record.setRowSumsBelow(b);
    }

    public void setRowSumsRight(boolean b) {
        WSBoolRecord record = (WSBoolRecord)this.sheet.findFirstRecordBySid((short)129);
        record.setRowSumsRight(b);
    }

    public boolean getAlternateExpression() {
        return ((WSBoolRecord)this.sheet.findFirstRecordBySid((short)129)).getAlternateExpression();
    }

    public boolean getAlternateFormula() {
        return ((WSBoolRecord)this.sheet.findFirstRecordBySid((short)129)).getAlternateFormula();
    }

    public boolean getAutobreaks() {
        return ((WSBoolRecord)this.sheet.findFirstRecordBySid((short)129)).getAutobreaks();
    }

    public boolean getDialog() {
        return ((WSBoolRecord)this.sheet.findFirstRecordBySid((short)129)).getDialog();
    }

    public boolean getDisplayGuts() {
        return ((WSBoolRecord)this.sheet.findFirstRecordBySid((short)129)).getDisplayGuts();
    }

    public boolean getFitToPage() {
        return ((WSBoolRecord)this.sheet.findFirstRecordBySid((short)129)).getFitToPage();
    }

    public boolean getRowSumsBelow() {
        return ((WSBoolRecord)this.sheet.findFirstRecordBySid((short)129)).getRowSumsBelow();
    }

    public boolean getRowSumsRight() {
        return ((WSBoolRecord)this.sheet.findFirstRecordBySid((short)129)).getRowSumsRight();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

