/*
 * NumberDocument.java
 *
 * iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 * Created on 10 febbraio 2003, 0.17
 */

package it.businesslogic.ireport.gui;

import javax.swing.text.*;
import java.text.*;
/**
 *
 * @author  Administrator
 */
public class NumberDocument extends javax.swing.text.PlainDocument {
    private char groupingSeparator = ',';
    private char decimalSeparator = '.';
    
    
    /** Creates a new instance of NumberDocument */
    public NumberDocument() {
        
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        groupingSeparator = dfs.getGroupingSeparator();
        decimalSeparator = dfs.getDecimalSeparator();
     }
    
    /** Inserts some content into the document.
     * Inserting content causes a write lock to be held while the
     * actual changes are taking place, followed by notification
     * to the observers on the thread that grabbed the write lock.
     * <p>
     * This method is thread safe, although most Swing methods
     * are not. Please see
     * <A HREF="http://java.sun.com/products/jfc/swingdoc-archive/threads.html">Threads
     * and Swing</A> for more information.
     *
     * @param offs the starting offset >= 0
     * @param str the string to insert; does nothing with null/empty strings
     * @param a the attributes for the inserted content
     * @exception BadLocationException  the given insert position is not a valid
     *   position within the document
     * @see Document#insertString
     *
     */
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {

        String currentText = getText(0, getLength());
        String beforeOffset = currentText.substring(0, offs);
        String afterOffset = currentText.substring(offs, currentText.length());
        String proposedResult = beforeOffset + str + afterOffset;

        proposedResult = proposedResult.replaceAll("\\"+groupingSeparator+"","");
        proposedResult = proposedResult.replace(decimalSeparator, '.');
        
        try {
            //Number n = format.parse(proposedResult);
            Double.parseDouble(proposedResult);
            
            super.insertString(offs, str, a);
        } catch (NumberFormatException e) {
            //System.err.println("insertString: could not parse: "
            //                   + proposedResult);
        }
        
    }
    
     public void remove(int offs, int len) throws BadLocationException {
        String currentText = getText(0, getLength());
        String beforeOffset = currentText.substring(0, offs);
        String afterOffset = currentText.substring(len + offs,
                                                   currentText.length());
        String proposedResult = beforeOffset + afterOffset;

        proposedResult = proposedResult.replaceAll("\\"+groupingSeparator+"","");
        proposedResult = proposedResult.replace(decimalSeparator, '.');
        
       try {
            //Number n = format.parse(proposedResult);
           if (proposedResult.length() != 0)
                Double.parseDouble(proposedResult);
            
            super.remove(offs, len);
        } catch (NumberFormatException e) {
           // System.err.println("remove: could not parse: " + proposedResult);
        }
    }
}
