/*
 * JNumberComboBox.java
 *
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 * Created on 15 febbraio 2003, 10.31
 */

package it.businesslogic.ireport.gui;
import it.businesslogic.ireport.gui.event.*;
import javax.swing.*;
import java.awt.event.*;
import java.util.*;
import java.text.*;
/**
 *  This class is designed for the zoom combo box.
 *  It stores a vector of predefined values (see the inner class NumberEntry),
 *  added from the program using  addEntry(String name, double value) method.
 *  The user can insert manually a value. It is interpreted using NumberFormat.
 *  (max fraction digits used:  2) 
 *  The value is valuated on focus lost....
 *  
 * @author  Giulio Toffoli
 */
public class JNumberComboBox extends JComboBox implements KeyListener, ActionListener, FocusListener {
    
    private NumberFormat numberFormat = null;
    private Vector entries;    
        
    private double value;
    
    private double minValue;
    
    private double maxValue;
    
    /** Utility field used by event firing mechanism. */
    private javax.swing.event.EventListenerList listenerList =  null;
    
    private String postfix="";
    
    /** Creates a new instance of JNumberComboBox */
    public JNumberComboBox() {     
      
        super();
        entries = new Vector();
       this.setFocusCycleRoot(false);
       numberFormat = NumberFormat.getNumberInstance();
       numberFormat.setMinimumFractionDigits(0);
       numberFormat.setMaximumFractionDigits(2);
       this.setEditable(true);
       
       // this code solve sun Metal Bug Id  4137675 
       // Attention, this.setEditable(true); must be call before!!!
       for (int i=0; i<this.getComponentCount(); i++) {
           //System.out.println("Register to: "+ this.getComponent(i).getClass());
                this.getComponent(i).addFocusListener(this);
        }

       this.addFocusListener(this);
       this.addKeyListener(this);
       this.addActionListener(this);      
    }
    
    public void addEntry(String name, double value)
    {
        // If this entry name already exists, we change the value...
        Enumeration enum = entries.elements();
        while (enum.hasMoreElements())
        {
            NumberEntry ne = (NumberEntry)enum.nextElement();
            if (ne.name.equals(name))
            {
                ne.value = value;
                return;
            }
        }
        NumberEntry entry = new NumberEntry(name,value);
        this.addItem(entry);
        this.entries.addElement(entry);
    }
    
    public void actionPerformed(ActionEvent e)
    {
        super.actionPerformed(e);  
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex > -1)
        {
            if (((NumberEntry)getSelectedItem()).value != value)
            {
                
                double oldValue = this.value;
                this.value = ((NumberEntry)getSelectedItem()).value;
                fireValueChangedListenerValueChanged(new ValueChangedEvent((JComponent)this, oldValue, this.value));
                
            }
            this.setSelectedItem( numberFormat.format( value ) +getPostfix());  
        }
    }
    
    /** Invoked when a key has been pressed.
     * See the class description for {@link KeyEvent} for a definition of
     * a key pressed event.
     *
     */
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == e.VK_ENTER)
        {
               
        }
    }
    
    /** Invoked when a key has been released.
     * See the class description for {@link KeyEvent} for a definition of
     * a key released event.
     *
     */
    public void keyReleased(KeyEvent e) {
    }
    
    /** Invoked when a key has been typed.
     * See the class description for {@link KeyEvent} for a definition of
     * a key typed event.
     *
     */
    public void keyTyped(KeyEvent e) {
    }
    
    /** Invoked when a component gains the keyboard focus.
     *
     */
    public void focusGained(FocusEvent e) {
    }
    
    /** Invoked when a component loses the keyboard focus.
     *
     */
    public void focusLost(FocusEvent e) {
        try {
                Number num = numberFormat.parse( ""+ this.getSelectedItem());
           
                 if (num.doubleValue() != value)
                {
                    double oldValue = this.value;
                    this.value = num.doubleValue(); 
                    fireValueChangedListenerValueChanged(new ValueChangedEvent(this, oldValue, this.value));
                }
            } catch (Exception ex)
            { 
                System.out.println(ex.getMessage());
            }           
            this.setSelectedItem( numberFormat.format( value )+getPostfix() );
    }
    
    /** Getter for property minValue.
     * @return Value of property minValue.
     *
     */
    public double getMinValue() {
        return minValue;
    }
    
    /** Setter for property minValue.
     * @param minValue New value of property minValue.
     *
     */
    public void setMinValue(double minValue) {
        this.minValue = minValue;
    }
    
    /** Getter for property maxValue.
     * @return Value of property maxValue.
     *
     */
    public double getMaxValue() {
        return maxValue;
    }
    
    /** Setter for property maxValue.
     * @param maxValue New value of property maxValue.
     *
     */
    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }
    
    /** Getter for property value.
     * @return Value of property value.
     *
     */
    public double getValue() {
        return value;
    }
    
    /** Setter for property value.
     * @param value New value of property value.
     *
     */
    public void setValue(double value) {    
        if (this.value != value)
        {
            double oldValue = this.value;
            this.value = value;
            fireValueChangedListenerValueChanged(new ValueChangedEvent(this, oldValue, this.value));
        }
        this.setSelectedItem( numberFormat.format( this.value )+getPostfix() );
    }
    
    /** Registers ValueChangedListener to receive events.
     * @param listener The listener to register.
     *
     */
    public synchronized void addValueChangedListener(it.businesslogic.ireport.gui.event.ValueChangedListener listener) {
        if (listenerList == null ) {
            listenerList = new javax.swing.event.EventListenerList();
        }
        listenerList.add(it.businesslogic.ireport.gui.event.ValueChangedListener.class, listener);
    }
    
    /** Removes ValueChangedListener from the list of listeners.
     * @param listener The listener to remove.
     *
     */
    public synchronized void removeValueChangedListener(it.businesslogic.ireport.gui.event.ValueChangedListener listener) {
        listenerList.remove(it.businesslogic.ireport.gui.event.ValueChangedListener.class, listener);
    }
    
    /** Notifies all registered listeners about the event.
     *
     * @param event The event to be fired
     *
     */
    private void fireValueChangedListenerValueChanged(it.businesslogic.ireport.gui.event.ValueChangedEvent event) {
        if (listenerList == null) return;
        Object[] listeners = listenerList.getListenerList();
        for (int i = listeners.length-2; i>=0; i-=2) {
            if (listeners[i]==it.businesslogic.ireport.gui.event.ValueChangedListener.class) {
                ((it.businesslogic.ireport.gui.event.ValueChangedListener)listeners[i+1]).valueChanged(event);
            }
        }
    }
    
    /** Getter for property postfix.
     * @return Value of property postfix.
     *
     */
    public java.lang.String getPostfix() {
        return postfix;
    }
    
    /** Setter for property postfix.
     * @param postfix New value of property postfix.
     *
     */
    public void setPostfix(java.lang.String postfix) {
        this.postfix = postfix;
    }
    
}

class NumberEntry {
    public String name="";
    public double value=0.0;
    
    public String toString()
    {
        return name;
    }
    
    public NumberEntry( String name, double value)
    {
        this.name  = name;
        this.value = value;
    }
}
