/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.engine.fill;

import dori.jasper.engine.JRElement;
import dori.jasper.engine.JRException;
import dori.jasper.engine.JRGraphicElement;
import dori.jasper.engine.fill.JRBaseFiller;
import dori.jasper.engine.fill.JRFillElement;
import java.util.Map;

public abstract class JRFillGraphicElement
extends JRFillElement
implements JRGraphicElement {
    private JRElement topElementInGroup = null;
    private JRElement bottomElementInGroup = null;

    protected JRFillGraphicElement(JRBaseFiller filler, JRGraphicElement graphicElement, Map fillObjectsMap) {
        super(filler, graphicElement, fillObjectsMap);
    }

    public byte getStretchType() {
        return ((JRGraphicElement)this.parent).getStretchType();
    }

    public void setStretchType(byte stretchType) {
    }

    public byte getPen() {
        return ((JRGraphicElement)this.parent).getPen();
    }

    public void setPen(byte pen) {
    }

    public byte getFill() {
        return ((JRGraphicElement)this.parent).getFill();
    }

    public void setFill(byte fill) {
    }

    public void rewind() throws JRException {
    }

    protected boolean prepare(int availableStretchHeight, boolean isOverflow) throws JRException {
        boolean willOverflow = false;
        super.prepare(availableStretchHeight, isOverflow);
        if (!this.isToPrint()) {
            return willOverflow;
        }
        boolean isToPrint = true;
        boolean isReprinted = false;
        if (isOverflow && this.isAlreadyPrinted() && !this.isPrintWhenDetailOverflows()) {
            isToPrint = false;
        }
        if (!(!isToPrint || !this.isPrintWhenExpressionNull() || this.isPrintRepeatedValues() || this.isPrintInFirstWholeBand() && this.getBand().isNewPageColumn() || this.getPrintWhenGroupChanges() != null && this.getBand().isNewGroup(this.getPrintWhenGroupChanges()) || isOverflow && this.isPrintWhenDetailOverflows())) {
            isToPrint = false;
        }
        if (isToPrint && availableStretchHeight < this.getRelativeY() - this.getY() - this.getBandBottomY()) {
            isToPrint = false;
            willOverflow = true;
        }
        if (isToPrint && isOverflow && this.isPrintWhenDetailOverflows() && (this.isAlreadyPrinted() || !this.isAlreadyPrinted() && !this.isPrintRepeatedValues())) {
            isReprinted = true;
        }
        this.setToPrint(isToPrint);
        this.setReprinted(isReprinted);
        return willOverflow;
    }

    protected void stretchElement(int bandStretch) throws JRException {
        switch (this.getStretchType()) {
            case 2: {
                this.setStretchHeight(this.getHeight() + bandStretch);
                break;
            }
            case 1: {
                if (this.elementGroup == null) break;
                this.setStretchHeight(this.getHeight() + this.getStretchHeightDiff());
                break;
            }
        }
    }

    private void setTopBottomElements() {
        JRElement[] elements;
        if (this.elementGroup != null && (elements = this.elementGroup.getElements()) != null && elements.length > 0) {
            int i = 0;
            while (i < elements.length) {
                if (elements[i] != this) {
                    if (this.topElementInGroup == null || this.topElementInGroup != null && elements[i].getY() + elements[i].getHeight() < this.topElementInGroup.getY() + this.topElementInGroup.getHeight()) {
                        this.topElementInGroup = elements[i];
                    }
                    if (this.bottomElementInGroup == null || this.bottomElementInGroup != null && elements[i].getY() + elements[i].getHeight() > this.bottomElementInGroup.getY() + this.bottomElementInGroup.getHeight()) {
                        this.bottomElementInGroup = elements[i];
                    }
                }
                ++i;
            }
        }
        if (this.topElementInGroup == null) {
            this.topElementInGroup = this;
        }
        if (this.bottomElementInGroup == null) {
            this.bottomElementInGroup = this;
        }
    }

    private int getStretchHeightDiff() {
        int diff;
        JRElement[] elements;
        if (this.topElementInGroup == null) {
            this.setTopBottomElements();
        }
        JRFillElement topElem = null;
        JRFillElement bottomElem = null;
        if (this.elementGroup != null && (elements = this.elementGroup.getElements()) != null && elements.length > 0) {
            JRFillElement element = null;
            int i = 0;
            while (i < elements.length) {
                element = (JRFillElement)elements[i];
                if (element != this && element.isToPrint()) {
                    if (topElem == null || topElem != null && element.getRelativeY() + element.getStretchHeight() < topElem.getRelativeY() + topElem.getStretchHeight()) {
                        topElem = element;
                    }
                    if (bottomElem == null || bottomElem != null && element.getRelativeY() + element.getStretchHeight() > bottomElem.getRelativeY() + bottomElem.getStretchHeight()) {
                        bottomElem = element;
                    }
                }
                ++i;
            }
        }
        if (topElem == null) {
            topElem = this;
        }
        if (bottomElem == null) {
            bottomElem = this;
        }
        if ((diff = bottomElem.getRelativeY() + bottomElem.getStretchHeight() - topElem.getRelativeY() - (this.bottomElementInGroup.getY() + this.bottomElementInGroup.getHeight() - this.topElementInGroup.getY())) < 0) {
            diff = 0;
        }
        return diff;
    }
}

