/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.engine.export;

import dori.jasper.engine.JRAbstractExporter;
import dori.jasper.engine.JRException;
import dori.jasper.engine.JRExporterParameter;
import dori.jasper.engine.JRPrintElement;
import dori.jasper.engine.JRPrintPage;
import dori.jasper.engine.JRPrintText;
import dori.jasper.engine.JasperPrint;
import dori.jasper.engine.export.JRCsvExporterParameter;
import dori.jasper.engine.export.JRExporterGridCell;
import dori.jasper.engine.export.JRXmlExporterParameter;
import dori.jasper.engine.util.JRLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class JRCsvExporter
extends JRAbstractExporter {
    private JasperPrint jasperPrint = null;
    private String delimiter = null;
    private Writer writer = null;
    private JRExporterGridCell[][] grid = null;
    private boolean[] isRowUsed = null;
    private boolean[] isColUsed = null;
    private List xCuts = null;
    private List yCuts = null;

    public void exportReport() throws JRException {
        StringBuffer sb;
        String encoding;
        this.jasperPrint = (JasperPrint)this.parameters.get(JRExporterParameter.JASPER_PRINT);
        if (this.jasperPrint == null) {
            InputStream is = (InputStream)this.parameters.get(JRExporterParameter.INPUT_STREAM);
            if (is != null) {
                this.jasperPrint = (JasperPrint)JRLoader.loadObject(is);
            } else {
                URL url = (URL)this.parameters.get(JRExporterParameter.INPUT_URL);
                if (url != null) {
                    this.jasperPrint = (JasperPrint)JRLoader.loadObject(url);
                } else {
                    File file = (File)this.parameters.get(JRExporterParameter.INPUT_FILE);
                    if (file != null) {
                        this.jasperPrint = (JasperPrint)JRLoader.loadObject(file);
                    } else {
                        String fileName = (String)this.parameters.get(JRExporterParameter.INPUT_FILE_NAME);
                        if (fileName != null) {
                            this.jasperPrint = (JasperPrint)JRLoader.loadObject(fileName);
                        } else {
                            throw new JRException("No input source supplied to the exporter.");
                        }
                    }
                }
            }
        }
        if ((encoding = (String)this.parameters.get(JRExporterParameter.CHARACTER_ENCODING)) == null) {
            encoding = "ISO-8859-1";
        }
        this.delimiter = (String)this.parameters.get(JRCsvExporterParameter.FIELD_DELIMITER);
        if (this.delimiter == null) {
            this.delimiter = ",";
        }
        if ((sb = (StringBuffer)this.parameters.get(JRXmlExporterParameter.OUTPUT_STRING_BUFFER)) != null) {
            try {
                this.writer = new StringWriter();
                this.exportReportToWriter();
                sb.append(this.writer.toString());
                this.writer.close();
            }
            catch (IOException e) {
                throw new JRException("Error writing to StringBuffer writer : " + this.jasperPrint.getName(), e);
            }
        }
        this.writer = (Writer)this.parameters.get(JRExporterParameter.OUTPUT_WRITER);
        if (this.writer != null) {
            try {
                this.exportReportToWriter();
            }
            catch (IOException e) {
                throw new JRException("Error writing to writer : " + this.jasperPrint.getName(), e);
            }
        }
        OutputStream os = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
        if (os != null) {
            try {
                this.writer = new OutputStreamWriter(os, encoding);
                this.exportReportToWriter();
            }
            catch (IOException e) {
                throw new JRException("Error writing to OutputStream writer : " + this.jasperPrint.getName(), e);
            }
        }
        File destFile = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
        if (destFile == null) {
            String fileName = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
            if (fileName != null) {
                destFile = new File(fileName);
            } else {
                throw new JRException("No output specified for the exporter.");
            }
        }
        try {
            os = new FileOutputStream(destFile);
            this.writer = new OutputStreamWriter(os, encoding);
            this.exportReportToWriter();
            this.writer.close();
        }
        catch (IOException e) {
            throw new JRException("Error writing to file writer : " + this.jasperPrint.getName(), e);
        }
    }

    private void exportReportToWriter() throws JRException, IOException {
        List pages = this.jasperPrint.getPages();
        if (pages != null && pages.size() > 0) {
            JRPrintPage page = null;
            int i = 0;
            while (i < pages.size()) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new JRException("Current thread interrupted.");
                }
                page = (JRPrintPage)pages.get(i);
                this.exportPage(page);
                ++i;
            }
        }
        this.writer.flush();
    }

    private void exportPage(JRPrintPage page) throws JRException, IOException {
        this.layoutGrid(page);
        StringBuffer rowbuffer = null;
        JRPrintElement element = null;
        String text = null;
        boolean isFirstColumn = true;
        int y = 0;
        while (y < this.grid.length) {
            rowbuffer = new StringBuffer();
            if (this.isRowUsed[y]) {
                isFirstColumn = true;
                int x = 0;
                while (x < this.grid[y].length) {
                    if (this.grid[y][x].element != null) {
                        element = this.grid[y][x].element;
                        if (element instanceof JRPrintText) {
                            text = ((JRPrintText)element).getText();
                            if (text == null) {
                                text = "";
                            }
                            if (!isFirstColumn) {
                                rowbuffer.append(this.delimiter);
                            }
                            rowbuffer.append(this.prepareText(text));
                            isFirstColumn = false;
                        }
                    } else if (this.isColUsed[x]) {
                        if (!isFirstColumn) {
                            rowbuffer.append(this.delimiter);
                        }
                        isFirstColumn = false;
                    }
                    ++x;
                }
                if (rowbuffer.length() > 0) {
                    this.writer.write(rowbuffer.toString());
                    this.writer.write("\n");
                }
            }
            ++y;
        }
    }

    private void layoutGrid(JRPrintPage page) {
        this.xCuts = new ArrayList();
        this.yCuts = new ArrayList();
        this.xCuts.add(new Integer(0));
        this.xCuts.add(new Integer(this.jasperPrint.getPageWidth()));
        this.yCuts.add(new Integer(0));
        this.yCuts.add(new Integer(this.jasperPrint.getPageWidth()));
        Integer x = null;
        Integer y = null;
        List elems = page.getElements();
        Iterator it = elems.iterator();
        while (it.hasNext()) {
            JRPrintElement element = (JRPrintElement)it.next();
            if (!(element instanceof JRPrintText)) continue;
            x = new Integer(element.getX());
            if (!this.xCuts.contains(x)) {
                this.xCuts.add(x);
            }
            if (!this.xCuts.contains(x = new Integer(element.getX() + element.getWidth()))) {
                this.xCuts.add(x);
            }
            if (!this.yCuts.contains(y = new Integer(element.getY()))) {
                this.yCuts.add(y);
            }
            if (this.yCuts.contains(y = new Integer(element.getY() + element.getHeight()))) continue;
            this.yCuts.add(y);
        }
        Collections.sort(this.xCuts);
        Collections.sort(this.yCuts);
        int xCellCount = this.xCuts.size() - 1;
        int yCellCount = this.yCuts.size() - 1;
        this.grid = new JRExporterGridCell[yCellCount][xCellCount];
        this.isRowUsed = new boolean[yCellCount];
        this.isColUsed = new boolean[xCellCount];
        int j = 0;
        while (j < yCellCount) {
            int i = 0;
            while (i < xCellCount) {
                this.grid[j][i] = new JRExporterGridCell(null, (Integer)this.xCuts.get(i + 1) - (Integer)this.xCuts.get(i), (Integer)this.yCuts.get(j + 1) - (Integer)this.yCuts.get(j), 1, 1);
                ++i;
            }
            ++j;
        }
        int x1 = 0;
        int y1 = 0;
        int x2 = 0;
        int y2 = 0;
        Iterator it2 = elems.iterator();
        while (it2.hasNext()) {
            JRPrintElement element = (JRPrintElement)it2.next();
            if (!(element instanceof JRPrintText)) continue;
            x1 = this.xCuts.indexOf(new Integer(element.getX()));
            y1 = this.yCuts.indexOf(new Integer(element.getY()));
            x2 = this.xCuts.indexOf(new Integer(element.getX() + element.getWidth()));
            y2 = this.yCuts.indexOf(new Integer(element.getY() + element.getHeight()));
            this.grid[y1][x1].element = element;
            this.grid[y1][x1].width = element.getWidth();
            this.grid[y1][x1].height = element.getHeight();
            this.grid[y1][x1].colSpan = x2 - x1;
            this.grid[y1][x1].rowSpan = y2 - y1;
            this.isRowUsed[y1] = true;
            this.isColUsed[x1] = true;
        }
    }

    private String prepareText(String source) {
        String str = null;
        if (source != null) {
            boolean putQuotes = false;
            if (source.indexOf(this.delimiter) >= 0) {
                putQuotes = true;
            }
            StringBuffer sbuffer = new StringBuffer();
            StringTokenizer tkzer = new StringTokenizer(source, ",\"\n", true);
            String token = null;
            while (tkzer.hasMoreTokens()) {
                token = tkzer.nextToken();
                if (",".equals(token)) {
                    putQuotes = true;
                    sbuffer.append(",");
                    continue;
                }
                if ("\"".equals(token)) {
                    putQuotes = true;
                    sbuffer.append("\"\"");
                    continue;
                }
                if ("\n".equals(token)) {
                    sbuffer.append(" ");
                    continue;
                }
                sbuffer.append(token);
            }
            str = sbuffer.toString();
            if (putQuotes) {
                str = "\"" + str + "\"";
            }
        }
        return str;
    }
}

