/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.engine.data;

import dori.jasper.engine.JRException;
import dori.jasper.engine.JRField;
import dori.jasper.engine.JRRewindableDataSource;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class JRTableModelDataSource
implements JRRewindableDataSource {
    private TableModel tableModel = null;
    private int index = -1;
    private HashMap columnNames = new HashMap();

    public JRTableModelDataSource(TableModel model) {
        this.tableModel = model;
        if (this.tableModel != null) {
            int i = 0;
            while (i < this.tableModel.getColumnCount()) {
                this.columnNames.put(this.tableModel.getColumnName(i), new Integer(i));
                ++i;
            }
        }
    }

    public boolean next() throws JRException {
        ++this.index;
        if (this.tableModel != null) {
            return this.index < this.tableModel.getRowCount();
        }
        return false;
    }

    public Object getFieldValue(JRField jrField) throws JRException {
        String fieldName = jrField.getName();
        Integer columnIndex = (Integer)this.columnNames.get(fieldName);
        if (columnIndex != null) {
            return this.tableModel.getValueAt(this.index, columnIndex);
        }
        if (fieldName.startsWith("COLUMN_")) {
            return this.tableModel.getValueAt(this.index, Integer.parseInt(fieldName.substring(7)));
        }
        throw new JRException("Unknown column name : " + fieldName);
    }

    public void moveFirst() throws JRException {
        this.index = -1;
    }
}

