/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.tooltips;

import java.io.Serializable;
import java.text.NumberFormat;
import org.jfree.chart.tooltips.XYToolTipGenerator;
import org.jfree.data.XYDataset;

public class StandardXYToolTipGenerator
implements XYToolTipGenerator,
Serializable {
    private NumberFormat xFormat;
    private NumberFormat yFormat;

    public StandardXYToolTipGenerator() {
        this(NumberFormat.getNumberInstance(), NumberFormat.getNumberInstance());
    }

    public StandardXYToolTipGenerator(NumberFormat numberFormat, NumberFormat numberFormat2) {
        this.xFormat = numberFormat;
        this.yFormat = numberFormat2;
    }

    public NumberFormat getXFormat() {
        return this.xFormat;
    }

    public NumberFormat getYFormat() {
        return this.yFormat;
    }

    public String generateToolTip(XYDataset xYDataset, int n, int n2) {
        String string = xYDataset.getSeriesName(n) + ": ";
        Number number = xYDataset.getXValue(n, n2);
        string = string + "x: " + this.xFormat.format(number);
        Number number2 = xYDataset.getYValue(n, n2);
        string = number2 != null ? string + ", y: " + this.yFormat.format(number2) : string + ", y: null";
        return string;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof StandardXYToolTipGenerator) {
            StandardXYToolTipGenerator standardXYToolTipGenerator = (StandardXYToolTipGenerator)object;
            return this.xFormat.equals(standardXYToolTipGenerator.getXFormat()) && this.yFormat.equals(standardXYToolTipGenerator.getYFormat());
        }
        return false;
    }
}

