/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.tooltips;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import org.jfree.chart.tooltips.XYToolTipGenerator;
import org.jfree.data.HighLowDataset;
import org.jfree.data.XYDataset;

public class HighLowToolTipGenerator
implements XYToolTipGenerator,
Serializable {
    private DateFormat dateFormatter;

    public HighLowToolTipGenerator() {
        this(DateFormat.getInstance());
    }

    public HighLowToolTipGenerator(DateFormat dateFormat) {
        this.dateFormatter = dateFormat;
    }

    public String generateToolTip(XYDataset xYDataset, int n, int n2) {
        String string = null;
        if (xYDataset instanceof HighLowDataset) {
            HighLowDataset highLowDataset = (HighLowDataset)xYDataset;
            Number number = highLowDataset.getHighValue(n, n2);
            Number number2 = highLowDataset.getLowValue(n, n2);
            Number number3 = highLowDataset.getOpenValue(n, n2);
            Number number4 = highLowDataset.getCloseValue(n, n2);
            Number number5 = highLowDataset.getXValue(n, n2);
            string = highLowDataset.getSeriesName(n);
            if (number5 != null) {
                Date date = new Date(number5.longValue());
                string = string + "--> Date=" + this.dateFormatter.format(date);
                if (number != null) {
                    string = string + " High=" + number.toString();
                }
                if (number2 != null) {
                    string = string + " Low=" + number2.toString();
                }
                if (number3 != null) {
                    string = string + " Open=" + number3.toString();
                }
                if (number4 != null) {
                    string = string + " Close=" + number4.toString();
                }
            }
        }
        return string;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof HighLowToolTipGenerator) {
            HighLowToolTipGenerator highLowToolTipGenerator = (HighLowToolTipGenerator)object;
            return this.dateFormatter.equals(highLowToolTipGenerator.dateFormatter);
        }
        return false;
    }
}

