/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.CrosshairInfo;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractXYItemRenderer;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.data.XYDataset;

public class XYDotRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Serializable {
    public void drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, int n3, CrosshairInfo crosshairInfo) {
        Number number = xYDataset.getXValue(n2, n3);
        Number number2 = xYDataset.getYValue(n2, n3);
        if (number2 != null) {
            double d = number.doubleValue();
            double d2 = number2.doubleValue();
            double d3 = valueAxis.translateValueToJava2D(d, rectangle2D);
            double d4 = valueAxis2.translateValueToJava2D(d2, rectangle2D);
            graphics2D.drawRect((int)d3, (int)d4, 1, 1);
            if (xYPlot.isDomainCrosshairLockedOnData()) {
                if (xYPlot.isRangeCrosshairLockedOnData()) {
                    crosshairInfo.updateCrosshairPoint(d, d2);
                } else {
                    crosshairInfo.updateCrosshairX(d);
                }
            } else if (xYPlot.isRangeCrosshairLockedOnData()) {
                crosshairInfo.updateCrosshairY(d2);
            }
        }
    }
}

