/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.CrosshairInfo;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractXYItemRenderer;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.chart.tooltips.XYZToolTipGenerator;
import org.jfree.chart.urls.XYZURLGenerator;
import org.jfree.data.XYDataset;
import org.jfree.data.XYZDataset;

public class XYBubbleRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Serializable {
    public static final int SCALE_ON_BOTH_AXES = 0;
    public static final int SCALE_ON_DOMAIN_AXIS = 1;
    public static final int SCALE_ON_RANGE_AXIS = 2;
    private int scaleType;

    public XYBubbleRenderer() {
        this(0, null, null);
    }

    public XYBubbleRenderer(int n, XYZToolTipGenerator xYZToolTipGenerator, XYZURLGenerator xYZURLGenerator) {
        super(xYZToolTipGenerator, xYZURLGenerator);
        this.scaleType = n;
    }

    public int getScaleType() {
        return this.scaleType;
    }

    public void drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, int n3, CrosshairInfo crosshairInfo) {
        Number number = xYDataset.getXValue(n2, n3);
        Number number2 = xYDataset.getYValue(n2, n3);
        Number number3 = null;
        if (xYDataset instanceof XYZDataset) {
            XYZDataset xYZDataset = (XYZDataset)xYDataset;
            number3 = xYZDataset.getZValue(n2, n3);
        }
        if (number3 != null) {
            double d = number.doubleValue();
            double d2 = number2.doubleValue();
            double d3 = number3.doubleValue();
            double d4 = valueAxis.translateValueToJava2D(d, rectangle2D);
            double d5 = valueAxis2.translateValueToJava2D(d2, rectangle2D);
            double d6 = 0.0;
            double d7 = 0.0;
            switch (this.scaleType) {
                case 1: {
                    double d8 = valueAxis.translateValueToJava2D(0.0, rectangle2D);
                    d7 = d6 = valueAxis.translateValueToJava2D(d3, rectangle2D) - d8;
                    break;
                }
                case 2: {
                    double d9 = valueAxis2.translateValueToJava2D(0.0, rectangle2D);
                    d7 = d6 = d9 - valueAxis2.translateValueToJava2D(d3, rectangle2D);
                    break;
                }
                default: {
                    double d10 = valueAxis.translateValueToJava2D(0.0, rectangle2D);
                    double d11 = valueAxis2.translateValueToJava2D(0.0, rectangle2D);
                    d6 = valueAxis.translateValueToJava2D(d3, rectangle2D) - d10;
                    d7 = d11 - valueAxis2.translateValueToJava2D(d3, rectangle2D);
                }
            }
            double d12 = -valueAxis2.translateValueToJava2D(d3, rectangle2D) + valueAxis2.translateValueToJava2D(0.0, rectangle2D);
            Ellipse2D.Double double_ = new Ellipse2D.Double(d4 - d12 / 2.0, d5 - d12 / 2.0, d6, d7);
            graphics2D.setPaint(this.getItemPaint(n, n2, n3));
            graphics2D.fill(double_);
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.setPaint(Color.lightGray);
            graphics2D.draw(double_);
            EntityCollection entityCollection = null;
            if (chartRenderingInfo != null) {
                entityCollection = chartRenderingInfo.getEntityCollection();
            }
            if (entityCollection != null) {
                String string = null;
                if (this.getToolTipGenerator() != null) {
                    string = this.getToolTipGenerator().generateToolTip(xYDataset, n2, n3);
                }
                String string2 = null;
                if (this.getURLGenerator() != null) {
                    string2 = this.getURLGenerator().generateURL(xYDataset, n2, n3);
                }
                XYItemEntity xYItemEntity = new XYItemEntity(double_, string, string2, n2, n3);
                entityCollection.addEntity(xYItemEntity);
            }
            if (xYPlot.isDomainCrosshairLockedOnData()) {
                if (xYPlot.isRangeCrosshairLockedOnData()) {
                    crosshairInfo.updateCrosshairPoint(d, d2);
                } else {
                    crosshairInfo.updateCrosshairX(d);
                }
            } else if (xYPlot.isRangeCrosshairLockedOnData()) {
                crosshairInfo.updateCrosshairY(d2);
            }
        }
    }
}

