/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.text.Format;
import org.jfree.chart.Marker;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.renderer.CategoryItemRenderer;
import org.jfree.chart.renderer.VerticalBarRenderer;
import org.jfree.chart.tooltips.CategoryToolTipGenerator;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.data.IntervalCategoryDataset;
import org.jfree.data.KeyedValues2DDataset;
import org.jfree.data.Range;
import org.jfree.ui.RefineryUtilities;

public class VerticalIntervalBarRenderer
extends VerticalBarRenderer
implements CategoryItemRenderer,
Serializable {
    private static final int LOW_LABEL = 0;
    private static final int HIGH_LABEL = 1;

    public VerticalIntervalBarRenderer() {
        this(null, null);
    }

    public VerticalIntervalBarRenderer(CategoryToolTipGenerator categoryToolTipGenerator) {
        this(categoryToolTipGenerator, null);
    }

    public VerticalIntervalBarRenderer(CategoryURLGenerator categoryURLGenerator) {
        this(null, categoryURLGenerator);
    }

    public VerticalIntervalBarRenderer(CategoryToolTipGenerator categoryToolTipGenerator, CategoryURLGenerator categoryURLGenerator) {
        super(categoryToolTipGenerator, categoryURLGenerator);
    }

    public void drawRangeMarker(Graphics2D graphics2D, CategoryPlot categoryPlot, ValueAxis valueAxis, Marker marker, Rectangle2D rectangle2D, Shape shape) {
        double d = marker.getValue();
        Range range = valueAxis.getRange();
        if (!range.contains(d)) {
            return;
        }
        double d2 = valueAxis.translateValueToJava2D(marker.getValue(), rectangle2D);
        Line2D.Double double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
        graphics2D.setPaint(marker.getOutlinePaint());
        graphics2D.draw(double_);
    }

    public void drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, KeyedValues2DDataset keyedValues2DDataset, int n, int n2, int n3) {
        Object object;
        Object object2;
        Object object3;
        double d;
        IntervalCategoryDataset intervalCategoryDataset = (IntervalCategoryDataset)((Object)keyedValues2DDataset);
        double d2 = categoryAxis.getCategoryStart(n3, this.getColumnCount(), rectangle2D);
        int n4 = this.getRowCount();
        int n5 = this.getColumnCount();
        if (n4 > 1) {
            double d3 = rectangle2D.getWidth() * this.getItemMargin() / (double)(n5 * (n4 - 1));
            d2 += (double)n2 * (this.getBarWidth() + d3);
        } else {
            d2 += (double)n2 * this.getBarWidth();
        }
        Number number = intervalCategoryDataset.getEndValue(n2, n3);
        double d4 = valueAxis.translateValueToJava2D(number.doubleValue(), rectangle2D);
        Number number2 = intervalCategoryDataset.getStartValue(n2, n3);
        double d5 = valueAxis.translateValueToJava2D(number2.doubleValue(), rectangle2D);
        if (d5 < d4) {
            d = d5;
            d5 = d4;
            d4 = d;
            Number number3 = number2;
            number2 = number;
            number = number3;
        }
        d = d4;
        double d6 = this.getBarWidth();
        double d7 = Math.abs(d5 - d4);
        Rectangle2D.Double double_ = new Rectangle2D.Double(d2, d, d6, d7);
        Paint paint = this.getItemPaint(n, n2, n3);
        graphics2D.setPaint(paint);
        graphics2D.fill(double_);
        if (this.getBarWidth() > 3.0) {
            graphics2D.setStroke(this.getItemStroke(n, n2, n3));
            graphics2D.setPaint(this.getItemOutlinePaint(n, n2, n3));
            graphics2D.draw(double_);
        }
        if (categoryPlot.getValueLabelsVisible()) {
            object3 = categoryPlot.getValueLabelFormatter();
            object2 = categoryPlot.getValueLabelFont();
            graphics2D.setFont((Font)object2);
            object = categoryPlot.getValueLabelPaint();
            graphics2D.setPaint((Paint)object);
            boolean bl = categoryPlot.getVerticalValueLabels();
            String string = ((Format)object3).format(number2);
            Rectangle2D.Double double_2 = new Rectangle2D.Double(d2, d5, d6, rectangle2D.getMaxY() - d5);
            this.drawLabel(graphics2D, string, double_2, (Font)object2, 0, bl);
            String string2 = ((Format)object3).format(number);
            Rectangle2D.Double double_3 = new Rectangle2D.Double(d2, rectangle2D.getY(), d6, d4 - rectangle2D.getY());
            this.drawLabel(graphics2D, string2, double_3, (Font)object2, 1, bl);
        }
        if (this.getInfo() != null && (object3 = this.getInfo().getEntityCollection()) != null) {
            object2 = null;
            if (this.getToolTipGenerator() != null) {
                object2 = this.getToolTipGenerator().generateToolTip(keyedValues2DDataset, n2, n3);
            }
            object = null;
            if (this.getURLGenerator() != null) {
                object = this.getURLGenerator().generateURL(keyedValues2DDataset, n2, n3);
            }
            CategoryItemEntity categoryItemEntity = new CategoryItemEntity(double_, (String)object2, (String)object, n2, keyedValues2DDataset.getColumnKey(n3), n3);
            object3.addEntity(categoryItemEntity);
        }
    }

    private void drawLabel(Graphics2D graphics2D, String string, Rectangle2D rectangle2D, Font font, int n, boolean bl) {
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Rectangle2D rectangle2D2 = font.getStringBounds(string, fontRenderContext);
        LineMetrics lineMetrics = font.getLineMetrics(string, fontRenderContext);
        float f = (float)rectangle2D.getCenterX();
        if (bl) {
            float f2 = n == 1 ? (float)(rectangle2D.getMaxY() - (double)lineMetrics.getLeading()) : (float)(rectangle2D.getY() + rectangle2D2.getWidth() + (double)lineMetrics.getLeading());
            RefineryUtilities.drawRotatedString((String)string, (Graphics2D)graphics2D, (float)(f += (float)(rectangle2D2.getHeight() / 2.0 - (double)lineMetrics.getDescent())), (float)f2, (double)-1.5707963267948966);
        } else {
            float f3 = n == 1 ? (float)(rectangle2D.getMaxY() - (double)lineMetrics.getDescent() - (double)lineMetrics.getLeading()) : (float)(rectangle2D.getY() + (double)lineMetrics.getAscent() + (double)lineMetrics.getLeading());
            graphics2D.drawString(string, f -= (float)(rectangle2D2.getWidth() / 2.0), f3);
        }
    }
}

