/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.renderer.AreaRenderer;
import org.jfree.chart.tooltips.CategoryToolTipGenerator;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.data.CategoryDataset;

public class StackedAreaRenderer
extends AreaRenderer
implements Serializable {
    public StackedAreaRenderer() {
        this(null, null);
    }

    public StackedAreaRenderer(CategoryToolTipGenerator categoryToolTipGenerator, CategoryURLGenerator categoryURLGenerator) {
        super(categoryToolTipGenerator, categoryURLGenerator);
    }

    public int getRangeType() {
        return 1;
    }

    public void drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        Number number = categoryDataset.getValue(n2, n3);
        if (number != null) {
            Object object;
            double d = categoryAxis.getCategoryMiddle(n3, this.getColumnCount(), rectangle2D);
            double d2 = 0.0;
            double d3 = number.doubleValue();
            graphics2D.setPaint(this.getItemPaint(n, n2, n3));
            graphics2D.setStroke(this.getItemStroke(n, n2, n3));
            if (n3 != 0 && (object = categoryDataset.getValue(n2, n3 - 1)) != null) {
                double d4 = categoryAxis.getCategoryMiddle(n3 - 1, this.getColumnCount(), rectangle2D);
                double d5 = ((Number)object).doubleValue();
                double d6 = this.getPreviousHeight(categoryDataset, n2, n3 - 1);
                double d7 = this.getPreviousHeight(categoryDataset, n2, n3);
                double d8 = valueAxis.translateValueToJava2D(d6, rectangle2D);
                double d9 = valueAxis.translateValueToJava2D(d7, rectangle2D);
                double d10 = valueAxis.translateValueToJava2D(d5 += d6, rectangle2D);
                d2 = valueAxis.translateValueToJava2D(d3 += d7, rectangle2D);
                Polygon polygon = new Polygon();
                polygon.addPoint((int)d4, (int)d10);
                polygon.addPoint((int)d, (int)d2);
                polygon.addPoint((int)d, (int)d9);
                polygon.addPoint((int)d4, (int)d8);
                graphics2D.setPaint(this.getItemPaint(n, n2, n3));
                graphics2D.setStroke(this.getItemStroke(n, n2, n3));
                graphics2D.fill(polygon);
            }
            if (this.getInfo() != null) {
                object = this.getInfo().getEntityCollection();
                Rectangle2D.Double double_ = new Rectangle2D.Double(d - 3.0, d2 - 3.0, 6.0, 6.0);
                if (object != null && double_ != null) {
                    String string = null;
                    if (this.getToolTipGenerator() != null) {
                        string = this.getToolTipGenerator().generateToolTip(categoryDataset, n2, n3);
                    }
                    String string2 = null;
                    if (this.getURLGenerator() != null) {
                        string2 = this.getURLGenerator().generateURL(categoryDataset, n2, n3);
                    }
                    CategoryItemEntity categoryItemEntity = new CategoryItemEntity(double_, string, string2, n2, categoryDataset.getColumnKey(n3), n3);
                    object.addEntity(categoryItemEntity);
                }
            }
        }
    }

    protected double getPreviousHeight(CategoryDataset categoryDataset, int n, int n2) {
        double d = 0.0;
        int n3 = 0;
        while (n3 < n) {
            Number number = categoryDataset.getValue(n3, n2);
            if (number != null) {
                d += number.doubleValue();
            }
            ++n3;
        }
        return d;
    }
}

