/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.Marker;
import org.jfree.chart.annotations.CategoryAnnotation;
import org.jfree.chart.axis.AxisNotCompatibleException;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.plot.CategoryPlotConstants;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotNotCompatibleException;
import org.jfree.chart.renderer.CategoryItemRenderer;
import org.jfree.data.CategoryDataset;
import org.jfree.data.DatasetChangeEvent;
import org.jfree.io.SerialUtilities;

public abstract class CategoryPlot
extends Plot
implements CategoryPlotConstants,
Serializable {
    private CategoryAxis domainAxis;
    private int domainAxisLocation;
    private ValueAxis rangeAxis;
    private int rangeAxisLocation;
    private CategoryItemRenderer renderer;
    private ValueAxis secondaryRangeAxis;
    private CategoryItemRenderer secondaryRenderer;
    private boolean domainGridlinesVisible;
    private transient Stroke domainGridlineStroke;
    private transient Paint domainGridlinePaint;
    private boolean rangeGridlinesVisible;
    private transient Stroke rangeGridlineStroke;
    private transient Paint rangeGridlinePaint;
    private double rangeAnchor;
    private boolean rangeCrosshairVisible;
    private double rangeCrosshairValue;
    private transient Stroke rangeCrosshairStroke;
    private transient Paint rangeCrosshairPaint;
    private boolean rangeCrosshairLockedOnData = true;
    private List rangeMarkers;
    private boolean valueLabelsVisible;
    private Font valueLabelFont;
    private transient Paint valueLabelPaint;
    private String valueLabelFormatPattern;
    private NumberFormat valueLabelFormatter;
    private boolean verticalValueLabels;
    private List annotations;

    protected CategoryPlot(CategoryDataset categoryDataset, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryItemRenderer categoryItemRenderer) {
        super(categoryDataset);
        this.renderer = categoryItemRenderer;
        if (categoryItemRenderer != null) {
            categoryItemRenderer.setPlot(this);
        }
        this.domainAxis = categoryAxis;
        if (categoryAxis != null) {
            categoryAxis.setPlot(this);
            categoryAxis.addChangeListener(this);
        }
        this.rangeAxis = valueAxis;
        if (valueAxis != null) {
            valueAxis.setPlot(this);
            valueAxis.addChangeListener(this);
        }
        this.domainGridlinesVisible = false;
        this.domainGridlineStroke = CategoryPlotConstants.DEFAULT_GRIDLINE_STROKE;
        this.domainGridlinePaint = CategoryPlotConstants.DEFAULT_GRIDLINE_PAINT;
        this.rangeGridlinesVisible = true;
        this.rangeGridlineStroke = CategoryPlotConstants.DEFAULT_GRIDLINE_STROKE;
        this.rangeGridlinePaint = CategoryPlotConstants.DEFAULT_GRIDLINE_PAINT;
        this.valueLabelsVisible = false;
        this.valueLabelFont = CategoryPlotConstants.DEFAULT_VALUE_LABEL_FONT;
        this.valueLabelPaint = Color.black;
        this.valueLabelFormatter = NumberFormat.getInstance();
        this.valueLabelFormatPattern = null;
        this.verticalValueLabels = false;
        this.rangeMarkers = null;
        Marker marker = new Marker(0.0, new Color(0.8f, 0.8f, 0.8f, 0.5f), new BasicStroke(1.0f), new Color(0.85f, 0.85f, 0.95f, 0.5f), 0.6f);
        this.addRangeMarker(marker);
    }

    public LegendItemCollection getLegendItems() {
        CategoryDataset categoryDataset;
        int n;
        LegendItemCollection legendItemCollection = new LegendItemCollection();
        CategoryDataset categoryDataset2 = this.getCategoryDataset();
        if (categoryDataset2 != null) {
            int n2 = categoryDataset2.getRowCount();
            n = 0;
            while (n < n2) {
                LegendItem legendItem = this.renderer.getLegendItem(0, n);
                legendItemCollection.add(legendItem);
                ++n;
            }
        }
        if ((categoryDataset = this.getSecondaryCategoryDataset()) != null) {
            n = categoryDataset.getRowCount();
            int n3 = 0;
            while (n3 < n) {
                LegendItem legendItem = this.getSecondaryRenderer().getLegendItem(1, n3);
                legendItemCollection.add(legendItem);
                ++n3;
            }
        }
        return legendItemCollection;
    }

    public CategoryItemRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(CategoryItemRenderer categoryItemRenderer) {
        this.setRenderer(categoryItemRenderer, true);
    }

    public void setRenderer(CategoryItemRenderer categoryItemRenderer, boolean bl) {
        this.renderer = categoryItemRenderer;
        if (categoryItemRenderer != null) {
            categoryItemRenderer.setPlot(this);
        }
        if (bl) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public CategoryDataset getCategoryDataset() {
        return (CategoryDataset)this.getDataset();
    }

    public CategoryAxis getDomainAxis() {
        Plot plot;
        CategoryAxis categoryAxis = this.domainAxis;
        if (categoryAxis == null && (plot = this.getParent()) instanceof CategoryPlot) {
            CategoryPlot categoryPlot = (CategoryPlot)plot;
            categoryAxis = categoryPlot.getDomainAxis();
        }
        return categoryAxis;
    }

    public void setDomainAxis(CategoryAxis categoryAxis) throws AxisNotCompatibleException {
        if (this.isCompatibleDomainAxis(categoryAxis)) {
            if (categoryAxis != null) {
                try {
                    categoryAxis.setPlot(this);
                }
                catch (PlotNotCompatibleException plotNotCompatibleException) {
                    throw new AxisNotCompatibleException("CategoryPlot.setDomainAxis(...): plot not compatible with axis.");
                }
                categoryAxis.addChangeListener(this);
            }
            if (this.domainAxis != null) {
                this.domainAxis.removeChangeListener(this);
            }
        } else {
            throw new AxisNotCompatibleException("CategoryPlot.setDomainAxis(...): axis not compatible with plot.");
        }
        this.domainAxis = categoryAxis;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public int getDomainAxisLocation() {
        return this.domainAxisLocation;
    }

    public void setDomainAxisLocation(int n) {
        this.setDomainAxisLocation(n, true);
    }

    public void setDomainAxisLocation(int n, boolean bl) {
        if (n != this.domainAxisLocation) {
            this.domainAxisLocation = n;
            if (bl) {
                this.notifyListeners(new PlotChangeEvent(this));
            }
        }
    }

    public ValueAxis getRangeAxis() {
        Plot plot;
        ValueAxis valueAxis = this.rangeAxis;
        if (valueAxis == null && (plot = this.getParent()) instanceof CategoryPlot) {
            CategoryPlot categoryPlot = (CategoryPlot)plot;
            valueAxis = categoryPlot.getRangeAxis();
        }
        return valueAxis;
    }

    public void setRangeAxis(ValueAxis valueAxis) throws AxisNotCompatibleException {
        if (this.isCompatibleRangeAxis(valueAxis)) {
            if (valueAxis != null) {
                try {
                    valueAxis.setPlot(this);
                }
                catch (PlotNotCompatibleException plotNotCompatibleException) {
                    throw new AxisNotCompatibleException("CategoryPlot.setRangeAxis(...): plot not compatible with axis.");
                }
                valueAxis.addChangeListener(this);
            }
            if (this.rangeAxis != null) {
                this.rangeAxis.removeChangeListener(this);
            }
        } else {
            throw new AxisNotCompatibleException("Plot.setRangeAxis(...): axis not compatible with plot.");
        }
        this.rangeAxis = valueAxis;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public int getRangeAxisLocation() {
        return this.rangeAxisLocation;
    }

    public void setRangeAxisLocation(int n) {
        this.setRangeAxisLocation(n, true);
    }

    public void setRangeAxisLocation(int n, boolean bl) {
        if (n != this.rangeAxisLocation) {
            this.rangeAxisLocation = n;
            if (bl) {
                this.notifyListeners(new PlotChangeEvent(this));
            }
        }
    }

    public CategoryDataset getSecondaryCategoryDataset() {
        return (CategoryDataset)this.getSecondaryDataset();
    }

    public ValueAxis getSecondaryRangeAxis() {
        return this.secondaryRangeAxis;
    }

    public void setSecondaryRangeAxis(ValueAxis valueAxis) {
        if (this.isCompatibleRangeAxis(valueAxis)) {
            ValueAxis valueAxis2 = this.secondaryRangeAxis;
            this.secondaryRangeAxis = valueAxis;
            if (valueAxis != null) {
                try {
                    valueAxis.setPlot(this);
                }
                catch (PlotNotCompatibleException plotNotCompatibleException) {
                    this.secondaryRangeAxis = valueAxis2;
                    throw new AxisNotCompatibleException("CategoryPlot.setSecondaryRangeAxis(...): plot not compatible with axis.");
                }
                valueAxis.addChangeListener(this);
            }
            if (valueAxis2 != null) {
                valueAxis2.removeChangeListener(this);
            }
        } else {
            throw new AxisNotCompatibleException("Plot.setSecondaryRangeAxis(...): axis not compatible with plot.");
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public CategoryItemRenderer getSecondaryRenderer() {
        return this.secondaryRenderer;
    }

    public void setSecondaryRenderer(CategoryItemRenderer categoryItemRenderer) {
        this.secondaryRenderer = categoryItemRenderer;
        if (categoryItemRenderer != null) {
            categoryItemRenderer.setPlot(this);
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean isDomainGridlinesVisible() {
        return this.domainGridlinesVisible;
    }

    public void setDomainGridlinesVisible(boolean bl) {
        if (this.domainGridlinesVisible != bl) {
            this.domainGridlinesVisible = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Stroke getDomainGridlineStroke() {
        return this.domainGridlineStroke;
    }

    public void setDomainGridlineStroke(Stroke stroke) {
        this.domainGridlineStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getDomainGridlinePaint() {
        return this.domainGridlinePaint;
    }

    public void setDomainGridlinePaint(Paint paint) {
        this.domainGridlinePaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean isRangeGridlinesVisible() {
        return this.rangeGridlinesVisible;
    }

    public void setRangeGridlinesVisible(boolean bl) {
        if (this.rangeGridlinesVisible != bl) {
            this.rangeGridlinesVisible = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Stroke getRangeGridlineStroke() {
        return this.rangeGridlineStroke;
    }

    public void setRangeGridlineStroke(Stroke stroke) {
        this.rangeGridlineStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getRangeGridlinePaint() {
        return this.rangeGridlinePaint;
    }

    public void setRangeGridlinePaint(Paint paint) {
        this.rangeGridlinePaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public abstract boolean isCompatibleDomainAxis(CategoryAxis var1);

    public abstract boolean isCompatibleRangeAxis(ValueAxis var1);

    public void zoom(double d) {
        ValueAxis valueAxis = this.getRangeAxis();
        if (d > 0.0) {
            double d2 = valueAxis.getMaximumAxisValue() - valueAxis.getMinimumAxisValue();
            double d3 = d2 * d;
            valueAxis.setAnchoredRange(d3);
        } else {
            valueAxis.setAutoRange(true);
        }
    }

    public boolean getValueLabelsVisible() {
        return this.valueLabelsVisible;
    }

    public void setLabelsVisible(boolean bl) {
        this.setValueLabelsVisible(bl);
    }

    public void setValueLabelsVisible(boolean bl) {
        if (this.valueLabelsVisible != bl) {
            this.valueLabelsVisible = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Font getValueLabelFont() {
        return this.valueLabelFont;
    }

    public void setValueLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("CategoryPlot.setValueLabelFont(...): null font not allowed.");
        }
        if (!this.valueLabelFont.equals(font)) {
            this.valueLabelFont = font;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Paint getValueLabelPaint() {
        return this.valueLabelPaint;
    }

    public void setValueLabelPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("CategoryPlot.setValueLabelPaint(...): null paint not allowed.");
        }
        if (!this.valueLabelPaint.equals(paint)) {
            this.valueLabelPaint = paint;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public NumberFormat getValueLabelFormatter() {
        return this.valueLabelFormatter;
    }

    public void setValueLabelFormatString(String string) {
        boolean bl = false;
        if (string == null) {
            if (this.valueLabelFormatter != null) {
                this.valueLabelFormatPattern = null;
                this.valueLabelFormatter = null;
                bl = true;
            }
        } else if (this.valueLabelFormatter == null || !string.equals(this.valueLabelFormatPattern)) {
            this.valueLabelFormatPattern = string;
            this.valueLabelFormatter = new DecimalFormat(string);
            bl = true;
        }
        if (bl) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public boolean getVerticalValueLabels() {
        return this.verticalValueLabels;
    }

    public void setVerticalValueLabels(boolean bl) {
        if (this.verticalValueLabels != bl) {
            this.verticalValueLabels = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public void datasetChanged(DatasetChangeEvent datasetChangeEvent) {
        if (this.rangeAxis != null) {
            this.rangeAxis.configure();
        }
        if (this.secondaryRangeAxis != null) {
            this.secondaryRangeAxis.configure();
        }
        super.datasetChanged(datasetChangeEvent);
    }

    public void addRangeMarker(Marker marker) {
        if (this.rangeMarkers == null) {
            this.rangeMarkers = new ArrayList();
        }
        this.rangeMarkers.add(marker);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void clearRangeMarkers() {
        if (this.rangeMarkers != null) {
            this.rangeMarkers.clear();
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public List getRangeMarkers() {
        return this.rangeMarkers;
    }

    public boolean isRangeCrosshairVisible() {
        return this.rangeCrosshairVisible;
    }

    public void setRangeCrosshairVisible(boolean bl) {
        if (this.rangeCrosshairVisible != bl) {
            this.rangeCrosshairVisible = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public boolean isRangeCrosshairLockedOnData() {
        return this.rangeCrosshairLockedOnData;
    }

    public void setRangeCrosshairLockedOnData(boolean bl) {
        if (this.rangeCrosshairLockedOnData != bl) {
            this.rangeCrosshairLockedOnData = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public double getRangeCrosshairValue() {
        return this.rangeCrosshairValue;
    }

    public void setRangeCrosshairValue(double d) {
        this.setRangeCrosshairValue(d, true);
    }

    public void setRangeCrosshairValue(double d, boolean bl) {
        this.rangeCrosshairValue = d;
        if (this.isRangeCrosshairVisible() && bl) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Stroke getRangeCrosshairStroke() {
        return this.rangeCrosshairStroke;
    }

    public void setRangeCrosshairStroke(Stroke stroke) {
        this.rangeCrosshairStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getRangeCrosshairPaint() {
        return this.rangeCrosshairPaint;
    }

    public void setRangeCrosshairPaint(Paint paint) {
        this.rangeCrosshairPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public List getAnnotations() {
        return this.annotations;
    }

    public void addAnnotation(CategoryAnnotation categoryAnnotation) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        this.annotations.add(categoryAnnotation);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeStroke((Stroke)this.domainGridlineStroke, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.domainGridlinePaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writeStroke((Stroke)this.rangeGridlineStroke, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.rangeGridlinePaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writeStroke((Stroke)this.rangeCrosshairStroke, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.rangeCrosshairPaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.valueLabelPaint, (ObjectOutputStream)objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.domainGridlineStroke = SerialUtilities.readStroke((ObjectInputStream)objectInputStream);
        this.domainGridlinePaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.rangeGridlineStroke = SerialUtilities.readStroke((ObjectInputStream)objectInputStream);
        this.rangeGridlinePaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.rangeCrosshairStroke = SerialUtilities.readStroke((ObjectInputStream)objectInputStream);
        this.rangeCrosshairPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.valueLabelPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        if (this.domainAxis != null) {
            this.domainAxis.addChangeListener(this);
        }
        if (this.rangeAxis != null) {
            this.rangeAxis.addChangeListener(this);
        }
    }
}

