/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public class NumberFormatIndexRecord
extends Record {
    public static final short sid = 4174;
    private short field_1_formatIndex;

    public NumberFormatIndexRecord() {
    }

    public NumberFormatIndexRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public NumberFormatIndexRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    protected void validateSid(short id) {
        if (id != 4174) {
            throw new RecordFormatException("Not a NumberFormatIndex record");
        }
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_formatIndex = LittleEndian.getShort(data, 0 + offset);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[NumberFormatIndex]\n");
        buffer.append("    .formatIndex          = ").append("0x").append(HexDump.toHex(this.getFormatIndex())).append(" (").append(this.getFormatIndex()).append(" )\n");
        buffer.append("[/NumberFormatIndex]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)4174);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(data, 4 + offset, this.field_1_formatIndex);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 4174;
    }

    public short getFormatIndex() {
        return this.field_1_formatIndex;
    }

    public void setFormatIndex(short field_1_formatIndex) {
        this.field_1_formatIndex = field_1_formatIndex;
    }
}

