/*
 * ReportQueryFrame.java
 *
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute  and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 *
 * Created on 27 maggio 2003, 19.47
 */

package it.businesslogic.ireport.gui;
import it.businesslogic.ireport.*;
import it.businesslogic.ireport.util.*;
import javax.swing.table.*;
import javax.swing.*;
import java.util.*;

/**
 *
 * @author  Administrator
 */
public class ReportQueryDialog extends javax.swing.JDialog {
    
    /** Creates new form ReportQueryFrame */
    public ReportQueryDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        this.setSize(520, 500);
        Misc.centerFrame(this);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jSplitPane1 = new javax.swing.JSplitPane();
        jPanel1 = new javax.swing.JPanel();
        jTabbedPane1 = new javax.swing.JTabbedPane();
        jPanelSQL = new javax.swing.JPanel();
        jRSQLExpressionArea1 = new it.businesslogic.ireport.gui.JRSQLExpressionArea();
        jPanel7 = new javax.swing.JPanel();
        jButtonReadFieldsSQL = new javax.swing.JButton();
        jButtonSaveQuery = new javax.swing.JButton();
        jButton6 = new javax.swing.JButton();
        jPanel8 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jComboBoxConnections = new javax.swing.JComboBox();
        jPanel5 = new javax.swing.JPanel();
        jTextFieldBeanClass = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        jButtonReadBeanAttributes = new javax.swing.JButton();
        jPanel6 = new javax.swing.JPanel();
        jPanel2 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTableFields = new javax.swing.JTable();
        jPanel3 = new javax.swing.JPanel();
        jPanel4 = new javax.swing.JPanel();
        jButtonClose = new javax.swing.JButton();
        jPanel9 = new javax.swing.JPanel();
        jButtonRegisterFields = new javax.swing.JButton();
        jButtonClear = new javax.swing.JButton();

        setTitle("Report query");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        jSplitPane1.setOrientation(javax.swing.JSplitPane.VERTICAL_SPLIT);
        jSplitPane1.setResizeWeight(0.4);
        jPanel1.setLayout(new java.awt.BorderLayout());

        jPanel1.setMinimumSize(new java.awt.Dimension(10, 100));
        jPanel1.setPreferredSize(new java.awt.Dimension(10, 350));
        jTabbedPane1.setFont(new java.awt.Font("Dialog", 0, 11));
        jTabbedPane1.setMinimumSize(new java.awt.Dimension(154, 350));
        jTabbedPane1.setPreferredSize(new java.awt.Dimension(154, 350));
        jPanelSQL.setLayout(new java.awt.BorderLayout());

        jPanelSQL.setMinimumSize(new java.awt.Dimension(1, 100));
        jPanelSQL.setPreferredSize(new java.awt.Dimension(1, 350));

        jRSQLExpressionArea1.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.LOWERED));
        jRSQLExpressionArea1.setMinimumSize(new java.awt.Dimension(661, 200));
        jRSQLExpressionArea1.setPreferredSize(new java.awt.Dimension(661, 340));
        jPanelSQL.add(jRSQLExpressionArea1, java.awt.BorderLayout.CENTER);

        jPanel7.setLayout(null);

        jPanel7.setMinimumSize(new java.awt.Dimension(10, 30));
        jPanel7.setPreferredSize(new java.awt.Dimension(10, 30));
        jButtonReadFieldsSQL.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonReadFieldsSQL.setText("Read fields");
        jButtonReadFieldsSQL.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonReadFieldsSQLActionPerformed(evt);
            }
        });

        jPanel7.add(jButtonReadFieldsSQL);
        jButtonReadFieldsSQL.setBounds(192, 4, 116, 25);

        jButtonSaveQuery.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonSaveQuery.setText("Save query to report");
        jButtonSaveQuery.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonSaveQueryActionPerformed(evt);
            }
        });

        jPanel7.add(jButtonSaveQuery);
        jButtonSaveQuery.setBounds(314, 4, 158, 25);

        jButton6.setFont(new java.awt.Font("Dialog", 0, 11));
        jButton6.setText("Open SQL query designer");
        jButton6.setEnabled(false);
        jPanel7.add(jButton6);
        jButton6.setBounds(6, 4, 180, 25);

        jPanelSQL.add(jPanel7, java.awt.BorderLayout.SOUTH);

        jPanel8.setLayout(new java.awt.BorderLayout());

        jPanel8.setPreferredSize(new java.awt.Dimension(10, 45));
        jLabel1.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel1.setText("Connection");
        jLabel1.setVerticalAlignment(javax.swing.SwingConstants.BOTTOM);
        jLabel1.setPreferredSize(new java.awt.Dimension(54, 20));
        jPanel8.add(jLabel1, java.awt.BorderLayout.NORTH);

        jComboBoxConnections.setFont(new java.awt.Font("Dialog", 0, 11));
        jPanel8.add(jComboBoxConnections, java.awt.BorderLayout.SOUTH);

        jPanelSQL.add(jPanel8, java.awt.BorderLayout.NORTH);

        jTabbedPane1.addTab("Report SQL query ", jPanelSQL);

        jPanel5.setLayout(null);

        jPanel5.add(jTextFieldBeanClass);
        jTextFieldBeanClass.setBounds(8, 28, 342, 20);

        jLabel2.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel2.setText("Class name");
        jLabel2.setVerticalAlignment(javax.swing.SwingConstants.BOTTOM);
        jLabel2.setPreferredSize(new java.awt.Dimension(54, 20));
        jPanel5.add(jLabel2);
        jLabel2.setBounds(8, 6, 240, 20);

        jButtonReadBeanAttributes.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonReadBeanAttributes.setText("Read javabeans attributes");
        jButtonReadBeanAttributes.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonReadBeanAttributesActionPerformed(evt);
            }
        });

        jPanel5.add(jButtonReadBeanAttributes);
        jButtonReadBeanAttributes.setBounds(8, 54, 188, 25);

        jTabbedPane1.addTab("JavaBean Datasource", jPanel5);

        jTabbedPane1.addTab("Custom Datasource", jPanel6);

        jPanel1.add(jTabbedPane1, java.awt.BorderLayout.CENTER);

        jSplitPane1.setTopComponent(jPanel1);

        jPanel2.setLayout(new java.awt.BorderLayout());

        jPanel2.setPreferredSize(new java.awt.Dimension(453, 150));
        jScrollPane1.setPreferredSize(new java.awt.Dimension(453, 150));
        jTableFields.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                "Field name", "Field type"
            }
        ) {
            boolean[] canEdit = new boolean [] {
                false, false
            };

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        jScrollPane1.setViewportView(jTableFields);

        jPanel2.add(jScrollPane1, java.awt.BorderLayout.CENTER);

        jPanel3.setLayout(new java.awt.BorderLayout());

        jPanel3.setMinimumSize(new java.awt.Dimension(10, 34));
        jPanel3.setPreferredSize(new java.awt.Dimension(10, 34));
        jPanel4.setLayout(null);

        jPanel4.setPreferredSize(new java.awt.Dimension(150, 10));
        jButtonClose.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonClose.setText("Close");
        jButtonClose.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCloseActionPerformed(evt);
            }
        });

        jPanel4.add(jButtonClose);
        jButtonClose.setBounds(30, 4, 116, 25);

        jPanel3.add(jPanel4, java.awt.BorderLayout.EAST);

        jPanel9.setLayout(null);

        jButtonRegisterFields.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonRegisterFields.setText("Register fields to report");
        jPanel9.add(jButtonRegisterFields);
        jButtonRegisterFields.setBounds(4, 4, 164, 25);

        jButtonClear.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonClear.setText("Clear list");
        jButtonClear.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonClearActionPerformed(evt);
            }
        });

        jPanel9.add(jButtonClear);
        jButtonClear.setBounds(172, 4, 76, 25);

        jPanel3.add(jPanel9, java.awt.BorderLayout.CENTER);

        jPanel2.add(jPanel3, java.awt.BorderLayout.SOUTH);

        jSplitPane1.setBottomComponent(jPanel2);

        getContentPane().add(jSplitPane1, java.awt.BorderLayout.CENTER);

        pack();
    }//GEN-END:initComponents

    private void jButtonReadFieldsSQLActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonReadFieldsSQLActionPerformed
        
        if (jComboBoxConnections.getSelectedIndex() < 0 ||
            !(jComboBoxConnections.getSelectedItem() instanceof IReportConnection) )
        {
            javax.swing.JOptionPane.showMessageDialog(this,"You must first select a connection.\nIf you have never created a connection before,\ngo to menu item database->connections and create it now."); 
            return;
        }
    }//GEN-LAST:event_jButtonReadFieldsSQLActionPerformed

    private void jButtonSaveQueryActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonSaveQueryActionPerformed
        if (this.getJReportFrame() != null)
        {
            this.getJReportFrame().getReport().setQuery( jRSQLExpressionArea1.getText());
        }
    }//GEN-LAST:event_jButtonSaveQueryActionPerformed

    private void jButtonCloseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCloseActionPerformed
        this.setVisible(false);
    }//GEN-LAST:event_jButtonCloseActionPerformed

    private void jButtonClearActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonClearActionPerformed
        DefaultTableModel dtm = (DefaultTableModel)jTableFields.getModel();
            dtm.setRowCount(0);
            
    }//GEN-LAST:event_jButtonClearActionPerformed

    private void jButtonReadBeanAttributesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonReadBeanAttributesActionPerformed
        String classname = jTextFieldBeanClass.getText().trim();
        if (classname.equals("")){
         
            javax.swing.JOptionPane.showMessageDialog(this, "No class specified!","Error",javax.swing.JOptionPane.ERROR_MESSAGE);
            return;
        }
        try {
            
            java.lang.reflect.Method[] methods = Class.forName(classname).getMethods();
            java.lang.reflect.Field[] fields = Class.forName(classname).getFields();
            // for any method, looking for get<FieldName> ....
            
            DefaultTableModel dtm = (DefaultTableModel)jTableFields.getModel();
            dtm.setRowCount(0);
            
            for (int i=0; i<methods.length; ++i)
            {
               
                if ( java.lang.reflect.Modifier.isPublic( methods[i].getModifiers() ) &&
                     methods[i].getDeclaringClass().getName().equals(classname) &&
                     !java.lang.reflect.Modifier.isNative( methods[i].getModifiers() )     
                     && methods[i].getName().startsWith("get")
                        && !methods[i].getReturnType().isPrimitive() 
                        && !methods[i].getReturnType().isArray())
                {
                   String fieldName = methods[i].getName().substring(3);
                   // Looking for the field...
                   for (int f=0; f<fields.length; ++f)
                   {
                       if (fields[f].getName().equalsIgnoreCase( fieldName ))
                       {
                           
                           fieldName = fields[f].getName();
                           break;
                       }
                   }
                   
                   String returnType =  methods[i].getReturnType().getName();
                   it.businesslogic.ireport.JRField field = new it.businesslogic.ireport.JRField(fieldName, returnType);
                   field.setDescription("Field returned by " +methods[i].getName() + " method of " + classname);
                   Vector row = new Vector();
                   row.addElement(field);
                   row.addElement(field.getClassType());
                   dtm.addRow(row);
                }
            }
            
        } catch (ClassNotFoundException cnf)
        {
            javax.swing.JOptionPane.showMessageDialog(this, "Class npt found!\nCheck your classpath and retry.","Error",javax.swing.JOptionPane.ERROR_MESSAGE);
            return;
        } catch (Exception ex)
        {
            javax.swing.JOptionPane.showMessageDialog(this, ex.getMessage() ,"Error",javax.swing.JOptionPane.ERROR_MESSAGE);
            return;
        }
    }//GEN-LAST:event_jButtonReadBeanAttributesActionPerformed
    
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible(false);
        dispose();
    }//GEN-LAST:event_closeDialog
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        new ReportQueryDialog(new javax.swing.JFrame(), true).show();
    }
    
    /** Getter for property jReportFrame.
     * @return Value of property jReportFrame.
     *
     */
    public it.businesslogic.ireport.gui.JReportFrame getJReportFrame() {
        return jReportFrame;
    }    
    
    /** Setter for property jReportFrame.
     * @param jReportFrame New value of property jReportFrame.
     *
     */
    public void setJReportFrame(it.businesslogic.ireport.gui.JReportFrame jReportFrame) {
        this.jReportFrame = jReportFrame;
        DefaultTableModel dtm = (DefaultTableModel)jTableFields.getModel();
        dtm.setRowCount(0); 
        // Load query...
        if (jReportFrame == null)
            this.jRSQLExpressionArea1.setText("");
        else
        {
            this.jRSQLExpressionArea1.setText( this.jReportFrame.getReport().getQuery() );
        }
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField jTextFieldBeanClass;
    private javax.swing.JButton jButtonClose;
    private javax.swing.JButton jButtonReadBeanAttributes;
    private javax.swing.JComboBox jComboBoxConnections;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JButton jButtonReadFieldsSQL;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JSplitPane jSplitPane1;
    private javax.swing.JPanel jPanelSQL;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JButton jButton6;
    private javax.swing.JPanel jPanel8;
    private javax.swing.JPanel jPanel7;
    private javax.swing.JPanel jPanel1;
    private it.businesslogic.ireport.gui.JRSQLExpressionArea jRSQLExpressionArea1;
    private javax.swing.JPanel jPanel6;
    private javax.swing.JButton jButtonSaveQuery;
    private javax.swing.JTable jTableFields;
    private javax.swing.JButton jButtonRegisterFields;
    private javax.swing.JButton jButtonClear;
    private javax.swing.JPanel jPanel9;
    private javax.swing.JTabbedPane jTabbedPane1;
    // End of variables declaration//GEN-END:variables

    private JReportFrame jReportFrame;    
    
}
