/*
 * MainFrame.java
 *
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute  and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 * Created on 5 febbraio 2003, 12.45
 */

package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.gui.event.*;
import it.businesslogic.ireport.*;
import it.businesslogic.ireport.util.*;
import javax.swing.tree.*;
import java.util.*;
import java.io.*;
import javax.swing.*;


import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.*;
import org.xml.sax.SAXException;
/**
 * This class is the core of the GUI of iReport. From this class we control all
 * events related to the open and close files, handling of properties files,
 * handling JMDIDestopPane, Menus....
 *
 * @author  Administrator
 */
public class MainFrame extends javax.swing.JFrame  {
    
    public int docCounter=0;
    
    public static String constTitle = "iReport 0.2.0 - ";
    private java.util.Vector toolBarControls;
    private ElementPropertiesDialog elementPropertiesDialog;    
    private ValuesDialog valuesDialog;
    private GroupsDialog groupsDialog;
    private BandsDialog bandsDialog;
    private FontsDialog fontsDialog;
    private ReportQueryDialog reportQueryDialog;
    private Vector ttfFonts;
    private Vector connections;    
    private Properties properties;    
    
    private StringBuffer outputBuffer;
    
    /** Creates new form MainFrame */
    public MainFrame() {
        initComponents();
        
        
        outputBuffer = new StringBuffer();
        connections = new Vector();
        properties = new Properties();
        this.ttfFonts = FontListLoader.loadTTFFonts();
        
        if (ttfFonts == null) ttfFonts = new Vector();
        
        System.setProperty("org.xml.sax.driver","org.apache.xerces.parsers.SAXParser"); 
        
        //jMDIDesktopPane.addInternalFrameActivatedListener(this);  
        this.setTitle(constTitle+ " (c) 2002-2003 by Giulio Toffoli"); 
        toolBarControls = new java.util.Vector();
        
        elementPropertiesDialog = new ElementPropertiesDialog (this,false); 
        elementPropertiesDialog.updateFonts(ttfFonts);
        valuesDialog = new ValuesDialog(this,false); 
        groupsDialog = new GroupsDialog(this,false); 
        bandsDialog = new BandsDialog(this,false); 
        fontsDialog = new FontsDialog(this,false); 
        reportQueryDialog = new ReportQueryDialog(this,false); 
        
        jNumberComboBoxZoom.addValueChangedListener(new ValueChangedListener() {
            public void valueChanged(ValueChangedEvent evt) {
                jNumberComboBoxZoomValueChanged(evt);
            }
        });
        
        jMDIDesktopPane.addInternalFrameActivatedListener(new InternalFrameActivatedListener() {
            public void internalFrameActivated( InternalFrameActivatedEvent evt) {
                jMDIDesktopPaneInternalFrameActivated(evt);
            }
        });
        
        toolBarControls.addElement( this.jButtonNew); 
        toolBarControls.addElement( this.jButtonOpen); 
        toolBarControls.addElement( this.jButtonSave);
        toolBarControls.addElement( null); 
        toolBarControls.addElement( this.jButtonCut); 
        toolBarControls.addElement( this.jButtonCopy); 
        toolBarControls.addElement( this.jButtonPaste); 
        toolBarControls.addElement( null); 
        toolBarControls.addElement( this.jToggleButtonPointer); 
        toolBarControls.addElement( this.jToggleButtonLineTool); 
        toolBarControls.addElement( this.jToggleButtonRectTool); 
        toolBarControls.addElement( this.jToggleButtonRectRoundTool); 
        toolBarControls.addElement( this.jToggleButtonEllipseTool); 
        toolBarControls.addElement( this.jToggleButtonImageTool); 
        toolBarControls.addElement( this.jToggleButtonStaticTextTool); 
        toolBarControls.addElement( this.jToggleButtonTextFieldTool); 
        toolBarControls.addElement( this.jToggleButtonSubreportTool); 
        toolBarControls.addElement( this.jToggleButtonChartTool); 
        toolBarControls.addElement( null); 
        toolBarControls.addElement( this.jButtonParameters);
        toolBarControls.addElement( this.jButtonGroups); 
        toolBarControls.addElement( this.jButtonBands);
        toolBarControls.addElement( this.jButtonDatabase);
        toolBarControls.addElement( null); 
        toolBarControls.addElement( this.jPanelZoom); 
        toolBarControls.addElement( null); 
        toolBarControls.addElement( this.jButtonCompiler); 
        
        toolBarControls.addElement(this.jButtonRun1); 
        toolBarControls.addElement(this.jButtonRun2); 
        toolBarControls.addElement( null); 
        toolBarControls.addElement(this.jButtonAlignLeft); 
        toolBarControls.addElement(this.jButtonAlignCenter); 
        toolBarControls.addElement(this.jButtonAlignRight); 
        toolBarControls.addElement(this.jButtonAlignJustify); 
        
        jNumberComboBoxZoom.addEntry("50%",50);
        jNumberComboBoxZoom.addEntry("75%",75);
        jNumberComboBoxZoom.addEntry("100%",100);
        jNumberComboBoxZoom.addEntry("150%",150);
        jNumberComboBoxZoom.addEntry("200%",200);
        jNumberComboBoxZoom.addEntry("Fit to page",100);
        //java.awt.Dimension dim = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        //this.setSize(dim);
     
        jPanelToolBarComponentResized(new java.awt.event.ComponentEvent(jPanelToolBar,0));
        
        // This try is of java <1.4 comatibility
        try {
               this.setExtendedState(MAXIMIZED_BOTH);
       } catch (java.lang.NoSuchMethodError ex)
       {}
        
        java.awt.Image def = Misc.loadImageFromResources("it/businesslogic/ireport/icons/layout/img.gif");
        try {
        java.awt.MediaTracker mt = new java.awt.MediaTracker( new javax.swing.JPanel() );
        mt.addImage(def,0);
        mt.waitForID(0);
        } catch (Exception ex){}
        ImageReportElement.setImgDef(def);
        //jNumberComboBoxZoom.setPostfix("%");
        
        javax.swing.tree.DefaultMutableTreeNode root = new javax.swing.tree.DefaultMutableTreeNode("Opened files");
        javax.swing.tree.DefaultTreeModel model = new javax.swing.tree.DefaultTreeModel(root);

        javax.swing.ToolTipManager.sharedInstance().registerComponent(jTreeFiles);
        jTreeFiles.setModel( model );
        jTreeFiles.setCellRenderer( new ProjectExplorerTreeCellRenderer());
        
        loadiReportConfiguration();
        //IRCompilerDocument doc = new IRCompilerDocument();
        
        //this.jEditorPaneOutput.setDocument(doc );
        this.jEditorPaneOutput.setContentType("text/html");

        this.jEditorPaneOutput.addHyperlinkListener( new javax.swing.event.HyperlinkListener() { 
 	    public void hyperlinkUpdate(javax.swing.event.HyperlinkEvent e) { 
 		if (e.getEventType() == javax.swing.event.HyperlinkEvent.EventType.ACTIVATED) { 
 		    if (!parseError(e.getURL()))
                        JOptionPane.showMessageDialog(null," HyperlinkEvent " + e.getURL() );
                    
 		} 
 	    } 
 	});
    
    
    }
    
    /**
     * Retrive the first unused mane like untitled_report_XXX
     */
    public String getFirstNameFree()
    {
        JInternalFrame[] frames = jMDIDesktopPane.getAllFrames();
        
        for (int k=1; ; k++)
        {
            String name = "untitled_report_" + k;
            boolean found = false;
            for (int i=0; i<frames.length ; ++i)
            {
                if (frames[i] instanceof JReportFrame)
                {
                    JReportFrame jrf = (JReportFrame)frames[i];
                    if (jrf.getReport().getName().equalsIgnoreCase(name))
                    {
                        found = true;
                        break;
                    }
                }
            }
            if (!found)
            {
                 return name;
            }
        }
    }
    
    
    public void setFileListActivatedFrame(JReportFrame jrf)
    {
         // remove the frame from the documnets list....
            DefaultTreeModel dtm = (DefaultTreeModel)jTreeFiles.getModel();
            Enumeration opened_entries = ((DefaultMutableTreeNode)dtm.getRoot()).children();
            while (opened_entries.hasMoreElements())
            {
                DefaultMutableTreeNode documentEntryNode = (DefaultMutableTreeNode)opened_entries.nextElement();
                if (documentEntryNode.getUserObject() instanceof DocumentTreeEntry)
                {
                    DocumentTreeEntry dte = (DocumentTreeEntry)documentEntryNode.getUserObject();
                    if (dte.getJrf() == jrf)
                    {
                        jTreeFiles.setSelectionPath(new TreePath(new Object[]{dtm.getRoot(), documentEntryNode}));
                        jTreeFiles.updateUI();
                        break;
                    }
                }
                
            }
    }
    
    public void updateMenuWindowList()
    {
        // Remove all menus...
        java.awt.Component[] menus = this.jMenuWindow.getMenuComponents();
        int i = 0;
        for (int k = 0;  k<menus.length ; ++k)
        {
            if ((menus[k] instanceof JRadioButtonMenuItemMDIFrame) &&
            ((JRadioButtonMenuItemMDIFrame)menus[k]).getFrame() != null &&
            ((JRadioButtonMenuItemMDIFrame)menus[k]).getFrame().isValid() &&
            ((JRadioButtonMenuItemMDIFrame)menus[k]).getFrame().isVisible())
            {
                
                JRadioButtonMenuItemMDIFrame menuItem = (JRadioButtonMenuItemMDIFrame)menus[k];
                menuItem.setText( (i+1) + ". " + menuItem.getFrame().getTitle() );
                menuItem.setMnemonic((int)(((i+1)+"").charAt(0)) );
                menuItem.setFont(new java.awt.Font("Dialog", 0, 11));
                menuItem.setAccelerator( javax.swing.KeyStroke.getKeyStroke((int)(((i+1)+"").charAt(0)),java.awt.Event.META_MASK));            
                i++;
                //System.out.println("Menu "+menuItem.getText());
            }           
        }
        
    }
    
    
     public void jMenuWindowListActionPerformed(java.awt.event.ActionEvent evt) {
        if (evt.getSource() != null &&
            evt.getSource() instanceof JRadioButtonMenuItemMDIFrame)
        {
            JRadioButtonMenuItemMDIFrame mdm = (JRadioButtonMenuItemMDIFrame)evt.getSource();
            try {
                
                mdm.getFrame().setSelected(true);
            } catch (Exception ex){}
        }
     
     }
                
    public void jMDIDesktopPaneInternalFrameActivated(InternalFrameActivatedEvent evt)
    {
        if (evt.getJMDIFrame() != null && evt.getAction() == InternalFrameActivatedEvent.CLOSED)
        {
            // remove the frame from the documnets list....
            DefaultTreeModel dtm = (DefaultTreeModel)jTreeFiles.getModel();
            Enumeration opened_entries = ((DefaultMutableTreeNode)dtm.getRoot()).children();
            while (opened_entries.hasMoreElements())
            {
                DefaultMutableTreeNode documentEntryNode = (DefaultMutableTreeNode)opened_entries.nextElement();
                if (documentEntryNode.getUserObject() instanceof DocumentTreeEntry)
                {
                    DocumentTreeEntry dte = (DocumentTreeEntry)documentEntryNode.getUserObject();
                    if (dte.getJrf() == evt.getJMDIFrame())
                    {
                        ((DefaultMutableTreeNode)dtm.getRoot()).remove(documentEntryNode); 
                        jTreeFiles.updateUI();
                        
                        break;
                    }
                }
                
            }
            // Remove from window list...
            java.awt.Component[] menus = this.jMenuWindow.getMenuComponents();
            for (int k = menus.length-1;  k>=0 ; --k)
            {
                    if (menus[k] instanceof JRadioButtonMenuItemMDIFrame &&
                        ((JRadioButtonMenuItemMDIFrame)menus[k]).getFrame() == evt.getJMDIFrame())
                    {
                        this.jMenuWindow.remove(menus[k]); 
                    }
            }
            updateMenuWindowList();
            return;
        }
        
        if (evt.getJMDIFrame() == null)
        {
            this.setTitle(constTitle);           
            setActiveReportForm( null );
            return;
        }
        
        
        this.setTitle(constTitle + " ["+ evt.getJMDIFrame().getTitle() + "]"); 
        jMDIMenuBar.restoreButtonsPosition();
        //System.out.println("Value setted!");
        if (evt.getJMDIFrame() instanceof JReportFrame)
        {
            
            JReportFrame jrf = (JReportFrame)evt.getJMDIFrame();
            this.jNumberComboBoxZoom.setValue(jrf.getZoomFactor()*100);
            // Set the fit to page value...
            setFileListActivatedFrame(jrf);
            updateFitToPage(jrf);
            
            // Enable all buttons and menus...
            setActiveReportForm( jrf );
            
        }
        else
        {
            //System.out.println("Chiusetutte lengthfinestre!");
            setActiveReportForm( null );
        }
    }
    
    private void setActiveReportForm(JReportFrame jrf)
    {
        boolean enabled = true;
        if (jrf == null)
        {
            enabled = false;
        }
        else
        {
            this.setTitle(constTitle + " ["+ jrf.getReport().getName() + " "+ jrf.getReport().getWidth()+"x"+jrf.getReport().getHeight()+" "+jrf.getReport().getFilename()+" ]"); 
        }
        
        if (jrf != null)
        {
            java.awt.Component[] menus = this.jMenuWindow.getMenuComponents();
            for (int k = menus.length-1;  k>=0 ; --k)
            {
                    if (menus[k] instanceof JRadioButtonMenuItemMDIFrame &&
                        ((JRadioButtonMenuItemMDIFrame)menus[k]).getFrame() == jrf)
                    {
                        ((JRadioButtonMenuItemMDIFrame)menus[k]).setSelected(true);
                    }
            }
        }
        
        this.elementPropertiesDialog.setJReportFrame(jrf);
        this.valuesDialog.setJReportFrame(jrf);
        this.groupsDialog.setJReportFrame(jrf);
        this.bandsDialog.setJReportFrame(jrf);
        this.fontsDialog.setJReportFrame(jrf);
        this.reportQueryDialog.setJReportFrame(jrf);
        
        // Toolbar...
        this.jButtonBands.setEnabled(enabled);
        this.jButtonDatabase.setEnabled(enabled);
        this.jButtonParameters.setEnabled(enabled);
        this.jButtonGroups.setEnabled(enabled);
        this.jButtonCompiler.setEnabled(enabled);
        this.jButtonRun1.setEnabled(enabled);
        this.jButtonRun2.setEnabled(enabled);
        this.jButtonAlignLeft.setEnabled(enabled);
        this.jButtonAlignCenter.setEnabled(enabled);
        this.jButtonAlignRight.setEnabled(enabled);
        this.jButtonAlignJustify.setEnabled(enabled);
        
        this.jToggleButtonEllipseTool.setEnabled(enabled);
        this.jToggleButtonImageTool.setEnabled(enabled);
        this.jToggleButtonLineTool.setEnabled(enabled);
        
        this.jToggleButtonPointer.setEnabled(enabled);    
        this.jToggleButtonRectRoundTool.setEnabled(enabled);
        this.jToggleButtonRectTool.setEnabled(enabled);
        this.jButtonSave.setEnabled(enabled);
        this.jToggleButtonStaticTextTool.setEnabled(enabled);
        this.jToggleButtonSubreportTool.setEnabled(enabled);
        this.jToggleButtonChartTool.setEnabled(enabled);
        this.jToggleButtonTextFieldTool.setEnabled(enabled);
        this.jMenuItemXMLSource.setEnabled(enabled);
        this.jCheckBoxMenuItemEMM.setEnabled(enabled);
        this.jCheckBoxMenuItemGrid.setEnabled(enabled);
        this.jCheckBoxMenuItemSnapToGrid.setEnabled(enabled);
        this.jMenuAdd.setEnabled(true);
        
        jMDIDesktopPane.setPreferredSize(new java.awt.Dimension(100,10));
        jMDIDesktopPane.setMinimumSize(new java.awt.Dimension(100,10));
        //jMDIDesktopPane.setPreferredSize(new Dimension(100,100));
        setActiveTool(this.jToggleButtonPointer);
        if (!enabled)  this.jToggleButtonPointer.setSelected(false);
    }
    
    public boolean isEMMActive()
    {
        return this.jCheckBoxMenuItemEMM.isSelected();
    }
    
    public void setActiveTool( int tool )
    {
        if (tool == 0)
            setActiveTool(this.jToggleButtonPointer);
    }
    private void setActiveTool( java.awt.Component tool )
    {
        try {
        this.jToggleButtonEllipseTool.setSelected(  (tool ==this.jToggleButtonEllipseTool) );
        this.jToggleButtonImageTool.setSelected(  (tool ==this.jToggleButtonImageTool) );
        this.jToggleButtonLineTool.setSelected(  (tool ==this.jToggleButtonLineTool) );
        this.jToggleButtonPointer.setSelected(  (tool ==this.jToggleButtonPointer) );
        this.jToggleButtonRectRoundTool.setSelected(  (tool ==this.jToggleButtonRectRoundTool) );
        this.jToggleButtonRectTool.setSelected(  (tool ==this.jToggleButtonRectTool) );
        this.jToggleButtonStaticTextTool.setSelected(  (tool ==this.jToggleButtonStaticTextTool) );
        this.jToggleButtonSubreportTool.setSelected(  (tool ==this.jToggleButtonSubreportTool) );
        this.jToggleButtonChartTool.setSelected(  (tool ==this.jToggleButtonChartTool) );
        this.jToggleButtonTextFieldTool.setSelected(  (tool ==this.jToggleButtonTextFieldTool) );
        } catch (Exception ex) {}
    }
    
    public void updateFitToPage(JReportFrame jrf)
    {
        int w = jrf.getReport().getWidth();
        double s = (jrf.getReportPanel().getWidth()-20)/(double)w;        
	jNumberComboBoxZoom.addEntry("Fit to page", s*100);
    }
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        buttonGroupExportType = new javax.swing.ButtonGroup();
        buttonGroupFramesList = new javax.swing.ButtonGroup();
        jPanelToolBar = new javax.swing.JPanel();
        jPanelZoom = new javax.swing.JPanel();
        jNumberComboBoxZoom = new it.businesslogic.ireport.gui.JNumberComboBox();
        jButtonNew = new javax.swing.JButton();
        jButtonOpen = new javax.swing.JButton();
        jButtonSave = new javax.swing.JButton();
        jButtonCut = new javax.swing.JButton();
        jButtonCopy = new javax.swing.JButton();
        jButtonPaste = new javax.swing.JButton();
        jToggleButtonPointer = new javax.swing.JToggleButton();
        jToggleButtonLineTool = new javax.swing.JToggleButton();
        jToggleButtonRectTool = new javax.swing.JToggleButton();
        jToggleButtonRectRoundTool = new javax.swing.JToggleButton();
        jToggleButtonEllipseTool = new javax.swing.JToggleButton();
        jToggleButtonImageTool = new javax.swing.JToggleButton();
        jToggleButtonStaticTextTool = new javax.swing.JToggleButton();
        jToggleButtonTextFieldTool = new javax.swing.JToggleButton();
        jToggleButtonSubreportTool = new javax.swing.JToggleButton();
        jButtonBands = new javax.swing.JButton();
        jButtonGroups = new javax.swing.JButton();
        jButtonParameters = new javax.swing.JButton();
        jButtonDatabase = new javax.swing.JButton();
        jButtonAlignLeft = new javax.swing.JButton();
        jButtonAlignCenter = new javax.swing.JButton();
        jButtonAlignRight = new javax.swing.JButton();
        jButtonAlignJustify = new javax.swing.JButton();
        jButtonCompiler = new javax.swing.JButton();
        jButtonRun1 = new javax.swing.JButton();
        jButtonRun2 = new javax.swing.JButton();
        jToggleButtonChartTool = new javax.swing.JToggleButton();
        jSplitPaneV = new javax.swing.JSplitPane();
        jPanelMaster = new javax.swing.JPanel();
        jSplitPaneHorizontal = new javax.swing.JSplitPane();
        jMDIDesktopPane = new it.businesslogic.ireport.gui.JMDIDesktopPane();
        jTabbedPaneExplorer = new javax.swing.JTabbedPane();
        jPanelFiles = new javax.swing.JPanel();
        jScrollPaneFiles = new javax.swing.JScrollPane();
        jTreeFiles = new javax.swing.JTree();
        jPanelDocumentStructure = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTreeDocument = new javax.swing.JTree();
        jPanelSouth = new javax.swing.JPanel();
        jScrollPaneOutput = new javax.swing.JScrollPane();
        jEditorPaneOutput = new javax.swing.JEditorPane();
        jPanelProcesses = new javax.swing.JPanel();
        jTabbedPane1 = new javax.swing.JTabbedPane();
        jScrollProcesses = new javax.swing.JScrollPane();
        jListThreads = new javax.swing.JList();
        jMDIMenuBar = new it.businesslogic.ireport.gui.JMDIMenuBar();
        jMenuFile = new javax.swing.JMenu();
        jMenuItemNewDocument = new javax.swing.JMenuItem();
        jMenuItemOpen = new javax.swing.JMenuItem();
        jMenuItemQOpen = new javax.swing.JMenuItem();
        jSeparator16 = new javax.swing.JSeparator();
        jMenuItemSave = new javax.swing.JMenuItem();
        jMenuItemSaveAs = new javax.swing.JMenuItem();
        jMenuItemSaveAll = new javax.swing.JMenuItem();
        jSeparator3 = new javax.swing.JSeparator();
        jMenuRecentFiles = new javax.swing.JMenu();
        jMenuRecentProjects = new javax.swing.JMenu();
        jMenuItemFavorites = new javax.swing.JMenuItem();
        jSeparator15 = new javax.swing.JSeparator();
        jMenuItemQuit = new javax.swing.JMenuItem();
        jMenuEdit = new javax.swing.JMenu();
        jMenuItemUndo = new javax.swing.JMenuItem();
        jMenuItemRedo = new javax.swing.JMenuItem();
        jSeparator1 = new javax.swing.JSeparator();
        jMenuItemCut = new javax.swing.JMenuItem();
        jMenuItemCopy = new javax.swing.JMenuItem();
        jMenuItemPaste = new javax.swing.JMenuItem();
        jMenuItemDelete = new javax.swing.JMenuItem();
        jSeparator2 = new javax.swing.JSeparator();
        jCheckBoxMenuItemEMM = new javax.swing.JCheckBoxMenuItem();
        jCheckBoxMenuItemSnapToGrid = new javax.swing.JCheckBoxMenuItem();
        jMenuAdd = new javax.swing.JMenu();
        jMenuItemNullElement = new javax.swing.JMenuItem();
        jMenuItemLine = new javax.swing.JMenuItem();
        jMenuItemRectangle = new javax.swing.JMenuItem();
        jMenuItemRoundRectangle = new javax.swing.JMenuItem();
        jMenuItemEllipse = new javax.swing.JMenuItem();
        jMenuItemStaticText = new javax.swing.JMenuItem();
        jMenuItemTextField = new javax.swing.JMenuItem();
        jMenuItemSubreport = new javax.swing.JMenuItem();
        jMenuItemXMLSource = new javax.swing.JMenuItem();
        jMenuView = new javax.swing.JMenu();
        jCheckBoxMenuItemGrid = new javax.swing.JCheckBoxMenuItem();
        jSeparator4 = new javax.swing.JSeparator();
        jCheckBoxMenuItemOutput = new javax.swing.JCheckBoxMenuItem();
        jCheckBoxMenuItemExplorer = new javax.swing.JCheckBoxMenuItem();
        jSeparator12 = new javax.swing.JSeparator();
        jMenuItemReportProperties = new javax.swing.JMenuItem();
        jMenuItemReportQuery = new javax.swing.JMenuItem();
        jMenuItemFields = new javax.swing.JMenuItem();
        jMenuItemVariables = new javax.swing.JMenuItem();
        jMenuItemParameters = new javax.swing.JMenuItem();
        jMenuItemFonts = new javax.swing.JMenuItem();
        jSeparator6 = new javax.swing.JSeparator();
        jMenuItemBands = new javax.swing.JMenuItem();
        jMenuItemGroups = new javax.swing.JMenuItem();
        jSeparator7 = new javax.swing.JSeparator();
        jMenuItemElementProperties = new javax.swing.JMenuItem();
        jMenuItemElementsBrowser = new javax.swing.JMenuItem();
        jMenuSearch = new javax.swing.JMenu();
        jMenuItemFind = new javax.swing.JMenuItem();
        jMenuItemFindNext = new javax.swing.JMenuItem();
        jMenuItemFindPrev = new javax.swing.JMenuItem();
        jMenuItemReplace = new javax.swing.JMenuItem();
        jMenuProjects = new javax.swing.JMenu();
        jMenuItemNewProject = new javax.swing.JMenuItem();
        jMenuItemOpenProject = new javax.swing.JMenuItem();
        jMenuItemCloseProject = new javax.swing.JMenuItem();
        jSeparator13 = new javax.swing.JSeparator();
        jMenuItemAddFileToProject = new javax.swing.JMenuItem();
        jMenuItemProjectOptions = new javax.swing.JMenuItem();
        jMenuBuild = new javax.swing.JMenu();
        jMenuItemCompile = new javax.swing.JMenuItem();
        jMenuItemCompileAll = new javax.swing.JMenuItem();
        jSeparator10 = new javax.swing.JSeparator();
        jMenuItemExecute = new javax.swing.JMenuItem();
        jMenuItemViewConsole = new javax.swing.JMenuItem();
        jSeparator11 = new javax.swing.JSeparator();
        jRadioButtonMenuItemPreviewPDF = new javax.swing.JRadioButtonMenuItem();
        jRadioButtonMenuItemPreviewHTML = new javax.swing.JRadioButtonMenuItem();
        jRadioButtonMenuItemPreviewJAVA = new javax.swing.JRadioButtonMenuItem();
        jRadioButtonMenuItemPreviewXLS = new javax.swing.JRadioButtonMenuItem();
        jRadioButtonMenuItemPreviewCSV = new javax.swing.JRadioButtonMenuItem();
        jSeparator14 = new javax.swing.JSeparator();
        jMenuItemActiveConnection = new javax.swing.JMenuItem();
        jMenuFormat = new javax.swing.JMenu();
        jMenuAlign = new javax.swing.JMenu();
        jMenuItemAlignLeft = new javax.swing.JMenuItem();
        jMenuItemAlignRight = new javax.swing.JMenuItem();
        jMenuItemAlignTop = new javax.swing.JMenuItem();
        jMenuItemAlignBottom = new javax.swing.JMenuItem();
        jSeparator19 = new javax.swing.JSeparator();
        jMenuItemAlignVerticalAxis = new javax.swing.JMenuItem();
        jMenuItemAlignHorizontalAxis = new javax.swing.JMenuItem();
        jSeparator20 = new javax.swing.JSeparator();
        jMenuItemAlignToBandTop = new javax.swing.JMenuItem();
        jMenuItemAlignToBandBottom = new javax.swing.JMenuItem();
        jMenuSize = new javax.swing.JMenu();
        jMenuItemSameWidth = new javax.swing.JMenuItem();
        jMenuItemSameWidthMax = new javax.swing.JMenuItem();
        jMenuItemSameWidthMin = new javax.swing.JMenuItem();
        jSeparator17 = new javax.swing.JSeparator();
        jMenuItemSameHeight = new javax.swing.JMenuItem();
        jMenuItemSameHeightMin = new javax.swing.JMenuItem();
        jMenuItemSameHeightMax = new javax.swing.JMenuItem();
        jSeparator18 = new javax.swing.JSeparator();
        jMenuItemSameSize = new javax.swing.JMenuItem();
        jMenuPosition = new javax.swing.JMenu();
        jMenuItemCenterH = new javax.swing.JMenuItem();
        jMenuItemCenterV = new javax.swing.JMenuItem();
        jMenuItemCenterInBand = new javax.swing.JMenuItem();
        jMenuItemCenterBackground = new javax.swing.JMenuItem();
        jMenuItemJoinLeft = new javax.swing.JMenuItem();
        jMenuItemJoinRight = new javax.swing.JMenuItem();
        jSeparator5 = new javax.swing.JSeparator();
        jMenuHSpacing = new javax.swing.JMenu();
        jMenuItemHSMakeEqual = new javax.swing.JMenuItem();
        jMenuItemHSIncrease = new javax.swing.JMenuItem();
        jMenuItemHSDecrease = new javax.swing.JMenuItem();
        jMenuItemHSRemove = new javax.swing.JMenuItem();
        jMenuVSpacing = new javax.swing.JMenu();
        jMenuItemVSMakeEqual = new javax.swing.JMenuItem();
        jMenuItemVSIncrease = new javax.swing.JMenuItem();
        jMenuItemVSDecrease = new javax.swing.JMenuItem();
        jMenuItemVSRemove = new javax.swing.JMenuItem();
        jSeparator8 = new javax.swing.JSeparator();
        jMenuItemBringToFront = new javax.swing.JMenuItem();
        jMenuItemSendToBack = new javax.swing.JMenuItem();
        jMenuDatabase = new javax.swing.JMenu();
        jMenuItemConnections = new javax.swing.JMenuItem();
        jSeparator9 = new javax.swing.JSeparator();
        jMenuItemReportQuery2 = new javax.swing.JMenuItem();
        jMenuTools = new javax.swing.JMenu();
        jMenuItemOptions = new javax.swing.JMenuItem();
        jMenuItemCompatibility = new javax.swing.JMenuItem();
        jMenuWindow = new javax.swing.JMenu();
        jMenuItemCascade = new javax.swing.JMenuItem();
        jMenuItemTileHorizontal = new javax.swing.JMenuItem();
        jMenuItemTileVertical = new javax.swing.JMenuItem();
        jMenuItemtileAnodine = new javax.swing.JMenuItem();
        jMenuItemNextWin = new javax.swing.JMenuItem();
        jMenuItemPrevWin = new javax.swing.JMenuItem();
        jSeparator21 = new javax.swing.JSeparator();
        jMenuHelp = new javax.swing.JMenu();
        jMenuItemHelp = new javax.swing.JMenuItem();
        jMenuItemAbout = new javax.swing.JMenuItem();

        setTitle("iReport 0.0.9");
        setIconImage(getIconImage());
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowOpened(java.awt.event.WindowEvent evt) {
                formWindowOpened(evt);
            }
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        jPanelToolBar.setLayout(null);

        jPanelToolBar.setMaximumSize(new java.awt.Dimension(32000, 32000));
        jPanelToolBar.setMinimumSize(new java.awt.Dimension(36, 500));
        jPanelToolBar.setPreferredSize(new java.awt.Dimension(200, 36));
        jPanelToolBar.addComponentListener(new java.awt.event.ComponentAdapter() {
            public void componentResized(java.awt.event.ComponentEvent evt) {
                jPanelToolBarComponentResized(evt);
            }
        });

        jPanelZoom.setLayout(null);

        jPanelZoom.setBorder(new javax.swing.border.EtchedBorder());
        jNumberComboBoxZoom.setPostfix("%");
        jPanelZoom.add(jNumberComboBoxZoom);
        jNumberComboBoxZoom.setBounds(4, 4, 82, 24);

        jPanelToolBar.add(jPanelZoom);
        jPanelZoom.setBounds(400, 0, 90, 32);

        jButtonNew.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/new1.jpg")));
        jButtonNew.setToolTipText("New document");
        jButtonNew.setBorder(null);
        jButtonNew.setBorderPainted(false);
        jButtonNew.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/new2.jpg")));
        jButtonNew.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/new3.jpg")));
        jButtonNew.setSelectedIcon(new javax.swing.ImageIcon(""));
        jButtonNew.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonNewActionPerformed(evt);
            }
        });

        jPanelToolBar.add(jButtonNew);
        jButtonNew.setBounds(0, 0, 32, 32);

        jButtonOpen.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/open1.jpg")));
        jButtonOpen.setToolTipText("Open a document");
        jButtonOpen.setBorder(null);
        jButtonOpen.setBorderPainted(false);
        jButtonOpen.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/open2.jpg")));
        jButtonOpen.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/open3.jpg")));
        jButtonOpen.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOpenActionPerformed(evt);
            }
        });

        jPanelToolBar.add(jButtonOpen);
        jButtonOpen.setBounds(50, 0, 32, 32);

        jButtonSave.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/save1.jpg")));
        jButtonSave.setBorder(null);
        jButtonSave.setBorderPainted(false);
        jButtonSave.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/save2.jpg")));
        jButtonSave.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/save3.jpg")));
        jButtonSave.setEnabled(false);
        jButtonSave.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonSaveActionPerformed(evt);
            }
        });

        jPanelToolBar.add(jButtonSave);
        jButtonSave.setBounds(40, 0, 32, 32);

        jButtonCut.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/cut1.jpg")));
        jButtonCut.setToolTipText("Cut");
        jButtonCut.setBorder(null);
        jButtonCut.setBorderPainted(false);
        jButtonCut.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/cut2.jpg")));
        jButtonCut.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/cut3.jpg")));
        jButtonCut.setEnabled(false);
        jPanelToolBar.add(jButtonCut);
        jButtonCut.setBounds(50, 0, 32, 32);

        jButtonCopy.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/copy1.jpg")));
        jButtonCopy.setToolTipText("Copy");
        jButtonCopy.setBorder(null);
        jButtonCopy.setBorderPainted(false);
        jButtonCopy.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/copy2.jpg")));
        jButtonCopy.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/copy3.jpg")));
        jButtonCopy.setEnabled(false);
        jPanelToolBar.add(jButtonCopy);
        jButtonCopy.setBounds(0, 0, 32, 32);

        jButtonPaste.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/paste1.jpg")));
        jButtonPaste.setToolTipText("Paste");
        jButtonPaste.setBorder(null);
        jButtonPaste.setBorderPainted(false);
        jButtonPaste.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/paste2.jpg")));
        jButtonPaste.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/paste3.jpg")));
        jButtonPaste.setEnabled(false);
        jPanelToolBar.add(jButtonPaste);
        jButtonPaste.setBounds(80, 0, 32, 32);

        jToggleButtonPointer.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/pointer1.jpg")));
        jToggleButtonPointer.setBorder(null);
        jToggleButtonPointer.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/pointer2.jpg")));
        jToggleButtonPointer.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/pointer3.jpg")));
        jToggleButtonPointer.setSelectedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/pointer3.jpg")));
        jToggleButtonPointer.setEnabled(false);
        jToggleButtonPointer.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jToggleButtonPointerActionPerformed(evt);
            }
        });

        jToggleButtonPointer.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jToggleButtonPointerItemStateChanged(evt);
            }
        });

        jPanelToolBar.add(jToggleButtonPointer);
        jToggleButtonPointer.setBounds(100, 0, 32, 32);

        jToggleButtonLineTool.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/lineTool1.jpg")));
        jToggleButtonLineTool.setBorder(null);
        jToggleButtonLineTool.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/lineTool2.jpg")));
        jToggleButtonLineTool.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/lineTool3.jpg")));
        jToggleButtonLineTool.setSelectedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/lineTool3.jpg")));
        jToggleButtonLineTool.setEnabled(false);
        jToggleButtonLineTool.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jToggleButtonLineToolActionPerformed(evt);
            }
        });

        jToggleButtonLineTool.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jToggleButtonLineToolItemStateChanged(evt);
            }
        });

        jPanelToolBar.add(jToggleButtonLineTool);
        jToggleButtonLineTool.setBounds(100, 0, 32, 32);

        jToggleButtonRectTool.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/rectTool1.jpg")));
        jToggleButtonRectTool.setBorder(null);
        jToggleButtonRectTool.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/rectTool2.jpg")));
        jToggleButtonRectTool.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/rectTool3.jpg")));
        jToggleButtonRectTool.setSelectedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/rectTool3.jpg")));
        jToggleButtonRectTool.setEnabled(false);
        jToggleButtonRectTool.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jToggleButtonRectToolActionPerformed(evt);
            }
        });

        jToggleButtonRectTool.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jToggleButtonRectToolItemStateChanged(evt);
            }
        });

        jPanelToolBar.add(jToggleButtonRectTool);
        jToggleButtonRectTool.setBounds(110, 0, 32, 32);

        jToggleButtonRectRoundTool.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/roundRectTool1.jpg")));
        jToggleButtonRectRoundTool.setBorder(null);
        jToggleButtonRectRoundTool.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/roundRectTool2.jpg")));
        jToggleButtonRectRoundTool.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/roundRectTool3.jpg")));
        jToggleButtonRectRoundTool.setSelectedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/roundRectTool3.jpg")));
        jToggleButtonRectRoundTool.setEnabled(false);
        jToggleButtonRectRoundTool.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jToggleButtonRectRoundToolActionPerformed(evt);
            }
        });

        jToggleButtonRectRoundTool.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jToggleButtonRectRoundToolItemStateChanged(evt);
            }
        });

        jPanelToolBar.add(jToggleButtonRectRoundTool);
        jToggleButtonRectRoundTool.setBounds(110, 0, 32, 32);

        jToggleButtonEllipseTool.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/ellipseTool1.jpg")));
        jToggleButtonEllipseTool.setBorder(null);
        jToggleButtonEllipseTool.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/ellipseTool2.jpg")));
        jToggleButtonEllipseTool.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/ellipseTool3.jpg")));
        jToggleButtonEllipseTool.setSelectedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/ellipseTool3.jpg")));
        jToggleButtonEllipseTool.setEnabled(false);
        jToggleButtonEllipseTool.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jToggleButtonEllipseToolActionPerformed(evt);
            }
        });

        jToggleButtonEllipseTool.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jToggleButtonEllipseToolItemStateChanged(evt);
            }
        });

        jPanelToolBar.add(jToggleButtonEllipseTool);
        jToggleButtonEllipseTool.setBounds(110, 0, 32, 32);

        jToggleButtonImageTool.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/imageTool1.jpg")));
        jToggleButtonImageTool.setBorder(null);
        jToggleButtonImageTool.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/imageTool2.jpg")));
        jToggleButtonImageTool.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/imageTool3.jpg")));
        jToggleButtonImageTool.setSelectedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/imageTool3.jpg")));
        jToggleButtonImageTool.setEnabled(false);
        jToggleButtonImageTool.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jToggleButtonImageToolActionPerformed(evt);
            }
        });

        jToggleButtonImageTool.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jToggleButtonImageToolItemStateChanged(evt);
            }
        });

        jPanelToolBar.add(jToggleButtonImageTool);
        jToggleButtonImageTool.setBounds(110, 0, 32, 32);

        jToggleButtonStaticTextTool.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/textTool1.jpg")));
        jToggleButtonStaticTextTool.setBorder(null);
        jToggleButtonStaticTextTool.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/textTool2.jpg")));
        jToggleButtonStaticTextTool.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/textTool3.jpg")));
        jToggleButtonStaticTextTool.setSelectedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/textTool3.jpg")));
        jToggleButtonStaticTextTool.setEnabled(false);
        jToggleButtonStaticTextTool.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jToggleButtonStaticTextToolActionPerformed(evt);
            }
        });

        jToggleButtonStaticTextTool.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jToggleButtonStaticTextToolItemStateChanged(evt);
            }
        });

        jPanelToolBar.add(jToggleButtonStaticTextTool);
        jToggleButtonStaticTextTool.setBounds(110, 0, 32, 32);

        jToggleButtonTextFieldTool.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/fieldTool1.jpg")));
        jToggleButtonTextFieldTool.setBorder(null);
        jToggleButtonTextFieldTool.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/fieldTool2.jpg")));
        jToggleButtonTextFieldTool.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/fieldTool3.jpg")));
        jToggleButtonTextFieldTool.setSelectedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/fieldTool3.jpg")));
        jToggleButtonTextFieldTool.setEnabled(false);
        jToggleButtonTextFieldTool.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jToggleButtonTextFieldToolActionPerformed(evt);
            }
        });

        jToggleButtonTextFieldTool.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jToggleButtonTextFieldToolItemStateChanged(evt);
            }
        });

        jPanelToolBar.add(jToggleButtonTextFieldTool);
        jToggleButtonTextFieldTool.setBounds(110, 0, 32, 32);

        jToggleButtonSubreportTool.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/subreportTool1.jpg")));
        jToggleButtonSubreportTool.setBorder(null);
        jToggleButtonSubreportTool.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/subreportTool2.jpg")));
        jToggleButtonSubreportTool.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/subreportTool3.jpg")));
        jToggleButtonSubreportTool.setSelectedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/subreportTool3.jpg")));
        jToggleButtonSubreportTool.setEnabled(false);
        jToggleButtonSubreportTool.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jToggleButtonSubreportToolActionPerformed(evt);
            }
        });

        jToggleButtonSubreportTool.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jToggleButtonSubreportToolItemStateChanged(evt);
            }
        });

        jPanelToolBar.add(jToggleButtonSubreportTool);
        jToggleButtonSubreportTool.setBounds(110, 0, 32, 32);

        jButtonBands.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/bands1.jpg")));
        jButtonBands.setToolTipText("Copy");
        jButtonBands.setBorder(null);
        jButtonBands.setBorderPainted(false);
        jButtonBands.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/bands2.jpg")));
        jButtonBands.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/bands3.jpg")));
        jButtonBands.setEnabled(false);
        jButtonBands.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonBandsActionPerformed(evt);
            }
        });

        jPanelToolBar.add(jButtonBands);
        jButtonBands.setBounds(0, 0, 32, 32);

        jButtonGroups.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/groups1.jpg")));
        jButtonGroups.setToolTipText("Copy");
        jButtonGroups.setBorder(null);
        jButtonGroups.setBorderPainted(false);
        jButtonGroups.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/groups2.jpg")));
        jButtonGroups.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/groups3.jpg")));
        jButtonGroups.setEnabled(false);
        jButtonGroups.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonGroupsActionPerformed(evt);
            }
        });

        jPanelToolBar.add(jButtonGroups);
        jButtonGroups.setBounds(0, 0, 32, 32);

        jButtonParameters.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/parameters1.jpg")));
        jButtonParameters.setToolTipText("Copy");
        jButtonParameters.setBorder(null);
        jButtonParameters.setBorderPainted(false);
        jButtonParameters.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/parameters2.jpg")));
        jButtonParameters.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/parameters3.jpg")));
        jButtonParameters.setEnabled(false);
        jButtonParameters.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonParametersActionPerformed(evt);
            }
        });

        jPanelToolBar.add(jButtonParameters);
        jButtonParameters.setBounds(0, 0, 32, 32);

        jButtonDatabase.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/database1.jpg")));
        jButtonDatabase.setToolTipText("Copy");
        jButtonDatabase.setBorder(null);
        jButtonDatabase.setBorderPainted(false);
        jButtonDatabase.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/database2.jpg")));
        jButtonDatabase.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/database3.jpg")));
        jButtonDatabase.setEnabled(false);
        jButtonDatabase.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonDatabaseActionPerformed(evt);
            }
        });

        jPanelToolBar.add(jButtonDatabase);
        jButtonDatabase.setBounds(0, 0, 32, 32);

        jButtonAlignLeft.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/alignLeft1.jpg")));
        jButtonAlignLeft.setToolTipText("Copy");
        jButtonAlignLeft.setBorder(null);
        jButtonAlignLeft.setBorderPainted(false);
        jButtonAlignLeft.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/alignLeft2.jpg")));
        jButtonAlignLeft.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/alignLeft3.jpg")));
        jButtonAlignLeft.setEnabled(false);
        jPanelToolBar.add(jButtonAlignLeft);
        jButtonAlignLeft.setBounds(0, 0, 32, 32);

        jButtonAlignCenter.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/alignCenter1.jpg")));
        jButtonAlignCenter.setToolTipText("Copy");
        jButtonAlignCenter.setBorder(null);
        jButtonAlignCenter.setBorderPainted(false);
        jButtonAlignCenter.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/alignCenter2.jpg")));
        jButtonAlignCenter.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/alignCenter3.jpg")));
        jButtonAlignCenter.setEnabled(false);
        jPanelToolBar.add(jButtonAlignCenter);
        jButtonAlignCenter.setBounds(0, 0, 32, 32);

        jButtonAlignRight.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/alignRight1.jpg")));
        jButtonAlignRight.setToolTipText("Copy");
        jButtonAlignRight.setBorder(null);
        jButtonAlignRight.setBorderPainted(false);
        jButtonAlignRight.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/alignRight2.jpg")));
        jButtonAlignRight.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/alignRight3.jpg")));
        jButtonAlignRight.setEnabled(false);
        jPanelToolBar.add(jButtonAlignRight);
        jButtonAlignRight.setBounds(0, 0, 32, 32);

        jButtonAlignJustify.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/alignJustify1.jpg")));
        jButtonAlignJustify.setToolTipText("Copy");
        jButtonAlignJustify.setBorder(null);
        jButtonAlignJustify.setBorderPainted(false);
        jButtonAlignJustify.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/alignJustify2.jpg")));
        jButtonAlignJustify.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/alignJustify3.jpg")));
        jButtonAlignJustify.setEnabled(false);
        jPanelToolBar.add(jButtonAlignJustify);
        jButtonAlignJustify.setBounds(0, 0, 32, 32);

        jButtonCompiler.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/comp1.jpg")));
        jButtonCompiler.setToolTipText("Compile the report");
        jButtonCompiler.setBorder(null);
        jButtonCompiler.setBorderPainted(false);
        jButtonCompiler.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/comp2.jpg")));
        jButtonCompiler.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/comp3.jpg")));
        jButtonCompiler.setEnabled(false);
        jButtonCompiler.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCompilerActionPerformed(evt);
            }
        });

        jPanelToolBar.add(jButtonCompiler);
        jButtonCompiler.setBounds(0, 0, 32, 32);

        jButtonRun1.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/run1.jpg")));
        jButtonRun1.setToolTipText("Run report using an empty datasource");
        jButtonRun1.setBorder(null);
        jButtonRun1.setBorderPainted(false);
        jButtonRun1.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/run2.jpg")));
        jButtonRun1.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/run3.jpg")));
        jButtonRun1.setEnabled(false);
        jButtonRun1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonRun1ActionPerformed(evt);
            }
        });

        jPanelToolBar.add(jButtonRun1);
        jButtonRun1.setBounds(0, 0, 32, 32);

        jButtonRun2.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/rundb1.jpg")));
        jButtonRun2.setToolTipText("Run report using a connection");
        jButtonRun2.setBorder(null);
        jButtonRun2.setBorderPainted(false);
        jButtonRun2.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/rundb2.jpg")));
        jButtonRun2.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/rundb3.jpg")));
        jButtonRun2.setEnabled(false);
        jPanelToolBar.add(jButtonRun2);
        jButtonRun2.setBounds(0, 0, 32, 32);

        jToggleButtonChartTool.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/chart1.jpg")));
        jToggleButtonChartTool.setBorder(null);
        jToggleButtonChartTool.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/chart2.jpg")));
        jToggleButtonChartTool.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/chart3.jpg")));
        jToggleButtonChartTool.setSelectedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/chart3.jpg")));
        jToggleButtonChartTool.setEnabled(false);
        jToggleButtonChartTool.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jToggleButtonChartToolStateChanged(evt);
            }
        });

        jToggleButtonChartTool.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jToggleButtonChartToolItemStateChanged(evt);
            }
        });

        jPanelToolBar.add(jToggleButtonChartTool);
        jToggleButtonChartTool.setBounds(110, 0, 32, 32);

        getContentPane().add(jPanelToolBar, java.awt.BorderLayout.NORTH);

        jSplitPaneV.setDividerSize(8);
        jSplitPaneV.setOrientation(javax.swing.JSplitPane.VERTICAL_SPLIT);
        jSplitPaneV.setResizeWeight(1.0);
        jSplitPaneV.setOneTouchExpandable(true);
        jPanelMaster.setLayout(new java.awt.BorderLayout());

        jPanelMaster.setMinimumSize(new java.awt.Dimension(750, 100));
        jPanelMaster.setPreferredSize(new java.awt.Dimension(750, 550));
        jSplitPaneHorizontal.setDividerSize(8);
        jSplitPaneHorizontal.setOneTouchExpandable(true);
        jSplitPaneHorizontal.setRightComponent(jMDIDesktopPane);

        jTabbedPaneExplorer.setTabPlacement(javax.swing.JTabbedPane.BOTTOM);
        jTabbedPaneExplorer.setFont(new java.awt.Font("Dialog", 0, 11));
        jTabbedPaneExplorer.setPreferredSize(new java.awt.Dimension(150, 10));
        jTabbedPaneExplorer.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jTabbedPaneExplorerStateChanged(evt);
            }
        });

        jPanelFiles.setLayout(new java.awt.BorderLayout());

        jTreeFiles.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jTreeFilesMouseClicked(evt);
            }
        });

        jScrollPaneFiles.setViewportView(jTreeFiles);

        jPanelFiles.add(jScrollPaneFiles, java.awt.BorderLayout.CENTER);

        jTabbedPaneExplorer.addTab("Files", jPanelFiles);

        jPanelDocumentStructure.setLayout(new java.awt.BorderLayout());

        jScrollPane1.setViewportView(jTreeDocument);

        jPanelDocumentStructure.add(jScrollPane1, java.awt.BorderLayout.CENTER);

        jTabbedPaneExplorer.addTab("Document structure", jPanelDocumentStructure);

        jSplitPaneHorizontal.setLeftComponent(jTabbedPaneExplorer);

        jPanelMaster.add(jSplitPaneHorizontal, java.awt.BorderLayout.CENTER);

        jSplitPaneV.setTopComponent(jPanelMaster);

        jPanelSouth.setLayout(new java.awt.BorderLayout());

        jScrollPaneOutput.setHorizontalScrollBarPolicy(javax.swing.JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
        jScrollPaneOutput.setVerticalScrollBarPolicy(javax.swing.JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
        jScrollPaneOutput.setMinimumSize(new java.awt.Dimension(22, 75));
        jScrollPaneOutput.setPreferredSize(new java.awt.Dimension(3, 100));
        jEditorPaneOutput.setBackground(new java.awt.Color(204, 204, 204));
        jEditorPaneOutput.setEditable(false);
        jEditorPaneOutput.setFont(new java.awt.Font("Courier New", 0, 12));
        jScrollPaneOutput.setViewportView(jEditorPaneOutput);

        jPanelSouth.add(jScrollPaneOutput, java.awt.BorderLayout.CENTER);

        jPanelProcesses.setLayout(new java.awt.BorderLayout());

        jPanelProcesses.setMinimumSize(new java.awt.Dimension(10, 1));
        jPanelProcesses.setPreferredSize(new java.awt.Dimension(120, 1));
        jTabbedPane1.setTabPlacement(javax.swing.JTabbedPane.BOTTOM);
        jTabbedPane1.setFont(new java.awt.Font("Dialog", 0, 11));
        jScrollProcesses.setViewportView(jListThreads);

        jTabbedPane1.addTab("Active Threads", jScrollProcesses);

        jPanelProcesses.add(jTabbedPane1, java.awt.BorderLayout.CENTER);

        jPanelSouth.add(jPanelProcesses, java.awt.BorderLayout.EAST);

        jSplitPaneV.setBottomComponent(jPanelSouth);

        getContentPane().add(jSplitPaneV, java.awt.BorderLayout.CENTER);

        jMenuFile.setMnemonic('f');
        jMenuFile.setText("File");
        jMenuFile.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuFile.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuFileActionPerformed(evt);
            }
        });

        jMenuItemNewDocument.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemNewDocument.setText("New document");
        jMenuItemNewDocument.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/new.gif")));
        jMenuItemNewDocument.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemNewDocumentActionPerformed(evt);
            }
        });

        jMenuFile.add(jMenuItemNewDocument);

        jMenuItemOpen.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemOpen.setText("Open");
        jMenuItemOpen.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/open.gif")));
        jMenuItemOpen.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemOpenActionPerformed(evt);
            }
        });

        jMenuFile.add(jMenuItemOpen);

        jMenuItemQOpen.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemQOpen.setText("Quick open...");
        jMenuItemQOpen.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/open.gif")));
        jMenuFile.add(jMenuItemQOpen);

        jMenuFile.add(jSeparator16);

        jMenuItemSave.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemSave.setMnemonic('s');
        jMenuItemSave.setText("Save");
        jMenuItemSave.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/save.gif")));
        jMenuItemSave.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemSaveActionPerformed(evt);
            }
        });

        jMenuFile.add(jMenuItemSave);

        jMenuItemSaveAs.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemSaveAs.setText("Save as...");
        jMenuItemSaveAs.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/save.gif")));
        jMenuItemSaveAs.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemSaveAsActionPerformed(evt);
            }
        });

        jMenuFile.add(jMenuItemSaveAs);

        jMenuItemSaveAll.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemSaveAll.setText("Save all");
        jMenuItemSaveAll.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/saveall.gif")));
        jMenuItemSaveAll.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemSaveAllActionPerformed(evt);
            }
        });

        jMenuFile.add(jMenuItemSaveAll);

        jMenuFile.add(jSeparator3);

        jMenuRecentFiles.setText("Recent Files");
        jMenuRecentFiles.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuFile.add(jMenuRecentFiles);

        jMenuRecentProjects.setText("Recent Projects");
        jMenuRecentProjects.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuFile.add(jMenuRecentProjects);

        jMenuItemFavorites.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemFavorites.setText("Favorite Files...");
        jMenuFile.add(jMenuItemFavorites);

        jMenuFile.add(jSeparator15);

        jMenuItemQuit.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemQuit.setMnemonic('q');
        jMenuItemQuit.setText("Quit");
        jMenuItemQuit.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/null.gif")));
        jMenuFile.add(jMenuItemQuit);

        jMDIMenuBar.add(jMenuFile);

        jMenuEdit.setMnemonic('e');
        jMenuEdit.setText("Edit");
        jMenuEdit.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuEdit.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuEditActionPerformed(evt);
            }
        });

        jMenuItemUndo.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemUndo.setText("Undo");
        jMenuItemUndo.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/undo.gif")));
        jMenuItemUndo.setEnabled(false);
        jMenuEdit.add(jMenuItemUndo);

        jMenuItemRedo.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemRedo.setText("Redo");
        jMenuItemRedo.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/redo.gif")));
        jMenuItemRedo.setEnabled(false);
        jMenuEdit.add(jMenuItemRedo);

        jMenuEdit.add(jSeparator1);

        jMenuItemCut.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemCut.setText("Cut");
        jMenuItemCut.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/cut.gif")));
        jMenuItemCut.setEnabled(false);
        jMenuEdit.add(jMenuItemCut);

        jMenuItemCopy.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemCopy.setText("Copy");
        jMenuItemCopy.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/copy.gif")));
        jMenuItemCopy.setEnabled(false);
        jMenuEdit.add(jMenuItemCopy);

        jMenuItemPaste.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemPaste.setText("Paste");
        jMenuItemPaste.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/paste.gif")));
        jMenuItemPaste.setEnabled(false);
        jMenuEdit.add(jMenuItemPaste);

        jMenuItemDelete.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemDelete.setText("Delete");
        jMenuItemDelete.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/delete.gif")));
        jMenuItemDelete.setEnabled(false);
        jMenuEdit.add(jMenuItemDelete);

        jMenuEdit.add(jSeparator2);

        jCheckBoxMenuItemEMM.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxMenuItemEMM.setText("Disable elements mouse move");
        jCheckBoxMenuItemEMM.setEnabled(false);
        jMenuEdit.add(jCheckBoxMenuItemEMM);

        jCheckBoxMenuItemSnapToGrid.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxMenuItemSnapToGrid.setText("Snap To Grid");
        jCheckBoxMenuItemSnapToGrid.setEnabled(false);
        jCheckBoxMenuItemSnapToGrid.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxMenuItemSnapToGridActionPerformed(evt);
            }
        });

        jMenuEdit.add(jCheckBoxMenuItemSnapToGrid);

        jMenuAdd.setText("Insert element...");
        jMenuAdd.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuAdd.setEnabled(false);
        jMenuItemNullElement.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemNullElement.setText("Null element (debug only)");
        jMenuItemNullElement.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemNullElementActionPerformed(evt);
            }
        });

        jMenuAdd.add(jMenuItemNullElement);

        jMenuItemLine.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemLine.setText("Line");
        jMenuItemLine.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemLineActionPerformed(evt);
            }
        });

        jMenuAdd.add(jMenuItemLine);

        jMenuItemRectangle.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemRectangle.setText("Rectangle");
        jMenuItemRectangle.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemRectangleActionPerformed(evt);
            }
        });

        jMenuAdd.add(jMenuItemRectangle);

        jMenuItemRoundRectangle.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemRoundRectangle.setText("Rounded rectangle");
        jMenuItemRoundRectangle.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemRoundRectangleActionPerformed(evt);
            }
        });

        jMenuAdd.add(jMenuItemRoundRectangle);

        jMenuItemEllipse.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemEllipse.setText("Ellipse");
        jMenuItemEllipse.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemEllipseActionPerformed(evt);
            }
        });

        jMenuAdd.add(jMenuItemEllipse);

        jMenuItemStaticText.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemStaticText.setText("Static text");
        jMenuItemStaticText.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemStaticTextActionPerformed(evt);
            }
        });

        jMenuAdd.add(jMenuItemStaticText);

        jMenuItemTextField.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemTextField.setText("Text field");
        jMenuItemTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemTextFieldActionPerformed(evt);
            }
        });

        jMenuAdd.add(jMenuItemTextField);

        jMenuItemSubreport.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemSubreport.setText("Subreport");
        jMenuItemSubreport.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemSubreportActionPerformed(evt);
            }
        });

        jMenuAdd.add(jMenuItemSubreport);

        jMenuEdit.add(jMenuAdd);

        jMenuItemXMLSource.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemXMLSource.setText("Edit XML source...");
        jMenuItemXMLSource.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/null.gif")));
        jMenuItemXMLSource.setEnabled(false);
        jMenuEdit.add(jMenuItemXMLSource);

        jMDIMenuBar.add(jMenuEdit);

        jMenuView.setMnemonic('v');
        jMenuView.setText("View");
        jMenuView.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxMenuItemGrid.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxMenuItemGrid.setText("Show grid");
        jCheckBoxMenuItemGrid.setEnabled(false);
        jCheckBoxMenuItemGrid.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxMenuItemGridActionPerformed(evt);
            }
        });

        jMenuView.add(jCheckBoxMenuItemGrid);

        jMenuView.add(jSeparator4);

        jCheckBoxMenuItemOutput.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxMenuItemOutput.setSelected(true);
        jCheckBoxMenuItemOutput.setText("Show output window");
        jCheckBoxMenuItemOutput.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxMenuItemOutputActionPerformed(evt);
            }
        });

        jMenuView.add(jCheckBoxMenuItemOutput);

        jCheckBoxMenuItemExplorer.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxMenuItemExplorer.setSelected(true);
        jCheckBoxMenuItemExplorer.setText("Show project browser");
        jCheckBoxMenuItemExplorer.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxMenuItemExplorerActionPerformed(evt);
            }
        });

        jMenuView.add(jCheckBoxMenuItemExplorer);

        jMenuView.add(jSeparator12);

        jMenuItemReportProperties.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemReportProperties.setText("Report properties");
        jMenuView.add(jMenuItemReportProperties);

        jMenuItemReportQuery.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemReportQuery.setText("Report query");
        jMenuView.add(jMenuItemReportQuery);

        jMenuItemFields.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemFields.setText("Report fields");
        jMenuView.add(jMenuItemFields);

        jMenuItemVariables.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemVariables.setText("Report variables");
        jMenuView.add(jMenuItemVariables);

        jMenuItemParameters.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemParameters.setText("Report parameters");
        jMenuView.add(jMenuItemParameters);

        jMenuItemFonts.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemFonts.setText("Report fonts");
        jMenuItemFonts.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemFontsActionPerformed(evt);
            }
        });

        jMenuView.add(jMenuItemFonts);

        jMenuView.add(jSeparator6);

        jMenuItemBands.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemBands.setText("Bands");
        jMenuView.add(jMenuItemBands);

        jMenuItemGroups.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemGroups.setText("Report groups");
        jMenuView.add(jMenuItemGroups);

        jMenuView.add(jSeparator7);

        jMenuItemElementProperties.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemElementProperties.setText("Element properties");
        jMenuView.add(jMenuItemElementProperties);

        jMenuItemElementsBrowser.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemElementsBrowser.setText("Elements browser");
        jMenuView.add(jMenuItemElementsBrowser);

        jMDIMenuBar.add(jMenuView);

        jMenuSearch.setMnemonic('s');
        jMenuSearch.setText("Search");
        jMenuSearch.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemFind.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemFind.setText("Find");
        jMenuItemFind.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/find.gif")));
        jMenuSearch.add(jMenuItemFind);

        jMenuItemFindNext.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemFindNext.setText("Find next");
        jMenuItemFindNext.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/findnext.gif")));
        jMenuSearch.add(jMenuItemFindNext);

        jMenuItemFindPrev.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemFindPrev.setText("Find Prev");
        jMenuItemFindPrev.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/findprev.gif")));
        jMenuSearch.add(jMenuItemFindPrev);

        jMenuItemReplace.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemReplace.setText("Replace");
        jMenuItemReplace.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/findreplace.gif")));
        jMenuSearch.add(jMenuItemReplace);

        jMDIMenuBar.add(jMenuSearch);

        jMenuProjects.setMnemonic('p');
        jMenuProjects.setText("Project");
        jMenuProjects.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemNewProject.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemNewProject.setText("New project");
        jMenuItemNewProject.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemNewProjectActionPerformed(evt);
            }
        });

        jMenuProjects.add(jMenuItemNewProject);

        jMenuItemOpenProject.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemOpenProject.setText("Open project");
        jMenuProjects.add(jMenuItemOpenProject);

        jMenuItemCloseProject.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemCloseProject.setText("Close project");
        jMenuItemCloseProject.setEnabled(false);
        jMenuItemCloseProject.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemCloseProjectActionPerformed(evt);
            }
        });

        jMenuProjects.add(jMenuItemCloseProject);

        jMenuProjects.add(jSeparator13);

        jMenuItemAddFileToProject.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemAddFileToProject.setText("Add report to project...");
        jMenuProjects.add(jMenuItemAddFileToProject);

        jMenuItemProjectOptions.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemProjectOptions.setText("Project options...");
        jMenuProjects.add(jMenuItemProjectOptions);

        jMDIMenuBar.add(jMenuProjects);

        jMenuBuild.setMnemonic('b');
        jMenuBuild.setText("Build");
        jMenuBuild.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemCompile.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemCompile.setText("Compile");
        jMenuBuild.add(jMenuItemCompile);

        jMenuItemCompileAll.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemCompileAll.setText("Compile All");
        jMenuBuild.add(jMenuItemCompileAll);

        jMenuBuild.add(jSeparator10);

        jMenuItemExecute.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemExecute.setText("Execute report");
        jMenuBuild.add(jMenuItemExecute);

        jMenuItemViewConsole.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemViewConsole.setText("View console");
        jMenuBuild.add(jMenuItemViewConsole);

        jMenuBuild.add(jSeparator11);

        jRadioButtonMenuItemPreviewPDF.setFont(new java.awt.Font("Dialog", 0, 11));
        jRadioButtonMenuItemPreviewPDF.setSelected(true);
        jRadioButtonMenuItemPreviewPDF.setText("PDF preview");
        buttonGroupExportType.add(jRadioButtonMenuItemPreviewPDF);
        jRadioButtonMenuItemPreviewPDF.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonMenuItemPreviewPDFActionPerformed(evt);
            }
        });

        jMenuBuild.add(jRadioButtonMenuItemPreviewPDF);

        jRadioButtonMenuItemPreviewHTML.setFont(new java.awt.Font("Dialog", 0, 11));
        jRadioButtonMenuItemPreviewHTML.setText("HTML preview");
        buttonGroupExportType.add(jRadioButtonMenuItemPreviewHTML);
        jMenuBuild.add(jRadioButtonMenuItemPreviewHTML);

        jRadioButtonMenuItemPreviewJAVA.setFont(new java.awt.Font("Dialog", 0, 11));
        jRadioButtonMenuItemPreviewJAVA.setText("JAVA 2D preview");
        buttonGroupExportType.add(jRadioButtonMenuItemPreviewJAVA);
        jMenuBuild.add(jRadioButtonMenuItemPreviewJAVA);

        jRadioButtonMenuItemPreviewXLS.setFont(new java.awt.Font("Dialog", 0, 11));
        jRadioButtonMenuItemPreviewXLS.setText("Excel preview");
        buttonGroupExportType.add(jRadioButtonMenuItemPreviewXLS);
        jMenuBuild.add(jRadioButtonMenuItemPreviewXLS);

        jRadioButtonMenuItemPreviewCSV.setFont(new java.awt.Font("Dialog", 0, 11));
        jRadioButtonMenuItemPreviewCSV.setText("CSV preview");
        buttonGroupExportType.add(jRadioButtonMenuItemPreviewCSV);
        jMenuBuild.add(jRadioButtonMenuItemPreviewCSV);

        jMenuBuild.add(jSeparator14);

        jMenuItemActiveConnection.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemActiveConnection.setText("Set active connection");
        jMenuItemActiveConnection.setToolTipText("Set the connection that must be used to fill this report");
        jMenuItemActiveConnection.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemActiveConnectionActionPerformed(evt);
            }
        });

        jMenuBuild.add(jMenuItemActiveConnection);

        jMDIMenuBar.add(jMenuBuild);

        jMenuFormat.setMnemonic('o');
        jMenuFormat.setText("Format");
        jMenuFormat.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuAlign.setText("Align...");
        jMenuAlign.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemAlignLeft.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemAlignLeft.setText("Align left");
        jMenuItemAlignLeft.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_align_left.gif")));
        jMenuAlign.add(jMenuItemAlignLeft);

        jMenuItemAlignRight.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemAlignRight.setText("Align right");
        jMenuItemAlignRight.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_align_right.gif")));
        jMenuAlign.add(jMenuItemAlignRight);

        jMenuItemAlignTop.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemAlignTop.setText("Align top");
        jMenuItemAlignTop.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_align_top.gif")));
        jMenuAlign.add(jMenuItemAlignTop);

        jMenuItemAlignBottom.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemAlignBottom.setText("Align bottom");
        jMenuItemAlignBottom.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_align_bottom.gif")));
        jMenuAlign.add(jMenuItemAlignBottom);

        jMenuAlign.add(jSeparator19);

        jMenuItemAlignVerticalAxis.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemAlignVerticalAxis.setText("Align vertical axis");
        jMenuItemAlignVerticalAxis.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_center_axis.gif")));
        jMenuAlign.add(jMenuItemAlignVerticalAxis);

        jMenuItemAlignHorizontalAxis.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemAlignHorizontalAxis.setText("Align horizontal axis");
        jMenuItemAlignHorizontalAxis.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_vcenter_axis.gif")));
        jMenuAlign.add(jMenuItemAlignHorizontalAxis);

        jMenuAlign.add(jSeparator20);

        jMenuItemAlignToBandTop.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemAlignToBandTop.setText("Align to band top");
        jMenuAlign.add(jMenuItemAlignToBandTop);

        jMenuItemAlignToBandBottom.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemAlignToBandBottom.setText("Align to band bottom");
        jMenuAlign.add(jMenuItemAlignToBandBottom);

        jMenuFormat.add(jMenuAlign);

        jMenuSize.setText("Size...");
        jMenuSize.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemSameWidth.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemSameWidth.setText("Same width");
        jMenuItemSameWidth.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_same_hsize.gif")));
        jMenuSize.add(jMenuItemSameWidth);

        jMenuItemSameWidthMax.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemSameWidthMax.setText("Same width (max)");
        jMenuItemSameWidthMax.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_same_hsize_plus.gif")));
        jMenuSize.add(jMenuItemSameWidthMax);

        jMenuItemSameWidthMin.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemSameWidthMin.setText("Same width (min)");
        jMenuItemSameWidthMin.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_same_hsize_min.gif")));
        jMenuSize.add(jMenuItemSameWidthMin);

        jMenuSize.add(jSeparator17);

        jMenuItemSameHeight.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemSameHeight.setText("Same height");
        jMenuItemSameHeight.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_same_vsize.gif")));
        jMenuSize.add(jMenuItemSameHeight);

        jMenuItemSameHeightMin.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemSameHeightMin.setText("Same height (min)");
        jMenuItemSameHeightMin.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_same_vsize_min.gif")));
        jMenuSize.add(jMenuItemSameHeightMin);

        jMenuItemSameHeightMax.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemSameHeightMax.setText("Same height (max)");
        jMenuItemSameHeightMax.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_same_vsize_plus.gif")));
        jMenuSize.add(jMenuItemSameHeightMax);

        jMenuSize.add(jSeparator18);

        jMenuItemSameSize.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemSameSize.setText("Same size");
        jMenuItemSameSize.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_same_size.gif")));
        jMenuSize.add(jMenuItemSameSize);

        jMenuFormat.add(jMenuSize);

        jMenuPosition.setText("Position...");
        jMenuPosition.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemCenterH.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemCenterH.setText("Center horizontally (band based)");
        jMenuItemCenterH.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_hcenter.gif")));
        jMenuPosition.add(jMenuItemCenterH);

        jMenuItemCenterV.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemCenterV.setText("Center vertically (band based)");
        jMenuItemCenterV.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_vcenter.gif")));
        jMenuPosition.add(jMenuItemCenterV);

        jMenuItemCenterInBand.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemCenterInBand.setText("Center in band");
        jMenuItemCenterInBand.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_ccenter.gif")));
        jMenuPosition.add(jMenuItemCenterInBand);

        jMenuItemCenterBackground.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemCenterBackground.setText("Center in background");
        jMenuItemCenterBackground.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_bcenter.gif")));
        jMenuPosition.add(jMenuItemCenterBackground);

        jMenuItemJoinLeft.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemJoinLeft.setText("Join sides left");
        jMenuPosition.add(jMenuItemJoinLeft);

        jMenuItemJoinRight.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemJoinRight.setText("Join sides right");
        jMenuPosition.add(jMenuItemJoinRight);

        jMenuFormat.add(jMenuPosition);

        jMenuFormat.add(jSeparator5);

        jMenuHSpacing.setText("Horizontal spacing...");
        jMenuHSpacing.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemHSMakeEqual.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemHSMakeEqual.setText("Make equal");
        jMenuHSpacing.add(jMenuItemHSMakeEqual);

        jMenuItemHSIncrease.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemHSIncrease.setText("Increase");
        jMenuHSpacing.add(jMenuItemHSIncrease);

        jMenuItemHSDecrease.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemHSDecrease.setText("Decrease");
        jMenuItemHSDecrease.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemHSDecreaseActionPerformed(evt);
            }
        });

        jMenuHSpacing.add(jMenuItemHSDecrease);

        jMenuItemHSRemove.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemHSRemove.setText("Remove");
        jMenuHSpacing.add(jMenuItemHSRemove);

        jMenuFormat.add(jMenuHSpacing);

        jMenuVSpacing.setText("Vertical spacing");
        jMenuVSpacing.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemVSMakeEqual.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemVSMakeEqual.setText("Make equal");
        jMenuVSpacing.add(jMenuItemVSMakeEqual);

        jMenuItemVSIncrease.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemVSIncrease.setText("Increase");
        jMenuItemVSIncrease.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemVSIncreaseActionPerformed(evt);
            }
        });

        jMenuVSpacing.add(jMenuItemVSIncrease);

        jMenuItemVSDecrease.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemVSDecrease.setText("Decrease");
        jMenuVSpacing.add(jMenuItemVSDecrease);

        jMenuItemVSRemove.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemVSRemove.setText("Remove");
        jMenuVSpacing.add(jMenuItemVSRemove);

        jMenuFormat.add(jMenuVSpacing);

        jMenuFormat.add(jSeparator8);

        jMenuItemBringToFront.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemBringToFront.setText("Bring to front");
        jMenuItemBringToFront.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/sendtofront.gif")));
        jMenuFormat.add(jMenuItemBringToFront);

        jMenuItemSendToBack.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemSendToBack.setText("Send to back");
        jMenuItemSendToBack.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/sendtoback.gif")));
        jMenuFormat.add(jMenuItemSendToBack);

        jMDIMenuBar.add(jMenuFormat);

        jMenuDatabase.setMnemonic('d');
        jMenuDatabase.setText("Datasource");
        jMenuDatabase.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemConnections.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemConnections.setText("Connections / Datasources");
        jMenuItemConnections.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemConnectionsActionPerformed(evt);
            }
        });

        jMenuDatabase.add(jMenuItemConnections);

        jMenuDatabase.add(jSeparator9);

        jMenuItemReportQuery2.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemReportQuery2.setText("Report query");
        jMenuItemReportQuery2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemReportQuery2ActionPerformed(evt);
            }
        });

        jMenuDatabase.add(jMenuItemReportQuery2);

        jMDIMenuBar.add(jMenuDatabase);

        jMenuTools.setMnemonic('t');
        jMenuTools.setText("Tools");
        jMenuTools.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemOptions.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemOptions.setText("Options...");
        jMenuItemOptions.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemOptionsActionPerformed(evt);
            }
        });

        jMenuTools.add(jMenuItemOptions);

        jMenuItemCompatibility.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemCompatibility.setText("Compatibility...");
        jMenuItemCompatibility.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemCompatibilityActionPerformed(evt);
            }
        });

        jMenuTools.add(jMenuItemCompatibility);

        jMDIMenuBar.add(jMenuTools);

        jMenuWindow.setMnemonic('w');
        jMenuWindow.setText("Window");
        jMenuWindow.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemCascade.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemCascade.setText("Cascade");
        jMenuItemCascade.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/win_cascade.gif")));
        jMenuItemCascade.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemCascadeActionPerformed(evt);
            }
        });

        jMenuWindow.add(jMenuItemCascade);

        jMenuItemTileHorizontal.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemTileHorizontal.setText("Tile horizontal");
        jMenuItemTileHorizontal.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/win_htile.gif")));
        jMenuItemTileHorizontal.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemTileHorizontalActionPerformed(evt);
            }
        });

        jMenuWindow.add(jMenuItemTileHorizontal);

        jMenuItemTileVertical.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemTileVertical.setText("Tile vertical");
        jMenuItemTileVertical.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/win_vtile.gif")));
        jMenuItemTileVertical.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemTileVerticalActionPerformed(evt);
            }
        });

        jMenuWindow.add(jMenuItemTileVertical);

        jMenuItemtileAnodine.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemtileAnodine.setText("Tile anodine");
        jMenuItemtileAnodine.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/win_atile.gif")));
        jMenuItemtileAnodine.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemtileAnodineActionPerformed(evt);
            }
        });

        jMenuWindow.add(jMenuItemtileAnodine);

        jMenuItemNextWin.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemNextWin.setText("Next Window");
        jMenuItemNextWin.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/win_next.gif")));
        jMenuItemNextWin.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemNextWinActionPerformed(evt);
            }
        });

        jMenuWindow.add(jMenuItemNextWin);

        jMenuItemPrevWin.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemPrevWin.setText("Previous Windpw");
        jMenuItemPrevWin.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/win_prev.gif")));
        jMenuItemPrevWin.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemPrevWinActionPerformed(evt);
            }
        });

        jMenuWindow.add(jMenuItemPrevWin);

        jMenuWindow.add(jSeparator21);

        jMDIMenuBar.add(jMenuWindow);

        jMenuHelp.setMnemonic('h');
        jMenuHelp.setText("Help");
        jMenuHelp.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemHelp.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemHelp.setText("Help...");
        jMenuHelp.add(jMenuItemHelp);

        jMenuItemAbout.setFont(new java.awt.Font("Dialog", 1, 11));
        jMenuItemAbout.setText("About iReport...");
        jMenuItemAbout.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemAboutActionPerformed(evt);
            }
        });

        jMenuHelp.add(jMenuItemAbout);

        jMDIMenuBar.add(jMenuHelp);

        setJMenuBar(jMDIMenuBar);

        pack();
    }//GEN-END:initComponents

    private void jMenuItemAboutActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemAboutActionPerformed
        IReportAbout ra = new IReportAbout(this, true);
        ra.show();
    }//GEN-LAST:event_jMenuItemAboutActionPerformed

    private void jButtonRun1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonRun1ActionPerformed
        
        // 1. Get active report...
        if (jMDIDesktopPane.getSelectedFrame() != null &&
             jMDIDesktopPane.getSelectedFrame() instanceof JReportFrame)
        {
             JReportFrame jrf = (JReportFrame)jMDIDesktopPane.getSelectedFrame();
             if (Misc.nvl(this.getProperties().getProperty("SaveBeforeCompiling"), "true").equals("true"))
                 jMenuItemSaveActionPerformed(new java.awt.event.ActionEvent(jMenuItemSave,0,"Save"));
            //1. Save the report if needed....
             if (jrf.getReport().isDirty() ||
                 jrf.getReport().getFilename() == null ||
                 jrf.getReport().getFilename().trim().equals(""))
             {
                 this.logOnConsole("Action aborted by user.\n");
                 return;
             }
             
             this.jEditorPaneOutput.setContentType("text/html");
             outputBuffer.setLength(0);
             logOnConsole("");
             //1. Compile....
             IReportCompiler ic = new IReportCompiler();
             ic.setCommand( IReportCompiler.CMD_COMPILE | IReportCompiler.CMD_EXPORT);
             HashMap hm = new HashMap();
             hm.put( ic.USE_EMPTY_DATASOURCE, "true");
             hm.put( ic.OUTPUT_FORMAT, "pdf");
             ic.setProperties(hm);
             ic.setJrf(jrf);
             ic.setMainFrame(this);
             
             ic.start();
        }         
    }//GEN-LAST:event_jButtonRun1ActionPerformed

    private void jMenuItemPrevWinActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemPrevWinActionPerformed
       // Remove all menus...
        java.awt.Component[] menus = this.jMenuWindow.getMenuComponents();
        int firstFrame = -1;
        for (int k = 0;  k<menus.length ; ++k)
        {
            if (menus[k] instanceof JRadioButtonMenuItemMDIFrame)
            {
                if (firstFrame == -1) firstFrame = k;
                if ( ((JRadioButtonMenuItemMDIFrame)menus[k]).getFrame() == jMDIDesktopPane.getSelectedFrame())
                {
                    // The next if exists, is the right menu..
                    k--;
                    if (k>=firstFrame && menus[k] instanceof JRadioButtonMenuItemMDIFrame)
                    {
                        try {
                           ((JRadioButtonMenuItemMDIFrame)menus[k]).getFrame().setSelected(true);
                        } catch (Exception ex){}
                    }
                    else if (menus[menus.length-1] instanceof JRadioButtonMenuItemMDIFrame)
                    {
                        try {
                           ((JRadioButtonMenuItemMDIFrame)menus[menus.length-1]).getFrame().setSelected(true);
                        } catch (Exception ex){}
                    }      
                    return;
                }       
            }
        }
    }//GEN-LAST:event_jMenuItemPrevWinActionPerformed

    private void jMenuItemNextWinActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemNextWinActionPerformed

        
        // Remove all menus...
        java.awt.Component[] menus = this.jMenuWindow.getMenuComponents();
        int firstFrame = -1;
        for (int k = 0;  k<menus.length ; ++k)
        {
            if (menus[k] instanceof JRadioButtonMenuItemMDIFrame)
            {
                if (firstFrame == -1) firstFrame = k;
                if ( ((JRadioButtonMenuItemMDIFrame)menus[k]).getFrame() == jMDIDesktopPane.getSelectedFrame())
                {
                    // The next if exists, is the right menu..
                    k++;
                    if (k<menus.length && menus[k] instanceof JRadioButtonMenuItemMDIFrame)
                    {
                        try {
                           ((JRadioButtonMenuItemMDIFrame)menus[k]).getFrame().setSelected(true);
                        } catch (Exception ex){}
                    }
                    else if (firstFrame != -1)
                    {
                        try {
                           ((JRadioButtonMenuItemMDIFrame)menus[firstFrame]).getFrame().setSelected(true);
                        } catch (Exception ex){}
                    }               
                    return;
                }       
            }
        }
        
        /*
        JInternalFrame[] frames = jMDIDesktopPane.getAllFrames();
        if (frames.length < 2) return;
        for (int i=0; i<frames.length; ++i)
        {
            if (frames[i] == jMDIDesktopPane.getSelectedFrame())
            {
                i++;
                if (i == frames.length) i=0;
                try {
                frames[i].setSelected(true);
                } catch (Exception ex){}
                return;
            }
        }
         */
        
    }//GEN-LAST:event_jMenuItemNextWinActionPerformed

    private void jMenuItemtileAnodineActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemtileAnodineActionPerformed
        jMDIDesktopPane.tileAnodine();
    }//GEN-LAST:event_jMenuItemtileAnodineActionPerformed

    private void jMenuItemTileVerticalActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemTileVerticalActionPerformed
        jMDIDesktopPane.tileVertically();
    }//GEN-LAST:event_jMenuItemTileVerticalActionPerformed

    private void jMenuItemTileHorizontalActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemTileHorizontalActionPerformed
        jMDIDesktopPane.tileHorizontally();
    }//GEN-LAST:event_jMenuItemTileHorizontalActionPerformed

    private void jMenuItemCascadeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemCascadeActionPerformed
        // Dispose all frames in cascade....
        // The active frame must be the last....
        jMDIDesktopPane.cascade();
    }//GEN-LAST:event_jMenuItemCascadeActionPerformed

    private void jRadioButtonMenuItemPreviewPDFActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButtonMenuItemPreviewPDFActionPerformed
        // Add your handling code here:
    }//GEN-LAST:event_jRadioButtonMenuItemPreviewPDFActionPerformed

    private void jTreeFilesMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jTreeFilesMouseClicked
        if (evt.getClickCount() == 2)
        {
            TreePath path = jTreeFiles.getSelectionPath();
            if (path == null) return;
            TreeNode node = (TreeNode)path.getLastPathComponent();
            if (node instanceof DefaultMutableTreeNode)
            {
                DefaultMutableTreeNode nodem = (DefaultMutableTreeNode)node;
                Object obj = nodem.getUserObject();
                if (obj != null && obj instanceof DocumentTreeEntry)
                {
                    DocumentTreeEntry dtn = (DocumentTreeEntry)obj;
                    if (dtn.getJrf() != null)
                    {
                        //
                        try {
                                dtn.getJrf().setSelected(true);
                        } catch (Exception ex){};
                        //dtn.getJrf().updateUI();
                        //jMDIDesktopPane.internalFrameActivated(dtn.getJrf());
                        //this.logOnConsole("Activated :"+dtn.getJrf().getReport().getFilename()+"\n");
                    }
                }
            }
       }
        
    }//GEN-LAST:event_jTreeFilesMouseClicked

    private void jMenuItemFontsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemFontsActionPerformed
        this.fontsDialog.setVisible(true);
    }//GEN-LAST:event_jMenuItemFontsActionPerformed

    private void jMenuItemActiveConnectionActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemActiveConnectionActionPerformed
        ActiveConnectionDialog acd = new ActiveConnectionDialog(this, true);
        acd.show();
        if (acd.getDialogResult() == JOptionPane.OK_OPTION)
        {
            this.getProperties().put( "DefaultConnection",acd.getIReportConnection());
            
            this.saveiReportConfiguration();
            
        }
    }//GEN-LAST:event_jMenuItemActiveConnectionActionPerformed

    private void jTabbedPaneExplorerStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jTabbedPaneExplorerStateChanged
        if (jTabbedPaneExplorer.getSelectedComponent() instanceof ProjectPane)
        {
            jMenuItemCloseProject.setEnabled(true);
        }
        else
        {
            jMenuItemCloseProject.setEnabled(false);
        }
    }//GEN-LAST:event_jTabbedPaneExplorerStateChanged

    private void jMenuItemCloseProjectActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemCloseProjectActionPerformed
        // Close the active project...
        if (jTabbedPaneExplorer.getSelectedComponent() instanceof ProjectPane)
        {
            // ProjectPane.close();
            jTabbedPaneExplorer.remove(jTabbedPaneExplorer.getSelectedComponent());
        }
        
        
    }//GEN-LAST:event_jMenuItemCloseProjectActionPerformed

    private void jMenuItemNewProjectActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemNewProjectActionPerformed
        
        ProjectDialog pd = new ProjectDialog(this, true);
        pd.show();
        if (pd.getDialogResult() == javax.swing.JOptionPane.OK_OPTION)
        {
            /* Code to handle the new project... */
            ProjectInfo pi = new ProjectInfo();
            pi.setName( pd.getProjectName() );
            pi.setSourcesDir( pd.getSourcesDir() );
            pi.setOutputDir( pd.getOutputDir() );
            pi.setConnection( pd.getConnection() );
            ProjectPane pp = new ProjectPane(pi);
            this.jTabbedPaneExplorer.addTab("Project "+pi, pp);
           this.jTabbedPaneExplorer.setSelectedComponent(pp);  
        }        
    }//GEN-LAST:event_jMenuItemNewProjectActionPerformed

    private void jToggleButtonChartToolItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jToggleButtonChartToolItemStateChanged
         if (evt.getStateChange() == java.awt.event.ItemEvent.SELECTED)
       { 
            if (jMDIDesktopPane.getSelectedFrame() != null &&
             jMDIDesktopPane.getSelectedFrame() instanceof JReportFrame)
            {
             JReportFrame jrf = (JReportFrame)jMDIDesktopPane.getSelectedFrame();
             jrf.setNewObjectType( ReportElementType.CHART_ELEMENT);
             jrf.setLensMode(false);
            }
            setActiveTool(jToggleButtonChartTool);
        }
    }//GEN-LAST:event_jToggleButtonChartToolItemStateChanged

    private void jToggleButtonChartToolStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jToggleButtonChartToolStateChanged

      
    }//GEN-LAST:event_jToggleButtonChartToolStateChanged

    private void jMenuItemConnectionsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemConnectionsActionPerformed
        ConnectionsDialog cd = new ConnectionsDialog(this,true);
        cd.show();
    }//GEN-LAST:event_jMenuItemConnectionsActionPerformed

    private void jMenuItemReportQuery2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemReportQuery2ActionPerformed
        this.getReportQueryDialog().setVisible(true);
    }//GEN-LAST:event_jMenuItemReportQuery2ActionPerformed

    private void jMenuItemCompatibilityActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemCompatibilityActionPerformed
        CompatibilityDialog cd = new CompatibilityDialog(this,true);
        cd.show();
    }//GEN-LAST:event_jMenuItemCompatibilityActionPerformed

    private void jMenuItemOptionsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemOptionsActionPerformed
        OptionsDialog od = new OptionsDialog(this,true);
        od.loadConfiguration();
        od.show();
    }//GEN-LAST:event_jMenuItemOptionsActionPerformed

    private void jCheckBoxMenuItemOutputActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxMenuItemOutputActionPerformed
       if (jCheckBoxMenuItemOutput.isSelected())
        {
            jSplitPaneV.add("bottom", jPanelSouth );
            jSplitPaneV.setDividerSize(8);
        }
        else
        {
            jSplitPaneV.remove( jPanelSouth); 
            jSplitPaneV.setDividerSize(0);
        }
        
    }//GEN-LAST:event_jCheckBoxMenuItemOutputActionPerformed

    private void jCheckBoxMenuItemExplorerActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxMenuItemExplorerActionPerformed
        if (jCheckBoxMenuItemExplorer.isSelected())
        {
            jSplitPaneHorizontal.add("left", jTabbedPaneExplorer);
            jSplitPaneHorizontal.setDividerSize(8);
        }
        else
        {
            jSplitPaneHorizontal.remove( jTabbedPaneExplorer); 
            jSplitPaneHorizontal.setDividerSize(0);
        }
    }//GEN-LAST:event_jCheckBoxMenuItemExplorerActionPerformed

    private void jMenuItemHSDecreaseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemHSDecreaseActionPerformed
        // Add your handling code here:
    }//GEN-LAST:event_jMenuItemHSDecreaseActionPerformed

    private void jMenuItemVSIncreaseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemVSIncreaseActionPerformed
        // Add your handling code here:
    }//GEN-LAST:event_jMenuItemVSIncreaseActionPerformed

    private void jButtonDatabaseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonDatabaseActionPerformed
        this.getReportQueryDialog().setVisible(true);
    }//GEN-LAST:event_jButtonDatabaseActionPerformed

    private void jMenuItemSaveAllActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemSaveAllActionPerformed
       javax.swing.JInternalFrame[] frames = jMDIDesktopPane.getAllFrames();
         for (int i=0; i< frames.length; ++i)
         {
            if (frames[i]  instanceof JReportFrame)
            {
                 JReportFrame jrf = (JReportFrame)frames[i];
                 if (jrf.getReport().getFilename() == null ||
                     jrf.getReport().getFilename().trim().equals(""))
                 {
                     // Choose a file name....
                     javax.swing.JFileChooser jfc = new javax.swing.JFileChooser();
                     jfc.setDialogTitle("Save report as XML jasperreports file....");
                     jfc.setFileFilter( new javax.swing.filechooser.FileFilter() {
                            public boolean accept(java.io.File file) {
                                    String filename = file.getName();
                                    return (filename.endsWith(".xml") || file.isDirectory()) ;
                            }
                            public String getDescription() {
                                return "JasperReports XML *.xml";
                            }
                    });

                    jfc.setMultiSelectionEnabled(false);
                    
                    jfc.setDialogType( javax.swing.JFileChooser.SAVE_DIALOG);
                    if  (jfc.showSaveDialog( null) != javax.swing.JOptionPane.OK_OPTION) return;
                    
                    jrf.getReport().setFilename( jfc.getSelectedFile().getPath());
                 }
                 
                 //saveBackup( jrf.getReport().getFilename()); 
		 jrf.getReport().saveXMLFile();
		 //this.addToRecentFileList(rp.filename);
		 //saveProperties();
		 //this.updateRecentFileList();
            }
         }      
    }//GEN-LAST:event_jMenuItemSaveAllActionPerformed

    private void jMenuItemSaveAsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemSaveAsActionPerformed
         if (jMDIDesktopPane.getSelectedFrame() != null &&
             jMDIDesktopPane.getSelectedFrame() instanceof JReportFrame)
            {
                 JReportFrame jrf = (JReportFrame)jMDIDesktopPane.getSelectedFrame();
                 // Choose a new file name....
                 javax.swing.JFileChooser jfc = new javax.swing.JFileChooser();
                 jfc.setDialogTitle("Save report as XML jasperreports file as....");
                 jfc.setFileFilter( new javax.swing.filechooser.FileFilter() {
                      public boolean accept(java.io.File file) {
                               String filename = file.getName();
                               return (filename.endsWith(".xml") || file.isDirectory()) ;
                       }
                       public String getDescription() {
                           return "JasperReports XML *.xml";
                       }
                 });
                 jfc.setMultiSelectionEnabled(false);
                    
                 jfc.setDialogType( javax.swing.JFileChooser.SAVE_DIALOG);
                 if  (jfc.showSaveDialog( null) != javax.swing.JOptionPane.OK_OPTION) return;
                    
                 jrf.getReport().setFilename( jfc.getSelectedFile().getPath());
                 
                //saveBackup( jrf.getReport().getFilename()); 
                jrf.getReport().saveXMLFile();
		 //this.addToRecentFileList(rp.filename);
		 //saveProperties();
		 //this.updateRecentFileList();                 
        }       
    }//GEN-LAST:event_jMenuItemSaveAsActionPerformed

    private void jButtonOpenActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOpenActionPerformed
        this.jMenuItemOpenActionPerformed(evt);
    }//GEN-LAST:event_jButtonOpenActionPerformed

    private void jButtonCompilerActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCompilerActionPerformed
        // 1. Get active report...
        if (jMDIDesktopPane.getSelectedFrame() != null &&
             jMDIDesktopPane.getSelectedFrame() instanceof JReportFrame)
        {
             JReportFrame jrf = (JReportFrame)jMDIDesktopPane.getSelectedFrame();
             if (Misc.nvl(this.getProperties().getProperty("SaveBeforeCompiling"), "true").equals("true"))
                 jMenuItemSaveActionPerformed(new java.awt.event.ActionEvent(jMenuItemSave,0,"Save"));
            //1. Save the report if needed....
             if (jrf.getReport().isDirty() ||
                 jrf.getReport().getFilename() == null ||
                 jrf.getReport().getFilename().trim().equals(""))
             {
                 this.logOnConsole("Action aborted by user.\n");
                 return;
             }
             
             this.jEditorPaneOutput.setContentType("text/html");
             outputBuffer.setLength(0);
             logOnConsole("");
             //1. Compile....
             IReportCompiler ic = new IReportCompiler();
             ic.setCommand( IReportCompiler.CMD_COMPILE);
             ic.setJrf(jrf);
             ic.setMainFrame(this);
             
             ic.start();
        }
        
        
    }//GEN-LAST:event_jButtonCompilerActionPerformed

    private void jButtonSaveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonSaveActionPerformed
        jMenuItemSaveActionPerformed(evt);
    }//GEN-LAST:event_jButtonSaveActionPerformed

    private void jMenuItemSaveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemSaveActionPerformed
        if (jMDIDesktopPane.getSelectedFrame() != null &&
             jMDIDesktopPane.getSelectedFrame() instanceof JReportFrame)
            {
                 JReportFrame jrf = (JReportFrame)jMDIDesktopPane.getSelectedFrame();
                 if (jrf.getReport().getFilename() == null ||
                     jrf.getReport().getFilename().trim().equals(""))
                 {
                     // Choose a file name....
                     javax.swing.JFileChooser jfc = new javax.swing.JFileChooser();
                     jfc.setDialogTitle("Save report as XML jasperreports file....");
                     jfc.setFileFilter( new javax.swing.filechooser.FileFilter() {
                            public boolean accept(java.io.File file) {
                                    String filename = file.getName();
                                    return (filename.endsWith(".xml") || file.isDirectory()) ;
                            }
                            public String getDescription() {
                                return "JasperReports XML *.xml";
                            }
                    });

                    jfc.setMultiSelectionEnabled(false);
                    
                    jfc.setDialogType( javax.swing.JFileChooser.SAVE_DIALOG);
                    if  (jfc.showSaveDialog( null) != javax.swing.JOptionPane.OK_OPTION) return;
                    
                    jrf.getReport().setFilename( jfc.getSelectedFile().getPath());
                 }
                 
                 //saveBackup( jrf.getReport().getFilename()); 
		 jrf.getReport().saveXMLFile();
                 jrf.getReport().setDirty(false);
		 //this.addToRecentFileList(rp.filename);
		 //saveProperties();
		 //this.updateRecentFileList();
                 
        }       
    }//GEN-LAST:event_jMenuItemSaveActionPerformed

    private void jCheckBoxMenuItemSnapToGridActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxMenuItemSnapToGridActionPerformed
        // Set SnapToGrid to all reports form..
        javax.swing.JInternalFrame[] frames = jMDIDesktopPane.getAllFrames();
         for (int i=0; i< frames.length; ++i)
         {
            if (frames[i]  instanceof JReportFrame)
            {
                 JReportFrame jrf = (JReportFrame)frames[i];
                 jrf.setSnapToGrid(jCheckBoxMenuItemSnapToGrid.isSelected() );
            }
         }
    }//GEN-LAST:event_jCheckBoxMenuItemSnapToGridActionPerformed

    private void jCheckBoxMenuItemGridActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxMenuItemGridActionPerformed

            javax.swing.JInternalFrame[] frames = jMDIDesktopPane.getAllFrames();
         for (int i=0; i< frames.length; ++i)
         {
            if (frames[i]  instanceof JReportFrame)
            {
                 JReportFrame jrf = (JReportFrame)frames[i];
                 jrf.setShowGrid(jCheckBoxMenuItemGrid.isSelected() );
            }
         }      
    }//GEN-LAST:event_jCheckBoxMenuItemGridActionPerformed

    private void jButtonBandsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonBandsActionPerformed
       getBandsDialog().setVisible(true);
    }//GEN-LAST:event_jButtonBandsActionPerformed

    private void jButtonGroupsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonGroupsActionPerformed
        getGroupsDialog().setVisible(true);
    }//GEN-LAST:event_jButtonGroupsActionPerformed

    private void jButtonParametersActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonParametersActionPerformed
        // Show values frame...
        getValuesDialog().setVisible(true);
    }//GEN-LAST:event_jButtonParametersActionPerformed

    private void jMenuItemOpenActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemOpenActionPerformed
        // Select an XMl file...
        String fileName = "";
        javax.swing.JFileChooser jfc = new javax.swing.JFileChooser();
        jfc.setDialogTitle("Load XML jasperreports file....");
        jfc.setFileFilter( new javax.swing.filechooser.FileFilter() {
              public boolean accept(java.io.File file) {
                      String filename = file.getName();
                      return (filename.endsWith(".xml") || file.isDirectory()) ;
              }
              public String getDescription() {
                       return "JasperReports XML *.xml";
              }
        });

        jfc.setMultiSelectionEnabled(true);
        jfc.setDialogType( javax.swing.JFileChooser.OPEN_DIALOG);
        if  (jfc.showOpenDialog( null) == javax.swing.JOptionPane.OK_OPTION)
        {
            java.io.File[] files = jfc.getSelectedFiles();
            for (int i=0; i<files.length; ++i)
            {    
                Report report = new Report(files[i].getPath());
                openNewReportWindow( report );
            }
        }
         
    }//GEN-LAST:event_jMenuItemOpenActionPerformed

    private void jToggleButtonSubreportToolItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jToggleButtonSubreportToolItemStateChanged
       if (evt.getStateChange() == java.awt.event.ItemEvent.SELECTED)
       { 
            if (jMDIDesktopPane.getSelectedFrame() != null &&
             jMDIDesktopPane.getSelectedFrame() instanceof JReportFrame)
            {
             JReportFrame jrf = (JReportFrame)jMDIDesktopPane.getSelectedFrame();
             jrf.setNewObjectType( ReportElementType.SUBREPORT_ELEMENT);
             jrf.setLensMode(false);
            }
            setActiveTool(jToggleButtonSubreportTool);
        }
    }//GEN-LAST:event_jToggleButtonSubreportToolItemStateChanged

    private void jToggleButtonSubreportToolActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToggleButtonSubreportToolActionPerformed
        jToggleButtonSubreportTool.setSelected(true);
    }//GEN-LAST:event_jToggleButtonSubreportToolActionPerformed

    private void jToggleButtonTextFieldToolItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jToggleButtonTextFieldToolItemStateChanged
       if (evt.getStateChange() == java.awt.event.ItemEvent.SELECTED)
       { 
            if (jMDIDesktopPane.getSelectedFrame() != null &&
             jMDIDesktopPane.getSelectedFrame() instanceof JReportFrame)
            {
             JReportFrame jrf = (JReportFrame)jMDIDesktopPane.getSelectedFrame();
             jrf.setNewObjectType( ReportElementType.TEXTFIELD_ELEMENT);
             jrf.setLensMode(false);
            }
            setActiveTool(jToggleButtonTextFieldTool);
        }
    }//GEN-LAST:event_jToggleButtonTextFieldToolItemStateChanged

    private void jToggleButtonTextFieldToolActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToggleButtonTextFieldToolActionPerformed
        jToggleButtonTextFieldTool.setSelected(true);
    }//GEN-LAST:event_jToggleButtonTextFieldToolActionPerformed

    private void jToggleButtonStaticTextToolItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jToggleButtonStaticTextToolItemStateChanged
       if (evt.getStateChange() == java.awt.event.ItemEvent.SELECTED)
       { 
            if (jMDIDesktopPane.getSelectedFrame() != null &&
             jMDIDesktopPane.getSelectedFrame() instanceof JReportFrame)
            {
             JReportFrame jrf = (JReportFrame)jMDIDesktopPane.getSelectedFrame();
             jrf.setNewObjectType( ReportElementType.STATICTEXT_ELEMENT);
             jrf.setLensMode(false);
            }
            setActiveTool(jToggleButtonStaticTextTool);
        }
    }//GEN-LAST:event_jToggleButtonStaticTextToolItemStateChanged

    private void jToggleButtonStaticTextToolActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToggleButtonStaticTextToolActionPerformed
        jToggleButtonStaticTextTool.setSelected(true);
    }//GEN-LAST:event_jToggleButtonStaticTextToolActionPerformed

    private void jToggleButtonImageToolItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jToggleButtonImageToolItemStateChanged
       if (evt.getStateChange() == java.awt.event.ItemEvent.SELECTED)
       { 
            if (jMDIDesktopPane.getSelectedFrame() != null &&
             jMDIDesktopPane.getSelectedFrame() instanceof JReportFrame)
            {
             JReportFrame jrf = (JReportFrame)jMDIDesktopPane.getSelectedFrame();
             jrf.setNewObjectType( ReportElementType.IMAGE_ELEMENT);
             jrf.setLensMode(false);
            }
            setActiveTool(jToggleButtonImageTool);
        }
    }//GEN-LAST:event_jToggleButtonImageToolItemStateChanged

    private void jToggleButtonImageToolActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToggleButtonImageToolActionPerformed
        jToggleButtonImageTool.setSelected(true);
    }//GEN-LAST:event_jToggleButtonImageToolActionPerformed

    private void jToggleButtonEllipseToolItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jToggleButtonEllipseToolItemStateChanged
         if (evt.getStateChange() == java.awt.event.ItemEvent.SELECTED)
       { 
            if (jMDIDesktopPane.getSelectedFrame() != null &&
             jMDIDesktopPane.getSelectedFrame() instanceof JReportFrame)
            {
             JReportFrame jrf = (JReportFrame)jMDIDesktopPane.getSelectedFrame();
             jrf.setNewObjectType( ReportElementType.ELLIPSE_ELEMENT);
             jrf.setLensMode(false);
            }
            setActiveTool(jToggleButtonEllipseTool);
        }
    }//GEN-LAST:event_jToggleButtonEllipseToolItemStateChanged

    private void jToggleButtonEllipseToolActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToggleButtonEllipseToolActionPerformed
        jToggleButtonEllipseTool.setSelected(true);
    }//GEN-LAST:event_jToggleButtonEllipseToolActionPerformed

    private void jToggleButtonRectRoundToolItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jToggleButtonRectRoundToolItemStateChanged
        if (evt.getStateChange() == java.awt.event.ItemEvent.SELECTED)
       { 
            if (jMDIDesktopPane.getSelectedFrame() != null &&
             jMDIDesktopPane.getSelectedFrame() instanceof JReportFrame)
            {
             JReportFrame jrf = (JReportFrame)jMDIDesktopPane.getSelectedFrame();
             jrf.setNewObjectType( ReportElementType.ROUND_RECTANGLE_ELEMENT);
             jrf.setLensMode(false);
            }
            setActiveTool(jToggleButtonRectRoundTool);
        }
    }//GEN-LAST:event_jToggleButtonRectRoundToolItemStateChanged

    private void jToggleButtonRectRoundToolActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToggleButtonRectRoundToolActionPerformed
        jToggleButtonRectRoundTool.setSelected(true);
    }//GEN-LAST:event_jToggleButtonRectRoundToolActionPerformed

    private void jToggleButtonRectToolItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jToggleButtonRectToolItemStateChanged
        if (evt.getStateChange() == java.awt.event.ItemEvent.SELECTED)
       { 
             if (jMDIDesktopPane.getSelectedFrame() != null &&
             jMDIDesktopPane.getSelectedFrame() instanceof JReportFrame)
            {
             JReportFrame jrf = (JReportFrame)jMDIDesktopPane.getSelectedFrame();
             jrf.setNewObjectType( ReportElementType.RECTANGLE_ELEMENT);
             jrf.setLensMode(false);
            }
            setActiveTool(jToggleButtonRectTool);
        }
    }//GEN-LAST:event_jToggleButtonRectToolItemStateChanged

    private void jToggleButtonRectToolActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToggleButtonRectToolActionPerformed
        jToggleButtonRectTool.setSelected(true);
    }//GEN-LAST:event_jToggleButtonRectToolActionPerformed

    private void jToggleButtonLineToolActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToggleButtonLineToolActionPerformed
        jToggleButtonLineTool.setSelected(true);
    }//GEN-LAST:event_jToggleButtonLineToolActionPerformed

    private void jToggleButtonLineToolItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jToggleButtonLineToolItemStateChanged
       if (evt.getStateChange() == java.awt.event.ItemEvent.SELECTED)
       {
            if (jMDIDesktopPane.getSelectedFrame() != null &&
                jMDIDesktopPane.getSelectedFrame() instanceof JReportFrame)
            {
             JReportFrame jrf = (JReportFrame)jMDIDesktopPane.getSelectedFrame();
             jrf.setNewObjectType( ReportElementType.LINE_ELEMENT);
             jrf.setLensMode(false);
            }
            setActiveTool(jToggleButtonLineTool);
       }
    }//GEN-LAST:event_jToggleButtonLineToolItemStateChanged

    private void jToggleButtonPointerActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToggleButtonPointerActionPerformed
            jToggleButtonPointer.setSelected(true);
    }//GEN-LAST:event_jToggleButtonPointerActionPerformed

    private void jToggleButtonPointerItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jToggleButtonPointerItemStateChanged
        if (evt.getStateChange() == java.awt.event.ItemEvent.SELECTED)
        {
        
            if (jMDIDesktopPane.getSelectedFrame() != null &&
                jMDIDesktopPane.getSelectedFrame() instanceof JReportFrame)
            {
                JReportFrame jrf = (JReportFrame)jMDIDesktopPane.getSelectedFrame();
                jrf.setNewObjectType( ReportElementType.NONE);
                jrf.setLensMode(false);
            }      
            if (jToggleButtonPointer.isEnabled())
            {
                setActiveTool( jToggleButtonPointer );
            }
        }
    }//GEN-LAST:event_jToggleButtonPointerItemStateChanged

    private void jButtonNewActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonNewActionPerformed
            this.jMenuItemNewDocumentActionPerformed(evt);
    }//GEN-LAST:event_jButtonNewActionPerformed

    public void setCutCopyEnebled(boolean enabled)
    {
        this.jButtonCut.setEnabled(enabled);
        this.jMenuItemCut.setEnabled(enabled);
        
        this.jButtonCopy.setEnabled(enabled);
        this.jMenuItemCopy.setEnabled(enabled);
        
        this.jMenuItemDelete.setEnabled(enabled);
    }
        
    public void setPasteEnebled(boolean enabled)
    {
        this.jButtonPaste.setEnabled(enabled);
        this.jMenuItemPaste.setEnabled(enabled);
    }
    
    public void setUndoEnebled(boolean enabled)
    {
        this.jMenuItemUndo.setEnabled(enabled);
    }
    
    public void setRedoEnebled(boolean enabled)
    {
        this.jMenuItemRedo.setEnabled(enabled);
    }
    
    public void setSaveEnebled(boolean enabled)
    {
        this.jButtonSave.setEnabled( enabled);
        this.jMenuItemSave.setEnabled( enabled);
    }
    
    private void jMenuItemSubreportActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemSubreportActionPerformed
        jToggleButtonSubreportToolItemStateChanged(new java.awt.event.ItemEvent(jToggleButtonSubreportTool,0,jToggleButtonSubreportTool, java.awt.event.ItemEvent.SELECTED));
    }//GEN-LAST:event_jMenuItemSubreportActionPerformed

    private void jMenuItemTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemTextFieldActionPerformed
        jToggleButtonTextFieldToolItemStateChanged(new java.awt.event.ItemEvent(jToggleButtonTextFieldTool,0,jToggleButtonTextFieldTool, java.awt.event.ItemEvent.SELECTED));
    }//GEN-LAST:event_jMenuItemTextFieldActionPerformed

    private void jMenuItemStaticTextActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemStaticTextActionPerformed
        jToggleButtonStaticTextToolItemStateChanged(new java.awt.event.ItemEvent(jToggleButtonStaticTextTool,0,jToggleButtonStaticTextTool, java.awt.event.ItemEvent.SELECTED));
    }//GEN-LAST:event_jMenuItemStaticTextActionPerformed

    private void jMenuItemEllipseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemEllipseActionPerformed
       jToggleButtonEllipseToolItemStateChanged(new java.awt.event.ItemEvent(jToggleButtonEllipseTool,0,jToggleButtonEllipseTool, java.awt.event.ItemEvent.SELECTED));
    }//GEN-LAST:event_jMenuItemEllipseActionPerformed

    private void jMenuItemRoundRectangleActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemRoundRectangleActionPerformed
       jToggleButtonRectRoundToolItemStateChanged(new java.awt.event.ItemEvent(jToggleButtonRectRoundTool,0,jToggleButtonRectRoundTool, java.awt.event.ItemEvent.SELECTED));
    }//GEN-LAST:event_jMenuItemRoundRectangleActionPerformed

    private void jMenuItemRectangleActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemRectangleActionPerformed
        jToggleButtonRectToolItemStateChanged(new java.awt.event.ItemEvent(jToggleButtonRectTool,0,jToggleButtonRectTool, java.awt.event.ItemEvent.SELECTED));
    }//GEN-LAST:event_jMenuItemRectangleActionPerformed

    private void jMenuItemLineActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemLineActionPerformed
        jToggleButtonLineToolItemStateChanged(new java.awt.event.ItemEvent(jToggleButtonLineTool,0,jToggleButtonLineTool, java.awt.event.ItemEvent.SELECTED));
    }//GEN-LAST:event_jMenuItemLineActionPerformed

    private void jMenuItemNullElementActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemNullElementActionPerformed

    }//GEN-LAST:event_jMenuItemNullElementActionPerformed

    private void jMenuEditActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuEditActionPerformed
        // Add your handling code here:
    }//GEN-LAST:event_jMenuEditActionPerformed
    
    private void jNumberComboBoxZoomValueChanged(ValueChangedEvent evt) {
        //System.out.println("Zoom changed to" + evt.getNewValue());
        if (jMDIDesktopPane.getSelectedFrame() != null &&
            jMDIDesktopPane.getSelectedFrame() instanceof JReportFrame)
        {
            JReportFrame jrf = (JReportFrame)jMDIDesktopPane.getSelectedFrame();
            jrf.setZoomFactor(this.jNumberComboBoxZoom.getValue()/100.0);
        }
    }
    
    /**
     *  This method adjust JImageButtons position in according with buttons array.
     *  A null entry is interpreted as a 8 pixel space.
     */
    private void jPanelToolBarComponentResized(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_jPanelToolBarComponentResized
        // Add your handling code here:
        if (toolBarControls == null ) return;
	int actualWidth=0;
	int actualHeight=0;
	int availWidth = this.jPanelToolBar.getWidth();
	
	java.util.Enumeration enum = toolBarControls.elements();
	while (enum.hasMoreElements())
	{
			Object obj = enum.nextElement();
			if (obj == null || ! (obj instanceof javax.swing.JComponent))
			{
				if (actualWidth > 0)
				{
					actualWidth += 8;
				}
			}
			else
			{
					javax.swing.JComponent ctl = (javax.swing.JComponent)obj;
					if ((actualWidth + ctl.getWidth()) > availWidth && (ctl.getWidth()+0 <= availWidth))
					{
						// Go to the next row...
						actualHeight += 32;
						actualWidth = 0;
					}
					ctl.setLocation(actualWidth,actualHeight);
					actualWidth += ctl.getWidth();
        		}
        }
        jPanelToolBar.setSize( this.jPanelToolBar.getWidth(), (actualHeight+34));
        jPanelToolBar.setPreferredSize(new java.awt.Dimension( this.jPanelToolBar.getWidth(), (actualHeight)+34));
        jPanelToolBar.updateUI();
    }//GEN-LAST:event_jPanelToolBarComponentResized

    private void jMenuItemNewDocumentActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemNewDocumentActionPerformed
       
        // Get info about the new report....
        // 1. Display the ReportProperties frame in dialog mode.
        //    Will be proposed default values...
        ReportPropertiesFrame rpf = new ReportPropertiesFrame();
        rpf.setModal(true);
        // find the first name free...
        String name = getFirstNameFree();
        rpf.setReportName( name);
        rpf.show();
        if (rpf.getDialogResult() == javax.swing.JOptionPane.OK_OPTION)
        {
            // The user has clicked on OK...
            // Storing in a new report the report characteristics.
            Report newReport = new Report();
            newReport.setWidth(rpf.getReportWidth());
            newReport.setHeight(rpf.getReportHeight());
            newReport.setOrientation(rpf.getOrientation());
            newReport.setName(rpf.getReportName());
            newReport.setTopMargin(rpf.getTopMargin());
            newReport.setLeftMargin(rpf.getLeftMargin());
            newReport.setRightMargin(rpf.getRightMargin());
            newReport.setBottomMargin(rpf.getBottomMargin());
            newReport.setColumnCount(rpf.getColumns());
            newReport.setColumnWidth(rpf.getColumnsWidth());
            newReport.setColumnSpacing(rpf.getColumnsSpacing());
            newReport.setIsSummaryNewPage(rpf.isSummaryOnNewPage());
            newReport.setIsTitleNewPage(rpf.isTitleOnNewPage());
            newReport.setWhenNoDataType(rpf.getWhenNoDataType());
            newReport.setScriptletClass(rpf.getScriptletClass());
            newReport.setEncoding(rpf.getXmlEncoding());
            newReport.setPrintOrder(rpf.getPrintOrder());
            newReport.setReportFormat(rpf.getReportFormat());
            /* todo newReport.setPageName(rpf.getPageName());  */
            openNewReportWindow( newReport );
        }        
    }//GEN-LAST:event_jMenuItemNewDocumentActionPerformed

    private void openNewReportWindow( Report newReport )
    {
        // Create a new document frame....
            // ...that rappresent the report document created...
            JReportFrame jrf = new JReportFrame(newReport);        
            // this is for JMDIFrame design...
            // jMDIMenuBar could be retrived from the jrf parent, contained in the JFrame
            // that store the JDesktopPane parent...
            jrf.setMenu( this.jMDIMenuBar );     
            // Set default, but we starting the frame maximized by default...
            jrf.setBounds(10,10,700,500);
            // We must set the frame visible before adding it to the jMDIDesktopPane...
            jrf.setVisible(true);
            jMDIDesktopPane.add(jrf, javax.swing.JLayeredPane.DEFAULT_LAYER);

            jMDIDesktopPane.getDesktopManager().activateFrame(jrf);
            
            // Count all frames...
            
            int f_num = jMDIDesktopPane.getAllFrames().length;
            JRadioButtonMenuItemMDIFrame menuItem = new JRadioButtonMenuItemMDIFrame((JMDIFrame)jrf, f_num + ". " + jrf.getTitle() );
            menuItem.setSelected(true);
            menuItem.setMnemonic((int)((f_num+"").charAt(0)) );
            menuItem.setFont(new java.awt.Font("Dialog", 0, 11));
            menuItem.setAccelerator( javax.swing.KeyStroke.getKeyStroke((int)((f_num+"").charAt(0)),java.awt.Event.META_MASK));
            
            this.jMenuWindow.insert(menuItem, this.jMenuWindow.getMenuComponentCount());
            menuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuWindowListActionPerformed(evt);
            }
            });
            buttonGroupFramesList.add(menuItem);
            //updateMenuWindowList();
            
            // After activation, we try to maximize the window....
            try {
                jrf.setSelected(true);
                //if (jMDIMenuBar.getMaximizedFrame()  != null) 
                jrf.setMaximum(true);
                String report_name = jrf.getReport().getName();
                DocumentTreeEntry dte = new DocumentTreeEntry(jrf,jrf.getReport().getName());
                javax.swing.tree.DefaultTreeModel dtm = (javax.swing.tree.DefaultTreeModel) jTreeFiles.getModel();
                ((javax.swing.tree.DefaultMutableTreeNode)dtm.getRoot()).add(
                    new javax.swing.tree.DefaultMutableTreeNode(dte));
                setFileListActivatedFrame(jrf);
                jTreeFiles.updateUI();
            } catch (java.beans.PropertyVetoException ex) { /* Nothing to do */}
        
            
        // This call fix a bug in the code to show control box buttons on menu panel...
        jMDIMenuBar.restoreButtonsPosition();
    }
    private void jMenuFileActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuFileActionPerformed
        // Add your handling code here:
        jMDIMenuBar.restoreButtonsPosition();
    }//GEN-LAST:event_jMenuFileActionPerformed

    private void formWindowOpened(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowOpened
        
        // This try is of java <1.4 comatibility
        try {
                this.getExtendedState();
       } catch (java.lang.NoSuchMethodError ex)
       {
        java.awt.Dimension dim = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        java.awt.Point p = new java.awt.Point();
        p.x = Math.max( 0, (dim.width -this.getWidth())/2 );
        p.y = Math.max( 0, (dim.height -this.getHeight())/2 );
        this.setLocation(p);
       }
        //this.setSize(dim);
       //this.getContentPane().repaint();
        //this.update(this.getGraphics());
        //this.setState(java.awt.Frame.MAXIMIZED_HORIZ);
    }//GEN-LAST:event_formWindowOpened
        
    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
        System.exit(0);
    }//GEN-LAST:event_exitForm
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        new MainFrame().show();
    }
    
    
     private static byte[] getBytesFromInputStream(java.io.InputStream in, int length)  throws java.io.IOException {
    java.io.DataInputStream din = new java.io.DataInputStream(in);
    byte[] bytecodes = new byte[length];
    try {
      din.readFully(bytecodes);
    } finally {
      if (din != null) din.close();
    }
    return bytecodes;
  }
    
    /** Gets the image to be displayed in the minimized icon
     * for this frame.
     * @return    the icon image for this frame, or <code>null</code>
     *                    if this frame doesn't have an icon image.
     * @see       #setIconImage(Icon)
     *
     */
    public java.awt.Image getIconImage() {
       try {
            ClassLoader cl = this.getClass().getClassLoader();           
            java.io.InputStream in = new java.io.FileInputStream( cl.getResource("it/businesslogic/ireport/icons/iconsmall.jpg").getPath() );
            byte[] data = getBytesFromInputStream(in, in.available());
            return java.awt.Toolkit.getDefaultToolkit().createImage(data);
        } catch (Exception ex) 
        {ex.getMessage();
            ex.printStackTrace();
        }
        return null;
    }
        
    /** Getter for property elementPropertiesFrame.
     * @return Value of property elementPropertiesFrame.
     *
     */
    public ElementPropertiesDialog getElementPropertiesDialog() {
        return elementPropertiesDialog;
    }
    
    /** Setter for property elementPropertiesFrame.
     * @param elementPropertiesFrame New value of property elementPropertiesFrame.
     *
     */
    public void setElementPropertiesDialog(ElementPropertiesDialog elementPropertiesDialog) {
        this.elementPropertiesDialog = elementPropertiesDialog;
    }
    
    /** Getter for property valuesDialog.
     * @return Value of property valuesDialog.
     *
     */
    public it.businesslogic.ireport.gui.ValuesDialog getValuesDialog() {
        return valuesDialog;
    }
    
    /** Setter for property valuesDialog.
     * @param valuesDialog New value of property valuesDialog.
     *
     */
    public void setValuesDialog(it.businesslogic.ireport.gui.ValuesDialog valuesDialog) {
        this.valuesDialog = valuesDialog;
    }
    
    /** Getter for property groupsDialog.
     * @return Value of property groupsDialog.
     *
     */
    public it.businesslogic.ireport.gui.GroupsDialog getGroupsDialog() {
        return groupsDialog;
    }
    
    /** Setter for property groupsDialog.
     * @param groupsDialog New value of property groupsDialog.
     *
     */
    public void setGroupsDialog(it.businesslogic.ireport.gui.GroupsDialog groupsDialog) {
        this.groupsDialog = groupsDialog;
    }
    
    /** Getter for property bandsDialog.
     * @return Value of property bandsDialog.
     *
     */
    public BandsDialog getBandsDialog() {
        return bandsDialog;
    }
    
    /** Setter for property bandsDialog.
     * @param bandsDialog New value of property bandsDialog.
     *
     */
    public void setBandsDialog(BandsDialog bandsDialog) {
        this.bandsDialog = bandsDialog;
    }
    
    /** Getter for property reportQueryDialog.
     * @return Value of property reportQueryDialog.
     *
     */
    public it.businesslogic.ireport.gui.ReportQueryDialog getReportQueryDialog() {
        return reportQueryDialog;
    }
    
    /** Setter for property reportQueryDialog.
     * @param reportQueryDialog New value of property reportQueryDialog.
     *
     */
    public void setReportQueryDialog(it.businesslogic.ireport.gui.ReportQueryDialog reportQueryDialog) {
        this.reportQueryDialog = reportQueryDialog;
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JMenuItem jMenuItemBringToFront;
    private javax.swing.JSeparator jSeparator2;
    private javax.swing.JMenuItem jMenuItemGroups;
    private javax.swing.JMenu jMenuHSpacing;
    private javax.swing.JMenuItem jMenuItemJoinLeft;
    private javax.swing.JPanel jPanelZoom;
    private javax.swing.JMenuItem jMenuItemFonts;
    private javax.swing.JMenuItem jMenuItemDelete;
    private javax.swing.JMenuItem jMenuItemAlignVerticalAxis;
    private javax.swing.JButton jButtonAlignLeft;
    private javax.swing.JMenuItem jMenuItemNextWin;
    private javax.swing.JMenu jMenuEdit;
    private javax.swing.JMenuItem jMenuItemExecute;
    private javax.swing.JButton jButtonNew;
    private javax.swing.JMenu jMenuAdd;
    private javax.swing.JMenuItem jMenuItemPaste;
    private javax.swing.JMenuItem jMenuItemFindPrev;
    private javax.swing.JMenuItem jMenuItemHSDecrease;
    private javax.swing.JMenuItem jMenuItemAlignToBandTop;
    private javax.swing.JMenuItem jMenuItemSameWidthMin;
    private javax.swing.JSeparator jSeparator10;
    private javax.swing.JSeparator jSeparator19;
    private javax.swing.JPanel jPanelMaster;
    private javax.swing.JMenuItem jMenuItemVariables;
    private javax.swing.JMenuItem jMenuItemCenterH;
    private javax.swing.JMenuItem jMenuItemSaveAll;
    private javax.swing.JMenuItem jMenuItemSave;
    private javax.swing.JButton jButtonBands;
    private javax.swing.JMenuItem jMenuItemFavorites;
    private javax.swing.JToggleButton jToggleButtonRectTool;
    private javax.swing.JToggleButton jToggleButtonStaticTextTool;
    private javax.swing.JMenuItem jMenuItemEllipse;
    private javax.swing.JButton jButtonOpen;
    private javax.swing.JMenuItem jMenuItemQuit;
    private javax.swing.JSeparator jSeparator9;
    private javax.swing.JTabbedPane jTabbedPaneExplorer;
    private javax.swing.ButtonGroup buttonGroupFramesList;
    private javax.swing.JMenuItem jMenuItemSameHeightMax;
    private javax.swing.JPanel jPanelDocumentStructure;
    private javax.swing.JMenuItem jMenuItemNewDocument;
    private javax.swing.JMenu jMenuBuild;
    private javax.swing.JMenuItem jMenuItemSameHeightMin;
    private javax.swing.JButton jButtonPaste;
    private javax.swing.JMenu jMenuHelp;
    private javax.swing.JCheckBoxMenuItem jCheckBoxMenuItemEMM;
    private javax.swing.JScrollPane jScrollPaneFiles;
    private javax.swing.JMenuItem jMenuItemHSRemove;
    private javax.swing.JCheckBoxMenuItem jCheckBoxMenuItemSnapToGrid;
    private javax.swing.JSeparator jSeparator3;
    private javax.swing.JMenuItem jMenuItemSameSize;
    private javax.swing.JToggleButton jToggleButtonRectRoundTool;
    private javax.swing.JMenuItem jMenuItemAlignRight;
    private javax.swing.JMenuItem jMenuItemJoinRight;
    private javax.swing.JMenuItem jMenuItemReportQuery;
    private javax.swing.JScrollPane jScrollPaneOutput;
    private javax.swing.JMenuItem jMenuItemCenterInBand;
    private javax.swing.JMenuItem jMenuItemReportProperties;
    private javax.swing.ButtonGroup buttonGroupExportType;
    private javax.swing.JMenuItem jMenuItemVSRemove;
    private javax.swing.JMenuItem jMenuItemFields;
    private javax.swing.JMenuItem jMenuItemCompile;
    private javax.swing.JToggleButton jToggleButtonSubreportTool;
    private javax.swing.JMenuItem jMenuItemNullElement;
    private javax.swing.JMenuItem jMenuItemCloseProject;
    private javax.swing.JRadioButtonMenuItem jRadioButtonMenuItemPreviewCSV;
    private javax.swing.JEditorPane jEditorPaneOutput;
    private javax.swing.JPanel jPanelProcesses;
    private javax.swing.JMenuItem jMenuItemVSIncrease;
    private javax.swing.JMenu jMenuRecentFiles;
    private javax.swing.JMenuItem jMenuItemRedo;
    private javax.swing.JMenu jMenuSize;
    private javax.swing.JMenuItem jMenuItemHelp;
    private javax.swing.JMenuItem jMenuItemLine;
    private javax.swing.JMenu jMenuFormat;
    private javax.swing.JCheckBoxMenuItem jCheckBoxMenuItemGrid;
    private javax.swing.JMenuItem jMenuItemAlignBottom;
    private javax.swing.JTree jTreeDocument;
    private javax.swing.JMenuItem jMenuItemElementProperties;
    private javax.swing.JSeparator jSeparator17;
    private javax.swing.JMenuItem jMenuItemSaveAs;
    private javax.swing.JCheckBoxMenuItem jCheckBoxMenuItemOutput;
    private javax.swing.JToggleButton jToggleButtonChartTool;
    private javax.swing.JButton jButtonCut;
    private javax.swing.JMenu jMenuTools;
    private javax.swing.JMenuItem jMenuItemReplace;
    private javax.swing.JSplitPane jSplitPaneHorizontal;
    private javax.swing.JMenuItem jMenuItemConnections;
    private javax.swing.JMenu jMenuProjects;
    private javax.swing.JToggleButton jToggleButtonPointer;
    private javax.swing.JSeparator jSeparator18;
    private javax.swing.JSplitPane jSplitPaneV;
    private javax.swing.JMenuItem jMenuItemUndo;
    private javax.swing.JList jListThreads;
    private javax.swing.JMenuItem jMenuItemViewConsole;
    private javax.swing.JButton jButtonGroups;
    private javax.swing.JMenuItem jMenuItemFind;
    private javax.swing.JPanel jPanelFiles;
    private javax.swing.JSeparator jSeparator14;
    private javax.swing.JMenuItem jMenuItemVSMakeEqual;
    private javax.swing.JRadioButtonMenuItem jRadioButtonMenuItemPreviewXLS;
    private it.businesslogic.ireport.gui.JMDIDesktopPane jMDIDesktopPane;
    private it.businesslogic.ireport.gui.JNumberComboBox jNumberComboBoxZoom;
    private javax.swing.JMenu jMenuPosition;
    private javax.swing.JRadioButtonMenuItem jRadioButtonMenuItemPreviewJAVA;
    private javax.swing.JTree jTreeFiles;
    private javax.swing.JMenuItem jMenuItemRectangle;
    private javax.swing.JSeparator jSeparator13;
    private javax.swing.JSeparator jSeparator4;
    private javax.swing.JButton jButtonSave;
    private javax.swing.JMenuItem jMenuItemAbout;
    private javax.swing.JPanel jPanelToolBar;
    private javax.swing.JSeparator jSeparator12;
    private javax.swing.JMenuItem jMenuItemAlignLeft;
    private javax.swing.JSeparator jSeparator5;
    private javax.swing.JMenuItem jMenuItemCopy;
    private javax.swing.JSeparator jSeparator11;
    private javax.swing.JMenuItem jMenuItemTileVertical;
    private javax.swing.JMenuItem jMenuItemReportQuery2;
    private javax.swing.JMenuItem jMenuItemStaticText;
    private javax.swing.JButton jButtonParameters;
    private javax.swing.JSeparator jSeparator15;
    private javax.swing.JSeparator jSeparator21;
    private javax.swing.JMenu jMenuWindow;
    private javax.swing.JMenuItem jMenuItemVSDecrease;
    private javax.swing.JMenu jMenuVSpacing;
    private javax.swing.JMenuItem jMenuItemCenterV;
    private javax.swing.JMenuItem jMenuItemSameWidthMax;
    private javax.swing.JMenuItem jMenuItemQOpen;
    private javax.swing.JMenuItem jMenuItemNewProject;
    private javax.swing.JMenuItem jMenuItemtileAnodine;
    private javax.swing.JSeparator jSeparator7;
    private javax.swing.JMenuItem jMenuItemSameWidth;
    private javax.swing.JButton jButtonAlignRight;
    private javax.swing.JSeparator jSeparator20;
    private javax.swing.JMenuItem jMenuItemPrevWin;
    private javax.swing.JMenuItem jMenuItemSubreport;
    private javax.swing.JButton jButtonRun2;
    private javax.swing.JMenuItem jMenuItemOpenProject;
    private javax.swing.JMenuItem jMenuItemTextField;
    private javax.swing.JCheckBoxMenuItem jCheckBoxMenuItemExplorer;
    private javax.swing.JSeparator jSeparator16;
    private javax.swing.JMenuItem jMenuItemFindNext;
    private javax.swing.JMenu jMenuAlign;
    private javax.swing.JMenuItem jMenuItemOpen;
    private javax.swing.JMenuItem jMenuItemParameters;
    private javax.swing.JSeparator jSeparator6;
    private javax.swing.JMenu jMenuSearch;
    private javax.swing.JTabbedPane jTabbedPane1;
    private javax.swing.JButton jButtonCompiler;
    private javax.swing.JMenuItem jMenuItemElementsBrowser;
    private javax.swing.JMenuItem jMenuItemAlignTop;
    private javax.swing.JMenuItem jMenuItemAlignHorizontalAxis;
    private javax.swing.JButton jButtonCopy;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JMenuItem jMenuItemActiveConnection;
    private javax.swing.JMenuItem jMenuItemCompileAll;
    private javax.swing.JRadioButtonMenuItem jRadioButtonMenuItemPreviewHTML;
    private javax.swing.JToggleButton jToggleButtonTextFieldTool;
    private javax.swing.JMenu jMenuRecentProjects;
    private javax.swing.JButton jButtonAlignCenter;
    private javax.swing.JToggleButton jToggleButtonImageTool;
    private javax.swing.JMenuItem jMenuItemXMLSource;
    private javax.swing.JMenuItem jMenuItemAlignToBandBottom;
    private javax.swing.JMenuItem jMenuItemCascade;
    private javax.swing.JMenuItem jMenuItemCenterBackground;
    private it.businesslogic.ireport.gui.JMDIMenuBar jMDIMenuBar;
    private javax.swing.JPanel jPanelSouth;
    private javax.swing.JButton jButtonRun1;
    private javax.swing.JButton jButtonDatabase;
    private javax.swing.JMenu jMenuView;
    private javax.swing.JToggleButton jToggleButtonEllipseTool;
    private javax.swing.JMenuItem jMenuItemBands;
    private javax.swing.JButton jButtonAlignJustify;
    private javax.swing.JSeparator jSeparator8;
    private javax.swing.JMenuItem jMenuItemCut;
    private javax.swing.JMenuItem jMenuItemProjectOptions;
    private javax.swing.JMenuItem jMenuItemHSIncrease;
    private javax.swing.JMenuItem jMenuItemOptions;
    private javax.swing.JMenuItem jMenuItemRoundRectangle;
    private javax.swing.JMenuItem jMenuItemHSMakeEqual;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JMenuItem jMenuItemSameHeight;
    private javax.swing.JScrollPane jScrollProcesses;
    private javax.swing.JMenu jMenuFile;
    private javax.swing.JMenuItem jMenuItemTileHorizontal;
    private javax.swing.JToggleButton jToggleButtonLineTool;
    private javax.swing.JMenu jMenuDatabase;
    private javax.swing.JMenuItem jMenuItemAddFileToProject;
    private javax.swing.JRadioButtonMenuItem jRadioButtonMenuItemPreviewPDF;
    private javax.swing.JMenuItem jMenuItemSendToBack;
    private javax.swing.JMenuItem jMenuItemCompatibility;
    // End of variables declaration//GEN-END:variables

    
    
    /* iReport configuration loader...
     */
      public void loadiReportConfiguration()
     {
         
         String xmlFile = "config.xml";
         loadiReportConfiguration( System.getProperties().getProperty("user.home") + File.separatorChar + ".ireport" + File.separatorChar + xmlFile); 
     }     
    
         /* iReport configuration loader...
     */
     public void loadiReportConfiguration(String xmlFile) {

         // Adding default properties...
         properties.put("RecentFilesLength","10");
         properties.put("ViewRules","true");
         properties.put("GridSize","10");
         properties.put("ViewBorderForTextElements","true");
         properties.put("DefaultTemplate","");
         properties.put("DefaultCompilationDirectory","");
         properties.put("BackupPolicy","2");
         properties.put("DefaultBackupDirectory","");
         properties.put("ExternalEditor","");
         properties.put("ExternalPDFViever","");
         properties.put("ExternalHTMLViewer","");
         properties.put("ExternalXLSViewer","");
         properties.put("ExternalCSVViewer","");
         properties.put("ViewBorderForTextElements","true");
         properties.put("ViewBorderColor","1");
         properties.put("DefaultUnit","cm");
         properties.put("SaveBeforeCompiling","true");
         properties.put("ViewBorderColor","-6710887");
         
         File file = null;
         try {
            file = new File(xmlFile);
         } catch (Exception ex){}
         if (file == null || !file.exists() || file.isDirectory()) 
         {
              try {
                    outputBuffer.setLength(0);
                    logOnConsole("Error on load iReport Configuration file: "+xmlFile+"\nUsing default parameters.");
              } catch (Exception exsx){}
             return; 
         }
             //  Create a Xerces DOM Parser
        DOMParser parser = new DOMParser();
        //  Parse the Document     
        //  and traverse the DOM
        try {
          
         parser.setEntityResolver( new org.xml.sax.EntityResolver() {
         /* Code by Teodor Danciu */
             public org.xml.sax.InputSource resolveEntity(
		String publicId,
		String systemId
		) throws SAXException//, java.io.IOException
                {
                         org.xml.sax.InputSource inputSource = null;

                	if (systemId != null)
        		{
                        	String dtd = null;
			
                		if (
                                        systemId.equals("http://ireport.sourceforge.net/dtds/iReportProperties.dtd")
                                        )
                                {
                        		dtd = "it/businesslogic/ireport/dtds/iReportProperties.dtd";
                		}
                        	else
                                {
                                	return new org.xml.sax.InputSource(systemId);
                        	}
			

                		ClassLoader classLoader = this.getClass().getClassLoader();

        			java.net.URL url = null;
                                
                                
                                if (classLoader != null)
                                {
                                	url = classLoader.getResource(dtd);
                        	}
                		if (url == null)
        			{
                                	classLoader = this.getClass().getClassLoader();
                                }
			                               
                                java.io.InputStream is = classLoader.getResourceAsStream(dtd);
                                if (is != null)
                                {
                                        java.io.InputStreamReader isr = new java.io.InputStreamReader(is);
                                        inputSource = new org.xml.sax.InputSource(isr);
                                }

                        }

                        return inputSource;
                }
         });
         /* End Code by Teodor Danciu */
         parser.parse(xmlFile);
         Document document = parser.getDocument();

         traverse(document.getDocumentElement());
         
         String defaultConnection = Misc.nvl(properties.get("DefaultConnection"),"");
         
             //properties.put("DefaultConnection", null); // No default connection...
         if (!defaultConnection.equals(""))
         {
             // Looking for a connection width this name..,
             Enumeration enum = getConnections().elements();
             while (enum.hasMoreElements())
             {
                 IReportConnection irc = (IReportConnection)enum.nextElement();
                 if (Misc.nvl(irc.getName(),"").equals( defaultConnection ))
                 {
                     properties.put("DefaultConnection", irc);
                     break;
                 }
             }
         }
                
      } catch (SAXException e) {
         System.err.println (e);
      } catch (java.io.IOException e) {
         System.err.println (e);
      }
    }
     
     
     private void traverse (Node node) {
       //System.out.println("traverse");
       if (node.getNodeType() == Node.ELEMENT_NODE && node.getNodeName().equals("iReportProperties"))
       {
           //System.out.println("iReportProperties");
           // Get childs....
           NodeList children = node.getChildNodes();
           if (children != null) {
                for (int k=0; k< children.getLength(); k++) 
                {
                    Node nodeChild = (Node)children.item(k);
                    if (nodeChild.getNodeType() == Node.ELEMENT_NODE && nodeChild.getNodeName().equals("iReportProperty"))
                    {
                        
                         // Take the CDATA...
                        String paramName = "";
                        NamedNodeMap nnm = nodeChild.getAttributes();
                        if ( nnm.getNamedItem("name") != null) paramName = nnm.getNamedItem("name").getNodeValue();
                        //System.out.println("     iReportProperty "+nnm.getNamedItem("name").getNodeValue());
                        properties.put(paramName,  readPCDATA(nodeChild) );
                         
                    }
                    else if (nodeChild.getNodeType() == Node.ELEMENT_NODE && nodeChild.getNodeName().equals("iReportConnection"))
                    {
                         // Take the CDATA...
                        String connectionName = "";
                        String connectionClass = "";
                        HashMap hm = new HashMap();
                        NamedNodeMap nnm = nodeChild.getAttributes();
                        if ( nnm.getNamedItem("name") != null) connectionName = nnm.getNamedItem("name").getNodeValue();
                        if ( nnm.getNamedItem("connectionClass") != null) connectionClass = nnm.getNamedItem("connectionClass").getNodeValue();
                        
                        // Get all connections parameters...
                        NodeList list_child = nodeChild.getChildNodes();
                         for (int ck=0; ck< list_child.getLength(); ck++) 
                         {
                             String parameterName = "";
                             Node child_child = (Node)list_child.item(ck);
                             if (child_child.getNodeType() == Node.ELEMENT_NODE && child_child.getNodeName().equals("connectionParameter"))
                             {
                             
                                    NamedNodeMap nnm2 = child_child.getAttributes();
                                    if ( nnm2.getNamedItem("name") != null) 
                                           parameterName = nnm2.getNamedItem("name").getNodeValue();
                                    hm.put( parameterName,readPCDATA(child_child));      
                             }
                         }
                        try {
                            IReportConnection con = (IReportConnection) Class.forName(connectionClass).newInstance();
                            con.loadProperties(hm);
                            con.setName(connectionName);
                            connections.addElement( con );
                        } catch (Exception ex)
                        {
                            try {
                                    logOnConsole("Error loading " +connectionName+"\n"+ex.getMessage()+"\n");
                                    
                                } catch (Exception exsx){}
                        }
                    }
                }
           }       
       }
     }
     /** Getter for property connections.
      * @return Value of property connections.
      *
      */
     public java.util.Vector getConnections() {
         return connections;
     }
     
     /** Setter for property connections.
      * @param connections New value of property connections.
      *
      */
     public void setConnections(java.util.Vector connections) {
         this.connections = connections;
     }
     
     /** Getter for property properties.
      * @return Value of property properties.
      *
      */
     public Properties getProperties() {
         return properties;
     }
     
     /** Setter for property properties.
      * @param properties New value of property properties.
      *
      */
     public void setProperties(Properties properties) {
         this.properties = properties;
     }
     
     private String readPCDATA(Node textNode)
   {
        NodeList list_child = textNode.getChildNodes();
        for (int ck=0; ck< list_child.getLength(); ck++) 
        {
               Node child_child = (Node)list_child.item(ck);
               if (child_child.getNodeType() == Node.CDATA_SECTION_NODE ||
                   child_child.getNodeType() == Node.TEXT_NODE)
               {
                     return (String)child_child.getNodeValue();
               }
        }
        return "";
   }
     
     public boolean saveiReportConfiguration() 
     {
         String xmlFile = "config.xml";
         // Get the path of this class...
        // this.getClass().getResource("MainFrame");
        File dir = new File(System.getProperties().getProperty("user.home") + File.separatorChar + ".ireport");
        try {
            if (dir.exists())
            {
             if (!dir.isDirectory() )
             {
                 javax.swing.JOptionPane.showMessageDialog( null, dir.getPath() +" is not a directory!\nPlease rename this file and retry to save config!","",JOptionPane.ERROR_MESSAGE);
                 return false;
             }
            }
            else
            {
             dir.mkdirs();
            }
        } catch (Exception ex)
        {
             javax.swing.JOptionPane.showMessageDialog( null, "An error is occurred saving iReport config:\n"+ex.getMessage()+"\nPlease try to save config again!","",JOptionPane.ERROR_MESSAGE);
             return false;
        }
        
        return saveiReportConfiguration(dir.getPath()+ File.separatorChar + xmlFile ); 
     }
     public boolean saveiReportConfiguration(String xmlFile) 
     {
         try {
            PrintWriter pw = new PrintWriter( new FileWriter(xmlFile) );
            // Find iReport configuration in the home directory...
            // 1. Save all properties using am XML style...
            pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            pw.println("<!-- iReport 2 Configuration file - " + new Date() + " -->");
            pw.println("<!DOCTYPE iReportProperties PUBLIC \"-//iReport/DTD iReport Configuration//EN\" \"http://ireport.sourceforge.net/dtds/iReportProperties.dtd\">");
            pw.println("<iReportProperties>");
            
            Enumeration enum = this.getProperties().keys();
            while (enum.hasMoreElements())
            {
                String key = (String)enum.nextElement();
                pw.println("\t<iReportProperty name=\""+ key +"\"><![CDATA["+ this.getProperties().get(key) +"]]></iReportProperty>");
            }
            
            enum = this.getConnections().elements();
            while (enum.hasMoreElements())
            {
                IReportConnection con = (IReportConnection)enum.nextElement();
                con.save(pw);
            }
            
            pw.println("</iReportProperties>");
            pw.close();
         } catch (Exception ex)
         {
             //ex.printStackTrace(s
              try {
                  logOnConsole("Error on save iReport Configuration file: "+xmlFile+"\n"+ex.getMessage()+"\n");
                  
             } catch (Exception exsx){}
              return false;
         }
         try {
             logOnConsole("iReport configuration file "+ xmlFile + " succesfully updated!\n");
         } catch (Exception ex){ }
         return true;
     }
     
     public void logOnConsole(String noHTML)
     {
         logOnConsole(noHTML,false);
     }
     public void logOnConsole(String s, boolean isHTML)
     {
         try {
                   this.jEditorPaneOutput.setContentType("text/html");
                   if (!isHTML)
                   {
                    s = Misc.string_replace("&gt;",">",s);
                    s = Misc.string_replace("&lt;","<",s);
                    s = Misc.string_replace("&nbsp;"," ",s);
                    s = Misc.string_replace("&nbsp;&nbsp;&nbsp;&nbsp;","\t",s);
                    s = Misc.string_replace("<br>", "\n", s);
                   }
                   
                   outputBuffer.append(s);
                   //String text = Misc.string_replace("","</body></html>",this.jEditorPaneOutput.getText());
                   
                   //s =  + s+"</body></html>";
                   this.jEditorPaneOutput.setText("<html><body><table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr><td nowrap><font face=\"Courier New\" size=\"3\">" + outputBuffer + "</font></td></tr></table></body></html>");
                   //this.jEditorPaneOutput.getDocument().insertString(this.jEditorPaneOutput.getDocument().getLength(), s ,  null);    
                  
         } catch (Exception exsx){
                JOptionPane.showMessageDialog(null,""+exsx.getMessage());
             }
     }
     
     /** Getter for property ttfFonts.
      * @return Value of property ttfFonts.
      *
      */
     public java.util.Vector getTtfFonts() {
         return ttfFonts;
     }
     
     /** Setter for property ttfFonts.
      * @param ttfFonts New value of property ttfFonts.
      *
      */
     public void setTtfFonts(java.util.Vector ttfFonts) {
         this.ttfFonts = ttfFonts;
     }
     
     /** This method parse an error encoded using an url.
      *  The url must be in the form:
      *  http://{error|warinig}:{JReportFrame ID}/{expression}
      *  
      *  error: referred to an expression field
      *  warning: referred to an element position warning
      *   
      *  Possible expressions for error:
      *  variableInitialValue_<VARIABLE_NAME>
      *  textField_<TEXTFIELD NUMBER>
      *  printWhen_<PRINT WHEN EXPRESSION NUMBER>(*)
      *  parameterDefaultValue_<PARAMETER NAME>
      *  parameter_<PARAMETER NAME>
      *
      *  Possible expressions for warning:
      *  y=<Y>,height=<Height>,band-height=<Band-Height>
      *
      *  (*) The printWhen expression are considered only if not blank.
      *  The search order is this: bands, elements
      */
     public boolean  parseError(java.net.URL url)
     {
         if (url == null) return false;
         
         // First of all activate the right frame...
         JInternalFrame[] frames = jMDIDesktopPane.getAllFrames();
         JReportFrame jrf = null;
         for (int k=0; k< frames.length; k++)
         {
            if (frames[k] instanceof JReportFrame)
            {
                if ( ((JReportFrame)frames[k]).getWindowID() == url.getPort())
                {
                    jrf = (JReportFrame)frames[k];
                    if ( !frames[k].isSelected() )
                    {
                        try {
                            frames[k].setSelected(true);
                        } catch (Exception ex)
                        {}
                    }
                }
            }
         }
         if (jrf == null) return false;
         
         try {
             if (url.getHost().equalsIgnoreCase("error"))
             {
                 String expression = url.getFile();

                 if (expression!=null && expression.length() > 0)
                 {
                  // parse expression...
                  if (expression.startsWith("/textField_"))
                  {
                        int index = 0;
                        int number = Integer.parseInt( expression.substring(("/textField_").length()).trim());
                        Enumeration enum = jrf.getReport().getElements().elements();
                        while (enum.hasMoreElements()) 
                        {
                            ReportElement re = (ReportElement)enum.nextElement();
                            if (re instanceof TextFieldReportElement)
                            {
                                index++;
                                if (index == number)
                                {
                                    jrf.setSelectedElement(re);
                                    this.getElementPropertiesDialog().setVisible(true);
                                    this.getElementPropertiesDialog().gotoTab( this.getElementPropertiesDialog().TEXTFIELD_TAB );
                                    return true;
                                }
                            }
                        }
                  }
                  else if (expression.startsWith("/parameterDefaultValue_"))
                  {
                        int index = 0;
                        String name = expression.substring(("/parameterDefaultValue_").length()).trim();
                        Enumeration enum = jrf.getReport().getParameters().elements();
                        while (enum.hasMoreElements()) 
                        {
                            it.businesslogic.ireport.JRParameter param = (it.businesslogic.ireport.JRParameter)enum.nextElement();
                            if (param.getName().equals(name)) 
                            {
                                 this.getValuesDialog().setVisible(true);
                                 this.getValuesDialog().modifyParameter(param );
                                 return true;
                            }
                        }
                  
                  }
                }
            }
             else if (url.getHost().equals("warning"))
            {
            }
         } catch (Exception ex)
         {}
         return false;
     }
}
