/*
 * JRTextExpressionArea.java
 *
 * iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 * Created on 28 aprile 2003, 22.55
 */

package it.businesslogic.ireport.gui;
import org.syntax.jedit.*;

/**
 *
 * @author  Administrator
 */
public class JRTextExpressionArea extends JEditTextArea {
    
    private int spessore = 0;
    protected boolean viewScrollbars = true;
    
    /** Creates a new instance of JRTextExpressionArea */
    public JRTextExpressionArea() {
        super();
        spessore = vertical.getWidth();
        super.painter.setLineHighlightColor(java.awt.Color.WHITE);
        this.setDocument(new SyntaxDocument());
        
    }
    
    /** Getter for property viewScrollbars.
     * @return Value of property viewScrollbars.
     *
     */
    public boolean isViewScrollbars() {
        return viewScrollbars;
    }
    
    /** Setter for property viewScrollbars.
     * @param viewScrollbars New value of property viewScrollbars.
     *
     */
    public void setViewScrollbars(boolean viewScrollbars) {
        
         //System.out.println("Ops"+viewScrollbars);
        //if (this.viewScrollbars == viewScrollbars) return;
        if (!viewScrollbars)
        {
            //super.vertical.setVisible(false);
            //super.horizontal.setVisible(false);
            
            //super.vertical.setSize(0,0);
        }
        else
        {
            //super.vertical.setVisible(true);
            //super.horizontal.setVisible(true);
            //super.vertical.setSize(spessore,  super.vertical.getHeight());
            //super.horizontal.setSize(spessore,  super.horizontal.getWidth());
        }
        this.viewScrollbars = viewScrollbars;
    }
    

    public void setEnabled(boolean enabled)
    {
        if (super.isEnabled() == enabled) return;
        super.setEnabled(enabled);
        if (!super.isEnabled())
        {
            for (int i=0; i<this.getComponentCount(); ++i)
                this.getComponent(i).setBackground(java.awt.Color.LIGHT_GRAY);
            this.setCaretVisible(false);
           this.getPainter().setLineHighlightEnabled(false);
           
            
        }
        else
        {
            for (int i=0; i<this.getComponentCount(); ++i)
                this.getComponent(i).setBackground(java.awt.Color.WHITE);
            this.setCaretVisible(true);
            this.getPainter().setLineHighlightEnabled(true);
        }  
    }
    
}
