/*
 * IReportChartFactory.java
 *
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute  and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 *
 * Created on 4 giugno 2003, 14.01
 */

package it.businesslogic.ireport.chart;
import org.jfree.chart.*;
import org.jfree.data.*;
import java.awt.*;
import java.awt.image.*;
/**
 *
 * @author  Administrator
 */
public class IReportChartFactory {
    
    public static final int VERTICAL_BAR_CHART      = 0;
    public static final int VERTICAL_BAR_CHART_3D   = 1;  
    public static final int PIE_CHART               = 2;
    public static final int PIE_CHART_3D            = 3;
    
    public static BufferedImage  iReportChart( 
                                     String title,
                                     int chartWidth,
                                     int chartHeight,
                                     int chartType,
                                     boolean legend,
                                     Color bgcolor)
    {
         CategoryDataset  dataset=null;
         PieDataset pieDataset=null;
         JFreeChart chart = null; 
         
          double[][] data = new double[][]
            { { 10.0,   4.0,  15.0,  14.0 },
              { -5.0,  -7.0,  14.0,  -3.0 },
              {  6.0,  17.0, -12.0,   7.0 },
              {  7.0,  15.0,  11.0,   0.0 },
              { -8.0,  -6.0,  10.0,  -9.0 },
              {  9.0,   8.0,   0.0,   6.0 },
              {-10.0,   9.0,   7.0,   7.0 },
              { 11.0,  13.0,   9.0,   9.0 },
              { -3.0,   7.0,  11.0, -10.0 } };

              dataset = DatasetUtilities.createCategoryDataset("Series ", "Category ", data);
              pieDataset = DatasetUtilities.createPieDatasetForColumn(dataset,0);
              
         if (chartType == IReportChartFactory.VERTICAL_BAR_CHART)
             {
                 chart = ChartFactory.createVerticalBarChart( title,"Category", "Value", dataset, legend, false, false);  
             }
             else if (chartType == IReportChartFactory.VERTICAL_BAR_CHART_3D)
             {
                 chart = ChartFactory.createVerticalBarChart3D(title,"Category", "Value", dataset, legend, false, false);  
             }
             else if (chartType == IReportChartFactory.PIE_CHART)
             {
                 chart = ChartFactory.createPieChart(title, pieDataset, legend, false, false);  
             }
             else if (chartType == IReportChartFactory.PIE_CHART_3D)
             {
                 chart = ChartFactory.createPie3DChart(title, pieDataset, legend, false, false);  
             }
             chart.setBackgroundPaint(bgcolor);
             
             return chart.createBufferedImage(chartWidth, chartHeight);
    }
                                     
                                     
                                     
    
}
