/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.UnicodeString;
import org.apache.poi.util.LittleEndian;

public class WriteAccessRecord
extends Record {
    public static final short sid = 92;
    private String field_1_username;

    public WriteAccessRecord() {
    }

    public WriteAccessRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public WriteAccessRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    protected void validateSid(short id) {
        if (id != 92) {
            throw new RecordFormatException("NOT A WRITEACCESS RECORD");
        }
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_username = new String(data, 3 + offset, data.length - 4);
    }

    public void setUsername(String username) {
        this.field_1_username = username;
    }

    public String getUsername() {
        return this.field_1_username;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[WRITEACCESS]\n");
        buffer.append("    .name            = ").append(this.field_1_username.toString()).append("\n");
        buffer.append("[/WRITEACCESS]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        String username = this.getUsername();
        StringBuffer temp = new StringBuffer(109);
        temp.append(username);
        while (temp.length() < 109) {
            temp.append(" ");
        }
        username = temp.toString();
        UnicodeString str = new UnicodeString();
        str.setString(username);
        str.setOptionFlags((byte)0);
        str.setCharCount((short)4);
        byte[] stringbytes = str.serialize();
        LittleEndian.putShort(data, 0 + offset, (short)92);
        LittleEndian.putShort(data, 2 + offset, (short)stringbytes.length);
        System.arraycopy(stringbytes, 0, data, 4 + offset, stringbytes.length);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 116;
    }

    public short getSid() {
        return 92;
    }
}

