/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.dev;

import java.io.FileInputStream;
import java.util.List;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFactory;
import org.apache.poi.hssf.record.formula.OperationPtg;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class FormulaViewer {
    private String file;

    public void run() throws Exception {
        POIFSFileSystem fs = new POIFSFileSystem(new FileInputStream(this.file));
        List records = RecordFactory.createRecords(fs.createDocumentInputStream("Workbook"));
        int k = 0;
        while (k < records.size()) {
            Record record = (Record)records.get(k);
            if (record.getSid() == 6) {
                this.parseFormulaRecord((FormulaRecord)record);
            }
            ++k;
        }
    }

    public void parseFormulaRecord(FormulaRecord record) {
        System.out.println("In ParseFormula Record");
        System.out.println("row   = " + record.getRow());
        System.out.println("col   = " + record.getColumn());
        System.out.println("value = " + record.getValue());
        System.out.println("xf    = " + record.getXFIndex());
        System.out.println("number of ptgs = " + record.getNumberOfExpressionTokens());
        System.out.println("options = " + record.getOptions());
        System.out.println(this.composeForumla(record));
    }

    public String composeForumla(FormulaRecord record) {
        StringBuffer formula = new StringBuffer("=");
        int numptgs = record.getNumberOfExpressionTokens();
        List ptgs = record.getParsedExpression();
        int ptgnum = numptgs - 1;
        while (ptgnum > -1) {
            Ptg ptg = (Ptg)ptgs.get(ptgnum);
            OperationPtg optg = (OperationPtg)((Object)ptg);
            int numops = optg.getNumberOfOperands();
            Ptg[] ops = new Ptg[numops];
            int opoffset = 1;
            int opnum = ops.length - 1;
            while (opnum > -1) {
                ops[opnum] = (Ptg)ptgs.get(ptgnum - opoffset);
                ++opoffset;
                --opnum;
            }
            formula.append(optg.toFormulaString(ops));
            ptgnum -= ops.length;
            --ptgnum;
        }
        return formula.toString();
    }

    public void setFile(String file) {
        this.file = file;
    }

    public static void main(String[] args) {
        if (args == null || args.length != 1 || args[0].equals("--help")) {
            System.out.println("FormulaViewer .8 proof that the devil lies in the details (or just in BIFF8 files in general)");
            System.out.println("usage: Give me a big fat file name");
        } else {
            try {
                FormulaViewer viewer = new FormulaViewer();
                viewer.setFile(args[0]);
                viewer.run();
            }
            catch (Exception e) {
                System.out.println("Whoops!");
                e.printStackTrace();
            }
        }
    }
}

