/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Shape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.io.SerialUtilities;

public class ShapeTable
implements Serializable {
    private int rows = 0;
    private int columns = 0;
    private transient Shape[][] data = new Shape[0][0];

    public int getRowCount() {
        return this.rows;
    }

    public int getColumnCount() {
        return this.columns;
    }

    public Shape getShape(int n, int n2) {
        Shape[] shapeArray;
        Shape shape = null;
        if (n < this.data.length && n2 < (shapeArray = this.data[n]).length) {
            shape = shapeArray[n2];
        }
        return shape;
    }

    public void setShape(int n, int n2, Shape shape) {
        int n3;
        Shape[][] shapeArrayArray;
        if (n >= this.data.length) {
            shapeArrayArray = new Shape[n + 1][];
            int n4 = 0;
            while (n4 < this.data.length) {
                shapeArrayArray[n4] = this.data[n4];
                ++n4;
            }
            n3 = this.data.length;
            while (n3 <= n) {
                shapeArrayArray[n3] = new Shape[0];
                ++n3;
            }
            this.data = shapeArrayArray;
        }
        if (n2 >= (shapeArrayArray = this.data[n]).length) {
            Shape[] shapeArray = new Shape[n2 + 1];
            n3 = 0;
            while (n3 < shapeArrayArray.length) {
                shapeArray[n3] = shapeArrayArray[n3];
                ++n3;
            }
            shapeArray[n2] = shape;
            this.data[n] = shapeArray;
        } else {
            shapeArrayArray[n2] = shape;
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object instanceof ShapeTable) {
            ShapeTable shapeTable = (ShapeTable)object;
            boolean bl = this.rows == shapeTable.getRowCount() && this.columns == shapeTable.getColumnCount();
            int n = 0;
            while (n < this.rows) {
                int n2 = this.data[n].length;
                int n3 = 0;
                while (n3 < n2) {
                    bl = bl && this.data[n][n3].equals(shapeTable.getShape(n, n3));
                    ++n3;
                }
                ++n;
            }
            return bl;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        int n = 0;
        while (n < this.rows) {
            int n2 = this.data[n].length;
            objectOutputStream.writeInt(n2);
            int n3 = 0;
            while (n3 < n2) {
                SerialUtilities.writeShape((Shape)this.data[n][n3], (ObjectOutputStream)objectOutputStream);
                ++n3;
            }
            ++n;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.data = new Shape[this.rows][this.columns];
        int n = 0;
        while (n < this.rows) {
            int n2 = objectInputStream.readInt();
            int n3 = 0;
            while (n3 < n2) {
                Shape shape;
                this.data[n][n3] = shape = SerialUtilities.readShape((ObjectInputStream)objectInputStream);
                ++n3;
            }
            ++n;
        }
    }
}

