/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.CrosshairInfo;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.axis.HorizontalNumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.axis.VerticalNumberAxis;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.DatasetGroup;
import org.jfree.data.Range;

public class OverlaidXYPlot
extends XYPlot
implements Serializable {
    private List subplots = new ArrayList();

    public OverlaidXYPlot(String string, String string2) {
        this(new HorizontalNumberAxis(string), new VerticalNumberAxis(string2));
    }

    public OverlaidXYPlot(ValueAxis valueAxis, ValueAxis valueAxis2) {
        super(null, valueAxis, valueAxis2);
    }

    public void add(XYPlot xYPlot) {
        ValueAxis valueAxis;
        DatasetGroup datasetGroup = this.getDatasetGroup();
        if (datasetGroup != null) {
            xYPlot.setDatasetGroup(datasetGroup);
        } else {
            this.setDatasetGroup(xYPlot.getDatasetGroup());
        }
        xYPlot.setParent(this);
        xYPlot.setDomainAxis(null);
        xYPlot.setRangeAxis(null);
        this.subplots.add(xYPlot);
        ValueAxis valueAxis2 = this.getDomainAxis();
        if (valueAxis2 != null) {
            valueAxis2.configure();
        }
        if ((valueAxis = this.getRangeAxis()) != null) {
            valueAxis.configure();
        }
    }

    public void remove(XYPlot xYPlot) {
        ValueAxis valueAxis;
        this.subplots.remove(xYPlot);
        xYPlot.setParent(null);
        ValueAxis valueAxis2 = this.getDomainAxis();
        if (valueAxis2 != null) {
            valueAxis2.configure();
        }
        if ((valueAxis = this.getRangeAxis()) != null) {
            valueAxis.configure();
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public LegendItemCollection getLegendItems() {
        LegendItemCollection legendItemCollection = new LegendItemCollection();
        if (this.subplots != null) {
            Iterator iterator = this.subplots.iterator();
            while (iterator.hasNext()) {
                XYPlot xYPlot = (XYPlot)iterator.next();
                LegendItemCollection legendItemCollection2 = xYPlot.getLegendItems();
                legendItemCollection.addAll(legendItemCollection2);
            }
        }
        return legendItemCollection;
    }

    public void render(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo, CrosshairInfo crosshairInfo) {
        Iterator iterator = this.subplots.iterator();
        while (iterator.hasNext()) {
            XYPlot xYPlot = (XYPlot)iterator.next();
            xYPlot.render(graphics2D, rectangle2D, chartRenderingInfo, crosshairInfo);
        }
    }

    public String getPlotType() {
        return "Overlaid XY Plot";
    }

    public Range getHorizontalDataRange(ValueAxis valueAxis) {
        Range range = null;
        if (this.subplots != null) {
            Iterator iterator = this.subplots.iterator();
            while (iterator.hasNext()) {
                XYPlot xYPlot = (XYPlot)iterator.next();
                range = Range.combine(range, xYPlot.getHorizontalDataRange(valueAxis));
            }
        }
        return range;
    }

    public Range getVerticalDataRange(ValueAxis valueAxis) {
        Range range = null;
        if (this.subplots != null) {
            Iterator iterator = this.subplots.iterator();
            while (iterator.hasNext()) {
                XYPlot xYPlot = (XYPlot)iterator.next();
                range = Range.combine(range, xYPlot.getVerticalDataRange(valueAxis));
            }
        }
        return range;
    }
}

