/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.Iterator;
import org.jfree.chart.axis.ColorBarAxis;
import org.jfree.chart.axis.HorizontalNumberAxis;
import org.jfree.chart.axis.Tick;
import org.jfree.chart.plot.ContourValuePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.ui.ColorPalette;
import org.jfree.chart.ui.RainbowPalette;
import org.jfree.data.Range;
import org.jfree.ui.RefineryUtilities;

public class HorizontalColorBarAxis
extends HorizontalNumberAxis
implements ColorBarAxis,
Serializable {
    public static final int DEFAULT_COLORBAR_THICKNESS = 0;
    public static final double DEFAULT_COLORBAR_THICKNESS_PCT = 0.05;
    public static final int DEFAULT_OUTERGAP = 20;
    private int colorBarThickness = 0;
    private double colorBarThicknessPercent = 0.05;
    private ColorPalette colorPalette = new RainbowPalette();
    private int colorBarLength = 0;
    private int outerGap = 20;

    public HorizontalColorBarAxis(String string) {
        super(string);
        this.colorPalette.setMinZ(this.getRange().getLowerBound());
        this.colorPalette.setMaxZ(this.getRange().getUpperBound());
        this.setLowerMargin(0.0);
        this.setUpperMargin(0.0);
    }

    protected void autoAdjustRange() {
        Plot plot = this.getPlot();
        if (plot == null) {
            return;
        }
        if (plot instanceof ContourValuePlot) {
            ContourValuePlot contourValuePlot = (ContourValuePlot)((Object)plot);
            Range range = contourValuePlot.getContourDataRange();
            if (range == null) {
                range = new Range(0.0, 1.0);
            }
            double d = range.getUpperBound();
            double d2 = range.getLowerBound();
            double d3 = d - d2;
            double d4 = this.getFixedAutoRange();
            if (d4 > 0.0) {
                d2 = d - d4;
            } else {
                double d5 = this.getAutoRangeMinimumSize();
                if (d3 < d5) {
                    d = (d + d2 + d5) / 2.0;
                    d2 = (d + d2 - d5) / 2.0;
                }
                if (this.autoRangeIncludesZero()) {
                    if (this.autoRangeStickyZero()) {
                        d = d <= 0.0 ? 0.0 : (d += this.getUpperMargin() * d3);
                        d2 = d2 >= 0.0 ? 0.0 : (d2 -= this.getLowerMargin() * d3);
                    } else {
                        d = Math.max(0.0, d + this.getUpperMargin() * d3);
                        d2 = Math.min(0.0, d2 - this.getLowerMargin() * d3);
                    }
                } else if (this.autoRangeStickyZero()) {
                    d = d <= 0.0 ? Math.min(0.0, d + this.getUpperMargin() * d3) : (d += this.getUpperMargin() * d3);
                    d2 = d2 >= 0.0 ? Math.max(0.0, d2 - this.getLowerMargin() * d3) : (d2 -= this.getLowerMargin() * d3);
                } else {
                    d += this.getUpperMargin() * d3;
                    d2 -= this.getLowerMargin() * d3;
                }
            }
            this.setRangeAttribute(new Range(d2, d));
            this.colorPalette.setMinZ(d2);
            this.colorPalette.setMaxZ(d);
        }
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, int n) {
        Object object;
        double d;
        Object object2;
        double d2 = rectangle2D2.getWidth();
        if (this.colorBarLength > 0) {
            d2 = this.colorBarLength;
        }
        double d3 = this.colorBarThicknessPercent * rectangle2D2.getHeight();
        if (this.colorBarThickness > 0) {
            d3 = this.colorBarThickness;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D2.getX(), rectangle2D2.getMaxY(), d2, d3);
        this.refreshTicks(graphics2D, rectangle2D, double_, 1);
        this.drawColorBar(graphics2D, double_);
        double d4 = double_.getMaxX();
        double d5 = (float)double_.getMaxY();
        graphics2D.setFont(this.getTickLabelFont());
        Iterator iterator = this.getTicks().iterator();
        while (iterator.hasNext()) {
            object2 = (Tick)iterator.next();
            d = this.translateValueToJava2D(((Tick)object2).getNumericalValue(), double_);
            if (this.isTickLabelsVisible()) {
                graphics2D.setPaint(this.getTickLabelPaint());
                object = null;
                if (this.getLabel() != null) {
                    object = this.getLabelFont().getStringBounds(this.getLabel(), graphics2D.getFontRenderContext());
                }
                if (this.isVerticalTickLabels()) {
                    d = rectangle2D.getX() + (double)this.getLabelInsets().left + ((RectangularShape)object).getHeight();
                    d4 = rectangle2D2.getY() + rectangle2D2.getHeight() / 2.0 + ((RectangularShape)object).getWidth() / 2.0;
                    RefineryUtilities.drawRotatedString((String)this.getLabel(), (Graphics2D)graphics2D, (float)((float)d), (float)((float)d4), (double)-1.5707963267948966);
                } else {
                    graphics2D.drawString(((Tick)object2).getText(), ((Tick)object2).getX(), ((Tick)object2).getY());
                }
            }
            if (!this.isTickMarksVisible()) continue;
            graphics2D.setStroke(this.getTickMarkStroke());
            object = new Line2D.Double(d, d5 - 2.0, d, d5 + 2.0);
            graphics2D.draw((Shape)object);
        }
        object2 = this.getLabel();
        if (object2 != null) {
            d = this.getMaxTickLabelHeight(graphics2D, double_, this.isVerticalTickLabels());
            object = this.getLabelFont();
            graphics2D.setFont((Font)object);
            graphics2D.setPaint(this.getLabelPaint());
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            Rectangle2D rectangle2D3 = ((Font)object).getStringBounds((String)object2, fontRenderContext);
            LineMetrics lineMetrics = ((Font)object).getLineMetrics((String)object2, fontRenderContext);
            float f = (float)(((RectangularShape)double_).getX() + ((RectangularShape)double_).getWidth() / 2.0 - rectangle2D3.getWidth() / 2.0);
            float f2 = (float)(d + double_.getMaxY() + (double)this.getLabelInsets().bottom + 20.0 + (double)lineMetrics.getDescent() + (double)lineMetrics.getLeading());
            graphics2D.drawString((String)object2, f, f2);
        }
    }

    public void drawColorBar(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.colorPalette.setTickValues(this.getTicks());
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(new BasicStroke(1.0f));
        double d = rectangle2D.getY();
        double d2 = rectangle2D.getMaxY();
        double d3 = rectangle2D.getX();
        Line2D.Double double_ = new Line2D.Double();
        while (d3 <= rectangle2D.getMaxX()) {
            double d4 = this.translateJava2DtoValue((float)d3, rectangle2D);
            ((Line2D)double_).setLine(d3, d, d3, d2);
            graphics2D.setPaint(this.getPaint(d4));
            graphics2D.draw(double_);
            d3 += 1.0;
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        graphics2D.setStroke(stroke);
    }

    public ColorPalette getColorPalette() {
        return this.colorPalette;
    }

    private double getMaxTickLabelHeight(Graphics2D graphics2D, Rectangle2D rectangle2D, boolean bl) {
        Font font = this.getTickLabelFont();
        graphics2D.setFont(font);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        double d = 0.0;
        if (bl) {
            Iterator iterator = this.getTicks().iterator();
            while (iterator.hasNext()) {
                Tick tick = (Tick)iterator.next();
                Rectangle2D rectangle2D2 = font.getStringBounds(tick.getText(), fontRenderContext);
                if (!(rectangle2D2.getWidth() > d)) continue;
                d = rectangle2D2.getWidth();
            }
        } else {
            LineMetrics lineMetrics = font.getLineMetrics("Sample", fontRenderContext);
            d = lineMetrics.getHeight();
        }
        return d;
    }

    public Paint getPaint(double d) {
        return this.colorPalette.getPaint(d);
    }

    protected boolean isCompatiblePlot(Plot plot) {
        return plot instanceof ContourValuePlot;
    }

    public void setColorPalette(ColorPalette colorPalette) {
        this.colorPalette = colorPalette;
    }

    public void setMaximumAxisValue(double d) {
        this.colorPalette.setMaxZ(d);
        super.setMaximumAxisValue(d);
    }

    public void setMinimumAxisValue(double d) {
        this.colorPalette.setMinZ(d);
        super.setMinimumAxisValue(d);
    }

    public double reserveHeight(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D, int n) {
        double d = super.reserveHeight(graphics2D, plot, rectangle2D, n);
        return d + rectangle2D.getHeight() * this.colorBarThicknessPercent + (double)this.outerGap;
    }

    public double reserveHeight(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D, int n, double d, int n2) {
        double d2 = super.reserveHeight(graphics2D, plot, rectangle2D, n, d, 3);
        d2 = d2 + rectangle2D.getHeight() * this.colorBarThicknessPercent + (double)this.outerGap;
        return d2;
    }

    public void doAutoRange() {
        this.autoAdjustRange();
    }
}

