/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.event.AxisChangeEvent;

public abstract class CategoryAxis
extends Axis
implements Serializable {
    public static final double DEFAULT_AXIS_MARGIN = 0.05;
    public static final double DEFAULT_CATEGORY_MARGIN = 0.2;
    private double lowerMargin = 0.05;
    private double upperMargin = 0.05;
    private double categoryMargin = 0.2;

    protected CategoryAxis(String string) {
        super(string);
        this.setTickMarksVisible(false);
    }

    public double getLowerMargin() {
        return this.lowerMargin;
    }

    public void setLowerMargin(double d) {
        this.lowerMargin = d;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public double getUpperMargin() {
        return this.upperMargin;
    }

    public void setUpperMargin(double d) {
        this.upperMargin = d;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public double getCategoryMargin() {
        return this.categoryMargin;
    }

    public void setCategoryMargin(double d) {
        this.categoryMargin = d;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public abstract double getCategoryStart(int var1, int var2, Rectangle2D var3);

    public abstract double getCategoryMiddle(int var1, int var2, Rectangle2D var3);

    public abstract double getCategoryEnd(int var1, int var2, Rectangle2D var3);

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof CategoryAxis) {
            CategoryAxis categoryAxis = (CategoryAxis)object;
            if (super.equals(object)) {
                boolean bl = this.lowerMargin == categoryAxis.lowerMargin;
                boolean bl2 = this.upperMargin == categoryAxis.upperMargin;
                boolean bl3 = this.categoryMargin == categoryAxis.categoryMargin;
                return bl && bl2 && bl3;
            }
        }
        return false;
    }
}

