/**
 * <copyright>
 * </copyright>
 *
 * $Id: MondrianItemProviderAdapterFactory.java,v 1.2 2004/06/30 13:45:51 avix Exp $
 */
package net.sourceforge.mondrian.schema.Mondrian.provider;

import java.util.ArrayList;
import java.util.Collection;

import net.sourceforge.mondrian.schema.Mondrian.util.MondrianAdapterFactory;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class MondrianItemProviderAdapterFactory extends MondrianAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier {
  /**
   * This keeps track of the root adapter factory that delegates to this adapter factory.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected ComposedAdapterFactory parentAdapterFactory;

  /**
   * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected IChangeNotifier changeNotifier = new ChangeNotifier();

  /**
   * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected Collection supportedTypes = new ArrayList();

  /**
   * This constructs an instance.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public MondrianItemProviderAdapterFactory() {
    supportedTypes.add(IStructuredItemContentProvider.class);
    supportedTypes.add(ITreeItemContentProvider.class);
    supportedTypes.add(IItemPropertySource.class);
    supportedTypes.add(IEditingDomainItemProvider.class);
    supportedTypes.add(IItemLabelProvider.class);
  }

  /**
   * This keeps track of the one adapter used for all {@link net.sourceforge.mondrian.schema.Mondrian.ColumnType} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected ColumnTypeItemProvider columnTypeItemProvider;

  /**
   * This creates an adapter for a {@link net.sourceforge.mondrian.schema.Mondrian.ColumnType}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Adapter createColumnTypeAdapter() {
    if (columnTypeItemProvider == null) {
      columnTypeItemProvider = new ColumnTypeItemProvider(this);
    }

    return columnTypeItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link net.sourceforge.mondrian.schema.Mondrian.CubeGrantType} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected CubeGrantTypeItemProvider cubeGrantTypeItemProvider;

  /**
   * This creates an adapter for a {@link net.sourceforge.mondrian.schema.Mondrian.CubeGrantType}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Adapter createCubeGrantTypeAdapter() {
    if (cubeGrantTypeItemProvider == null) {
      cubeGrantTypeItemProvider = new CubeGrantTypeItemProvider(this);
    }

    return cubeGrantTypeItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link net.sourceforge.mondrian.schema.Mondrian.CubeType} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected CubeTypeItemProvider cubeTypeItemProvider;

  /**
   * This creates an adapter for a {@link net.sourceforge.mondrian.schema.Mondrian.CubeType}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Adapter createCubeTypeAdapter() {
    if (cubeTypeItemProvider == null) {
      cubeTypeItemProvider = new CubeTypeItemProvider(this);
    }

    return cubeTypeItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link net.sourceforge.mondrian.schema.Mondrian.DimensionGrantType} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected DimensionGrantTypeItemProvider dimensionGrantTypeItemProvider;

  /**
   * This creates an adapter for a {@link net.sourceforge.mondrian.schema.Mondrian.DimensionGrantType}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Adapter createDimensionGrantTypeAdapter() {
    if (dimensionGrantTypeItemProvider == null) {
      dimensionGrantTypeItemProvider = new DimensionGrantTypeItemProvider(this);
    }

    return dimensionGrantTypeItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link net.sourceforge.mondrian.schema.Mondrian.DimensionType} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected DimensionTypeItemProvider dimensionTypeItemProvider;

  /**
   * This creates an adapter for a {@link net.sourceforge.mondrian.schema.Mondrian.DimensionType}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Adapter createDimensionTypeAdapter() {
    if (dimensionTypeItemProvider == null) {
      dimensionTypeItemProvider = new DimensionTypeItemProvider(this);
    }

    return dimensionTypeItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link net.sourceforge.mondrian.schema.Mondrian.DimensionUsageType} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected DimensionUsageTypeItemProvider dimensionUsageTypeItemProvider;

  /**
   * This creates an adapter for a {@link net.sourceforge.mondrian.schema.Mondrian.DimensionUsageType}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Adapter createDimensionUsageTypeAdapter() {
    if (dimensionUsageTypeItemProvider == null) {
      dimensionUsageTypeItemProvider = new DimensionUsageTypeItemProvider(this);
    }

    return dimensionUsageTypeItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link net.sourceforge.mondrian.schema.Mondrian.DocumentRoot} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected DocumentRootItemProvider documentRootItemProvider;

  /**
   * This creates an adapter for a {@link net.sourceforge.mondrian.schema.Mondrian.DocumentRoot}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Adapter createDocumentRootAdapter() {
    if (documentRootItemProvider == null) {
      documentRootItemProvider = new DocumentRootItemProvider(this);
    }

    return documentRootItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link net.sourceforge.mondrian.schema.Mondrian.HierarchyGrantType} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected HierarchyGrantTypeItemProvider hierarchyGrantTypeItemProvider;

  /**
   * This creates an adapter for a {@link net.sourceforge.mondrian.schema.Mondrian.HierarchyGrantType}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Adapter createHierarchyGrantTypeAdapter() {
    if (hierarchyGrantTypeItemProvider == null) {
      hierarchyGrantTypeItemProvider = new HierarchyGrantTypeItemProvider(this);
    }

    return hierarchyGrantTypeItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link net.sourceforge.mondrian.schema.Mondrian.HierarchyType} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected HierarchyTypeItemProvider hierarchyTypeItemProvider;

  /**
   * This creates an adapter for a {@link net.sourceforge.mondrian.schema.Mondrian.HierarchyType}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Adapter createHierarchyTypeAdapter() {
    if (hierarchyTypeItemProvider == null) {
      hierarchyTypeItemProvider = new HierarchyTypeItemProvider(this);
    }

    return hierarchyTypeItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link net.sourceforge.mondrian.schema.Mondrian.JoinType} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected JoinTypeItemProvider joinTypeItemProvider;

  /**
   * This creates an adapter for a {@link net.sourceforge.mondrian.schema.Mondrian.JoinType}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Adapter createJoinTypeAdapter() {
    if (joinTypeItemProvider == null) {
      joinTypeItemProvider = new JoinTypeItemProvider(this);
    }

    return joinTypeItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link net.sourceforge.mondrian.schema.Mondrian.KeyExpressionType} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected KeyExpressionTypeItemProvider keyExpressionTypeItemProvider;

  /**
   * This creates an adapter for a {@link net.sourceforge.mondrian.schema.Mondrian.KeyExpressionType}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Adapter createKeyExpressionTypeAdapter() {
    if (keyExpressionTypeItemProvider == null) {
      keyExpressionTypeItemProvider = new KeyExpressionTypeItemProvider(this);
    }

    return keyExpressionTypeItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link net.sourceforge.mondrian.schema.Mondrian.LevelType} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected LevelTypeItemProvider levelTypeItemProvider;

  /**
   * This creates an adapter for a {@link net.sourceforge.mondrian.schema.Mondrian.LevelType}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Adapter createLevelTypeAdapter() {
    if (levelTypeItemProvider == null) {
      levelTypeItemProvider = new LevelTypeItemProvider(this);
    }

    return levelTypeItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link net.sourceforge.mondrian.schema.Mondrian.MeasureType} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected MeasureTypeItemProvider measureTypeItemProvider;

  /**
   * This creates an adapter for a {@link net.sourceforge.mondrian.schema.Mondrian.MeasureType}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Adapter createMeasureTypeAdapter() {
    if (measureTypeItemProvider == null) {
      measureTypeItemProvider = new MeasureTypeItemProvider(this);
    }

    return measureTypeItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link net.sourceforge.mondrian.schema.Mondrian.MemberGrantType} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected MemberGrantTypeItemProvider memberGrantTypeItemProvider;

  /**
   * This creates an adapter for a {@link net.sourceforge.mondrian.schema.Mondrian.MemberGrantType}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Adapter createMemberGrantTypeAdapter() {
    if (memberGrantTypeItemProvider == null) {
      memberGrantTypeItemProvider = new MemberGrantTypeItemProvider(this);
    }

    return memberGrantTypeItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link net.sourceforge.mondrian.schema.Mondrian.NameExpressionType} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected NameExpressionTypeItemProvider nameExpressionTypeItemProvider;

  /**
   * This creates an adapter for a {@link net.sourceforge.mondrian.schema.Mondrian.NameExpressionType}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Adapter createNameExpressionTypeAdapter() {
    if (nameExpressionTypeItemProvider == null) {
      nameExpressionTypeItemProvider = new NameExpressionTypeItemProvider(this);
    }

    return nameExpressionTypeItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link net.sourceforge.mondrian.schema.Mondrian.OrdinalExpressionType} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected OrdinalExpressionTypeItemProvider ordinalExpressionTypeItemProvider;

  /**
   * This creates an adapter for a {@link net.sourceforge.mondrian.schema.Mondrian.OrdinalExpressionType}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Adapter createOrdinalExpressionTypeAdapter() {
    if (ordinalExpressionTypeItemProvider == null) {
      ordinalExpressionTypeItemProvider = new OrdinalExpressionTypeItemProvider(this);
    }

    return ordinalExpressionTypeItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link net.sourceforge.mondrian.schema.Mondrian.ParameterType} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected ParameterTypeItemProvider parameterTypeItemProvider;

  /**
   * This creates an adapter for a {@link net.sourceforge.mondrian.schema.Mondrian.ParameterType}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Adapter createParameterTypeAdapter() {
    if (parameterTypeItemProvider == null) {
      parameterTypeItemProvider = new ParameterTypeItemProvider(this);
    }

    return parameterTypeItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link net.sourceforge.mondrian.schema.Mondrian.ParentExpressionType} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected ParentExpressionTypeItemProvider parentExpressionTypeItemProvider;

  /**
   * This creates an adapter for a {@link net.sourceforge.mondrian.schema.Mondrian.ParentExpressionType}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Adapter createParentExpressionTypeAdapter() {
    if (parentExpressionTypeItemProvider == null) {
      parentExpressionTypeItemProvider = new ParentExpressionTypeItemProvider(this);
    }

    return parentExpressionTypeItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link net.sourceforge.mondrian.schema.Mondrian.PropertyType} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected PropertyTypeItemProvider propertyTypeItemProvider;

  /**
   * This creates an adapter for a {@link net.sourceforge.mondrian.schema.Mondrian.PropertyType}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Adapter createPropertyTypeAdapter() {
    if (propertyTypeItemProvider == null) {
      propertyTypeItemProvider = new PropertyTypeItemProvider(this);
    }

    return propertyTypeItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link net.sourceforge.mondrian.schema.Mondrian.RoleType} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected RoleTypeItemProvider roleTypeItemProvider;

  /**
   * This creates an adapter for a {@link net.sourceforge.mondrian.schema.Mondrian.RoleType}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Adapter createRoleTypeAdapter() {
    if (roleTypeItemProvider == null) {
      roleTypeItemProvider = new RoleTypeItemProvider(this);
    }

    return roleTypeItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link net.sourceforge.mondrian.schema.Mondrian.SchemaGrantType} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected SchemaGrantTypeItemProvider schemaGrantTypeItemProvider;

  /**
   * This creates an adapter for a {@link net.sourceforge.mondrian.schema.Mondrian.SchemaGrantType}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Adapter createSchemaGrantTypeAdapter() {
    if (schemaGrantTypeItemProvider == null) {
      schemaGrantTypeItemProvider = new SchemaGrantTypeItemProvider(this);
    }

    return schemaGrantTypeItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link net.sourceforge.mondrian.schema.Mondrian.SchemaType} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected SchemaTypeItemProvider schemaTypeItemProvider;

  /**
   * This creates an adapter for a {@link net.sourceforge.mondrian.schema.Mondrian.SchemaType}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Adapter createSchemaTypeAdapter() {
    if (schemaTypeItemProvider == null) {
      schemaTypeItemProvider = new SchemaTypeItemProvider(this);
    }

    return schemaTypeItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link net.sourceforge.mondrian.schema.Mondrian.SQLType} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected SQLTypeItemProvider sqlTypeItemProvider;

  /**
   * This creates an adapter for a {@link net.sourceforge.mondrian.schema.Mondrian.SQLType}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Adapter createSQLTypeAdapter() {
    if (sqlTypeItemProvider == null) {
      sqlTypeItemProvider = new SQLTypeItemProvider(this);
    }

    return sqlTypeItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link net.sourceforge.mondrian.schema.Mondrian.TableType} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected TableTypeItemProvider tableTypeItemProvider;

  /**
   * This creates an adapter for a {@link net.sourceforge.mondrian.schema.Mondrian.TableType}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Adapter createTableTypeAdapter() {
    if (tableTypeItemProvider == null) {
      tableTypeItemProvider = new TableTypeItemProvider(this);
    }

    return tableTypeItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link net.sourceforge.mondrian.schema.Mondrian.ViewType} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected ViewTypeItemProvider viewTypeItemProvider;

  /**
   * This creates an adapter for a {@link net.sourceforge.mondrian.schema.Mondrian.ViewType}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Adapter createViewTypeAdapter() {
    if (viewTypeItemProvider == null) {
      viewTypeItemProvider = new ViewTypeItemProvider(this);
    }

    return viewTypeItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link net.sourceforge.mondrian.schema.Mondrian.VirtualCubeDimensionType} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected VirtualCubeDimensionTypeItemProvider virtualCubeDimensionTypeItemProvider;

  /**
   * This creates an adapter for a {@link net.sourceforge.mondrian.schema.Mondrian.VirtualCubeDimensionType}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Adapter createVirtualCubeDimensionTypeAdapter() {
    if (virtualCubeDimensionTypeItemProvider == null) {
      virtualCubeDimensionTypeItemProvider = new VirtualCubeDimensionTypeItemProvider(this);
    }

    return virtualCubeDimensionTypeItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link net.sourceforge.mondrian.schema.Mondrian.VirtualCubeMeasureType} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected VirtualCubeMeasureTypeItemProvider virtualCubeMeasureTypeItemProvider;

  /**
   * This creates an adapter for a {@link net.sourceforge.mondrian.schema.Mondrian.VirtualCubeMeasureType}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Adapter createVirtualCubeMeasureTypeAdapter() {
    if (virtualCubeMeasureTypeItemProvider == null) {
      virtualCubeMeasureTypeItemProvider = new VirtualCubeMeasureTypeItemProvider(this);
    }

    return virtualCubeMeasureTypeItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link net.sourceforge.mondrian.schema.Mondrian.VirtualCubeType} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected VirtualCubeTypeItemProvider virtualCubeTypeItemProvider;

  /**
   * This creates an adapter for a {@link net.sourceforge.mondrian.schema.Mondrian.VirtualCubeType}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Adapter createVirtualCubeTypeAdapter() {
    if (virtualCubeTypeItemProvider == null) {
      virtualCubeTypeItemProvider = new VirtualCubeTypeItemProvider(this);
    }

    return virtualCubeTypeItemProvider;
  }

  /**
   * This returns the root adapter factory that contains this factory.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public ComposeableAdapterFactory getRootAdapterFactory() {
    return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
  }

  /**
   * This sets the composed adapter factory that contains this factory.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
    this.parentAdapterFactory = parentAdapterFactory;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public boolean isFactoryForType(Object type) {
    return supportedTypes.contains(type) || super.isFactoryForType(type);
  }

  /**
   * This implementation substitutes the factory itself as the key for the adapter.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Adapter adapt(Notifier notifier, Object type) {
    return super.adapt(notifier, this);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Object adapt(Object object, Object type) {
    if (isFactoryForType(type)) {
      Object adapter = super.adapt(object, type);
      if (!(type instanceof Class) || (((Class)type).isInstance(adapter))) {
        return adapter;
      }
    }

    return null;
  }

  /**
   * This adds a listener.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void addListener(INotifyChangedListener notifyChangedListener) {
    changeNotifier.addListener(notifyChangedListener);
  }

  /**
   * This removes a listener.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void removeListener(INotifyChangedListener notifyChangedListener) {
    changeNotifier.removeListener(notifyChangedListener);
  }

  /**
   * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void fireNotifyChanged(Notification notification) {
    changeNotifier.fireNotifyChanged(notification);

    if (parentAdapterFactory != null) {
      parentAdapterFactory.fireNotifyChanged(notification);
    }
  }

}
