/*
 * ====================================================================
 * This software is subject to the terms of the Common Public License
 * Agreement, available at the following URL:
 *   http://www.opensource.org/licenses/cpl.html .
 * Copyright (C) 2003-2004 TONBELLER AG.
 * All Rights Reserved.
 * You must accept the terms of that agreement to use this software.
 * ====================================================================
 *
 * 
 */

package com.tonbeller.jpivot.xmla;

import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;

import com.tonbeller.jpivot.core.ExtensionSupport;
import com.tonbeller.jpivot.olap.mdxparse.Exp;
import com.tonbeller.jpivot.olap.mdxparse.FunCall;
import com.tonbeller.jpivot.olap.model.Axis;
import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.navi.PlaceHierarchiesOnAxes;
import com.tonbeller.jpivot.olap.query.Quax;
import com.tonbeller.jpivot.olap.query.QueryAdapter;

/**
 * XMLA Place Hierarchies
 */
public class XMLA_PlaceHierarchies extends ExtensionSupport implements PlaceHierarchiesOnAxes {

  private boolean expandAllMember = false;
  ArrayList aMemberSet = null;
  static Logger logger = Logger.getLogger(XMLA_PlaceHierarchies.class);

  /**
   * Constructor sets ID
   */
  public XMLA_PlaceHierarchies() {
    super.setId(PlaceHierarchiesOnAxes.ID);
  }

  /**
   * @see com.tonbeller.jpivot.olap.navi.PlaceHierarchiesOnAxes#createMemberExpression(Hierarchy)
   */
  public Object createMemberExpression(Hierarchy hier) {
    // if the query does not contain the hier,
    //  just return the highest level
    QueryAdapter.QueryAdapterHolder model = (QueryAdapter.QueryAdapterHolder) getModel();
    XMLA_QueryAdapter adapter = (XMLA_QueryAdapter) model.getQueryAdapter();

    // find the Quax for this hier
    Quax quax = adapter.findQuax(hier.getDimension());
    if (quax == null) {
      // the hierarchy was not found on any axis
      return XMLA_Util.topLevelMembers(hier, expandAllMember); // return top level members of the hierarchy
    }

    // the member expression is the list of members plus the list of FunCalls
    //  for this dimension 
    int iDimension = quax.dimIdx(hier.getDimension());
    return quax.genExpForDim(iDimension);
  }

  /**
   * @see com.tonbeller.jpivot.olap.navi.PlaceHierarchiesOnAxes#setQueryAxis(Axis, Object[])
   */
  public void setQueryAxis(Axis target, Object[] memberExpressions) {

    XMLA_Model model = (XMLA_Model) getModel();
    XMLA_QueryAdapter adapter = (XMLA_QueryAdapter) model.getQueryAdapter();

    // locate the appropriate query axis
    int iQuax = ((XMLA_Axis) target).getOrdinal();
    if (adapter.isSwapAxes())
      iQuax = (iQuax + 1) % 2;
    Quax quax = adapter.getQuaxes()[iQuax];

    int nDimension = memberExpressions.length;

    // if any of the member expressions is a memberlist from PlaceMembers
    //  we will have to reset sorting
    Object[] sets = new Object[nDimension];
    boolean changedMemberSet = false;
    for (int i = 0; i < nDimension; i++) {
      if (memberExpressions[i] instanceof List) {
        List memberList = (List) memberExpressions[i];
        Exp[] members = (Exp[]) memberList.toArray(new Exp[0]);
        if (members.length == 1)
          sets[i] = members[0];
        else
          sets[i] = new FunCall("{}", members, FunCall.TypeBraces);
        changedMemberSet = true;
      } else {
        // we already have an Exp generated by createMemberExpression
        sets[i] = memberExpressions[i];
      }
    }

    // generate the crossjoins
    quax.regeneratePosTree(sets, true);

    if (logger.isInfoEnabled()) {
      String changed = "";
      if (changedMemberSet)
        changed = " changed by navi";
      logger.info("setQueryAxis axis=" + quax.getOrdinal() + " nDimension=" + nDimension + changed);
      logger.info("Expression for Axis=" + quax.toString());
    }

    // tell listeners, that the axis was changed.
    quax.changed(this, changedMemberSet);

    model.fireModelChanged();
  }

  /**
   * @see PlaceHierarchiesOnAxes.setExpandAllMember
   */
  public void setExpandAllMember(boolean expandAllMember) {
    this.expandAllMember = expandAllMember;
  }

  /**
   * @see PlaceHierarchiesOnAxes.getExpandAllMember
   */
  public boolean getExpandAllMember() {
    return expandAllMember;
  }
  
} // End XMLA_PlaceHierarchies
