/*
// $Id: //open/mondrian/src/main/mondrian/gui/JDBCExplorer.java#4 $
// This software is subject to the terms of the Common Public License
// Agreement, available at the following URL:
// http://www.opensource.org/licenses/cpl.html.
// Copyright (C) 2002-2007 Julian Hyde and others
// All Rights Reserved.
// You must accept the terms of that agreement to use this software.
*/
package mondrian.gui;

import java.sql.Connection;

/**
 *
 * @author  sean
 * @version $Id: //open/mondrian/src/main/mondrian/gui/JDBCExplorer.java#4 $
 */
public class JDBCExplorer extends javax.swing.JPanel {
    Connection connection;
    JDBCTreeModel model;

    /** Creates new form JDBCExplorer */
    public JDBCExplorer() {
        initComponents();
    }

    public JDBCExplorer(Connection c) {
        this();
        setConnection(c);
    }

    public void setConnection(Connection c) {
        try {
            this.connection = c;

            model = new JDBCTreeModel(c);

            tree.setModel(model);
            //tree.addTreeSelectionListener(this);

        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jSplitPane1 = new javax.swing.JSplitPane();
        jScrollPane1 = new javax.swing.JScrollPane();
        tree = new javax.swing.JTree();
        jScrollPane2 = new javax.swing.JScrollPane();

        setLayout(new java.awt.BorderLayout());

        jSplitPane1.setDividerLocation(200);
        jScrollPane1.setViewportView(tree);

        jSplitPane1.setLeftComponent(jScrollPane1);

        jSplitPane1.setRightComponent(jScrollPane2);

        add(jSplitPane1, java.awt.BorderLayout.CENTER);

    }//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTree tree;
    private javax.swing.JSplitPane jSplitPane1;
    // End of variables declaration//GEN-END:variables

}

// End JDBCExplorer.java
