/*
// $Id: //open/mondrian/src/main/mondrian/calc/impl/DimensionCurrentMemberCalc.java#2 $
// This software is subject to the terms of the Common Public License
// Agreement, available at the following URL:
// http://www.opensource.org/licenses/cpl.html.
// Copyright (C) 2006-2006 Julian Hyde
// All Rights Reserved.
// You must accept the terms of that agreement to use this software.
*/
package mondrian.calc.impl;

import mondrian.olap.*;
import mondrian.olap.type.MemberType;
import mondrian.calc.impl.AbstractMemberCalc;
import mondrian.calc.DummyExp;
import mondrian.calc.Calc;

/**
 * Expression which returns the current member of a given dimension.
 *
 * @author jhyde
 * @version $Id: //open/mondrian/src/main/mondrian/calc/impl/DimensionCurrentMemberCalc.java#2 $
 * @since Sep 26, 2005
 */
public class DimensionCurrentMemberCalc extends AbstractMemberCalc {
    private final Dimension dimension;

    public DimensionCurrentMemberCalc(Dimension dimension) {
        super(
                new DummyExp(
                        MemberType.forHierarchy(dimension.getHierarchy())),
                new Calc[0]);
        this.dimension = dimension;
    }

    public Member evaluateMember(Evaluator evaluator) {
        return evaluator.getContext(dimension);
    }

    public boolean dependsOn(Dimension dimension) {
        return dimension == this.dimension;
    }
}

// End DimensionCurrentMemberCalc.java
