/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.xom;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import org.eigenbase.xom.AssertFailure;
import org.eigenbase.xom.DOMWrapper;
import org.eigenbase.xom.MetaDef;
import org.eigenbase.xom.Parser;
import org.eigenbase.xom.XOMException;
import org.eigenbase.xom.XOMUtil;

public class MetaGenerator {
    private MetaDef.Model model;
    private String prefix;
    private Hashtable keywordMap;
    private Hashtable typeMap;
    private Hashtable infoMap;
    private Hashtable subclassMap;
    private Vector allTypes;
    private boolean testMode;
    private static final String newLine = System.getProperty("line.separator");
    private static final char fileSep = System.getProperty("file.separator").charAt(0);
    static /* synthetic */ Class class$org$eigenbase$xom$MetaDef$Array;

    private static String getContentName(MetaDef.Content content) throws XOMException {
        if (content instanceof MetaDef.Object) {
            return ((MetaDef.Object)content).name;
        }
        if (content instanceof MetaDef.Array) {
            return ((MetaDef.Array)content).name;
        }
        throw new XOMException("Content of type " + content.getClass().getName() + " does not have a name.");
    }

    public TypeInfo getTypeInfo(String string, boolean bl) throws XOMException {
        TypeInfo typeInfo = (TypeInfo)this.infoMap.get(string);
        if (typeInfo == null && bl) {
            throw new XOMException("Type " + string + " does not exist.");
        }
        return typeInfo;
    }

    public MetaGenerator(String string, boolean bl) throws XOMException, IOException {
        this(string, bl, null);
    }

    protected MetaGenerator(String string, boolean bl, String string2) throws XOMException, IOException {
        Object object;
        this.testMode = bl;
        FileInputStream fileInputStream = new FileInputStream(string);
        Parser parser = XOMUtil.createDefaultParser();
        try {
            object = parser.parse(fileInputStream);
            this.model = new MetaDef.Model((DOMWrapper)object);
        }
        catch (XOMException xOMException) {
            throw new XOMException(xOMException, "Failed to parse XML file: " + string);
        }
        if (string2 != null) {
            if (this.model.className == null) {
                this.model.className = string2;
            } else {
                object = this.model.className;
                if (this.model.packageName != null && !this.model.packageName.equals("")) {
                    object = this.model.packageName + "." + this.model.className;
                }
                if (!string2.equals(object)) {
                    throw new XOMException("className parameter (" + string2 + ") is inconsistent with model's packageName and " + "className attributes (" + (String)object + ")");
                }
            }
        }
        this.prefix = this.model.prefix;
        if (this.prefix == null) {
            this.prefix = "";
        }
        this.initKeywordMap();
        this.initTypeMap();
        this.initSubclassMap();
    }

    private void initKeywordMap() {
        this.keywordMap = new Hashtable();
        this.keywordMap.put("abstract", "_abstract");
        this.keywordMap.put("boolean", "_boolean");
        this.keywordMap.put("break", "_break");
        this.keywordMap.put("byte", "_byte");
        this.keywordMap.put("case", "_case");
        this.keywordMap.put("catch", "_catch");
        this.keywordMap.put("char", "_char");
        this.keywordMap.put("class", "_class");
        this.keywordMap.put("const", "_const");
        this.keywordMap.put("continue", "_continue");
        this.keywordMap.put("default", "_default");
        this.keywordMap.put("do", "_do");
        this.keywordMap.put("double", "_double");
        this.keywordMap.put("else", "_else");
        this.keywordMap.put("extends", "_extends");
        this.keywordMap.put("final", "_final");
        this.keywordMap.put("finally", "_finally");
        this.keywordMap.put("float", "_float");
        this.keywordMap.put("for", "_for");
        this.keywordMap.put("if", "_if");
        this.keywordMap.put("implements", "_implements");
        this.keywordMap.put("import", "_import");
        this.keywordMap.put("instanceof", "_instanceof");
        this.keywordMap.put("int", "_int");
        this.keywordMap.put("interface", "_interface");
        this.keywordMap.put("long", "_long");
        this.keywordMap.put("native", "_native");
        this.keywordMap.put("new", "_new");
        this.keywordMap.put("goto", "_goto");
        this.keywordMap.put("package", "_package");
        this.keywordMap.put("private", "_private");
        this.keywordMap.put("protected", "_protected");
        this.keywordMap.put("public", "_public");
        this.keywordMap.put("return", "_return");
        this.keywordMap.put("short", "_short");
        this.keywordMap.put("static", "_static");
        this.keywordMap.put("super", "_super");
        this.keywordMap.put("switch", "_switch");
        this.keywordMap.put("synchronized", "_synchronized");
        this.keywordMap.put("this", "_this");
        this.keywordMap.put("throw", "_throw");
        this.keywordMap.put("throws", "_throws");
        this.keywordMap.put("transient", "_transient");
        this.keywordMap.put("try", "_try");
        this.keywordMap.put("void", "_void");
        this.keywordMap.put("volatile", "_volatile");
        this.keywordMap.put("while", "_while");
        this.keywordMap.put("true", "_true");
        this.keywordMap.put("false", "_false");
        this.keywordMap.put("null", "_null");
    }

    private void initTypeMap() throws XOMException {
        Object object;
        MetaDef.Definition definition;
        int n;
        this.typeMap = new Hashtable();
        this.allTypes = new Vector();
        for (n = 0; n < this.model.elements.length; ++n) {
            definition = this.model.elements[n];
            object = null;
            if (definition instanceof MetaDef.Element) {
                object = ((MetaDef.Element)definition).type;
            } else if (definition instanceof MetaDef.Plugin) {
                object = ((MetaDef.Plugin)definition).type;
            } else if (definition instanceof MetaDef.Class) {
                object = ((MetaDef.Class)definition)._class;
            } else if (definition instanceof MetaDef.StringElement) {
                object = ((MetaDef.StringElement)definition).type;
            } else if (definition instanceof MetaDef.Import) {
                object = ((MetaDef.Import)definition).type;
            } else {
                throw new XOMException("Illegal element type " + definition.getClass().getName());
            }
            this.typeMap.put(object, definition);
            this.allTypes.addElement(object);
        }
        this.infoMap = new Hashtable();
        for (n = 0; n < this.model.elements.length; ++n) {
            definition = this.model.elements[n];
            object = new TypeInfo(definition);
            this.infoMap.put(((TypeInfo)object).name, object);
        }
    }

    private void initSubclassMap() throws XOMException {
        MetaDef.FullDefinition fullDefinition;
        MetaDef.Definition definition;
        int n;
        this.subclassMap = new Hashtable();
        for (n = 0; n < this.model.elements.length; ++n) {
            definition = this.model.elements[n];
            if (!(definition instanceof MetaDef.Class)) continue;
            fullDefinition = (MetaDef.Class)definition;
            this.subclassMap.put(fullDefinition._class, new Vector());
        }
        for (n = 0; n < this.model.elements.length; ++n) {
            definition = this.model.elements[n];
            if (!(definition instanceof MetaDef.Element)) continue;
            fullDefinition = (MetaDef.Element)definition;
            TypeInfo typeInfo = this.getTypeInfo(((MetaDef.Element)fullDefinition).type, true);
            this.addToSubclassMap((MetaDef.Element)fullDefinition, typeInfo);
        }
    }

    private void addToSubclassMap(MetaDef.Element element, TypeInfo typeInfo) throws XOMException {
        while (typeInfo.superInfo != null) {
            Vector vector = (Vector)this.subclassMap.get(typeInfo.superInfo.name);
            if (vector == null) {
                throw new XOMException("Class " + typeInfo.superInfo.name + " of element " + element.type + " is not defined.");
            }
            vector.addElement(element);
            typeInfo = typeInfo.superInfo;
        }
    }

    public void writeFiles(String string, String string2) throws XOMException, IOException {
        if (string2 != null) {
            if (this.model.dtdName == null) {
                this.model.dtdName = string2;
            } else if (!string2.equals(this.model.dtdName)) {
                throw new XOMException("dtdFileName parameter (" + string2 + ") is inconsistent with model's dtdName " + "attribute (" + this.model.dtdName + ")");
            }
        }
        File file = new File(string);
        if (!this.testMode && this.model.packageName != null && !this.model.packageName.equals("")) {
            file = new File(file, this.model.packageName.replace('.', fileSep));
        }
        File file2 = new File(file, this.model.className + ".java");
        File file3 = file2.getParentFile();
        File file4 = new File(file3, this.model.dtdName);
        XOMUtil.discard(new MetaDef());
        file3.mkdir();
        FileWriter fileWriter = new FileWriter(file4);
        PrintWriter printWriter = new PrintWriter(fileWriter);
        FileWriter fileWriter2 = new FileWriter(file2);
        PrintWriter printWriter2 = new PrintWriter(fileWriter2);
        if (!this.testMode) {
            System.out.println("Writing " + file4);
        }
        this.writeDtd(printWriter);
        printWriter.flush();
        fileWriter.close();
        if (!this.testMode) {
            System.out.println("Writing " + file2);
        }
        this.writeJava(printWriter2);
        printWriter2.flush();
        fileWriter2.close();
        if (!this.testMode) {
            System.out.println("Done");
        }
    }

    public void writeDtd(PrintWriter printWriter) throws XOMException {
        int n;
        printWriter.println("<!--");
        printWriter.println("     This dtd file was automatically generated from XOM model " + this.model.name + ".");
        printWriter.println("     Do not edit this file by hand.");
        printWriter.println("  -->");
        printWriter.println();
        this.writeDtdDoc(printWriter, this.model.doc);
        for (n = 0; n < this.model.elements.length; ++n) {
            if (!(this.model.elements[n] instanceof MetaDef.Class)) continue;
            this.writeDtdEntity(printWriter, (MetaDef.Class)this.model.elements[n]);
        }
        for (n = 0; n < this.model.elements.length; ++n) {
            this.writeDtdElement(printWriter, this.model.elements[n]);
        }
    }

    public void writeJava(PrintWriter printWriter) throws XOMException {
        int n;
        printWriter.println("/*");
        printWriter.println("// This java file was automatically generated");
        printWriter.println("// from XOM model '" + this.model.name + "'");
        if (!this.testMode) {
            printWriter.println("// on " + new Date().toString());
        }
        printWriter.println("// Do not edit this file by hand.");
        printWriter.println("*/");
        printWriter.println();
        if (!this.testMode && this.model.packageName != null && !this.model.packageName.equals("")) {
            printWriter.println("package " + this.model.packageName + ";");
        }
        if (!this.testMode && this.model.importName != null && !this.model.importName.equals("")) {
            int n2 = this.model.importName.indexOf(":");
            n = 0;
            while (n2 != -1) {
                printWriter.println("import " + this.model.importName.substring(n, n2) + ";");
                n = n2 + 1;
                n2 = this.model.importName.indexOf(":", n);
            }
            printWriter.println("import " + this.model.importName.substring(n) + ";");
        }
        String string = newLine + "<p>This class was generated from XOM model '" + this.model.name + "' on " + new Date().toString();
        if (this.testMode) {
            string = "";
        }
        this.writeJavaDoc(printWriter, 0, this.model.doc + string);
        printWriter.println("public class " + this.model.className + " {");
        printWriter.println();
        printWriter.println("\tpublic static java.lang.Class getXMLDefClass()");
        printWriter.println("\t{");
        printWriter.println("\t\treturn " + this.model.className + ".class;");
        printWriter.println("\t}");
        printWriter.println();
        printWriter.println("\tpublic static String[] _elements = {");
        for (n = 0; n < this.allTypes.size(); ++n) {
            String string2 = (String)this.allTypes.elementAt(n);
            printWriter.print("\t\t\"" + string2 + "\"");
            if (n < this.allTypes.size() - 1) {
                printWriter.println(",");
                continue;
            }
            printWriter.println();
        }
        printWriter.println("\t};");
        printWriter.println();
        for (n = 0; n < this.model.elements.length; ++n) {
            this.writeJavaElement(printWriter, this.model.elements[n]);
        }
        printWriter.println();
        printWriter.println("}");
    }

    private void writeDtdEntity(PrintWriter printWriter, MetaDef.Class clazz) {
        if (clazz.doc != null) {
            this.writeDtdDoc(printWriter, clazz.doc);
        }
        Vector vector = (Vector)this.subclassMap.get(clazz._class);
        printWriter.print("<!ENTITY % " + clazz._class + " \"");
        if (vector == null) {
            throw new AssertFailure("Missing subclass vector for class " + clazz._class);
        }
        for (int i = 0; i < vector.size(); ++i) {
            MetaDef.Element element = (MetaDef.Element)vector.elementAt(i);
            if (element.dtdName != null) {
                printWriter.print(element.dtdName);
            } else {
                printWriter.print(this.prefix + element.type);
            }
            if (i >= vector.size() - 1) continue;
            printWriter.print("|");
        }
        printWriter.println("\">");
        printWriter.println();
    }

    private void writeDtdElement(PrintWriter printWriter, MetaDef.Definition definition) throws XOMException {
        if (definition instanceof MetaDef.Element) {
            int n;
            MetaDef.Element element = (MetaDef.Element)definition;
            TypeInfo typeInfo = this.getTypeInfo(element.type, false);
            if (typeInfo == null) {
                throw new AssertFailure("Element type " + element.type + " is missing from the " + "type map.");
            }
            if (element.doc != null) {
                this.writeDtdDoc(printWriter, element.doc);
            }
            printWriter.print("<!ELEMENT " + typeInfo.tagName + " ");
            if (typeInfo.allContent.length == 0 && !typeInfo.isAny && !typeInfo.isCData) {
                printWriter.print("EMPTY");
            } else if (typeInfo.isAny) {
                printWriter.print("ANY");
            } else if (typeInfo.isCData) {
                printWriter.print("(#PCDATA)");
            } else {
                printWriter.print("(");
                for (n = 0; n < typeInfo.allContent.length; ++n) {
                    this.writeDtdContent(printWriter, typeInfo.allContent[n]);
                    if (n >= typeInfo.allContent.length - 1) continue;
                    printWriter.print(",");
                }
                printWriter.print(")");
            }
            printWriter.println(">");
            if (typeInfo.allAttributes.length > 0) {
                printWriter.println("<!ATTLIST " + typeInfo.tagName);
                for (n = 0; n < typeInfo.allAttributes.length; ++n) {
                    this.writeDtdAttribute(printWriter, typeInfo.allAttributes[n]);
                }
                printWriter.println(">");
            }
            printWriter.println();
        } else if (!(definition instanceof MetaDef.Class)) {
            if (definition instanceof MetaDef.StringElement) {
                MetaDef.StringElement stringElement = (MetaDef.StringElement)definition;
                TypeInfo typeInfo = (TypeInfo)this.infoMap.get(stringElement.type);
                if (typeInfo == null) {
                    throw new AssertFailure("StringElement type " + stringElement.type + " is missing from the " + "type map.");
                }
                if (stringElement.doc != null) {
                    this.writeDtdDoc(printWriter, stringElement.doc);
                }
                printWriter.println("<!ELEMENT " + typeInfo.tagName + " (#PCDATA)>");
                printWriter.println();
            } else if (definition instanceof MetaDef.Plugin) {
                MetaDef.Plugin plugin = (MetaDef.Plugin)definition;
                TypeInfo typeInfo = (TypeInfo)this.infoMap.get(plugin.type);
                if (typeInfo == null) {
                    throw new AssertFailure("Plugin element " + plugin.type + " is missing from the " + "type map.");
                }
                if (plugin.doc != null) {
                    this.writeDtdDoc(printWriter, plugin.doc);
                }
                printWriter.println("<!ELEMENT " + typeInfo.tagName + " ANY>");
                printWriter.println("<!ATTLIST " + typeInfo.tagName);
                for (int i = 0; i < typeInfo.allAttributes.length; ++i) {
                    if (typeInfo.allAttributes[i].name.equals("defPackage") || typeInfo.allAttributes[i].name.equals("defClass")) {
                        throw new XOMException("The attribute \"" + typeInfo.allAttributes[i].name + "\" is reserved and may not be redefined in " + "or inherited by a Plugin.");
                    }
                    this.writeDtdAttribute(printWriter, typeInfo.allAttributes[i]);
                }
                printWriter.println("defPackage CDATA \"org.eigenbase.xom\"");
                printWriter.println("defClass CDATA #REQUIRED");
                printWriter.println(">");
                printWriter.println();
            } else if (definition instanceof MetaDef.Import) {
                MetaDef.Import import_ = (MetaDef.Import)definition;
                TypeInfo typeInfo = this.getTypeInfo(import_.type, true);
                printWriter.println("<!ELEMENT " + typeInfo.name + " ANY>");
                printWriter.println();
            } else {
                throw new XOMException("Unrecognized element type definition: " + definition.getClass().getName());
            }
        }
    }

    private void writeDtdDoc(PrintWriter printWriter, String string) {
        printWriter.println("<!--");
        try {
            String string2;
            LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(string));
            while ((string2 = lineNumberReader.readLine()) != null) {
                String string3 = string2.trim();
                if (string3.equals("")) continue;
                printWriter.print("     ");
                printWriter.println(string3);
            }
        }
        catch (IOException iOException) {
            throw new AssertFailure(iOException);
        }
        printWriter.println("  -->");
    }

    private void writeJavaDoc(PrintWriter printWriter, int n, String string) {
        for (int i = 0; i < n; ++i) {
            printWriter.print("\t");
        }
        printWriter.println("/**");
        try {
            String string2;
            LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(string));
            while ((string2 = lineNumberReader.readLine()) != null) {
                String string3 = string2.trim();
                if (string3.equals("")) continue;
                for (int i = 0; i < n; ++i) {
                    printWriter.print("\t");
                }
                printWriter.print(" * ");
                printWriter.println(string3);
            }
        }
        catch (IOException iOException) {
            throw new AssertFailure(iOException);
        }
        for (int i = 0; i < n; ++i) {
            printWriter.print("\t");
        }
        printWriter.println(" */");
    }

    private void writeJavaCode(PrintWriter printWriter, int n, String string) {
        for (int i = 0; i < n; ++i) {
            printWriter.print("\t");
        }
        printWriter.println("// BEGIN pass-through code block ---");
        try {
            String string2;
            LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(string));
            while ((string2 = lineNumberReader.readLine()) != null) {
                printWriter.println(string2);
            }
        }
        catch (IOException iOException) {
            throw new AssertFailure(iOException);
        }
        for (int i = 0; i < n; ++i) {
            printWriter.print("\t");
        }
        printWriter.println("// END pass-through code block ---");
    }

    private MetaDef.Definition getType(String string) throws XOMException {
        MetaDef.Definition definition = (MetaDef.Definition)this.typeMap.get(string);
        if (definition == null) {
            throw new XOMException("Element type name " + string + " was never " + "defined.");
        }
        return definition;
    }

    private String getDeclaredName(String string) {
        String string2 = (String)this.keywordMap.get(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    private void writeDtdContent(PrintWriter printWriter, MetaDef.Content content) throws XOMException {
        if (content instanceof MetaDef.Object) {
            MetaDef.Object object = (MetaDef.Object)content;
            TypeInfo typeInfo = (TypeInfo)this.infoMap.get(object.type);
            if (typeInfo == null) {
                throw new XOMException("Object " + object.name + " has undefined type " + object.type);
            }
            printWriter.print(typeInfo.tagName);
            if (!object.required.booleanValue()) {
                printWriter.print("?");
            }
        } else if (content instanceof MetaDef.Array) {
            MetaDef.Array array = (MetaDef.Array)content;
            TypeInfo typeInfo = (TypeInfo)this.infoMap.get(array.type);
            if (typeInfo == null) {
                throw new XOMException("Array " + array.name + " has undefined type " + array.type);
            }
            printWriter.print("(" + typeInfo.tagName + ")");
            if (array.min > 0) {
                printWriter.print("+");
            } else {
                printWriter.print("*");
            }
        } else {
            throw new XOMException("Unrecognized content type definition: " + content.getClass().getName());
        }
    }

    private void writeDtdAttribute(PrintWriter printWriter, MetaDef.Attribute attribute) {
        printWriter.print(attribute.name + " ");
        if (attribute.values == null || attribute.values.length == 0) {
            if (attribute.type.equalsIgnoreCase("Boolean")) {
                printWriter.print("(true|false) ");
            } else {
                printWriter.print("CDATA ");
            }
        } else {
            printWriter.print("(");
            for (int i = 0; i < attribute.values.length; ++i) {
                printWriter.print(attribute.values[i]);
                if (i >= attribute.values.length - 1) continue;
                printWriter.print("|");
            }
            printWriter.print(") ");
        }
        if (attribute._default == null) {
            if (attribute.required.booleanValue()) {
                printWriter.println("#REQUIRED");
            } else {
                printWriter.println("#IMPLIED");
            }
        } else {
            printWriter.print("\"" + attribute._default + "\"");
            printWriter.println();
        }
    }

    private static boolean hasContentType(MetaDef.Content[] contentArray, Class clazz) {
        for (int i = 0; i < contentArray.length; ++i) {
            if (contentArray[i].getClass() != clazz) continue;
            return true;
        }
        return false;
    }

    private void writeJavaElement(PrintWriter printWriter, MetaDef.Definition definition) throws XOMException {
        if (definition instanceof MetaDef.Element) {
            MetaDef.Element element = (MetaDef.Element)definition;
            TypeInfo typeInfo = (TypeInfo)this.infoMap.get(element.type);
            if (typeInfo == null) {
                throw new XOMException("Element type " + element.type + " was never defined.");
            }
            typeInfo.writeJavaClass(printWriter);
        } else if (definition instanceof MetaDef.Plugin) {
            MetaDef.Plugin plugin = (MetaDef.Plugin)definition;
            TypeInfo typeInfo = (TypeInfo)this.infoMap.get(plugin.type);
            if (typeInfo == null) {
                throw new XOMException("Plugin type " + plugin.type + " was never defined.");
            }
            typeInfo.writeJavaClass(printWriter);
        } else if (definition instanceof MetaDef.Class) {
            MetaDef.Class clazz = (MetaDef.Class)definition;
            TypeInfo typeInfo = (TypeInfo)this.infoMap.get(clazz._class);
            if (typeInfo == null) {
                throw new XOMException("Class type " + clazz._class + " was never defined.");
            }
            typeInfo.writeJavaClass(printWriter);
        } else if (definition instanceof MetaDef.StringElement) {
            MetaDef.StringElement stringElement = (MetaDef.StringElement)definition;
            if (stringElement.doc != null) {
                this.writeJavaDoc(printWriter, 1, stringElement.doc);
            }
            printWriter.println("\tpublic static final String " + stringElement.type + " = \"" + stringElement.type + "\";");
            printWriter.println();
        } else if (!(definition instanceof MetaDef.Import)) {
            throw new XOMException("Unrecognized element type definition: " + definition.getClass().getName());
        }
    }

    public void writeJavaGetAttribute(PrintWriter printWriter, MetaDef.Attribute attribute) throws XOMException {
        printWriter.print("\t\t\t\t" + this.getDeclaredName(attribute.name) + " = ");
        printWriter.print("(" + attribute.type + ")_parser.getAttribute(");
        printWriter.print("\"" + attribute.name + "\", \"" + attribute.type + "\", ");
        if (attribute._default == null) {
            printWriter.print("null, ");
        } else {
            printWriter.print("\"" + attribute._default + "\", ");
        }
        if (attribute.values == null || attribute.values.length == 0) {
            printWriter.print("null, ");
        } else {
            printWriter.print("_" + this.getDeclaredName(attribute.name) + "_values, ");
        }
        if (attribute.required.booleanValue()) {
            printWriter.print("true");
        } else {
            printWriter.print("false");
        }
        printWriter.println(");");
    }

    public void writeJavaDeclareAttribute(PrintWriter printWriter, MetaDef.Attribute attribute) throws XOMException {
        if (attribute.values != null && attribute.values.length > 0) {
            printWriter.println("\t\t/** Allowable values for {@link #" + this.getDeclaredName(attribute.name) + "}. */");
            printWriter.print("\t\tpublic static final String[] _" + this.getDeclaredName(attribute.name) + "_values = {");
            for (int i = 0; i < attribute.values.length; ++i) {
                printWriter.print("\"" + attribute.values[i] + "\"");
                if (i >= attribute.values.length - 1) continue;
                printWriter.print(", ");
            }
            printWriter.println("};");
        }
        printWriter.print("\t\tpublic " + attribute.type + " " + this.getDeclaredName(attribute.name) + ";  /" + "/ ");
        if (attribute._default != null) {
            printWriter.print("attribute default: " + attribute._default);
        } else if (attribute.required.booleanValue()) {
            printWriter.print("required attribute");
        } else {
            printWriter.print("optional attribute");
        }
        printWriter.println();
    }

    public void writeJavaDisplayAttribute(PrintWriter printWriter, MetaDef.Attribute attribute) throws XOMException {
        printWriter.println("\t\t\tdisplayAttribute(_out, \"" + attribute.name + "\", " + this.getDeclaredName(attribute.name) + ", _indent+1);");
    }

    public void writeJavaDisplayXMLAttribute(PrintWriter printWriter, MetaDef.Attribute attribute) throws XOMException {
        printWriter.println("\t\t\t\t.add(\"" + attribute.name + "\", " + this.getDeclaredName(attribute.name) + ")");
    }

    public void writeJavaDisplayDiffAttribute(PrintWriter printWriter, MetaDef.Attribute attribute) throws XOMException {
        printWriter.println("\t\t\t_diff = _diff && displayAttributeDiff(\"" + attribute.name + "\", " + this.getDeclaredName(attribute.name) + ", _cother." + this.getDeclaredName(attribute.name) + ", _out, _indent+1);");
    }

    public void writeJavaGetContent(PrintWriter printWriter, MetaDef.Content content) throws XOMException {
        if (content instanceof MetaDef.Object) {
            MetaDef.Object object = (MetaDef.Object)content;
            MetaDef.Definition definition = this.getType(object.type);
            TypeInfo typeInfo = this.getTypeInfo(object.type, true);
            printWriter.print("\t\t\t\t" + this.getDeclaredName(object.name) + " = ");
            if (definition != null && definition instanceof MetaDef.Import) {
                typeInfo = this.getTypeInfo(((MetaDef.Import)definition).type, true);
                printWriter.print("(" + typeInfo.impName + ")_parser.getElement(");
                printWriter.print(typeInfo.impName + ".class, ");
            } else if (definition != null && definition instanceof MetaDef.StringElement) {
                printWriter.print("_parser.getString(" + typeInfo.className + ", ");
            } else {
                printWriter.print("(" + typeInfo.className + ")_parser.getElement(");
                printWriter.print(typeInfo.className + ".class, ");
            }
            if (object.required.booleanValue()) {
                printWriter.print("true");
            } else {
                printWriter.print("false");
            }
            printWriter.println(");");
        } else if (content instanceof MetaDef.Array) {
            MetaDef.Array array = (MetaDef.Array)content;
            MetaDef.Definition definition = this.getType(array.type);
            String string = this.getTypeInfo((String)array.type, (boolean)true).className;
            if (definition instanceof MetaDef.Import) {
                TypeInfo typeInfo = this.getTypeInfo(((MetaDef.Import)definition).type, true);
                printWriter.print("\t\t\t\t_tempArray = _parser.getArray(");
                printWriter.print(typeInfo.impName + ".class, ");
                printWriter.println(array.min + ", " + array.max + ");");
                printWriter.println("\t\t\t\t" + this.getDeclaredName(array.name) + " = new " + typeInfo.impName + "[_tempArray.length];");
                printWriter.println("\t\t\t\tfor(int _i=0; _i<" + this.getDeclaredName(array.name) + ".length; _i++)");
                printWriter.println("\t\t\t\t\t" + this.getDeclaredName(array.name) + "[_i] = " + "(" + string + ")_tempArray[_i];");
            } else if (definition instanceof MetaDef.StringElement) {
                printWriter.print("\t\t\t\t" + this.getDeclaredName(array.name) + " = _parser.getStringArray(");
                printWriter.println("\"" + string + "\", " + array.min + ", " + array.max + ");");
            } else {
                printWriter.print("\t\t\t\t_tempArray = _parser.getArray(");
                printWriter.print(string + ".class, ");
                printWriter.println(array.min + ", " + array.max + ");");
                printWriter.println("\t\t\t\t" + this.getDeclaredName(array.name) + " = new " + string + "[_tempArray.length];");
                printWriter.println("\t\t\t\tfor(int _i=0; _i<" + this.getDeclaredName(array.name) + ".length; _i++)");
                printWriter.println("\t\t\t\t\t" + this.getDeclaredName(array.name) + "[_i] = " + "(" + string + ")_tempArray[_i];");
            }
        } else {
            throw new XOMException("Unrecognized content type definition: " + content.getClass().getName());
        }
    }

    public void writeJavaGetAnyContent(PrintWriter printWriter, boolean bl) {
        if (bl) {
            printWriter.println("\t\t\t\tchildren = getMixedChildren(_def, " + this.model.className + ".class, " + "\"" + this.prefix + "\");");
        } else {
            printWriter.println("\t\t\t\tchildren = getElementChildren(_def, " + this.model.className + ".class, " + "\"" + this.prefix + "\");");
        }
    }

    public void writeJavaGetCDataContent(PrintWriter printWriter) {
        printWriter.println("\t\t\t\tcdata = _parser.getText();");
    }

    public void writeJavaDeclareContent(PrintWriter printWriter, MetaDef.Content content) throws XOMException {
        if (content instanceof MetaDef.Object) {
            MetaDef.Object object = (MetaDef.Object)content;
            if (object.doc != null) {
                this.writeJavaDoc(printWriter, 2, object.doc);
            }
            MetaDef.Definition definition = this.getType(object.type);
            String string = this.getTypeInfo((String)object.type, (boolean)true).className;
            if (definition instanceof MetaDef.Import) {
                TypeInfo typeInfo = this.getTypeInfo(((MetaDef.Import)definition).type, true);
                string = typeInfo.impName;
                printWriter.print("\t\tpublic " + string + " " + this.getDeclaredName(object.name) + ";  /" + "/");
            } else if (definition instanceof MetaDef.StringElement) {
                printWriter.print("\t\tpublic String " + this.getDeclaredName(object.name) + ";  /" + "/");
            } else {
                printWriter.print("\t\tpublic " + string + " " + this.getDeclaredName(object.name) + ";  /" + "/");
            }
            if (object.required.booleanValue()) {
                printWriter.println("required element");
            } else {
                printWriter.println("optional element");
            }
        } else if (content instanceof MetaDef.Array) {
            MetaDef.Array array = (MetaDef.Array)content;
            if (array.doc != null) {
                this.writeJavaDoc(printWriter, 2, array.doc);
            }
            MetaDef.Definition definition = this.getType(array.type);
            String string = this.getTypeInfo((String)array.type, (boolean)true).className;
            if (definition instanceof MetaDef.Import) {
                TypeInfo typeInfo = this.getTypeInfo(((MetaDef.Import)definition).type, true);
                string = typeInfo.impName;
                printWriter.print("\t\tpublic " + string + "[] " + this.getDeclaredName(array.name) + ";  /" + "/");
            } else if (definition instanceof MetaDef.StringElement) {
                printWriter.print("\t\tpublic String[] " + this.getDeclaredName(array.name) + ";  /" + "/");
            } else {
                printWriter.print("\t\tpublic " + string + "[] " + this.getDeclaredName(array.name) + ";  /" + "/");
            }
            if (array.min <= 0 && array.max <= 0) {
                printWriter.println("optional array");
            } else {
                if (array.min > 0) {
                    printWriter.print("min " + array.min);
                }
                if (array.max > 0) {
                    printWriter.print("max " + array.max);
                }
                printWriter.println();
            }
        } else {
            throw new XOMException("Unrecognized content type definition: " + content.getClass().getName());
        }
    }

    public void writeJavaDeclareAnyContent(PrintWriter printWriter, boolean bl) {
        printWriter.println("\t\tpublic org.eigenbase.xom." + (bl ? "NodeDef" : "ElementDef") + "[] children;  /" + "/holder for variable-type children");
        printWriter.println("\t\t// implement Any");
        printWriter.println("\t\tpublic org.eigenbase.xom.NodeDef[] getChildren()");
        printWriter.println("\t\t{");
        printWriter.println("\t\t\treturn children;");
        printWriter.println("\t\t}");
        printWriter.println("\t\t// implement Any");
        printWriter.println("\t\tpublic void setChildren(org.eigenbase.xom.NodeDef[] children)");
        printWriter.println("\t\t{");
        printWriter.println("\t\t\tthis.children = " + (bl ? "" : "(org.eigenbase.xom.ElementDef[]) ") + "children;");
        printWriter.println("\t\t}");
    }

    public void writeJavaDeclareCDataContent(PrintWriter printWriter) {
        printWriter.print("\t\tpublic String cdata;  // All text goes here");
    }

    public void writeJavaDisplayContent(PrintWriter printWriter, MetaDef.Content content) throws XOMException {
        if (content instanceof MetaDef.Object) {
            MetaDef.Object object = (MetaDef.Object)content;
            MetaDef.Definition definition = this.getType(object.type);
            if (definition instanceof MetaDef.StringElement) {
                printWriter.println("\t\t\tdisplayString(_out, \"" + object.name + "\", " + this.getDeclaredName(object.name) + ", _indent+1);");
            } else {
                printWriter.println("\t\t\tdisplayElement(_out, \"" + object.name + "\", " + this.getDeclaredName(object.name) + ", _indent+1);");
            }
        } else if (content instanceof MetaDef.Array) {
            MetaDef.Array array = (MetaDef.Array)content;
            MetaDef.Definition definition = this.getType(array.type);
            if (definition instanceof MetaDef.StringElement) {
                printWriter.println("\t\t\tdisplayStringArray(_out, \"" + array.name + "\", " + this.getDeclaredName(array.name) + ", _indent+1);");
            } else {
                printWriter.println("\t\t\tdisplayElementArray(_out, \"" + array.name + "\", " + this.getDeclaredName(array.name) + ", _indent+1);");
            }
        } else {
            throw new XOMException("Unrecognized content type definition: " + content.getClass().getName());
        }
    }

    public void writeJavaDisplayAnyContent(PrintWriter printWriter) {
        printWriter.println("\t\t\tdisplayElementArray(_out, \"children\", children, _indent+1);");
    }

    public void writeJavaDisplayCDataContent(PrintWriter printWriter) {
        printWriter.println("\t\t\tdisplayString(_out, \"cdata\", cdata, _indent+1);");
    }

    public void writeJavaDisplayXMLContent(PrintWriter printWriter, MetaDef.Content content) throws XOMException {
        if (content instanceof MetaDef.Object) {
            MetaDef.Object object = (MetaDef.Object)content;
            MetaDef.Definition definition = this.getType(object.type);
            if (definition instanceof MetaDef.StringElement) {
                printWriter.println("\t\t\tdisplayXMLString(_out, \"" + this.getTypeInfo((String)object.type, (boolean)true).tagName + "\", " + this.getDeclaredName(object.name) + ");");
            } else {
                printWriter.println("\t\t\tdisplayXMLElement(_out, " + this.getDeclaredName(object.name) + ");");
            }
        } else if (content instanceof MetaDef.Array) {
            MetaDef.Array array = (MetaDef.Array)content;
            MetaDef.Definition definition = this.getType(array.type);
            if (definition instanceof MetaDef.StringElement) {
                printWriter.println("\t\t\tdisplayXMLStringArray(_out, \"" + this.getTypeInfo((String)array.type, (boolean)true).tagName + "\", " + this.getDeclaredName(array.name) + ");");
            } else {
                printWriter.println("\t\t\tdisplayXMLElementArray(_out, " + this.getDeclaredName(array.name) + ");");
            }
        } else if (content instanceof MetaDef.Any) {
            printWriter.println("\t\t\tdisplayXMLElementArray(_out, children);");
        } else if (content instanceof MetaDef.CData) {
            printWriter.println("\t\t\t_out.cdata(cdata);");
        } else {
            throw new XOMException("Unrecognized content type definition: " + content.getClass().getName());
        }
    }

    public void writeJavaDisplayXMLAnyContent(PrintWriter printWriter) {
        printWriter.println("\t\t\tdisplayXMLElementArray(_out, children);");
    }

    public void writeJavaDisplayXMLCDataContent(PrintWriter printWriter) {
        printWriter.println("\t\t\t_out.cdata(cdata);");
    }

    public void writeJavaDisplayDiffContent(PrintWriter printWriter, MetaDef.Content content) throws XOMException {
        if (content instanceof MetaDef.Object) {
            MetaDef.Object object = (MetaDef.Object)content;
            MetaDef.Definition definition = this.getType(object.type);
            if (definition instanceof MetaDef.StringElement) {
                printWriter.println("\t\t\t_diff = _diff && displayStringDiff(\"" + object.name + "\", " + this.getDeclaredName(object.name) + ", " + "_cother." + this.getDeclaredName(object.name) + ", " + "_out, _indent+1);");
            } else {
                printWriter.println("\t\t\t_diff = _diff && displayElementDiff(\"" + object.name + "\", " + this.getDeclaredName(object.name) + ", " + "_cother." + this.getDeclaredName(object.name) + ", " + "_out, _indent+1);");
            }
        } else if (content instanceof MetaDef.Array) {
            MetaDef.Array array = (MetaDef.Array)content;
            MetaDef.Definition definition = this.getType(array.type);
            if (definition instanceof MetaDef.StringElement) {
                printWriter.println("\t\t\t_diff = _diff && displayStringArrayDiff(\"" + array.name + "\", " + this.getDeclaredName(array.name) + ", " + "_cother." + this.getDeclaredName(array.name) + ", " + "_out, _indent+1);");
            } else {
                printWriter.println("\t\t\t_diff = _diff && displayElementArrayDiff(\"" + array.name + "\", " + this.getDeclaredName(array.name) + ", " + "_cother." + this.getDeclaredName(array.name) + ", " + "_out, _indent+1);");
            }
        } else {
            throw new XOMException("Unrecognized content type definition: " + content.getClass().getName());
        }
    }

    public void writeJavaDisplayDiffAnyContent(PrintWriter printWriter) {
        printWriter.println("\t\t\t_diff = _diff && displayElementArrayDiff(\"children\", children, _cother.children, _out, _indent+1);");
    }

    public void writeJavaDisplayDiffCDataContent(PrintWriter printWriter) {
        printWriter.println("\t\t\t_diff = _diff && displayStringDiff(\"cdata\", cdata, _cother.cdata, _out, _indent+1);");
    }

    public void writeJavaDeclarePluginAttributes(PrintWriter printWriter) {
        this.writeJavaDoc(printWriter, 2, "defPackage is a built-in attribute defining the package of the plugin class.");
        printWriter.println("\t\tpublic String defPackage;");
        printWriter.println();
        this.writeJavaDoc(printWriter, 2, "defClass is a built-in attribute definition the plugin parser class.");
        printWriter.println("\t\tpublic String defClass;");
        printWriter.println();
    }

    public void writeJavaDisplayPluginAttributes(PrintWriter printWriter) {
        printWriter.println("\t\t\tdisplayAttribute(_out, \"defPackage\", defPackage, _indent+1);");
        printWriter.println("\t\t\tdisplayAttribute(_out, \"defClass\", defClass, _indent+1);");
    }

    public void writeJavaDisplayXMLPluginAttributes(PrintWriter printWriter) {
        printWriter.println("\t\t\t\t.add(\"defPackage\", defPackage)");
        printWriter.println("\t\t\t\t.add(\"defClass\", defClass)");
    }

    public void writeJavaDisplayDiffPluginAttributes(PrintWriter printWriter) {
        printWriter.println("\t\t\t_diff = _diff && displayAttributeDiff(\"defPackage\", defPackage, _cother.defPackage, _out, _indent+1);");
        printWriter.println("\t\t\t_diff = _diff && displayAttributeDiff(\"defClass\", defClass, _cother.defClass, _out, _indent+1);");
    }

    public void writeJavaGetPluginContent(PrintWriter printWriter, boolean bl) {
        if (bl) {
            printWriter.println("\t\t\t\tchildren = getMixedChildren(_def, _pluginClass, \"\");");
        } else {
            printWriter.println("\t\t\t\tchildren = getElementChildren(_def, _pluginClass, \"\");");
        }
    }

    public void writeJavaDeclarePluginContent(PrintWriter printWriter, boolean bl) {
        printWriter.println("\t\tpublic org.eigenbase.xom." + (bl ? "NodeDef" : "ElementDef") + "[] children;  /" + "/holder for variable-type children");
    }

    public void writeJavaDisplayPluginContent(PrintWriter printWriter) {
        printWriter.println("\t\t\tdisplayElementArray(_out, \"children\", children, _indent+1);");
    }

    public void writeJavaDisplayXMLPluginContent(PrintWriter printWriter) {
        printWriter.println("\t\t\tdisplayXMLElementArray(_out, children);");
    }

    public void writeJavaDisplayDiffPluginContent(PrintWriter printWriter) {
        printWriter.println("\t\t\t_diff = _diff && displayElementArrayDiff(\"children\", children, _cother.children, _out, _indent+1);");
    }

    public void writeOutputs() {
        if (this.testMode) {
            System.out.println(this.model.dtdName + " " + this.model.className);
        }
    }

    public static void main(String[] stringArray) {
        int n = 0;
        boolean bl = false;
        if (n < stringArray.length && stringArray[n].equals("-debug")) {
            System.err.println("MetaGenerator pausing for debugging.  Attach your debugger and press return.");
            try {
                System.in.read();
                ++n;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (n < stringArray.length && stringArray[n].equals("-test")) {
            System.err.println("Ignoring package name.");
            bl = true;
            ++n;
        }
        if (stringArray.length != 2 + n) {
            System.err.println("Usage: java MetaGenerator [-debug] [-test] <XML model file> <output directory>");
            System.exit(2);
        }
        try {
            MetaGenerator metaGenerator = new MetaGenerator(stringArray[0 + n], bl);
            metaGenerator.writeFiles(stringArray[1 + n], null);
            metaGenerator.writeOutputs();
        }
        catch (XOMException xOMException) {
            System.err.println("Generation of model failed:");
            System.err.println(xOMException.toString());
            xOMException.printStackTrace();
            System.exit(1);
        }
        catch (IOException iOException) {
            System.err.println("Generation of model failed:");
            System.err.println(iOException.toString());
            iOException.printStackTrace();
            System.exit(1);
        }
    }

    public void debugDisplay() {
        System.out.println("Model:");
        System.out.println(this.model.toString());
    }

    private class TypeInfo {
        public MetaDef.Definition def;
        public String doc;
        public String code;
        public String name;
        public String className;
        public String tagName;
        public MetaDef.Attribute[] allAttributes;
        public MetaDef.Attribute[] ovrAttributes;
        public MetaDef.Attribute[] newAttributes;
        public MetaDef.Content[] allContent;
        public MetaDef.Content[] newContent;
        public boolean isAny;
        public boolean isCData;
        public TypeInfo superInfo;
        public Class impClass;
        public String impName;
        public String contentModel;

        public TypeInfo(MetaDef.Definition definition) throws XOMException {
            MetaDef.Definition definition2;
            this.def = definition;
            this.name = null;
            String string = null;
            MetaDef.Attribute[] attributeArray = null;
            MetaDef.Content[] contentArray = null;
            this.contentModel = "sequential";
            if (definition instanceof MetaDef.Element) {
                definition2 = (MetaDef.Element)definition;
                this.name = definition2.type;
                this.tagName = definition2.dtdName != null ? definition2.dtdName : MetaGenerator.this.prefix + this.name;
                string = definition2._class;
                attributeArray = definition2.attributes;
                contentArray = definition2.content;
                this.contentModel = definition2.contentModel;
                this.doc = definition2.doc;
                this.code = definition2.code;
                this.impClass = null;
                this.impName = null;
            } else if (definition instanceof MetaDef.Plugin) {
                this.name = ((MetaDef.Plugin)definition).type;
                this.tagName = MetaGenerator.this.prefix + this.name;
                string = ((MetaDef.Plugin)definition)._class;
                attributeArray = ((MetaDef.Plugin)definition).attributes;
                contentArray = new MetaDef.Content[]{};
                this.doc = ((MetaDef.Plugin)definition).doc;
                this.code = ((MetaDef.Plugin)definition).code;
                this.impClass = null;
                this.impName = null;
            } else if (definition instanceof MetaDef.Class) {
                this.name = ((MetaDef.Class)definition)._class;
                this.tagName = "(%" + this.name + ";)";
                string = ((MetaDef.Class)definition).superclass;
                attributeArray = ((MetaDef.Class)definition).attributes;
                contentArray = ((MetaDef.Class)definition).content;
                this.doc = ((MetaDef.Class)definition).doc;
                this.code = ((MetaDef.Class)definition).code;
                this.impClass = null;
                this.impName = null;
            } else if (definition instanceof MetaDef.StringElement) {
                this.name = ((MetaDef.StringElement)definition).type;
                this.tagName = MetaGenerator.this.prefix + this.name;
                string = null;
                attributeArray = new MetaDef.Attribute[]{};
                contentArray = new MetaDef.Content[]{};
                this.doc = ((MetaDef.StringElement)definition).doc;
                this.code = null;
                this.impClass = null;
                this.impName = null;
            } else if (definition instanceof MetaDef.Import) {
                definition2 = (MetaDef.Import)definition;
                this.name = ((MetaDef.Import)definition2).type;
                this.tagName = ((MetaDef.Import)definition2).dtdName != null ? ((MetaDef.Import)definition2).dtdName : MetaGenerator.this.prefix + this.name;
                string = null;
                attributeArray = new MetaDef.Attribute[]{};
                contentArray = new MetaDef.Content[]{};
                this.doc = null;
                this.code = null;
                try {
                    this.impName = ((MetaDef.Import)definition2).defPackage + "." + ((MetaDef.Import)definition2).defClass + "." + this.name;
                    this.impClass = Class.forName(((MetaDef.Import)definition2).defPackage + "." + ((MetaDef.Import)definition2).defClass + "$" + this.name);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            } else {
                throw new XOMException("Illegal element type " + definition.getClass().getName());
            }
            this.className = XOMUtil.capitalize(this.name);
            this.superInfo = null;
            if (string != null) {
                this.superInfo = (TypeInfo)MetaGenerator.this.infoMap.get(string);
                if (this.superInfo == null) {
                    definition2 = (MetaDef.Definition)MetaGenerator.this.infoMap.get(string);
                    if (definition2 == null) {
                        throw new XOMException("Parent class " + string + " of element " + this.name + " was never defined.");
                    }
                    this.superInfo = new TypeInfo(definition2);
                }
            }
            boolean bl = false;
            boolean bl2 = false;
            if (contentArray.length == 1) {
                if (contentArray[0] instanceof MetaDef.CData) {
                    bl2 = true;
                } else if (contentArray[0] instanceof MetaDef.Any) {
                    bl = true;
                }
            }
            if (!bl && !bl2) {
                for (int i = 0; i < contentArray.length; ++i) {
                    if (!(contentArray[i] instanceof MetaDef.CData) && !(contentArray[i] instanceof MetaDef.Any)) continue;
                    throw new XOMException("Type " + this.name + " defines <Any> or <CData> " + "content as well as other content.");
                }
            }
            if (this.superInfo == null) {
                this.allAttributes = attributeArray;
                this.ovrAttributes = new MetaDef.Attribute[0];
                this.newAttributes = this.allAttributes;
                if (bl || bl2) {
                    this.isAny = bl;
                    this.isCData = bl2;
                    this.allContent = new MetaDef.Content[0];
                } else {
                    this.isCData = false;
                    this.isAny = false;
                    this.allContent = contentArray;
                }
                this.newContent = this.allContent;
            } else {
                Cloneable cloneable;
                int n;
                Hashtable<String, MetaDef.Attribute> hashtable = new Hashtable<String, MetaDef.Attribute>();
                Hashtable<String, MetaDef.Attribute> hashtable2 = new Hashtable<String, MetaDef.Attribute>();
                Vector<MetaDef.Attribute> vector = new Vector<MetaDef.Attribute>();
                Vector<MetaDef.Attribute> vector2 = new Vector<MetaDef.Attribute>();
                Vector<MetaDef.Attribute> vector3 = new Vector<MetaDef.Attribute>();
                for (n = 0; n < this.superInfo.allAttributes.length; ++n) {
                    hashtable.put(this.superInfo.allAttributes[n].name, this.superInfo.allAttributes[n]);
                }
                for (n = 0; n < attributeArray.length; ++n) {
                    cloneable = (MetaDef.Attribute)hashtable.get(attributeArray[n].name);
                    if (cloneable == null) {
                        vector.addElement(attributeArray[n]);
                        vector3.addElement(attributeArray[n]);
                        continue;
                    }
                    if (!attributeArray[n].type.equals(((MetaDef.Attribute)cloneable).type)) {
                        throw new XOMException("Element " + this.name + " inherits attribute " + ((MetaDef.Attribute)cloneable).name + " of type " + ((MetaDef.Attribute)cloneable).type + " but redefines it to be of type " + attributeArray[n].type);
                    }
                    vector2.addElement(attributeArray[n]);
                    hashtable2.put(attributeArray[n].name, attributeArray[n]);
                }
                for (n = 0; n < this.superInfo.allAttributes.length; ++n) {
                    if (hashtable2.get(this.superInfo.allAttributes[n].name) != null) continue;
                    vector.addElement(this.superInfo.allAttributes[n]);
                }
                for (n = 0; n < vector2.size(); ++n) {
                    vector.addElement((MetaDef.Attribute)vector2.elementAt(n));
                }
                this.allAttributes = new MetaDef.Attribute[vector.size()];
                for (n = 0; n < this.allAttributes.length; ++n) {
                    this.allAttributes[n] = (MetaDef.Attribute)vector.elementAt(n);
                }
                this.ovrAttributes = new MetaDef.Attribute[vector2.size()];
                for (n = 0; n < this.ovrAttributes.length; ++n) {
                    this.ovrAttributes[n] = (MetaDef.Attribute)vector2.elementAt(n);
                }
                this.newAttributes = new MetaDef.Attribute[vector3.size()];
                for (n = 0; n < this.newAttributes.length; ++n) {
                    this.newAttributes[n] = (MetaDef.Attribute)vector3.elementAt(n);
                }
                if (bl || bl2) {
                    if (this.superInfo.isAny || this.superInfo.isCData) {
                        throw new XOMException("Element " + this.name + " both defines and inherits " + "<CData> or <Any> content.");
                    }
                    if (this.superInfo.allContent.length > 0) {
                        throw new XOMException("Element " + this.name + " inherits standard content " + "but defines <CData> or <Any> content.");
                    }
                    this.isAny = bl;
                    this.isCData = bl2;
                    this.allContent = new MetaDef.Content[0];
                    this.newContent = new MetaDef.Content[0];
                } else if (this.superInfo.isAny || this.superInfo.isCData) {
                    if (contentArray.length > 0) {
                        throw new XOMException("Element " + this.name + " inherits <CData> or <Any> " + "content but defines standard content.");
                    }
                    this.isAny = this.superInfo.isAny;
                    this.isCData = this.superInfo.isCData;
                    this.allContent = new MetaDef.Content[0];
                    this.newContent = new MetaDef.Content[0];
                } else {
                    int n2;
                    this.isCData = false;
                    this.isAny = false;
                    Hashtable<String, MetaDef.Content> hashtable3 = new Hashtable<String, MetaDef.Content>();
                    cloneable = new Vector();
                    for (n2 = 0; n2 < this.superInfo.allContent.length; ++n2) {
                        hashtable3.put(MetaGenerator.getContentName(this.superInfo.allContent[n2]), this.superInfo.allContent[n2]);
                        ((Vector)cloneable).addElement(this.superInfo.allContent[n2]);
                    }
                    for (n2 = 0; n2 < contentArray.length; ++n2) {
                        MetaDef.Content content = (MetaDef.Content)hashtable3.get(MetaGenerator.getContentName(contentArray[n2]));
                        if (content != null) {
                            throw new XOMException("Content named " + MetaGenerator.getContentName(contentArray[n2]) + " defined in element " + this.name + " was " + "already defined in an inherited element.");
                        }
                        ((Vector)cloneable).addElement(contentArray[n2]);
                    }
                    this.allContent = new MetaDef.Content[((Vector)cloneable).size()];
                    for (n2 = 0; n2 < this.allContent.length; ++n2) {
                        this.allContent[n2] = (MetaDef.Content)((Vector)cloneable).elementAt(n2);
                    }
                    this.newContent = contentArray;
                }
            }
            if (MetaGenerator.this.infoMap.get(this.name) == null) {
                MetaGenerator.this.infoMap.put(this.name, this);
            }
        }

        public void writeJavaClass(PrintWriter printWriter) throws XOMException {
            int n;
            if (this.doc != null) {
                MetaGenerator.this.writeJavaDoc(printWriter, 1, this.doc);
            }
            String string = this.def instanceof MetaDef.Class ? "abstract " : "";
            printWriter.print("\tpublic static " + string + "class " + this.className + " extends ");
            if (this.superInfo == null) {
                printWriter.println("org.eigenbase.xom.ElementDef");
            } else {
                printWriter.println(this.superInfo.className);
            }
            if (this.isAny) {
                printWriter.println("\t\timplements org.eigenbase.xom.Any");
            }
            printWriter.println("\t{");
            printWriter.println("\t\tpublic " + this.className + "()");
            printWriter.println("\t\t{");
            printWriter.println("\t\t}");
            printWriter.println();
            printWriter.println("\t\tpublic " + this.className + "(org.eigenbase.xom.DOMWrapper _def)");
            printWriter.println("\t\t\tthrows org.eigenbase.xom.XOMException");
            printWriter.println("\t\t{");
            boolean bl = this.contentModel.equals("mixed");
            if (this.allContent.length != 0 || this.allAttributes.length != 0 || this.isAny || this.isCData || this.def instanceof MetaDef.Plugin) {
                if (this.def instanceof MetaDef.Element && ((MetaDef.Element)this.def).keepDef.booleanValue()) {
                    printWriter.println("\t\t\tthis._def = _def;");
                }
                printWriter.println("\t\t\ttry {");
                if (this.def instanceof MetaDef.Plugin) {
                    printWriter.println("\t\t\t\tdefPackage = org.eigenbase.xom.DOMElementParser.requiredDefAttribute(_def, \"defPackage\", \"org.eigenbase.xom\");");
                    printWriter.println("\t\t\t\tdefClass = org.eigenbase.xom.DOMElementParser.requiredDefAttribute(_def, \"defClass\", null);");
                    printWriter.println("\t\t\t\tClass _pluginClass = org.eigenbase.xom.DOMElementParser.getPluginClass(defPackage, defClass);");
                }
                printWriter.print("\t\t\t\torg.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, ");
                if (this.def instanceof MetaDef.Plugin) {
                    printWriter.println("\"\", _pluginClass);");
                } else {
                    if (((MetaGenerator)MetaGenerator.this).model.prefix == null) {
                        printWriter.print("\"\", ");
                    } else {
                        printWriter.print("\"" + ((MetaGenerator)MetaGenerator.this).model.prefix + "\", ");
                    }
                    printWriter.println(((MetaGenerator)MetaGenerator.this).model.className + ".class);");
                }
                printWriter.println("\t\t\t\t_parser = _parser;");
                if (MetaGenerator.hasContentType(this.allContent, class$org$eigenbase$xom$MetaDef$Array == null ? (class$org$eigenbase$xom$MetaDef$Array = MetaGenerator.class$("org.eigenbase.xom.MetaDef$Array")) : class$org$eigenbase$xom$MetaDef$Array)) {
                    printWriter.println("\t\t\t\torg.eigenbase.xom.NodeDef[] _tempArray = null;");
                    printWriter.println("\t\t\t\t_tempArray = _tempArray;");
                }
                for (n = 0; n < this.allAttributes.length; ++n) {
                    MetaGenerator.this.writeJavaGetAttribute(printWriter, this.allAttributes[n]);
                }
                if (this.def instanceof MetaDef.Plugin) {
                    MetaGenerator.this.writeJavaGetPluginContent(printWriter, bl);
                } else if (this.isAny) {
                    MetaGenerator.this.writeJavaGetAnyContent(printWriter, bl);
                } else if (this.isCData) {
                    MetaGenerator.this.writeJavaGetCDataContent(printWriter);
                } else {
                    for (n = 0; n < this.allContent.length; ++n) {
                        MetaGenerator.this.writeJavaGetContent(printWriter, this.allContent[n]);
                    }
                }
                printWriter.println("\t\t\t} catch(org.eigenbase.xom.XOMException _ex) {");
                printWriter.println("\t\t\t\tthrow new org.eigenbase.xom.XOMException(\"In \" + getName() + \": \" + _ex.getMessage());");
                printWriter.println("\t\t\t}");
            }
            printWriter.println("\t\t}");
            printWriter.println();
            for (n = 0; n < this.newAttributes.length; ++n) {
                MetaGenerator.this.writeJavaDeclareAttribute(printWriter, this.newAttributes[n]);
            }
            if (this.def instanceof MetaDef.Plugin) {
                MetaGenerator.this.writeJavaDeclarePluginAttributes(printWriter);
            }
            if (this.def instanceof MetaDef.Element && ((MetaDef.Element)this.def).keepDef.booleanValue()) {
                printWriter.println("\t\tpublic org.eigenbase.xom.DOMWrapper _def;");
            }
            printWriter.println();
            if (this.def instanceof MetaDef.Plugin) {
                MetaGenerator.this.writeJavaDeclarePluginContent(printWriter, bl);
            } else if (this.isAny) {
                MetaGenerator.this.writeJavaDeclareAnyContent(printWriter, bl);
            } else if (this.isCData) {
                MetaGenerator.this.writeJavaDeclareCDataContent(printWriter);
            } else {
                for (n = 0; n < this.newContent.length; ++n) {
                    MetaGenerator.this.writeJavaDeclareContent(printWriter, this.newContent[n]);
                }
            }
            printWriter.println();
            printWriter.println("\t\tpublic String getName()");
            printWriter.println("\t\t{");
            printWriter.println("\t\t\treturn \"" + this.className + "\";");
            printWriter.println("\t\t}");
            printWriter.println();
            printWriter.println("\t\tpublic void display(java.io.PrintWriter _out, int _indent)");
            printWriter.println("\t\t{");
            if (!(this.def instanceof MetaDef.Class) || this.isAny || this.isCData || this.allContent.length != 0 || this.allAttributes.length != 0) {
                printWriter.println("\t\t\t_out.println(getName());");
            }
            for (n = 0; n < this.allAttributes.length; ++n) {
                MetaGenerator.this.writeJavaDisplayAttribute(printWriter, this.allAttributes[n]);
            }
            if (this.def instanceof MetaDef.Plugin) {
                MetaGenerator.this.writeJavaDisplayPluginAttributes(printWriter);
            }
            if (this.def instanceof MetaDef.Plugin) {
                MetaGenerator.this.writeJavaDisplayPluginContent(printWriter);
            } else if (this.isAny) {
                MetaGenerator.this.writeJavaDisplayAnyContent(printWriter);
            } else if (this.isCData) {
                MetaGenerator.this.writeJavaDisplayCDataContent(printWriter);
            } else {
                for (n = 0; n < this.allContent.length; ++n) {
                    MetaGenerator.this.writeJavaDisplayContent(printWriter, this.allContent[n]);
                }
            }
            printWriter.println("\t\t}");
            printWriter.println("\t\tpublic void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)");
            printWriter.println("\t\t{");
            printWriter.println("\t\t\t_out.beginTag(\"" + this.tagName + "\", " + "new org.eigenbase.xom.XMLAttrVector()");
            for (n = 0; n < this.allAttributes.length; ++n) {
                MetaGenerator.this.writeJavaDisplayXMLAttribute(printWriter, this.allAttributes[n]);
            }
            if (this.def instanceof MetaDef.Plugin) {
                MetaGenerator.this.writeJavaDisplayXMLPluginAttributes(printWriter);
            }
            printWriter.println("\t\t\t\t);");
            if (this.def instanceof MetaDef.Plugin) {
                MetaGenerator.this.writeJavaDisplayXMLPluginContent(printWriter);
            } else if (this.isAny) {
                MetaGenerator.this.writeJavaDisplayXMLAnyContent(printWriter);
            } else if (this.isCData) {
                MetaGenerator.this.writeJavaDisplayXMLCDataContent(printWriter);
            } else {
                for (n = 0; n < this.allContent.length; ++n) {
                    MetaGenerator.this.writeJavaDisplayXMLContent(printWriter, this.allContent[n]);
                }
            }
            printWriter.println("\t\t\t_out.endTag(\"" + this.tagName + "\");");
            printWriter.println("\t\t}");
            printWriter.println("\t\tpublic boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)");
            printWriter.println("\t\t{");
            printWriter.println("\t\t\tboolean _diff = true;");
            if (this.allAttributes.length > 0 || this.allContent.length > 0 || this.isAny || this.isCData || this.def instanceof MetaDef.Plugin) {
                printWriter.println("\t\t\t" + this.className + " _cother = (" + this.className + ")_other;");
            }
            for (n = 0; n < this.newAttributes.length; ++n) {
                MetaGenerator.this.writeJavaDisplayDiffAttribute(printWriter, this.allAttributes[n]);
            }
            if (this.def instanceof MetaDef.Plugin) {
                MetaGenerator.this.writeJavaDisplayDiffPluginAttributes(printWriter);
            }
            if (this.def instanceof MetaDef.Plugin) {
                MetaGenerator.this.writeJavaDisplayDiffPluginContent(printWriter);
            } else if (this.isAny) {
                MetaGenerator.this.writeJavaDisplayDiffAnyContent(printWriter);
            } else if (this.isCData) {
                MetaGenerator.this.writeJavaDisplayDiffCDataContent(printWriter);
            } else {
                for (n = 0; n < this.allContent.length; ++n) {
                    MetaGenerator.this.writeJavaDisplayDiffContent(printWriter, this.allContent[n]);
                }
            }
            printWriter.println("\t\t\treturn _diff;");
            printWriter.println("\t\t}");
            if (this.code != null) {
                MetaGenerator.this.writeJavaCode(printWriter, 2, this.code);
            }
            printWriter.println("\t}");
            printWriter.println();
        }
    }
}

