/*
 * Decompiled with CFR 0.152.
 */
package mondrian.xmla.impl;

import com.rc.retroweaver.runtime.Collections;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.xmla.XmlaConstants;
import mondrian.xmla.XmlaException;
import mondrian.xmla.XmlaRequest;
import mondrian.xmla.XmlaUtil;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultXmlaRequest
implements XmlaRequest,
XmlaConstants {
    private static final Logger LOGGER = Logger.getLogger((Class)(class$mondrian$xmla$impl$DefaultXmlaRequest == null ? (class$mondrian$xmla$impl$DefaultXmlaRequest = DefaultXmlaRequest.class$("mondrian.xmla.impl.DefaultXmlaRequest")) : class$mondrian$xmla$impl$DefaultXmlaRequest));
    private static final String MSG_INVALID_XMLA = "Invalid XML/A message";
    private static final String MSG_INVALID_DRILLTHROUGH = "Invalid DRILLTHROUGH statement";
    private static final String MSG_INVALID_MAXROWS = "MAXROWS is not positive integer";
    private static final String MSG_INVALID_FIRSTROWSET = "FIRSTROWSET isn't positive integer";
    private int method;
    private Map<String, String> properties;
    private String role;
    private String statement;
    private boolean drillthrough;
    private int maxRows;
    private int firstRowset;
    private String requestType;
    private Map<String, List<String>> restrictions;
    private static final /* synthetic */ Class class$mondrian$xmla$impl$DefaultXmlaRequest;

    public DefaultXmlaRequest(Element xmlaRoot) {
        this(xmlaRoot, null);
    }

    public DefaultXmlaRequest(Element xmlaRoot, String role) throws XmlaException {
        this.init(xmlaRoot);
        this.role = role;
    }

    @Override
    public int getMethod() {
        return this.method;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public Map<String, List<String>> getRestrictions() {
        if (this.method != 1) {
            throw new IllegalStateException("Only METHOD_DISCOVER has restrictions");
        }
        return this.restrictions;
    }

    @Override
    public String getStatement() {
        if (this.method != 2) {
            throw new IllegalStateException("Only METHOD_EXECUTE has statement");
        }
        return this.statement;
    }

    @Override
    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    @Override
    public String getRequestType() {
        if (this.method != 1) {
            throw new IllegalStateException("Only METHOD_DISCOVER has requestType");
        }
        return this.requestType;
    }

    @Override
    public boolean isDrillThrough() {
        if (this.method != 2) {
            throw new IllegalStateException("Only METHOD_EXECUTE determines drillthrough");
        }
        return this.drillthrough;
    }

    @Override
    public int drillThroughMaxRows() {
        if (this.method != 2) {
            throw new IllegalStateException("Only METHOD_EXECUTE determines drillthrough");
        }
        return this.maxRows;
    }

    @Override
    public int drillThroughFirstRowset() {
        if (this.method != 2) {
            throw new IllegalStateException("Only METHOD_EXECUTE determines drillthrough");
        }
        return this.firstRowset;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void init(Element xmlaRoot) throws XmlaException {
        if (!"urn:schemas-microsoft-com:xml-analysis".equals(xmlaRoot.getNamespaceURI())) {
            StringBuffer buf = new StringBuffer(100);
            buf.append(MSG_INVALID_XMLA);
            buf.append(": Bad namespace url \"");
            buf.append(xmlaRoot.getNamespaceURI());
            buf.append("\"");
            throw new XmlaException("Client", "00HSBB03", "XMLA SOAP bad method namespace", Util.newError(buf.toString()));
        }
        String lname = xmlaRoot.getLocalName();
        if ("Discover".equals(lname)) {
            this.method = 1;
            this.initDiscover(xmlaRoot);
            return;
        }
        if ("Execute".equals(lname)) {
            this.method = 2;
            this.initExecute(xmlaRoot);
            return;
        }
        StringBuffer buf = new StringBuffer(100);
        buf.append(MSG_INVALID_XMLA);
        buf.append(": Bad method name \"");
        buf.append(lname);
        buf.append("\"");
        throw new XmlaException("Client", "00HSBB02", "XMLA SOAP bad method", Util.newError(buf.toString()));
    }

    private void initDiscover(Element discoverRoot) throws XmlaException {
        Element[] childElems = XmlaUtil.filterChildElements(discoverRoot, "urn:schemas-microsoft-com:xml-analysis", "RequestType");
        if (childElems.length != 1) {
            StringBuffer buf = new StringBuffer(100);
            buf.append(MSG_INVALID_XMLA);
            buf.append(": Wrong number of RequestType elements: ");
            buf.append(childElems.length);
            throw new XmlaException("Client", "00HSBB04", "XMLA SOAP bad Discover RequestType element", Util.newError(buf.toString()));
        }
        this.requestType = XmlaUtil.textInElement(childElems[0]);
        childElems = XmlaUtil.filterChildElements(discoverRoot, "urn:schemas-microsoft-com:xml-analysis", "Restrictions");
        if (childElems.length != 1) {
            StringBuffer buf = new StringBuffer(100);
            buf.append(MSG_INVALID_XMLA);
            buf.append(": Wrong number of Restrictions elements: ");
            buf.append(childElems.length);
            throw new XmlaException("Client", "00HSBB05", "XMLA SOAP bad Discover Restrictions element", Util.newError(buf.toString()));
        }
        this.initRestrictions(childElems[0]);
        childElems = XmlaUtil.filterChildElements(discoverRoot, "urn:schemas-microsoft-com:xml-analysis", "Properties");
        if (childElems.length != 1) {
            StringBuffer buf = new StringBuffer(100);
            buf.append(MSG_INVALID_XMLA);
            buf.append(": Wrong number of Properties elements: ");
            buf.append(childElems.length);
            throw new XmlaException("Client", "00HSBB06", "XMLA SOAP bad Discover or Execute Properties element", Util.newError(buf.toString()));
        }
        this.initProperties(childElems[0]);
    }

    private void initExecute(Element executeRoot) throws XmlaException {
        Element[] childElems = XmlaUtil.filterChildElements(executeRoot, "urn:schemas-microsoft-com:xml-analysis", "Command");
        if (childElems.length != 1) {
            StringBuffer buf = new StringBuffer(100);
            buf.append(MSG_INVALID_XMLA);
            buf.append(": Wrong number of Command elements: ");
            buf.append(childElems.length);
            throw new XmlaException("Client", "00HSBB07", "XMLA SOAP bad Execute Command element", Util.newError(buf.toString()));
        }
        this.initCommand(childElems[0]);
        childElems = XmlaUtil.filterChildElements(executeRoot, "urn:schemas-microsoft-com:xml-analysis", "Properties");
        if (childElems.length != 1) {
            StringBuffer buf = new StringBuffer(100);
            buf.append(MSG_INVALID_XMLA);
            buf.append(": Wrong number of Properties elements: ");
            buf.append(childElems.length);
            throw new XmlaException("Client", "00HSBB06", "XMLA SOAP bad Discover or Execute Properties element", Util.newError(buf.toString()));
        }
        this.initProperties(childElems[0]);
    }

    private void initRestrictions(Element restrictionsRoot) throws XmlaException {
        HashMap restrictions = new HashMap();
        Element[] childElems = XmlaUtil.filterChildElements(restrictionsRoot, "urn:schemas-microsoft-com:xml-analysis", "RestrictionList");
        if (childElems.length == 1) {
            NodeList nlst = childElems[0].getChildNodes();
            int nlen = nlst.getLength();
            for (int i = 0; i < nlen; ++i) {
                List<String> values;
                Element e;
                Node n = nlst.item(i);
                if (!(n instanceof Element) || !"urn:schemas-microsoft-com:xml-analysis".equals((e = (Element)n).getNamespaceURI())) continue;
                String key = e.getLocalName();
                String value = XmlaUtil.textInElement(e);
                if (restrictions.containsKey(key)) {
                    values = (List)restrictions.get(key);
                } else {
                    values = new ArrayList();
                    restrictions.put(key, values);
                }
                if (LOGGER.isDebugEnabled()) {
                    StringBuffer buf = new StringBuffer(100);
                    buf.append("DefaultXmlaRequest.initRestrictions: ");
                    buf.append(" key=\"");
                    buf.append(key);
                    buf.append("\", value=\"");
                    buf.append(value);
                    buf.append("\"");
                    LOGGER.debug((Object)buf.toString());
                }
                values.add(value);
            }
        } else if (childElems.length > 1) {
            StringBuffer buf = new StringBuffer(100);
            buf.append(MSG_INVALID_XMLA);
            buf.append(": Wrong number of RestrictionList elements: ");
            buf.append(childElems.length);
            throw new XmlaException("Client", "00HSBB08", "XMLA SOAP too many Discover RestrictionList element", Util.newError(buf.toString()));
        }
        this.restrictions = Collections.unmodifiableMap(restrictions);
    }

    private void initProperties(Element propertiesRoot) throws XmlaException {
        HashMap<String, String> properties = new HashMap<String, String>();
        Element[] childElems = XmlaUtil.filterChildElements(propertiesRoot, "urn:schemas-microsoft-com:xml-analysis", "PropertyList");
        if (childElems.length == 1) {
            NodeList nlst = childElems[0].getChildNodes();
            int nlen = nlst.getLength();
            for (int i = 0; i < nlen; ++i) {
                Element e;
                Node n = nlst.item(i);
                if (!(n instanceof Element) || !"urn:schemas-microsoft-com:xml-analysis".equals((e = (Element)n).getNamespaceURI())) continue;
                String key = e.getLocalName();
                String value = XmlaUtil.textInElement(e);
                if (LOGGER.isDebugEnabled()) {
                    StringBuffer buf = new StringBuffer(100);
                    buf.append("DefaultXmlaRequest.initProperties: ");
                    buf.append(" key=\"");
                    buf.append(key);
                    buf.append("\", value=\"");
                    buf.append(value);
                    buf.append("\"");
                    LOGGER.debug((Object)buf.toString());
                }
                properties.put(key, value);
            }
        } else if (childElems.length > 1) {
            StringBuffer buf = new StringBuffer(100);
            buf.append(MSG_INVALID_XMLA);
            buf.append(": Wrong number of PropertyList elements: ");
            buf.append(childElems.length);
            throw new XmlaException("Client", "00HSBB09", "XMLA SOAP bad Discover or Execute PropertyList element", Util.newError(buf.toString()));
        }
        this.properties = Collections.unmodifiableMap(properties);
    }

    private void initCommand(Element commandRoot) throws XmlaException {
        Element[] childElems = XmlaUtil.filterChildElements(commandRoot, "urn:schemas-microsoft-com:xml-analysis", "Statement");
        if (childElems.length != 1) {
            StringBuffer buf = new StringBuffer(100);
            buf.append(MSG_INVALID_XMLA);
            buf.append(": Wrong number of Statement elements: ");
            buf.append(childElems.length);
            throw new XmlaException("Client", "00HSBB10", "XMLA SOAP bad Execute Statement element", Util.newError(buf.toString()));
        }
        this.statement = XmlaUtil.textInElement(childElems[0]).replaceAll("\\r", "");
        String upperStatement = this.statement.toUpperCase();
        int dtOffset = upperStatement.indexOf("DRILLTHROUGH");
        int mrOffset = upperStatement.indexOf("MAXROWS");
        int frOffset = upperStatement.indexOf("FIRSTROWSET");
        int slOffset = upperStatement.indexOf("SELECT");
        if (dtOffset == -1) {
            this.drillthrough = false;
        } else if (dtOffset < slOffset) {
            this.firstRowset = -1;
            this.maxRows = -1;
            try {
                if (mrOffset > dtOffset && mrOffset < slOffset) {
                    this.maxRows = this.parseIntValue(this.statement.substring(mrOffset, slOffset));
                    if (this.maxRows <= 0) {
                        StringBuffer buf = new StringBuffer(100);
                        buf.append(MSG_INVALID_MAXROWS);
                        buf.append(": ");
                        buf.append(this.maxRows);
                        throw new XmlaException("Client", "00HSBB11", "XMLA SOAP Drilldown Execute Statement non-positive maxrows", Util.newError(buf.toString()));
                    }
                }
                if (frOffset > dtOffset && frOffset > mrOffset && frOffset < slOffset) {
                    this.firstRowset = this.parseIntValue(this.statement.substring(frOffset, slOffset));
                    if (this.firstRowset <= 0) {
                        StringBuffer buf = new StringBuffer(100);
                        buf.append(MSG_INVALID_FIRSTROWSET);
                        buf.append(": ");
                        buf.append(this.firstRowset);
                        throw new XmlaException("Client", "00HSBB12", "XMLA SOAP Drilldown Execute Statement non-positive first rowset", Util.newError(buf.toString()));
                    }
                }
            }
            catch (XmlaException xex) {
                throw xex;
            }
            catch (Exception e) {
                throw new XmlaException("Client", "00HSBB13", "XMLA SOAP Drilldown Execute Statement error", Util.newError(e, MSG_INVALID_DRILLTHROUGH));
            }
            int configMaxRows = MondrianProperties.instance().MaxRows.get();
            if (configMaxRows > 0 && this.maxRows > configMaxRows) {
                this.maxRows = configMaxRows;
            }
            StringBuffer dtStmtBuf = new StringBuffer();
            dtStmtBuf.append(this.statement.substring(0, dtOffset));
            dtStmtBuf.append(this.statement.substring(slOffset));
            this.statement = dtStmtBuf.toString();
            this.drillthrough = true;
        } else {
            throw new XmlaException("Client", "00HSBB13", "XMLA SOAP Drilldown Execute Statement error", Util.newError(MSG_INVALID_DRILLTHROUGH));
        }
    }

    private int parseIntValue(String option) {
        String[] opts = option.split("[ \t\n]");
        return Integer.parseInt(opts[1]);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

