/*
 * Decompiled with CFR 0.152.
 */
package mondrian.xmla;

import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import mondrian.olap.MondrianException;
import mondrian.xmla.XmlaConstants;
import mondrian.xmla.XmlaException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class XmlaUtil
implements XmlaConstants {
    private static final Logger LOGGER = Logger.getLogger((Class)(class$mondrian$xmla$XmlaUtil == null ? (class$mondrian$xmla$XmlaUtil = XmlaUtil.class$("mondrian.xmla.XmlaUtil")) : class$mondrian$xmla$XmlaUtil));
    private static final String[] CHAR_TABLE = new String[256];
    private static final /* synthetic */ Class class$mondrian$xmla$XmlaUtil;

    private static void initCharTable(String charStr) {
        char[] chars = charStr.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            XmlaUtil.CHAR_TABLE[c] = XmlaUtil.encodeChar(c);
        }
    }

    private static String encodeChar(char c) {
        StringBuffer buf = new StringBuffer();
        buf.append("_x");
        String str = Integer.toHexString(c);
        for (int i = 4 - str.length(); i > 0; --i) {
            buf.append("0");
        }
        return buf.append(str).append("_").toString();
    }

    public static String encodeElementName(String name) {
        StringBuffer buf = new StringBuffer();
        char[] nameChars = name.toCharArray();
        for (int i = 0; i < nameChars.length; ++i) {
            String encodedStr;
            char ch = nameChars[i];
            String string = encodedStr = ch >= CHAR_TABLE.length ? null : CHAR_TABLE[ch];
            if (encodedStr == null) {
                buf.append(ch);
                continue;
            }
            buf.append(encodedStr);
        }
        return buf.toString();
    }

    public static String element2Text(Element elem) throws XmlaException {
        StringWriter writer = new StringWriter();
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.transform(new DOMSource(elem), new StreamResult(writer));
        }
        catch (Exception e) {
            throw new XmlaException("Client", "00USMC02", "DOM parse errors occur", e);
        }
        return writer.getBuffer().toString();
    }

    public static Element text2Element(String text) throws XmlaException {
        return XmlaUtil._2Element(new InputSource(new StringReader(text)));
    }

    public static Element stream2Element(InputStream stream) throws XmlaException {
        return XmlaUtil._2Element(new InputSource(stream));
    }

    private static Element _2Element(InputSource source) throws XmlaException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringElementContentWhitespace(true);
            factory.setIgnoringComments(true);
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(source);
            Element elem = doc.getDocumentElement();
            return elem;
        }
        catch (Exception e) {
            throw new XmlaException("Client", "00USMC02", "DOM parse errors occur", e);
        }
    }

    public static Element firstChildElement(Element parent, String ns, String lname) {
        if (LOGGER.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer(100);
            buf.append("XmlaUtil.firstChildElement: ");
            buf.append(" ns=\"");
            buf.append(ns);
            buf.append("\", lname=\"");
            buf.append(lname);
            buf.append("\"");
            LOGGER.debug((Object)buf.toString());
        }
        NodeList nlst = parent.getChildNodes();
        int nlen = nlst.getLength();
        for (int i = 0; i < nlen; ++i) {
            Node n = nlst.item(i);
            if (!(n instanceof Element)) continue;
            Element e = (Element)n;
            if (LOGGER.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer(100);
                buf.append("XmlaUtil.firstChildElement: ");
                buf.append(" e.getNamespaceURI()=\"");
                buf.append(e.getNamespaceURI());
                buf.append("\", e.getLocalName()=\"");
                buf.append(e.getLocalName());
                buf.append("\"");
                LOGGER.debug((Object)buf.toString());
            }
            if (ns != null && !ns.equals(e.getNamespaceURI()) || lname != null && !lname.equals(e.getLocalName())) continue;
            return e;
        }
        return null;
    }

    public static Element[] filterChildElements(Element parent, String ns, String lname) {
        ArrayList<Element> elems = new ArrayList<Element>();
        NodeList nlst = parent.getChildNodes();
        int nlen = nlst.getLength();
        for (int i = 0; i < nlen; ++i) {
            Node n = nlst.item(i);
            if (!(n instanceof Element)) continue;
            Element e = (Element)n;
            if (ns != null && !ns.equals(e.getNamespaceURI()) || lname != null && !lname.equals(e.getLocalName())) continue;
            elems.add(e);
        }
        return elems.toArray(new Element[0]);
    }

    public static String textInElement(Element elem) {
        StringBuffer buf = new StringBuffer(100);
        elem.normalize();
        NodeList nlst = elem.getChildNodes();
        int nlen = nlst.getLength();
        for (int i = 0; i < nlen; ++i) {
            Node n = nlst.item(i);
            if (!(n instanceof Text)) continue;
            String data = ((Text)n).getData();
            buf.append(data);
        }
        return buf.toString();
    }

    public static Throwable rootThrowable(Throwable throwable) {
        Throwable rootThrowable = throwable.getCause();
        if (rootThrowable != null && rootThrowable instanceof MondrianException) {
            return XmlaUtil.rootThrowable(rootThrowable);
        }
        return throwable;
    }

    public static String normalizeNumericString(String numericStr) {
        int index = numericStr.indexOf(46);
        if (index > 0) {
            boolean found = false;
            int p = numericStr.length();
            char c = numericStr.charAt(p - 1);
            while (c == '0') {
                found = true;
                c = numericStr.charAt(--p - 1);
            }
            if (c == '.') {
                --p;
            }
            if (found) {
                return numericStr.substring(0, p);
            }
        }
        return numericStr;
    }

    static {
        XmlaUtil.initCharTable(" \t\r\n(){}[]+/*%!,?");
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

