/*
 * Decompiled with CFR 0.152.
 */
package mondrian.xmla;

import com.rc.retroweaver.runtime.Collections;
import com.rc.retroweaver.runtime.Enum_;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import mondrian.olap.Util;
import mondrian.spi.CatalogLocator;
import mondrian.spi.impl.ServletContextCatalogLocator;
import mondrian.xmla.DataSourcesConfig;
import mondrian.xmla.XmlaConstants;
import mondrian.xmla.XmlaException;
import mondrian.xmla.XmlaHandler;
import mondrian.xmla.XmlaRequestCallback;
import org.apache.log4j.Logger;
import org.eigenbase.xom.DOMWrapper;
import org.eigenbase.xom.Parser;
import org.eigenbase.xom.XOMException;
import org.eigenbase.xom.XOMUtil;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XmlaServlet
extends HttpServlet
implements XmlaConstants {
    private static final Logger LOGGER = Logger.getLogger((Class)(class$mondrian$xmla$XmlaServlet == null ? (class$mondrian$xmla$XmlaServlet = XmlaServlet.class$("mondrian.xmla.XmlaServlet")) : class$mondrian$xmla$XmlaServlet));
    public static final String PARAM_DATASOURCES_CONFIG = "DataSourcesConfig";
    public static final String PARAM_OPTIONAL_DATASOURCE_CONFIG = "OptionalDataSourceConfig";
    public static final String PARAM_CHAR_ENCODING = "CharacterEncoding";
    public static final String PARAM_CALLBACKS = "Callbacks";
    public static final String DEFAULT_DATASOURCE_FILE = "datasources.xml";
    protected CatalogLocator catalogLocator = null;
    protected DataSourcesConfig.DataSources dataSources = null;
    protected XmlaHandler xmlaHandler = null;
    protected String charEncoding = null;
    private final List<XmlaRequestCallback> callbackList = new ArrayList<XmlaRequestCallback>();
    private static final /* synthetic */ Class class$mondrian$xmla$XmlaServlet;
    private static final /* synthetic */ Class class$mondrian$xmla$XmlaRequestCallback;

    public static boolean getBooleanInitParameter(ServletConfig servletConfig, String paramName) {
        String paramValue = servletConfig.getInitParameter(paramName);
        return paramValue != null && Boolean.valueOf(paramValue) != false;
    }

    public static boolean getParameter(HttpServletRequest req, String paramName) {
        String paramValue = req.getParameter(paramName);
        return paramValue != null && Boolean.valueOf(paramValue) != false;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.initCharEncodingHandler(servletConfig);
        this.initCallbacks(servletConfig);
        this.catalogLocator = this.makeCatalogLocator(servletConfig);
        DataSourcesConfig.DataSources dataSources = this.makeDataSources(servletConfig);
        this.addToDataSources(dataSources);
    }

    protected XmlaHandler getXmlaHandler() {
        if (this.xmlaHandler == null) {
            this.xmlaHandler = new XmlaHandler(this.dataSources, this.catalogLocator, "cxmla");
        }
        return this.xmlaHandler;
    }

    protected final void addCallback(XmlaRequestCallback callback) {
        this.callbackList.add(callback);
    }

    protected final List<XmlaRequestCallback> getCallbacks() {
        return Collections.unmodifiableList(this.callbackList);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Element[] requestSoapParts = new Element[2];
        byte[][] responseSoapParts = new byte[2][];
        Phase phase = Phase.VALIDATE_HTTP_HEAD;
        try {
            if (this.charEncoding != null) {
                try {
                    request.setCharacterEncoding(this.charEncoding);
                    response.setCharacterEncoding(this.charEncoding);
                }
                catch (UnsupportedEncodingException uee) {
                    this.charEncoding = null;
                    String msg = new StringBuffer().append("Unsupported character encoding '").append(this.charEncoding).append("': ").append("Use default character encoding from HTTP client for now").toString();
                    LOGGER.warn((Object)msg);
                }
            }
            response.setContentType("text/xml");
            HashMap<String, String> context = new HashMap<String, String>();
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Invoking validate http header callbacks");
                }
                for (XmlaRequestCallback callback : this.getCallbacks()) {
                    if (callback.processHttpHeader(request, response, context)) continue;
                    return;
                }
            }
            catch (XmlaException xex) {
                LOGGER.error((Object)"Errors when invoking callbacks validateHttpHeader", (Throwable)xex);
                this.handleFault(response, responseSoapParts, phase, xex);
                phase = Phase.SEND_ERROR;
                this.marshallSoapMessage(response, responseSoapParts);
                return;
            }
            catch (Exception ex) {
                LOGGER.error((Object)"Errors when invoking callbacks validateHttpHeader", (Throwable)ex);
                this.handleFault(response, responseSoapParts, phase, new XmlaException("Server", "00CHHA01", "Error in Callback processHttpHeader", ex));
                phase = Phase.SEND_ERROR;
                this.marshallSoapMessage(response, responseSoapParts);
                return;
            }
            phase = Phase.INITIAL_PARSE;
            try {
                String contentType;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Unmarshalling SOAP message");
                }
                if ((contentType = request.getContentType()) == null || contentType.indexOf("text/xml") == -1) {
                    throw new IllegalArgumentException(new StringBuffer().append("Only accepts content type 'text/xml', not '").append(contentType).append("'").toString());
                }
                this.unmarshallSoapMessage(request, requestSoapParts);
            }
            catch (XmlaException xex) {
                LOGGER.error((Object)"Unable to unmarshall SOAP message", (Throwable)xex);
                this.handleFault(response, responseSoapParts, phase, xex);
                phase = Phase.SEND_ERROR;
                this.marshallSoapMessage(response, responseSoapParts);
                return;
            }
            phase = Phase.PROCESS_HEADER;
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Handling XML/A message header");
                }
                this.handleSoapHeader(response, requestSoapParts, responseSoapParts, context);
            }
            catch (XmlaException xex) {
                LOGGER.error((Object)"Errors when handling XML/A message", (Throwable)xex);
                this.handleFault(response, responseSoapParts, phase, xex);
                phase = Phase.SEND_ERROR;
                this.marshallSoapMessage(response, responseSoapParts);
                return;
            }
            phase = Phase.CALLBACK_PRE_ACTION;
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Invoking callbacks preAction");
                }
                for (XmlaRequestCallback callback : this.getCallbacks()) {
                    callback.preAction(request, requestSoapParts, context);
                }
            }
            catch (XmlaException xex) {
                LOGGER.error((Object)"Errors when invoking callbacks preaction", (Throwable)xex);
                this.handleFault(response, responseSoapParts, phase, xex);
                phase = Phase.SEND_ERROR;
                this.marshallSoapMessage(response, responseSoapParts);
                return;
            }
            catch (Exception ex) {
                LOGGER.error((Object)"Errors when invoking callbacks preaction", (Throwable)ex);
                this.handleFault(response, responseSoapParts, phase, new XmlaException("Server", "00CPREA01", "Error in Callback PreAction", ex));
                phase = Phase.SEND_ERROR;
                this.marshallSoapMessage(response, responseSoapParts);
                return;
            }
            phase = Phase.PROCESS_BODY;
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Handling XML/A message body");
                }
                this.handleSoapBody(response, requestSoapParts, responseSoapParts, context);
            }
            catch (XmlaException xex) {
                LOGGER.error((Object)"Errors when handling XML/A message", (Throwable)xex);
                this.handleFault(response, responseSoapParts, phase, xex);
                phase = Phase.SEND_ERROR;
                this.marshallSoapMessage(response, responseSoapParts);
                return;
            }
            phase = Phase.CALLBACK_POST_ACTION;
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Invoking callbacks postAction");
                }
                for (XmlaRequestCallback callback : this.getCallbacks()) {
                    callback.postAction(request, response, responseSoapParts, context);
                }
            }
            catch (XmlaException xex) {
                LOGGER.error((Object)"Errors when invoking callbacks postaction", (Throwable)xex);
                this.handleFault(response, responseSoapParts, phase, xex);
                phase = Phase.SEND_ERROR;
                this.marshallSoapMessage(response, responseSoapParts);
                return;
            }
            catch (Exception ex) {
                LOGGER.error((Object)"Errors when invoking callbacks postaction", (Throwable)ex);
                this.handleFault(response, responseSoapParts, phase, new XmlaException("Server", "00CPOSTA01", "Error in Callback PostAction", ex));
                phase = Phase.SEND_ERROR;
                this.marshallSoapMessage(response, responseSoapParts);
                return;
            }
            phase = Phase.SEND_RESPONSE;
            try {
                response.setStatus(200);
                this.marshallSoapMessage(response, responseSoapParts);
            }
            catch (XmlaException xex) {
                LOGGER.error((Object)"Errors when handling XML/A message", (Throwable)xex);
                this.handleFault(response, responseSoapParts, phase, xex);
                phase = Phase.SEND_ERROR;
                this.marshallSoapMessage(response, responseSoapParts);
                return;
            }
        }
        catch (Throwable t) {
            LOGGER.error((Object)"Unknown Error when handling XML/A message", t);
            this.handleFault(response, responseSoapParts, phase, t);
            this.marshallSoapMessage(response, responseSoapParts);
        }
    }

    protected abstract void unmarshallSoapMessage(HttpServletRequest var1, Element[] var2) throws XmlaException;

    protected abstract void handleSoapHeader(HttpServletResponse var1, Element[] var2, byte[][] var3, Map<String, String> var4) throws XmlaException;

    protected abstract void handleSoapBody(HttpServletResponse var1, Element[] var2, byte[][] var3, Map<String, String> var4) throws XmlaException;

    protected abstract void marshallSoapMessage(HttpServletResponse var1, byte[][] var2) throws XmlaException;

    protected abstract void handleFault(HttpServletResponse var1, byte[][] var2, Phase var3, Throwable var4);

    protected CatalogLocator makeCatalogLocator(ServletConfig servletConfig) {
        ServletContext servletContext = servletConfig.getServletContext();
        return new ServletContextCatalogLocator(servletContext);
    }

    protected DataSourcesConfig.DataSources makeDataSources(ServletConfig servletConfig) {
        String msg;
        URL dataSourcesConfigUrl;
        block12: {
            String paramValue = servletConfig.getInitParameter(PARAM_DATASOURCES_CONFIG);
            boolean optional = XmlaServlet.getBooleanInitParameter(servletConfig, PARAM_OPTIONAL_DATASOURCE_CONFIG);
            dataSourcesConfigUrl = null;
            try {
                if (paramValue == null) {
                    String defaultDS = "WEB-INF/datasources.xml";
                    ServletContext servletContext = servletConfig.getServletContext();
                    File realPath = new File(servletContext.getRealPath(defaultDS));
                    if (realPath.exists()) {
                        dataSourcesConfigUrl = realPath.toURL();
                    }
                    break block12;
                }
                paramValue = Util.replaceProperties(paramValue, Util.toMap(System.getProperties()));
                if (LOGGER.isDebugEnabled()) {
                    msg = new StringBuffer().append("XmlaServlet.makeDataSources: paramValue=").append(paramValue).toString();
                    LOGGER.debug((Object)msg);
                }
                MalformedURLException mue = null;
                try {
                    dataSourcesConfigUrl = new URL(paramValue);
                }
                catch (MalformedURLException e) {
                    mue = e;
                }
                if (dataSourcesConfigUrl == null) {
                    File f = new File(paramValue);
                    if (f.exists()) {
                        dataSourcesConfigUrl = f.toURL();
                    } else if (mue != null && !optional) {
                        throw mue;
                    }
                }
            }
            catch (MalformedURLException mue) {
                throw Util.newError(mue, new StringBuffer().append("invalid URL path '").append(paramValue).append("'").toString());
            }
        }
        if (LOGGER.isDebugEnabled()) {
            msg = new StringBuffer().append("XmlaServlet.makeDataSources: dataSourcesConfigUrl=").append(dataSourcesConfigUrl).toString();
            LOGGER.debug((Object)msg);
        }
        return dataSourcesConfigUrl == null ? null : this.parseDataSourcesUrl(dataSourcesConfigUrl);
    }

    protected void addToDataSources(DataSourcesConfig.DataSources dataSources) {
        if (this.dataSources == null) {
            this.dataSources = dataSources;
        } else if (dataSources != null) {
            DataSourcesConfig.DataSource[] ds1 = this.dataSources.dataSources;
            int len1 = ds1.length;
            DataSourcesConfig.DataSource[] ds2 = dataSources.dataSources;
            int len2 = ds2.length;
            DataSourcesConfig.DataSource[] tmp = new DataSourcesConfig.DataSource[len1 + len2];
            System.arraycopy(ds1, 0, tmp, 0, len1);
            System.arraycopy(ds2, 0, tmp, len1, len2);
            this.dataSources.dataSources = tmp;
        } else {
            LOGGER.warn((Object)"XmlaServlet.addToDataSources: DataSources is null");
        }
    }

    protected DataSourcesConfig.DataSources parseDataSourcesUrl(URL dataSourcesConfigUrl) {
        try {
            String dataSourcesConfigString = Util.readURL(dataSourcesConfigUrl, Util.toMap(System.getProperties()));
            return this.parseDataSources(dataSourcesConfigString);
        }
        catch (Exception e) {
            throw Util.newError(e, new StringBuffer().append("Failed to parse data sources config '").append(dataSourcesConfigUrl.toExternalForm()).append("'").toString());
        }
    }

    protected DataSourcesConfig.DataSources parseDataSources(String dataSourcesConfigString) {
        try {
            if (dataSourcesConfigString == null) {
                LOGGER.warn((Object)"XmlaServlet.parseDataSources: null input");
                return null;
            }
            dataSourcesConfigString = Util.replaceProperties(dataSourcesConfigString, Util.toMap(System.getProperties()));
            if (LOGGER.isDebugEnabled()) {
                String msg = new StringBuffer().append("XmlaServlet.parseDataSources: dataSources=").append(dataSourcesConfigString).toString();
                LOGGER.debug((Object)msg);
            }
            Parser parser = XOMUtil.createDefaultParser();
            DOMWrapper doc = parser.parse(dataSourcesConfigString);
            return new DataSourcesConfig.DataSources(doc);
        }
        catch (XOMException e) {
            throw Util.newError(e, new StringBuffer().append("Failed to parse data sources config: ").append(dataSourcesConfigString).toString());
        }
    }

    protected void initCharEncodingHandler(ServletConfig servletConfig) {
        String paramValue = servletConfig.getInitParameter(PARAM_CHAR_ENCODING);
        if (paramValue != null) {
            this.charEncoding = paramValue;
        } else {
            this.charEncoding = null;
            LOGGER.warn((Object)"Use default character encoding from HTTP client");
        }
    }

    protected void initCallbacks(ServletConfig servletConfig) {
        String callbacksValue = servletConfig.getInitParameter(PARAM_CALLBACKS);
        if (callbacksValue != null) {
            String[] classNames = callbacksValue.split(";");
            int count = 0;
            for (String className1 : classNames) {
                String className = className1.trim();
                try {
                    Class<?> cls = Class.forName(className);
                    if ((class$mondrian$xmla$XmlaRequestCallback == null ? XmlaServlet.class$("mondrian.xmla.XmlaRequestCallback") : class$mondrian$xmla$XmlaRequestCallback).isAssignableFrom(cls)) {
                        XmlaRequestCallback callback = (XmlaRequestCallback)cls.newInstance();
                        try {
                            callback.init(servletConfig);
                        }
                        catch (Exception e) {
                            LOGGER.warn((Object)new StringBuffer().append("Failed to initialize callback '").append(className).append("'").toString(), (Throwable)e);
                            continue;
                        }
                        this.addCallback(callback);
                        ++count;
                        if (!LOGGER.isDebugEnabled()) continue;
                        LOGGER.info((Object)new StringBuffer().append("Register callback '").append(className).append("'").toString());
                        continue;
                    }
                    LOGGER.warn((Object)new StringBuffer().append("'").append(className).append("' is not an implementation of '").append(class$mondrian$xmla$XmlaRequestCallback == null ? XmlaServlet.class$("mondrian.xmla.XmlaRequestCallback") : class$mondrian$xmla$XmlaRequestCallback).append("'").toString());
                }
                catch (ClassNotFoundException cnfe) {
                    LOGGER.warn((Object)new StringBuffer().append("Callback class '").append(className).append("' not found").toString(), (Throwable)cnfe);
                }
                catch (InstantiationException ie) {
                    LOGGER.warn((Object)new StringBuffer().append("Can't instantiate class '").append(className).append("'").toString(), (Throwable)ie);
                }
                catch (IllegalAccessException iae) {
                    LOGGER.warn((Object)new StringBuffer().append("Can't instantiate class '").append(className).append("'").toString(), (Throwable)iae);
                }
            }
            LOGGER.debug((Object)new StringBuffer().append("Registered ").append(count).append(" callback").append(count > 1 ? "s" : "").toString());
        }
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    /*
     * Signature claims super is java.lang.Enum<mondrian.xmla.XmlaServlet$Phase>, not com.rc.retroweaver.runtime.Enum_ - discarding signature.
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Phase
    extends Enum_ {
        public static final /* enum */ Phase VALIDATE_HTTP_HEAD = new Phase("VALIDATE_HTTP_HEAD", 0);
        public static final /* enum */ Phase INITIAL_PARSE = new Phase("INITIAL_PARSE", 1);
        public static final /* enum */ Phase CALLBACK_PRE_ACTION = new Phase("CALLBACK_PRE_ACTION", 2);
        public static final /* enum */ Phase PROCESS_HEADER = new Phase("PROCESS_HEADER", 3);
        public static final /* enum */ Phase PROCESS_BODY = new Phase("PROCESS_BODY", 4);
        public static final /* enum */ Phase CALLBACK_POST_ACTION = new Phase("CALLBACK_POST_ACTION", 5);
        public static final /* enum */ Phase SEND_RESPONSE = new Phase("SEND_RESPONSE", 6);
        public static final /* enum */ Phase SEND_ERROR = new Phase("SEND_ERROR", 7);
        private static final /* synthetic */ Phase[] $VALUES;
        private static final /* synthetic */ long serialVersionUID = 0L;
        private static final /* synthetic */ Class class$mondrian$xmla$XmlaServlet$Phase;

        public static final Phase[] values() {
            return (Phase[])$VALUES.clone();
        }

        public static Phase valueOf(String name) {
            return (Phase)Enum_.valueOf((Class)(class$mondrian$xmla$XmlaServlet$Phase == null ? (class$mondrian$xmla$XmlaServlet$Phase = Phase.class$("mondrian.xmla.XmlaServlet$Phase")) : class$mondrian$xmla$XmlaServlet$Phase), (String)name);
        }

        private Phase(String string, int n) {
            super(string, n);
        }

        static {
            $VALUES = new Phase[]{VALIDATE_HTTP_HEAD, INITIAL_PARSE, CALLBACK_PRE_ACTION, PROCESS_HEADER, PROCESS_BODY, CALLBACK_POST_ACTION, SEND_RESPONSE, SEND_ERROR};
            Enum_.setEnumValues((Object[])Phase.values(), (Class)(class$mondrian$xmla$XmlaServlet$Phase == null ? (class$mondrian$xmla$XmlaServlet$Phase = Phase.class$("mondrian.xmla.XmlaServlet$Phase")) : class$mondrian$xmla$XmlaServlet$Phase));
        }

        static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
            Class<?> clazz;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                try {
                    noClassDefFoundError.initCause(classNotFoundException);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                throw noClassDefFoundError;
            }
            return clazz;
        }
    }
}

