/*
 * Decompiled with CFR 0.152.
 */
package mondrian.xmla;

import com.rc.retroweaver.runtime.Arrays;
import com.rc.retroweaver.runtime.ClassMethods;
import com.rc.retroweaver.runtime.Collections;
import com.rc.retroweaver.runtime.Enum_;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mondrian.olap.Util;
import mondrian.xmla.PropertyDefinition;
import mondrian.xmla.RowsetDefinition;
import mondrian.xmla.SaxWriter;
import mondrian.xmla.XmlaConstants;
import mondrian.xmla.XmlaException;
import mondrian.xmla.XmlaHandler;
import mondrian.xmla.XmlaRequest;
import mondrian.xmla.XmlaResponse;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Rowset
implements XmlaConstants {
    protected static final Logger LOGGER = Logger.getLogger((Class)(class$mondrian$xmla$Rowset == null ? (class$mondrian$xmla$Rowset = Rowset.class$("mondrian.xmla.Rowset")) : class$mondrian$xmla$Rowset));
    protected final RowsetDefinition rowsetDefinition;
    protected final Map<String, List<String>> restrictions;
    protected final Map<String, String> properties;
    protected final XmlaRequest request;
    protected final XmlaHandler handler;
    private final RowsetDefinition.Column[] restrictedColumns;
    private static final /* synthetic */ Class class$mondrian$xmla$PropertyDefinition;
    private static final /* synthetic */ Class class$mondrian$xmla$Rowset;

    Rowset(RowsetDefinition definition, XmlaRequest request, XmlaHandler handler) {
        this.rowsetDefinition = definition;
        this.restrictions = request.getRestrictions();
        this.properties = request.getProperties();
        this.request = request;
        this.handler = handler;
        ArrayList<RowsetDefinition.Column> list = new ArrayList<RowsetDefinition.Column>();
        for (Map.Entry<String, List<String>> restrictionEntry : this.restrictions.entrySet()) {
            String restrictedColumn = restrictionEntry.getKey();
            LOGGER.debug((Object)new StringBuffer().append("Rowset<init>: restrictedColumn=\"").append(restrictedColumn).append("\"").toString());
            RowsetDefinition.Column column = definition.lookupColumn(restrictedColumn);
            if (column == null) {
                throw Util.newError(new StringBuffer().append("Rowset '").append(definition.name()).append("' does not contain column '").append(restrictedColumn).append("'").toString());
            }
            if (!column.restriction) {
                throw Util.newError(new StringBuffer().append("Rowset '").append(definition.name()).append("' column '").append(restrictedColumn).append("' does not allow restrictions").toString());
            }
            List<String> requiredValue = restrictionEntry.getValue();
            if (requiredValue.size() > 1) {
                RowsetDefinition.Type type = column.type;
                switch (type) {
                    case StringArray: 
                    case EnumerationArray: 
                    case StringSometimesArray: {
                        break;
                    }
                    default: {
                        throw Util.newError(new StringBuffer().append("Rowset '").append(definition.name()).append("' column '").append(restrictedColumn).append("' can only be restricted on one value at a time").toString());
                    }
                }
            }
            list.add(column);
        }
        list = this.pruneRestrictions(list);
        this.restrictedColumns = list.toArray(new RowsetDefinition.Column[list.size()]);
        Iterator<Map.Entry<String, Object>> i$ = this.properties.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry<String, Object> propertyEntry;
            String propertyName;
            PropertyDefinition propertyDef = (PropertyDefinition)((Object)Util.lookup(class$mondrian$xmla$PropertyDefinition == null ? Rowset.class$("mondrian.xmla.PropertyDefinition") : class$mondrian$xmla$PropertyDefinition, propertyName = (propertyEntry = i$.next()).getKey()));
            if (propertyDef == null) {
                throw Util.newError(new StringBuffer().append("Rowset '").append(definition.name()).append("' does not support property '").append(propertyName).append("'").toString());
            }
            String propertyValue = (String)propertyEntry.getValue();
            this.setProperty(propertyDef, propertyValue);
        }
    }

    protected ArrayList<RowsetDefinition.Column> pruneRestrictions(ArrayList<RowsetDefinition.Column> list) {
        return list;
    }

    protected void setProperty(PropertyDefinition propertyDef, String value) {
        switch (propertyDef) {
            case Format: {
                break;
            }
            case DataSourceInfo: {
                break;
            }
            case Catalog: {
                break;
            }
            case LocaleIdentifier: {
                if (value != null && value.equals("1033")) {
                    return;
                }
            }
            default: {
                LOGGER.warn((Object)new StringBuffer().append("Warning: Rowset '").append(this.rowsetDefinition.name()).append("' does not support property '").append(propertyDef.name()).append("' (value is '").append(value).append("')").toString());
            }
        }
    }

    public final void unparse(XmlaResponse response) throws XmlaException {
        ArrayList<Row> rows = new ArrayList<Row>();
        this.populate(response, rows);
        Comparator<Row> comparator = this.rowsetDefinition.getComparator();
        if (comparator != null) {
            Collections.sort(rows, comparator);
        }
        for (Row row : rows) {
            this.emit(row, response);
        }
    }

    public abstract void populate(XmlaResponse var1, List<Row> var2) throws XmlaException;

    protected final boolean addRow(Row row, List<Row> rows) throws XmlaException {
        return rows.add(row);
    }

    protected void emit(Row row, XmlaResponse response) throws XmlaException {
        SaxWriter writer = response.getWriter();
        writer.startElement("row");
        for (RowsetDefinition.Column column : this.rowsetDefinition.columnDefinitions) {
            Object values;
            Object value = row.get(column.name);
            if (value == null) {
                if (column.nullable) continue;
                throw new XmlaException("Client", "00HSBB16", "XMLA SOAP non-nullable column", Util.newInternal(new StringBuffer().append("Value required for column ").append(column.name).append(" of rowset ").append(this.rowsetDefinition.name()).toString()));
            }
            if (value instanceof XmlElement[]) {
                XmlElement[] elements = (XmlElement[])value;
                for (XmlElement element : elements) {
                    this.emitXmlElement(writer, element);
                }
                continue;
            }
            if (value instanceof Object[]) {
                values = (Object[])value;
                for (Object value1 : values) {
                    writer.startElement(column.name);
                    writer.characters(value1.toString());
                    writer.endElement();
                }
                continue;
            }
            if (value instanceof List) {
                values = (List)value;
                Iterator i$ = values.iterator();
                while (i$.hasNext()) {
                    Object value1 = i$.next();
                    if (value1 instanceof XmlElement) {
                        XmlElement xmlElement = (XmlElement)value1;
                        this.emitXmlElement(writer, xmlElement);
                        continue;
                    }
                    writer.startElement(column.name);
                    writer.characters(value1.toString());
                    writer.endElement();
                }
                continue;
            }
            writer.startElement(column.name);
            writer.characters(value.toString());
            writer.endElement();
        }
        writer.endElement();
    }

    private void emitXmlElement(SaxWriter writer, XmlElement element) {
        if (XmlElement.access$000(element) == null) {
            writer.startElement(XmlElement.access$100(element));
        } else {
            writer.startElement(XmlElement.access$100(element), XmlElement.access$000(element));
        }
        if (XmlElement.access$200(element) == null) {
            for (XmlElement aChildren : XmlElement.access$300(element)) {
                this.emitXmlElement(writer, aChildren);
            }
        } else {
            writer.characters(XmlElement.access$200(element));
        }
        writer.endElement();
    }

    protected void emit(Object row, XmlaResponse response) throws XmlaException {
        SaxWriter writer = response.getWriter();
        writer.startElement("row");
        for (RowsetDefinition.Column column : this.rowsetDefinition.columnDefinitions) {
            Object value = column.get(row);
            if (value != null) {
                writer.startElement(column.name);
                writer.characters(value.toString());
                writer.endElement();
                continue;
            }
            writer.startElement(column.name);
            writer.endElement();
        }
        writer.endElement();
    }

    protected <E extends Enum<E>> void emit(Class<E> clazz, XmlaResponse response) throws XmlaException {
        Object[] valuesSortedByName = (Enum_[])((Enum_[])ClassMethods.getEnumConstants(clazz)).clone();
        Arrays.sort((Object[])valuesSortedByName, (Comparator)new Comparator<E>(){

            @Override
            public int compare(E o1, E o2) {
                return o1.name().compareTo(o2.name());
            }

            @Override
            public int compare(Object x0, Object x1) {
                return this.compare((E)((Enum_)x0), (E)((Enum_)x1));
            }
        });
        for (Object value : valuesSortedByName) {
            this.emit(value, response);
        }
    }

    RestrictionTest getRestrictionTest(RowsetDefinition.Column column) {
        final List<String> requiredValue = this.restrictions.get(column.name);
        if (requiredValue == null) {
            return new RestrictionTest(){

                public boolean passes(int ival) {
                    return true;
                }

                public boolean passes(Object value) {
                    return true;
                }
            };
        }
        return new RestrictionTest(){

            public boolean passes(Object value) {
                return requiredValue.contains(value);
            }
        };
    }

    private List<String> getRestrictionValue(RowsetDefinition.Column column) {
        return this.restrictions.get(column.name);
    }

    String getRestrictionValueAsString(RowsetDefinition.Column column) {
        List<String> rval = this.getRestrictionValue(column);
        return rval != null && rval.size() == 1 ? rval.get(0) : null;
    }

    int getRestrictionValueAsInt(RowsetDefinition.Column column) {
        List<String> rval = this.getRestrictionValue(column);
        if (rval != null && rval.size() == 1) {
            try {
                return Integer.parseInt(rval.get(0));
            }
            catch (NumberFormatException ex) {
                LOGGER.info((Object)new StringBuffer().append("Rowset.getRestrictionValue: bad integer restriction \"").append(rval).append("\"").toString());
                return -1;
            }
        }
        return -1;
    }

    protected boolean isRestricted(RowsetDefinition.Column column) {
        return this.restrictions.get(column.name) != null;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    protected class XmlElement {
        private final String tag;
        private final String[] attributes;
        private final String text;
        private final XmlElement[] children;

        XmlElement(String tag, String[] attributes) {
            this(tag, attributes, null, null);
        }

        XmlElement(String tag, String[] attributes, String text) {
            this(tag, attributes, text, null);
        }

        XmlElement(String tag, String[] attributes, XmlElement[] children) {
            this(tag, attributes, null, children);
        }

        private XmlElement(String tag, String[] attributes, String text, XmlElement[] children) {
            this.tag = tag;
            this.attributes = attributes;
            this.text = text;
            this.children = children;
        }

        static String[] access$000(XmlElement x0) {
            return x0.attributes;
        }

        static String access$100(XmlElement x0) {
            return x0.tag;
        }

        static String access$200(XmlElement x0) {
            return x0.text;
        }

        static XmlElement[] access$300(XmlElement x0) {
            return x0.children;
        }
    }

    protected class Row {
        private final ArrayList<String> names = new ArrayList();
        private final ArrayList<Object> values = new ArrayList();

        Row() {
        }

        void set(String name, Object value) {
            this.names.add(name);
            this.values.add(value);
        }

        void set(String name, boolean value) {
            this.set(name, value ? "true" : "false");
        }

        public Object get(String name) {
            int i = this.names.indexOf(name);
            return i < 0 ? null : this.values.get(i);
        }
    }

    static abstract class RestrictionTest {
        RestrictionTest() {
        }

        public abstract boolean passes(Object var1);
    }
}

